/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.table.AbstractTableElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.util.ArgChecks;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FlowElement
extends AbstractTableElement
implements TableElement,
Serializable {
    private List<TableElement> elements = new ArrayList<TableElement>();
    private HAlign horizontalAlignment = HAlign.CENTER;
    private int hgap = 2;

    public int getHGap() {
        return this.hgap;
    }

    public void setHGap(int gap) {
        this.hgap = gap;
    }

    public List<TableElement> getElements() {
        return new ArrayList<TableElement>(this.elements);
    }

    public void addElement(TableElement element) {
        ArgChecks.nullNotPermitted(element, "element");
        this.elements.add(element);
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        double maxWidth = bounds.getWidth();
        Insets insets = this.getInsets();
        double width = insets.left + insets.right;
        double height = insets.top + insets.bottom;
        double rowWidth = insets.left + insets.right;
        double rowHeight = 0.0;
        boolean first = true;
        for (TableElement e : this.elements) {
            Dimension2D dim = e.preferredSize(g2, bounds, constraints);
            if (rowWidth + dim.getWidth() <= maxWidth) {
                rowWidth += dim.getWidth();
                if (first) {
                    first = false;
                } else {
                    rowWidth += (double)this.hgap;
                }
                rowHeight = Math.max(dim.getHeight(), rowHeight);
            } else {
                width = Math.max(width, rowWidth);
                rowWidth = (double)(insets.left + insets.right) + dim.getWidth();
                height += rowHeight;
                rowHeight = dim.getHeight();
            }
            width = Math.max(width, rowWidth);
        }
        return new Dimension((int)width, (int)(height += rowHeight));
    }

    private ElementLine lineOfElements(int firstElement, Graphics2D g2, Rectangle2D bounds) {
        ArrayList<TableElement> elementsInLine = new ArrayList<TableElement>();
        ArrayList<Double> elementWidths = new ArrayList<Double>();
        double x = this.getInsets().left;
        double w = 0.0;
        double h = 0.0;
        for (int i = firstElement; i < this.elements.size(); ++i) {
            TableElement e = this.elements.get(i);
            Dimension2D dim = e.preferredSize(g2, bounds);
            if (x + dim.getWidth() < bounds.getWidth() + 10.0) {
                elementsInLine.add(this.elements.get(i));
                elementWidths.add(dim.getWidth());
                w = dim.getWidth();
                if (i > firstElement) {
                    w += (double)this.hgap;
                }
                h = Math.max(h, dim.getHeight());
            }
            x += dim.getWidth() + (double)this.hgap;
        }
        if (elementsInLine.isEmpty()) {
            elementsInLine.add(this.elements.get(firstElement));
            w = bounds.getWidth() - (double)this.getInsets().left - (double)this.getInsets().right;
            elementWidths.add(w);
        }
        return new ElementLine(elementsInLine, elementWidths, w, h);
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(this.elements.size());
        double x = bounds.getX() + (double)this.getInsets().left;
        double y = bounds.getY() + (double)this.getInsets().top;
        int i = 0;
        while (i < this.elements.size()) {
            ElementLine line = this.lineOfElements(i, g2, bounds);
            for (int elementIndex = 0; elementIndex < line.getElements().size(); ++elementIndex) {
                double dx = this.calculateXOffset(elementIndex, line.getWidths(), this.hgap);
                Rectangle2D.Double rect = new Rectangle2D.Double(x + dx, y, line.getWidths().get(elementIndex), line.getHeight());
                result.add(rect);
            }
            i += line.getElements().size();
            y += line.getHeight();
        }
        return result;
    }

    private double calculateXOffset(int elementIndex, List<Double> widths, int gap) {
        double x = 0.0;
        for (int i = 0; i < elementIndex; ++i) {
            x += widths.get(i).doubleValue();
        }
        if (elementIndex > 1) {
            x += (double)(gap * (elementIndex - 1));
        }
        return x;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        List<Rectangle2D> layoutInfo = this.layoutElements(g2, bounds, null);
        for (int i = 0; i < this.elements.size(); ++i) {
            Rectangle2D rect = layoutInfo.get(i);
            TableElement element = this.elements.get(i);
            element.draw(g2, rect);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlowElement)) {
            return false;
        }
        FlowElement that = (FlowElement)obj;
        if (this.hgap != that.hgap) {
            return false;
        }
        if (!this.elements.equals(that.elements)) {
            return false;
        }
        return super.equals(obj);
    }

    private static class ElementLine {
        private double width;
        private double height;
        private List<TableElement> elements;
        private List<Double> widths;

        public ElementLine() {
            this(new ArrayList<TableElement>(), new ArrayList<Double>(), 0.0, 0.0);
        }

        public ElementLine(List<TableElement> elements, List<Double> elementWidths, double width, double height) {
            this.elements = elements;
            this.widths = elementWidths;
            this.width = width;
            this.height = height;
        }

        public List<TableElement> getElements() {
            return this.elements;
        }

        public List<Double> getWidths() {
            return this.widths;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }
    }
}

