/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.table.AbstractTableElement;
import com.orsoncharts.table.ElementDimension;
import com.orsoncharts.table.TableElement;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ShapeElement
extends AbstractTableElement
implements TableElement {
    private Shape shape;

    public ShapeElement(Shape shape, Paint fillPaint) {
        this.shape = shape;
        this.setForegroundPaint(fillPaint);
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds) {
        return this.preferredSize(g2, bounds, null);
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        Insets insets = this.getInsets();
        Rectangle2D shapeBounds = this.shape.getBounds2D();
        return new ElementDimension(Math.min(shapeBounds.getWidth() + (double)insets.left + (double)insets.right, bounds.getWidth()), Math.min(shapeBounds.getHeight() + (double)insets.top + (double)insets.bottom, shapeBounds.getHeight()));
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>();
        Insets insets = this.getInsets();
        Rectangle2D shapeBounds = this.shape.getBounds2D();
        double w = Math.min(shapeBounds.getWidth() + (double)insets.left + (double)insets.right, bounds.getWidth());
        double h = Math.min(shapeBounds.getHeight() + (double)insets.top + (double)insets.bottom, bounds.getHeight());
        Rectangle2D.Double pos = new Rectangle2D.Double(bounds.getCenterX() - w / 2.0, bounds.getCenterY() - h / 2.0, w, h);
        result.add(pos);
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        AffineTransform saved = g2.getTransform();
        Paint background = this.getBackgroundPaint();
        if (background != null) {
            g2.setPaint(this.getBackgroundPaint());
            g2.fill(bounds);
        }
        g2.translate(bounds.getCenterX(), bounds.getCenterY());
        g2.setPaint(this.getForegroundPaint());
        g2.fill(this.shape);
        g2.setTransform(saved);
    }
}

