/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.table.AbstractTableElement;
import com.orsoncharts.table.ElementDimension;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextElement
extends AbstractTableElement
implements TableElement,
Serializable {
    private String text;
    private Font font;
    private HAlign alignment;

    public TextElement(String text) {
        this(text, new Font("Dialog", 0, 12));
    }

    public TextElement(String text, Font font) {
        ArgChecks.nullNotPermitted(text, "text");
        ArgChecks.nullNotPermitted(font, "font");
        this.text = text;
        this.font = font;
        this.alignment = HAlign.LEFT;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.font = font;
    }

    public HAlign getHorizontalAlignment() {
        return this.alignment;
    }

    public void setHorizontalAligment(HAlign align) {
        ArgChecks.nullNotPermitted((Object)align, "align");
        this.alignment = align;
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        g2.setFont(this.font);
        Rectangle2D textBounds = TextUtils.getTextBounds(this.text, g2, g2.getFontMetrics(this.font));
        Insets insets = this.getInsets();
        double w = Math.min(textBounds.getWidth() + (double)insets.left + (double)insets.right, bounds.getWidth());
        double h = Math.min(textBounds.getHeight() + (double)insets.top + (double)insets.bottom, bounds.getHeight());
        return new ElementDimension(w, h);
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        g2.setFont(this.font);
        Rectangle2D textBounds = TextUtils.getTextBounds(this.text, g2, g2.getFontMetrics(this.font));
        Insets insets = this.getInsets();
        double width = textBounds.getWidth() + (double)insets.left + (double)insets.right;
        double x = bounds.getX();
        switch (this.alignment) {
            case LEFT: {
                x = bounds.getX();
                break;
            }
            case CENTER: {
                x = bounds.getCenterX() - width / 2.0 - (double)insets.left;
                break;
            }
            case RIGHT: {
                x = bounds.getMaxX() - width;
                break;
            }
            default: {
                throw new IllegalStateException("HAlign: " + (Object)((Object)this.alignment));
            }
        }
        double y = bounds.getY();
        double w = Math.min(width, bounds.getWidth());
        double h = Math.min(textBounds.getHeight() + (double)insets.top + (double)insets.bottom, bounds.getHeight());
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(1);
        result.add(new Rectangle2D.Double(x, y, w, h));
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        List<Rectangle2D> layout = this.layoutElements(g2, bounds, null);
        Rectangle2D textBounds = layout.get(0);
        if (this.getBackgroundPaint() != null) {
            g2.setPaint(this.getBackgroundPaint());
            g2.fill(textBounds);
        }
        g2.setPaint(this.getForegroundPaint());
        g2.setFont(this.font);
        Insets insets = this.getInsets();
        TextUtils.drawAlignedString(this.text, g2, (float)(textBounds.getX() + (double)insets.left), (float)(textBounds.getY() + (double)insets.top), TextAnchor.TOP_LEFT);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextElement)) {
            return false;
        }
        TextElement that = (TextElement)obj;
        if (!this.text.equals(that.text)) {
            return false;
        }
        if (!this.font.equals(that.font)) {
            return false;
        }
        if (this.alignment != that.alignment) {
            return false;
        }
        return super.equals(obj);
    }
}

