/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.util;

import com.orsoncharts.util.Anchor2D;
import com.orsoncharts.util.Scale2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Fit2D
implements Serializable {
    private Anchor2D anchor;
    private Scale2D scale;

    public Fit2D(Anchor2D anchor, Scale2D scale) {
        this.anchor = anchor;
        this.scale = scale;
    }

    public Rectangle2D fit(Dimension2D srcDim, Rectangle2D target) {
        Rectangle2D.Double result = new Rectangle2D.Double();
        if (this.scale == Scale2D.SCALE_BOTH) {
            result.setFrame(target);
            return result;
        }
        double width = srcDim.getWidth();
        if (this.scale == Scale2D.SCALE_HORIZONTAL) {
            width = target.getWidth();
            if (!this.anchor.getRefPt().isHorizontalCenter()) {
                width -= 2.0 * this.anchor.getOffset().getDX();
            }
        }
        double height = srcDim.getHeight();
        if (this.scale == Scale2D.SCALE_VERTICAL) {
            height = target.getHeight();
            if (!this.anchor.getRefPt().isVerticalCenter()) {
                height -= 2.0 * this.anchor.getOffset().getDY();
            }
        }
        Point2D pt = this.anchor.getAnchorPoint(target);
        double x = Double.NaN;
        if (this.anchor.getRefPt().isLeft()) {
            x = pt.getX();
        } else if (this.anchor.getRefPt().isHorizontalCenter()) {
            x = target.getCenterX() - width / 2.0;
        } else if (this.anchor.getRefPt().isRight()) {
            x = pt.getX() - width;
        }
        double y = Double.NaN;
        if (this.anchor.getRefPt().isTop()) {
            y = pt.getY();
        } else if (this.anchor.getRefPt().isVerticalCenter()) {
            y = target.getCenterY() - height / 2.0;
        } else if (this.anchor.getRefPt().isBottom()) {
            y = pt.getY() - height;
        }
        ((Rectangle2D)result).setRect(x, y, width, height);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fit2D)) {
            return false;
        }
        Fit2D that = (Fit2D)obj;
        if (!this.anchor.equals(that.anchor)) {
            return false;
        }
        return this.scale.equals((Object)that.scale);
    }
}

