/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.util;

import com.orsoncharts.util.TextAnchor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class TextUtils {
    private TextUtils() {
    }

    public static Rectangle2D drawAlignedString(String text, Graphics2D g2, float x, float y, TextAnchor anchor) {
        Rectangle2D.Double textBounds = new Rectangle2D.Double();
        float[] adjust = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, anchor, textBounds);
        ((Rectangle2D)textBounds).setRect(x + adjust[0], y + adjust[1] + adjust[2], ((RectangularShape)textBounds).getWidth(), ((RectangularShape)textBounds).getHeight());
        g2.drawString(text, x + adjust[0], y + adjust[1]);
        return textBounds;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f);
        Rectangle2D bounds = TextUtils.getTextBounds(text, g2, fm);
        LineMetrics metrics = f.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isHalfHeight()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor, Rectangle2D textBounds) {
        float[] result = new float[3];
        FontRenderContext frc = g2.getFontRenderContext();
        Font f = g2.getFont();
        FontMetrics fm = g2.getFontMetrics(f);
        Rectangle2D bounds = TextUtils.getTextBounds(text, g2, fm);
        LineMetrics metrics = f.getLineMetrics(text, frc);
        float ascent = metrics.getAscent();
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isHorizontalCenter()) {
            xAdj = (float)(-bounds.getWidth()) / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)(-bounds.getWidth());
        }
        if (anchor.isTop()) {
            yAdj = -descent - leading + (float)bounds.getHeight();
        } else if (anchor.isHalfAscent()) {
            yAdj = halfAscent;
        } else if (anchor.isHorizontalCenter()) {
            yAdj = -descent - leading + (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = -metrics.getDescent() - metrics.getLeading();
        }
        if (textBounds != null) {
            textBounds.setRect(bounds);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static Rectangle2D getTextBounds(String text, Graphics2D g2, FontMetrics fm) {
        double width = fm.stringWidth(text);
        double height = fm.getHeight();
        return new Rectangle2D.Double(0.0, -fm.getAscent(), width, height);
    }

    public static void drawRotatedString(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, float rotationX, float rotationY) {
        if (text == null || text.equals("")) {
            return;
        }
        float[] textAdj = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        TextUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, rotationX, rotationY);
    }

    public static void drawRotatedString(String text, Graphics2D g2, float x, float y, TextAnchor textAnchor, double angle, TextAnchor rotationAnchor) {
        if (text == null || text.equals("")) {
            return;
        }
        float[] textAdj = TextUtils.deriveTextBoundsAnchorOffsets(g2, text, textAnchor);
        float[] rotateAdj = TextUtils.deriveRotationAnchorOffsets(g2, text, rotationAnchor);
        TextUtils.drawRotatedString(text, g2, x + textAdj[0], y + textAdj[1], angle, x + textAdj[0] + rotateAdj[0], y + textAdj[1] + rotateAdj[1]);
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D g2, String text, TextAnchor anchor) {
        float[] result = new float[2];
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics metrics = g2.getFont().getLineMetrics(text, frc);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = TextUtils.getTextBounds(text, g2, fm);
        float ascent = metrics.getAscent();
        float halfAscent = ascent / 2.0f;
        float descent = metrics.getDescent();
        float leading = metrics.getLeading();
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor.isLeft()) {
            xAdj = 0.0f;
        } else if (anchor.isHorizontalCenter()) {
            xAdj = (float)bounds.getWidth() / 2.0f;
        } else if (anchor.isRight()) {
            xAdj = (float)bounds.getWidth();
        }
        if (anchor.isTop()) {
            yAdj = descent + leading - (float)bounds.getHeight();
        } else if (anchor.isHalfHeight()) {
            yAdj = descent + leading - (float)(bounds.getHeight() / 2.0);
        } else if (anchor.isHalfAscent()) {
            yAdj = -halfAscent;
        } else if (anchor.isBaseline()) {
            yAdj = 0.0f;
        } else if (anchor.isBottom()) {
            yAdj = metrics.getDescent() + metrics.getLeading();
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static void drawRotatedString(String text, Graphics2D g2, double angle, float x, float y) {
        TextUtils.drawRotatedString(text, g2, x, y, angle, x, y);
    }

    public static void drawRotatedString(String text, Graphics2D g2, float textX, float textY, double angle, float rotateX, float rotateY) {
        if (text == null || text.equals("")) {
            return;
        }
        AffineTransform saved = g2.getTransform();
        AffineTransform rotate = AffineTransform.getRotateInstance(angle, rotateX, rotateY);
        g2.transform(rotate);
        g2.drawString(text, textX, textY);
        g2.setTransform(saved);
    }
}

