/**
 * Copyright (c) 2018, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Intel Corporation nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.intel.stl.ui.admin.impl.qosgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.swing.ImageIcon;

import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.ui.admin.ChangeState;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.ConfPageController;
import com.intel.stl.ui.admin.impl.ValidationTask;
import com.intel.stl.ui.admin.view.ValidationDialog;
import com.intel.stl.ui.admin.view.qosgroups.QOSGroupsSubpageView;
import com.intel.stl.ui.admin.view.qosgroups.QOSGsEditorPanel;
import com.intel.stl.ui.common.IProgressObserver;
import com.intel.stl.ui.common.UILabels;
import com.intel.stl.ui.main.Context;
import com.intel.stl.ui.main.HelpAction;

public class QOSGroupsPageController
        extends ConfPageController<QOSGroup, QOSGsEditorPanel> {
    private Set<String> reserved;

    /**
     * Description:
     *
     * @param name
     * @param description
     * @param icon
     * @param view
     */
    public QOSGroupsPageController(String name, String description,
            ImageIcon icon, QOSGroupsSubpageView view) {
        super(name, description, icon, view);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.intel.stl.ui.admin.impl.ConfPageController#getHelpID()
     */
    @Override
    protected String getHelpID() {
        return HelpAction.getInstance().getQOSGroupMgmt();
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.intel.stl.ui.admin.impl.ConfPageController#setContext(com.intel.stl
     * .ui.main.Context, com.intel.stl.ui.common.IProgressObserver)
     */
    @Override
    public void setContext(Context context, IProgressObserver observer) {
        super.setContext(context, observer);
        edtCtr.setContext(context);
        reserved = mgtApi.getReservedQOSGroups();
    }

    /*
     * (non-Javadoc)
     *
     * @see com.intel.stl.ui.admin.impl.ConfPageController#onEnter()
     */
    @Override
    public void onEnter() {
        if (mgtApi != null) {
            if (mgtApi.isConfigReady() && !mgtApi.supportQOSGroup()) {
                QOSGroupsSubpageView view = (QOSGroupsSubpageView) getView();
                view.showMessageCard(
                        UILabels.STL81060_QOSG_UNAVAILABLE.getDescription());
                return;
            }
        }
        super.onEnter();
    }

    /*
     * (non-Javadoc)
     *
     * @see com.intel.stl.ui.admin.impl.ConfPageController#initData()
     */
    @Override
    protected ArrayList<Item<QOSGroup>> initData() throws Exception {
        List<QOSGroup> qosGroups = mgtApi.getQOSGroups();
        ArrayList<Item<QOSGroup>> res = new ArrayList<Item<QOSGroup>>();
        if (qosGroups != null) {
            for (QOSGroup app : qosGroups) {
                boolean isEditable = isEditable(app);
                Item<QOSGroup> item = new Item<QOSGroup>(res.size(),
                        app.getName(), app, isEditable);
                item.setState(ChangeState.NONE);
                res.add(item);
            }
        }
        return res;
    }

    /**
     * <i>Description:</i>
     *
     * @param qos
     * @return
     */
    protected boolean isEditable(QOSGroup app) {
        String name = app.getName();
        return !reserved.contains(name);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.intel.stl.ui.admin.impl.ConfPageController#getCopy(java.lang.Object)
     */
    @Override
    protected QOSGroup getCopy(QOSGroup obj) {
        return obj.copy();
    }

    /*
     * (non-Javadoc)
     *
     * @see com.intel.stl.ui.admin.impl.ConfPageController#createObj()
     */
    @Override
    protected QOSGroup createObj() {
        return new QOSGroup();
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.intel.stl.ui.admin.impl.ConfPageController#removeItemObject(java.lang
     * .String)
     */
    @Override
    protected void removeItemObject(String name) throws Exception {
        mgtApi.removeQOSGroup(name);

    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.intel.stl.ui.admin.impl.ConfPageController#getValidationTask(com.
     * intel.stl.ui.admin.view.ValidationDialog, com.intel.stl.ui.admin.Item)
     */
    @Override
    protected ValidationTask<QOSGroup> getValidationTask(
            ValidationDialog dialog, Item<QOSGroup> item) {
        QosValidationTask task =
                new QosValidationTask(dialog, valModel, orgItems, item, mgtApi);
        return task;
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.intel.stl.ui.admin.impl.ConfPageController#saveItemObject(java.lang.
     * String, java.lang.Object)
     */
    @Override
    protected void saveItemObject(String oldName, QOSGroup obj)
            throws Exception {
        if (oldName != null) {
            mgtApi.updateQOSGroup(oldName, obj);
        } else {
            mgtApi.addQOSGroup(obj);
        }
    }

}
