/**
 * Copyright (c) 2018, Intel Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Intel Corporation nor the names of its contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.intel.stl.ui.admin.view.qosgroups;

import java.awt.Component;

import javax.swing.JList;
import javax.swing.ListCellRenderer;

import com.intel.stl.api.management.qosgroups.QOSGroup;
import com.intel.stl.ui.admin.Item;
import com.intel.stl.ui.admin.impl.qosgroups.QosGroupRendererModel;
import com.intel.stl.ui.admin.view.AbstractConfView;
import com.intel.stl.ui.admin.view.ItemListPanel;
import com.intel.stl.ui.admin.view.ItemPanel;

public class QOSGroupsSubpageView
        extends AbstractConfView<QOSGroup, QOSGsEditorPanel> {
    private static final long serialVersionUID = 6570109457615440128L;

    private QOSGsEditorPanel editorPanel;

    public QOSGroupsSubpageView(String name) {
        super(name);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.intel.stl.ui.admin.view.AbstractConfView#createrEditorPanel()
     */
    @Override
    protected QOSGsEditorPanel createrEditorPanel() {
        if (editorPanel == null) {
            editorPanel = new QOSGsEditorPanel(new QosGroupRendererModel());
        }
        return editorPanel;
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.intel.stl.ui.admin.view.AbstractConfView#createItemSelectionPanel()
     */
    @Override
    protected ItemListPanel<QOSGroup> createItemSelectionPanel() {
        ItemListPanel<QOSGroup> listPanel =
                new ItemListPanel<QOSGroup>(getName());
        listPanel.setItemRenderer(new ListCellRenderer<Item<QOSGroup>>() {

            @Override
            public Component getListCellRendererComponent(
                    JList<? extends Item<QOSGroup>> list, Item<QOSGroup> value,
                    int index, boolean isSelected, boolean cellHasFocus) {
                Item<?> item = value;
                QOSGroup qosGroup = (QOSGroup) item.getObj();
                ItemPanel ip = new ItemPanel(item.getName());
                ip.setState(isSelected, item.isEditable(),
                        qosGroup.getEnable().isSelected());
                return ip;
            }

        });
        return listPanel;
    }
}
