/*
 * I2O Configuration Browser CGI
 *
 * (c) 1999, 2000 Copyright Deepak Saxena 
 *
 * Originally written by Deepak Saxena <deepak@plexity.net>
 * Parts based on code by University of Helsinki
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * This program provides a CGI interface that allows a user
 * to communicate with the Linux I2O configuration subsystem 
 * with a web browser.
 *
 * The program needs to be compiled and placed in a directory
 * that allows cgi-bin access.  
 *
 * Once the program has been installed, just set your browser to:
 *
 *    http://host.domain/cgi-bin-directory/iop_view
 *
 * This will provide a summary of the I2O subsystem 
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>

/* Needed for i2o stuff */
#define u32	unsigned int
#define u16	unsigned short
#define	u8	unsigned char

#include <linux/i2o.h>
#include <linux/i2o-dev.h>

void iop_main(int);
void iop_browse(int, unsigned int, unsigned int, unsigned int);
void header(header);
void footer(void);
void error(void);

void main(void)
{
	int fd;
	char *path = getenv("PATH_INFO");
	char *parsing;

	fd = open("/dev/i2o/ctl", O_RDONLY);
	if(fd < 0)
	{
		perror("Could not open IOP:");
		printf("content-type: text/html\n\n");
		printf("<H2>Error: Could not open I<SUB>2</SUB>O System</H2>\n");
		
		exit(-1);
	}

	if(path)
	{
		int iop, tid, page;	
		int i;
		int ishex;

		/*
		 * Parse the path...
		 */
		parsing = strtok(path, "/");	// IOP#?

		for(i = 0; i < strlen(parsing); i++)
		{
			if(!isdigit(parsing[i]))
			{
				error();
				close(fd);
				exit(-1);
			}
		}
		sscanf(parsing, "%d", &iop);

		parsing = strtok(NULL, "/");	// TID?
		ishex = 0;
		i = 0;
		if(strlen(parsing) > 2 && parsing[0] == '0' && 
				(parsing[1] == 'x' || parsing[1] == 'X'))
		{
			ishex = 1;	
			i = 2;
		}
		
		for(; i < strlen(parsing); i++)
		{
			if((!ishex && !isdigit(parsing[i]))
				&& (ishex && !isxdigit(parsing[i])))
			{
				error();
				close(fd);
				exit(-1);
			}
		}
		if(ishex)
			sscanf(parsing, "%x", &tid);
		else
			sscanf(parsing, "%d", &tid);

		parsing = strtok(NULL, "/");	// Page?
		ishex = 0;
		i = 0;
		if(strlen(parsing) > 2 && parsing[0] == '0' && 
				(parsing[1] == 'x' || parsing[1] == 'X'))
		{
			ishex = 1;	
			i = 2;
		}
		
		for(; i < strlen(parsing); i++)
		{
			if((!ishex && !isdigit(parsing[i]))
				&& (ishex && !isxdigit(parsing[i])))
			{
				error();
				close(fd);
				exit(-1);
			}
		}
		if(ishex)
			sscanf(parsing, "%x", &page);
		else
			sscanf(parsing, "%d", &page);

		iop_browse(fd, iop, tid, page);
	}
	else
		iop_main(fd);

	close(fd);
	return;
}

void header(void)
{
	static char header[] = 
	"
	<HTML>
	<HEAD>
	<TITLE>Linux I2O Configuration Browser</TITLE>
	</HEAD>
	<BODY BGCOLOR=\"#FFFFFF\" TEXT=\"#000000\">
	";

	printf("content-type: text/html\n\n");
	fflush(stdout);
	printf("%s", header);
}

void footer(void)
{
	printf("</BODY></HTML>");
}


void iop_browse(int fd, unsigned int iop, unsigned int tid, unsigned int page)
{
	char *q = getenv("CONTENT_LENGTH");
	char *query;
	char buffer[65536];
	struct i2o_html html;
	unsigned int len = 65536;
	html.resbuf = (void*)buffer;
	html.reslen = &len;	

	html.iop = iop;
	html.tid = tid;
	html.page = page;
	
	if(q) 
	{
		query = (char *)malloc(atoi(q)+1);
		scanf("%s", query);

		html.qbuf = (void*)query;
		html.qlen = strlen(query)+1;
	}
	else
	{
		html.qbuf = NULL;
		html.qlen = 0;
	}

	if(!ioctl(fd, I2OHTML, &html))
		{
		printf("%s\n", buffer);
		}
	else
	{
		/* Allow admin to check specific errors in httpd log */
		perror("IOP ACCESS ERROR");
		header();
		printf("<H2>An error occurred in accessing IOP%d</H2>\n", html.iop);
		printf("<H3>Error #%d</H3>\n", errno);
		footer();
	}
}

void iop_main(int fd)
{
	unsigned char iop_table[MAX_I2O_CONTROLLERS];
	
	if(ioctl(fd, I2OGETIOPS, (void *)iop_table))
	{
		perror("I2OGETIOPS");
		printf("content-type: text/html\n\n");
		printf("<H2>An error occurred in accessing the I2O subsytem</H2>\n");
		return;
	}
	else
	{
		int i;

		header();
		printf("<CENTER>\n");
		printf("<H1>Linux I<SUB>2</SUB>O Configuration Browser</H1>");
		printf("<TABLE>\n<TR>\n<TH>IOP#</TH><TH>IOP Name</TH>"
					"<TH>Status</TH><TH>Actions</TH></TR>\n");

		for(i = 0; i < MAX_I2O_CONTROLLERS; i++)
		{
			if(iop_table[i])
			{
				printf("<TR><TD ALIGN=CENTER>");
				//printf("<A HREF=\"/%d/0x0/0\">i2o/iop%d</A></TD>\n", i, i);
				printf("<A HREF=\"/%d/0x0/0\">i2o/iop%d</A></TD>\n", i, i);
				printf("<TD>TBD</TD><TD>TBD</TD><TD>TBD</TD></TR>\n");
			}
		}
		
		printf("</TABLE></CENTER>\n");
		footer();
	}
}	

void error(void)
{
	header();
	printf("<B>ERROR:</B> An invalid IOP address was given\n");
	footer();
}



