#!/bin/sh
 
 
##################################################################
# This script will lay the ground for I2O subsystem              #
#                                                                #
#       (C) Copyright Intel Corp. 2000                           #
##################################################################
                                                           
LOG_FILE="/tmp/iir-install"

#echo "I2O subsystem needs the availability of certain block dev files"
#echo "in the /dev/ directory. "

if test -d /dev/i2o
	then
		echo "Skipping creating /dev/i2o, exists" >> $LOG_FILE
else
		echo "Creating /dev/i2o " >>  $LOG_FILE
		mkdir /dev/i2o >>  $LOG_FILE 2>&1
fi
	
if test -c /dev/i2o/ctl
	then
		echo "Skipping: /dev/i2o/ctl exists" >> $LOG_FILE
else
	echo "Creating: /dev/i2o/ctl"  >> $LOG_FILE
	mknod /dev/i2o/ctl c 10 166 >> $LOG_FILE 2>&1
fi

#########################################################################
# Currently this script creates /dev/i2o/hd[a-f] & /dev/i2o/hd[a-f][1-15] #
# We can have /dev/i2o/hd[a-p][1-5]                                      #
# If you need more than [a-f] add the letters (to max of [a-p]) to the  #
# for loop below                                                        #
#########################################################################

let "devnum = 0"
for char  in a b c d e f g h i j k l m n o p
do
	if test -b /dev/i2o/hd$char
	then
		echo "Skipping: /dev/i2o/hd$char exists" >> $LOG_FILE
	else		
		echo "Creating: /dev/i2o/hd$char"  >> $LOG_FILE
		 	mknod /dev/i2o/hd$char b 80 $devnum >> $LOG_FILE 2>&1
	fi

	let "devnum = devnum + 1"
	let "loop = devnum + 15"
	let "devindex = 1"

	while let "devnum < loop"
		do 
			if test -b /dev/i2o/hd$char$devindex
        		then
                		echo "Skipping: /dev/i2o/hd$char$devindex exists" >> $LOG_FILE
        		else 
				echo "Creating: /dev/i2o/hd$char$devindex"  >> $LOG_FILE
				mknod /dev/i2o/hd$char$devindex b 80 $devnum >> $LOG_FILE 2>&1
			fi
				let "devnum = devnum + 1" 
				let "devindex = devindex + 1"
		done
done

echo "I2O device files created !" >> $LOG_FILE

#echo " Next few things to do, to actually use a I2O RAID volume"
#echo "	1. Load I2O modules thus: "
#echo "		$ insmod i2o_pci"
#echo "		$ insmod i2o_core"
#echo "		$ insmod i2o_block"
#echo "		$ insmod i2o_config"

#echo " *** Check whether modules loaded with "lsmod" command ***"
#echo "	2. Use a web browser and point to : http://localhost/cgi-bin/iop_view "
#echo "		to configure Raid volumes"
#echo "	3. use fdisk to create partitions on the RAID volumes "
#echo "		$ fdisk /dev/i2o/hd[a : first RAID vol - f : sixth volume created]"
#echo "	4. Make linux native Filesystem (ext2) by:"
#echo " 		$ mke2fs /dev/i2o/hd[a-f][1-15: the partition number]"
#echo "	5. Mount the partition on a directory (create one if necessary)"
#echo "		$mkdir /mnt/i2o"
#echo "		$ mount /dev/i2o/hd[a-f][1-15] /mnt/i2o "
#echo " Now you can use the /mnt/i2o for normal I/O !"
#echo " Probs ? visit : http://iopd-linux.ch.intel.com/"
