#!/bin/sh

#####################################################################
# This script installs the various components of the RAID           # 
# Configuration server                                              #
#       (C) Copyright Intel Corp. 2000                              #
#####################################################################

DIALOG=dialog/dialog
TITLE="Linux IIR Setup - (C) Copyright Intel Corp. 2000"
# Height and width of the dialog window
ht=20
wd=65

#cp -rf ../iirserver/misc/iir /etc/rc.d/init.d

#if ! test -f /etc/rc.d/rc5.d/S99iir
#then
#		ln -s /etc/rc.d/init.d/iir /etc/rc.d/rc5.d/S99iir
#fi

#if ! test -f /etc/rc.d/rc3.d/S99iir
#then
#                ln -s /etc/rc.d/init.d/iir /etc/rc.d/rc3.d/S99iir
#fi

## This eventually should become an exhaustive chekc of java:
# 1. Check whether java is there !
# 2. which version is there ? Is it a Blackdown.org java or Kaffe ?
# 3. If the version is not suitable gfor us can we update it etc ?
# better idea have this in a separate script and call it from here !
#####################

#echo "Installing any optional java requirements"

$DIALOG --title "$TITLE" \
                        --yesno "

	RAID Configuration Services

The RAID Configuration Services needs the latest version
of Java Runtime Environment to run.
If you say \"yes\" below, Kaffe Java version 1.0.5 will 
be installed. 
If you have a newer version of Kaffe (http://www.kaffe.org/)
or Java runtime Environment , you can say \"no\" below.

The executable \"java\" should also be in your PATH
variable. 

	Install Kaffe version 1.0.5 ?
" $ht $wd

if [ "$?" = "1" ]
        then
        $DIALOG --title "$TITLE" \
                --msgbox "
Java support using Kaffe 1.0.5 cancelled at 
your request !
Please make sure you have Java Runtime 
Environment before running the RAID 
configuration components.

" $ht $wd
else
	rpm -U ../iirserver/misc/kaffe-1.0.5-6.i386.rpm
fi


#rm -f ../iirserver/misc/*.rpm

if test -d /opt/iir
then
mkdir /opt/iir/iirserver
#cp -rf ../iirserver/README /opt/iir/iirserver/.
cp -rf ../iirserver/bin/* /opt/iir/bin/.
cp -rf ../iirserver/iir /opt/iir/iirserver/.
chmod 700 /opt/iir/bin/*
ln -sf /opt/iir/bin/iradmin /usr/local/bin/iradmin
ln -sf /opt/iir/bin/iird /usr/local/bin/iird
ln -sf /opt/iir/bin/irconsole /usr/local/bin/irconsole
chmod 500 /usr/local/bin/iradmin
chmod 500 /usr/local/bin/irconsole
chmod 500 /usr/local/bin/iird

cp -rf ../iirserver/cgi-bin /opt/iir/iirserver/.
cp -rf ../iirserver/etc /opt/iir/iirserver/.
cp -rf ../iirserver/iir /opt/iir/iirserver/.
cp -rf ../iirserver/logs /opt/iir/iirserver/.

chmod 500 ../iirserver/misc/desktop/desktop.sh
cd ../iirserver/misc/desktop; ./desktop.sh

cp -rf ../iirserver/misc /opt/iir/iirserver/.
chmod -R 500 /opt/iir/iirserver/iir
 
fi

if  test -d /root/.gnome-desktop
then
	mv -f /opt/iir/iirserver/misc/rsc.desktop /root/.gnome-desktop/.
	cp -f /opt/iir/iirserver/misc/rsc.xpm /usr/share/pixmaps/.
fi


if test -d /root/Desktop
then
	mv -f /opt/iir/iirserver/misc/rsc.kdelink /root/Desktop/.
	cp -f /opt/iir/iirserver/misc/rsc.xpm /root/.kde/share/icons/.
fi

