#!/usr/bin/perl

##################################################################
# This script patches the kernel. It looks at the file called    #
# LATEST and reads the patch file names.                         #
#                                                                #
#       (C) Copyright Intel Corp. 2000                           #
##################################################################

$LOG_FILE = "/tmp/iir-install";
#### Get the current file name pointed to by /usr/src/linux
$pls = `ls -l /usr/src/linux`;
chomp($pls);
($some, $realls) = split("->",$pls);
($discard, $src_version) = split("-", $realls);


open(PATCHLIST,"../Kernel/Patches/LATEST") or die "Can't open LATEST: $!\n";
#open(PATCHLIST,"/iir_install/Kernel/Patches/LATEST") or die "Can't open LATEST: $!\n";

$src_dir = "/usr/src/linux";

#$current_version = `uname -r`;
$current_version = $src_version;

chomp($current_version);

while ($line = <PATCHLIST>) {
chomp($line);
	if ($line ne "PRIVATE") {
		($patch_file_name, $patch_version) = split(" ",$line);	
		if ($patch_version ne $current_version) {
		#print "Upgrading Linux Kernel version: $current_version to $patch_version \n";
		`cp  ../Kernel/Patches/Official/$patch_file_name $src_dir`;
		`cd $src_dir ; zcat -f $patch_file_name | patch -p1 >> $LOG_FILE`  ;
		#`cd $src_dir ; zcat -f /iir_install/Kernel/Patches/Official/$patch_file_name | patch -p1`  ;
		#system("cd $src_dir ; zcat -f /iir_install/Kernel/Patches/Official/$patch_file_name | patch -p1")  ;
	$current_version = $patch_version;
		} #end of if
	next;
	} #end of if 
	elsif ($line eq "PRIVATE") {
		$line = <PATCHLIST>;
		chomp($line);
		#print "Applying the internal patch: $line \n";
		`echo "Applying the internal patch: $line \n" >> $LOG_FILE`;
		`cp ../Kernel/Patches/Internal/$line $src_dir`;
		`cd $src_dir ; zcat -f $line | patch -p1 >> $LOG_FILE`  ;
		#`cd $src_dir ; zcat -f /iir_install/Kernel/Patches/Internal/$line | patch -p1`  ;
		last;
	} #end of elsif
	else {
		print "ERROR: Wrong formatting of LATEST file\n";
		print "Contact the IIR Linux team. \n";
	} #end of else
} #end of while

if ($src_version ne $current_version) {
#print "\nRenaming the source directory correctly from /usr/src/linux-$src_version to /usr/src/linux-$current_version\n";
system("rm -f /usr/src/linux; mv /usr/src/linux-$src_version /usr/src/linux-$current_version;ln -s /usr/src/linux-$current_version /usr/src/linux");
}

#print "\nWriting uninstall info\n";
`rm -f /opt/iir/uninstall/version_installed.dat`;
`echo -n $current_version > /opt/iir/uninstall/version_installed.dat`;
