#!/bin/sh

TARGETDIR=/usr/sbin
INSTALL=/usr/bin/install

echo "Installing srcd in $TARGETDIR..."
$INSTALL -m 750 -o root -g wheel srcd $TARGETDIR
$INSTALL -m 750 -o root -g wheel srcdconf.sh $TARGETDIR

echo "Installing srcd.conf in /etc..."
if [ -f /etc/srcd.conf ]; then
    while [ "$answer" != "y" -a "$answer" != "n" ]; do
	echo -n "/etc/srcd.conf already exists. Overwrite it (y/n) ? "
	read answer
    done
    if [ "$answer" = "n" ]; then
	echo "leaving /etc/srcd.conf untouched."
    else
	echo "writing new /etc/srcd.conf."
    fi
else
    answer="y"
fi

if [ "$answer" = "y" ]; then
    $INSTALL -m 644 -o root -g root srcd.conf /etc
fi

# launch $TARGETDIR/srcdconf.sh
$TARGETDIR/srcdconf.sh

