#!/bin/sh
clear

MYPWD=`pwd`

MYDIR=`dirname $0`

cd $MYDIR

COUNT="0"

LOOP="YES"
A=" " # keeps track whether storcon selected
B=" "
C=" "
D=" "
PKGS="0"

header()
{
clear
echo "             RAID Software Suite Install"
echo "             ==========================="
echo
}

which_pkg()
{
DISTRO="TGZ"
#while [ "$LOOP" = "YES" ]
#do
	header
	echo
	echo "	Unknown Linux system. Based on your system,"
	echo "	choose from the following packaging format:"
	echo " 	1. RPM : Redhat Package Manager format (*.rpm)"
	echo " 	2. DEB : Debian Package format(*.deb)"
	echo " 	3. TGZ : Tarred-gzipped format (suitable for any system)."
	echo
	echo -n "	Enter choice # [default: 3($DISTRO)]: "
	read CHOICE
	if [ "$CHOICE" != "" ]
	then
	case $CHOICE in
	
	1)
		echo "INFO: setting package type to RPM format"
		DISTRO="RPM"
		;;
	2)
		echo "INFO: setting package type to Debian format"
		DISTRO="DEB"
		;;
	3)
		echo "INFO: setting package type to distro-independent TGZ format "
		DISTRO="TGZ"
		;;
	*)
		echo "INFO: setting package type to distro-independent TGZ format "
		DISTRO="TGZ"
		;;
	esac
	else
		echo "INFO: setting package type to distro-independent TGZ format "
		DISTRO="TGZ"
	fi
		
#done	

}


choose_menu()
{
while [ "$LOOP" = "YES" ]
do
	header
	echo " 	Select/Deselect components to install." 
	echo "	Choose from the following menu:"
	echo " 	[$A]1. StorCon : Storage console"
	echo " 	[$B]2. iircfg  : Commandline configuration tool."
	echo " 	[$C]3. srcd    : Remote monitoring service."
	echo " 	[$D]4. All the above"
	echo " 	 I. Finished selection, Install."
	echo " 	 U. Finished selection, Uninstall."
	echo " 	 Q. Done,Quit."
	echo 
	echo " 	Selected $PKGS/3 packages."
	echo -n "	Enter choice: "
	read CHOICE
	
	case $CHOICE in
		1)
			if [ "$A" = " " ]
			then
			A="*" ; let "PKGS = PKGS + 1"
			else
			A=" " ; let "PKGS = PKGS - 1"
			fi
			;;
		2)
			if [ "$B" = " " ]
			then
			B="*" ; let "PKGS = PKGS + 1"
			else
			B=" " ; let "PKGS = PKGS - 1"
			fi
			;;
		3)
			if [ "$C" = " " ]
			then
			C="*" ; let "PKGS = PKGS + 1"
			else
			C=" " ; let "PKGS = PKGS - 1"
			fi
			;;
		4)
			if [ "$D" = " " ]
			then
			D="*" ; C="*"; B="*" ; A="*"; let "PKGS = 3"
			else
			D=" " ; C=" "; B=" " ; A=" "; let "PKGS = 0"
			fi
			
			;;
		
		i)
			COUNT="0"
			install_pkg
			#LOOP="NO"
			;;
		I)
			COUNT="0"
			install_pkg
			#LOOP="NO"
			;;
		u)
			COUNT="0"
			uninstall_pkg
			#LOOP="NO"
			;;
		U)
			COUNT="0"
			uninstall_pkg
			#LOOP="NO"
			;;
		q)
			cd $MYDIR
			exit
			;;
		Q)
			cd $MYDIR
			exit
			;;
		esac
done
}

which_distro()
{

if [ -r /etc/mandrake-release ]
then
        DISTROMSG="Working on a RPM compatible machine: Mandrake Linux"
        DISTRO="RPM"

elif [ -r /etc/redhat-release ]
then
        DISTROMSG="Working on a RPM compatible machine: Redhat Linux"
	echo $DISTROMSG
        DISTRO="RPM"

elif [ -r /etc/debian_version ]
then
        DISTROMSG="Working on a DEB compatible machine: Debian Linux"
        DISTRO="DEB"
elif [ -r /etc/turbolinux-release ]
then
        DISTROMSG="Working on a RPM compatible machine: TurboLinux"
        DISTRO="RPM"

elif [ -r /etc/SuSE-release ]
then
        DISTROMSG="Working on a RPM compatible machine: SuSE Linux"
        DISTRO="RPM"
else
        if [ -r /etc/issue ]
        then
                ISSUE=`grep Caldera /etc/issue`
                if [ "$ISSUE" = "" ]
                then
			DISTROMSG="Working on Unknown Linux system"
                        echo "Unsupported Linux distribution"
                        echo "Supported Linux distributions are:"
                        echo "Redhat, SuSE, Mandrake, Debian, TurboLinux and Caldera
OpenLinux"
                        echo "Proceed at your own risk."
                        echo "You might need to edit some of the config and startup scripts yourself"
                        echo "Proceed with installation ? (y/n/Q)" n
                        if [ "$answer" = "n" -o "$answer" = "N" ]  
			then
                                echo ""
                                echo "Installation terminated by user."
                                echo ""
				cd $MYDIR
                                exit 0
			else
				which_pkg
				DISTROMSG="Working on Unknown Linux system"
                        fi

                else

                        DISTROMSG="Working on a RPM compatible machine: Caldera OpenLinux"

                        DISTRO="RPM"
                fi #if ISSUE was empty
        fi #/etc/issue
fi #end of big if

}

tgz_install_command()
{
cd /
tar zxf $MYDIR/$PKGNAME
PGMNAME=`ls /usr/iir/$PROGRAM-*`
if [ -f $PGMNAME ]
then
	if [ ! -L /usr/sbin/$PROGRAM ]
	then
		ln -s $PGMNAME /usr/sbin/$PROGRAM
	else
		echo "WARNING: Symbolic link /usr/sbin/$PROGRAM already exists."
		echo "INFO: You might need to set it manually to $PGMNAME"
	fi

	if [ "$PROGRAM" = "srcd" ]
	then
		if [ -f /usr/iir/srcdconf.sh ]
		then
			if [ ! -L /usr/sbin/srcdconf.sh ]
			then
				ln -s /usr/iir/srcdconf.sh /usr/sbin/srcdconf.sh
			fi
			echo "INFO: Please run \"srcdconf.sh\" to configure srcd."
		fi
	fi
fi
cd $MYDIR
}

install_program()
{

PKGNAME=`ls ./$PROGRAM*.tar.gz`

if [ "$DISTRO" = "DEB" ]
then
        PKGNAME=`ls ./$PROGRAM*.deb`
	COMMAND="dpkg -i $PKGNAME"
fi

if [ "$DISTRO" = "RPM" ]
then
	PKGNAME=`ls ./$PROGRAM*.rpm`
	COMMAND="rpm -Uvh $PKGNAME"
fi
echo "	Installing $PROGRAM package:"
if [ -f $PKGNAME ]
then
	if [ "$DISTRO" = "TGZ" ]
	then
		tgz_install_command
	else
		$COMMAND
		if [ "$?" != "0" ]
		then
			echo "WARNING: $COMMAND returned failed status."
			echo "INFO: You might have to install the package manually"
			echo "INFO: Press <ENTER> to continue."
			read INPUT
		fi
	fi
	
else
	echo "ERROR: Cannot locate the $PROGRAM $DISTRO package"
	echo "ERROR: Please locate the $DISTRO package and install"
	echo "ERROR: it using the command $COMMAND"
	echo "INFO: Press <ENTER> to continue."
	read INPUT
fi
echo "	done"
echo

}

install_screen()
{
clear
header
echo $DISTROMSG
echo
#echo "Processing selected components: $COUNT/$PKGS."
echo
}

install_pkg()
{
install_screen;
sleep 3
if [ "$A" = "*" ]
then
	let "COUNT = COUNT + 1"
	#install_screen;
	echo "Processing selected components: $COUNT/$PKGS."
	PROGRAM="storcon"
	install_program
	#A="i"
fi
if [ "$B" = "*" ]
then
	let "COUNT = COUNT + 1"
	#install_screen;
	echo "Processing selected components: $COUNT/$PKGS."
	PROGRAM="iircfg"
	install_program
	#B="i"
fi
if [ "$C" = "*" ]
then
	let "COUNT = COUNT + 1"
	#install_screen;
	echo "Processing selected components: $COUNT/$PKGS."
	PROGRAM="srcd"
	install_program
	#C="i"
fi
echo "Selected components installed."
echo "Press <ENTER> to continue"
read INPUT
#D=" "
}

tgz_uninstall_command()
{

if [ "$PROGRAM" = "storcon" ]
then
	rm -f /usr/iir/storcon-*
	rm -f /usr/sbin/storcon
	rm -f /usr/share/man/man8/storcon.8
	rm -f /usr/share/man/man8/storcon.8.gz
fi

if [ "$PROGRAM" = "srcd" ]
then
	rm -f /usr/iir/srcd-*
	rm -f /usr/sbin/srcd
	rm -f /usr/sbin/srcdconf.sh
	rm -f /usr/iir/srcdconf.sh
	rm -f /usr/iir/srctrap.mib
	rm -f /usr/share/man/man8/srcd.8
	rm -f /usr/share/man/man8/srcd.8.gz
fi

if [ "$PROGRAM" = "iircfg" ]
then
	rm -f /usr/iir/iircfg-*
	rm -f /usr/sbin/iircfg
	rm -f /usr/share/man/man8/iircfg.8
	rm -f /usr/share/man/man8/iircfg.8.gz
fi

DIRCHECK=`ls /usr/iir`
if [ "$DIRCHECK" = "" ]
then
	rm -rf /usr/iir
fi

}



uninstall_program()
{
	echo "Uninstalling $PROGRAM :"
	if [ "$DISTRO" = "TGZ" ]
	then
		tgz_uninstall_command	
	else
	if [ "$DISTRO" = "DEB" ]
	then
		dpkg -r $PROGRAM	
	fi

	if [ "$DISTRO" = "RPM" ]
	then
		rpm -ev $PROGRAM
	fi

	if [ "$?" != "0" ]
	then
		echo "ERROR: command returned failed status."
		echo "INFO: You might have to uninstall the package manually"
		echo "INFO: Press <ENTER> to continue."
		read INPUT
	fi
	fi
echo "Done."
echo
}

uninstall_pkg()
{
install_screen;
if [ "$A" = "*" ]
then
	sleep 1
	let "COUNT = COUNT + 1"
	echo "Processing selected components: $COUNT/$PKGS."
	PROGRAM="storcon"
	uninstall_program
	A="u"
fi
if [ "$B" = "*" ]
then
	sleep 1
	let "COUNT = COUNT + 1"
	echo "Processing selected components: $COUNT/$PKGS."
	PROGRAM="iircfg"
	uninstall_program
	#B="u"
fi
if [ "$C" = "*" ]
then
	sleep 1
	let "COUNT = COUNT + 1"
	echo "Processing selected components: $COUNT/$PKGS."
	PROGRAM="srcd"
	uninstall_program
	#C="u"
fi
D=" "
echo "Selected components uninstalled."
echo "Press <ENTER> to continue"
read INPUT
}


which_distro
choose_menu

cd $MYPWD
