/*
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */
/******************************************************************************
 * File Name:   ctrl3204.c
 * Description: this file contains control related functions
 *
 ******************************************************************************/

#include "ixf3204.h"

/*******************************************************************************
 * Function Name: IXF3204GetAPIVersion
 * Returns: TEstatus
 * Description: This function retrives the software version
 ******************************************************************************/
TEstatus IXF3204GetAPIVersion(void * Results)
{
    TEdword *ReturnValue = (TEdword *)Results;

    CHK_NULL(ReturnValue);

    ReturnValue[0] = IXF3204_API_VERSION_MJR;
    ReturnValue[1] = IXF3204_API_VERSION_MNR;

    return TE_STATUS_SUCCESS;
}

