/*
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

 /**************************************************************************
  *    File name:      framer.h
  *    Description:    This is a header file for Framer APIs.
  *                    It contains all  parameter values especific to Framer
  ***************************************************************************/

#ifndef __FRAMER_H_
#define __FRAMER_H_


/**************************************************************************
 * API parameter definitions                                              *
 **************************************************************************/

/* FDL definitions */
#define  TE_FDL0             0x0008
#define  TE_FDL1             0x0009
#define  TE_FDL2             0x000A
#define  TE_FDL3             0x000B
#define  TE_FDL4             0x000C
#define  TE_FDL5             0x000D
#define  TE_FDL6             0x000E
#define  TE_FDL7             0x000F

/* BERT definitions */
#define  TE_BERT0            0x0010
#define  TE_BERT1            0x0011
#define  TE_BERT2            0x0012
#define  TE_BERT3            0x0013
#define  TE_BERT4            0x0014
#define  TE_BERT5            0x0015
#define  TE_BERT6            0x0016
#define  TE_BERT7            0x0017

#define  TE_NONINV           0x0020
#define  TE_INV              0x0021
#define  TE_GRAL             0x0025
#define  TE_FSYNC            0x0026
#define  TE_NRZ              0x0027
#define  TE_AMIPOST          0x0028
#define  TE_DE1              0x0031
#define  TE_DE2              0x0032
#define  TE_DE4              0x0033
#define  TE_DE8              0x0034
#define  TE_DE16             0x0035
#define  TE_DE32             0x0036
#define  TE_DE256            0x0037
#define  TE_DE512            0x0038
#define  TE_MS3              0x0039
#define  TE_MS9              0x003A
#define  TE_MS15             0x003B
#define  TE_MS21             0x003C
#define  TE_MS27             0x003D
#define  TE_MS33             0x003E
#define  TE_MS39             0x003F
#define  TE_MS42             0x0040
#define  TE_EXZCOUNT         0x0041
#define  TE_BPVCOUNT         0x0042
#define  TE_HDB3COUNT        0x0043
#define  TE_RE1              0x0044
#define  TE_RE2              0x0045
#define  TE_CRC4             0x0050
#define  TE_CAS              0x0051
#define  TE_D4               0x0052
#define  TE_ESF              0x0053
#define  TE_SLC96            0x0054
#define  TE_FAS              0x0055
#define  TE_CRC4CAS          0x0056
#define  TE_J12              0x0057
#define  TE_J24              0x0058
#define  TE_FTFS             0x005E
#define  TE_FT               0x005F

#define  TE_FASNFAS          0x0061
#define  TE_NOCRC4           0x0062
#define  TE_NOCAS            0x0063
#define  TE_F10              0x0064
#define  TE_F24              0x0065
#define  TE_CHTOCH           0x006B
#define  TE_TWOFRAMES        0x0075
#define  TE_MINDELAY         0x0076
#define  TE_BYPASS           0x0077
#define  TE_RCLK0            0x0078
#define  TE_RCLK1            0x0079
#define  TE_RCLK2            0x007A
#define  TE_RCLK3            0x007B
#define  TE_RCLK4            0x007C
#define  TE_RCLK5            0x007D
#define  TE_RCLK6            0x007E
#define  TE_RCLK7            0x007F
#define  TE_CLK0             0x0080
#define  TE_CLK1             0x0081
#define  TE_CLK2             0x0082
#define  TE_CLK3             0x0083
#define  TE_CLK4             0x0084
#define  TE_CLK5             0x0085
#define  TE_CLK6             0x0086
#define  TE_CLK7             0x0087
#define  TE_CLKA             0x0088
#define  TE_CLKB             0x0089
#define  TE_BTCLK0           0x008A
#define  TE_BTCLK1           0x008B
#define  TE_BTCLK2           0x008C
#define  TE_BTCLK3           0x008D
#define  TE_BTCLK4           0x008E
#define  TE_BTCLK5           0x008F
#define  TE_BTCLK6           0x0090
#define  TE_BTCLK7           0x0091
#define  TE_EXTT1CLK         0x0092
#define  TE_EXTE1CLK         0x0093
#define  TE_RXBP             0x0094
#define  TE_TXBP             0x0095
#define  TE_TXLINE           0x0096
#define  TE_BTCLK            0x0098
#define  TE_EXTCLKINTA       0x0099
#define  TE_EXTCLKINTB       0x009A
#define  TE_ADPLL            0x009B
#define  TE_RXFRAMER         0x009C
#define  TE_ENABLERX         0x00A0
#define  TE_ENABLETX         0x00A1
#define  TE_FRAMED           0x00A2
#define  TE_UNFRAMED         0x00A3
#define  TE_RATE1            0x00A4
#define  TE_RATE2            0x00A5
#define  TE_RATE3            0x00A6
#define  TE_RATE4            0x00A7
#define  TE_RATE5            0x00A8
#define  TE_RATE6            0x00A9
#define  TE_RATE7            0x00AA
#define  TE_SINGLEERROR      0x00AB
#define  TE_R2               0x00AC
#define  TE_NOFORCE          0x00AD
#define  TE_HDLC0            0x00AE
#define  TE_HDLC1            0x00AF
#define  TE_HDLC2            0x00B0
#define  TE_HDLC3            0x00B1
#define  TE_HDLC4            0x00B2
#define  TE_HDLC5            0x00B3
#define  TE_HDLC6            0x00B4
#define  TE_HDLC7            0x00B5
#define  TE_HDLC8            0x00B6
#define  TE_HDLC9            0x00B7
#define  TE_HDLC10           0x00B8
#define  TE_HDLC11           0x00B9
#define  TE_HDLC12           0x00BA
#define  TE_HDLC13           0x00BB
#define  TE_HDLC14           0x00BC
#define  TE_HDLC15           0x00BD
#define  TE_HDLC16           0x00BE
#define  TE_HDLC17           0x00BF
#define  TE_HDLC18           0x00C0
#define  TE_HDLC19           0x00C1
#define  TE_HDLC20           0x00C2
#define  TE_HDLC21           0x00C3
#define  TE_HDLC22           0x00C4
#define  TE_HDLC23           0x00C5
#define  TE_STUFFSTUFF       0x00CB
#define  TE_STUFFSIG         0x00CC
#define  TE_SIGSTUFF         0x00CD
#define  TE_SIGSIG           0x00CE
#define  TE_LOF              0x00CF
#define  TE_LOCASMF          0x00D1
#define  TE_AUXP             0x00D3
#define  TE_AISCI            0x00D4
#define  TE_CUSTOM           0x00D5
#define  TE_CODEWORD         0x00D6
#define  TE_J1RAI            0x00D7
#define  TE_RAI              0x00D8
#define  TE_MFLOS            0x00D9
#define  TE_INTERWORKING     0x00DA
#define  TE_ZERO             0x00DB
#define  TE_ONE              0x00DC
#define  TE_E1_OOF           0x00DD
#define  TE_E1_LOS           0x00DE
#define  TE_E1_AIS           0x00DF
#define  TE_E1_RAI           0x00E0
#define  TE_T1_OOF           0x00E1
#define  TE_T1_LOS           0x00E2
#define  TE_T1_AIS           0x00E3
#define  TE_T1_RAI           0x00E4
#define  TE_FLAGS            0x00E5
#define  TE_ONES             0x00E6
#define  TE_HYSTERESIS       0x00E7
#define  TE_CONTINUOUS       0x00E8
#define  TE_TIMES            0x00E9
#define  TE_EOM              0x00EA
#define  TE_EXP0             0x00ED
#define  TE_EXP_1            0x00EE
#define  TE_EXP_2            0x00EF
#define  TE_EXP_3            0x00F0
#define  TE_EXP_4            0x00F1
#define  TE_EXP_5            0x00F2
#define  TE_EXP_6            0x00F3
#define  TE_EXP_0            0x00F4
#define  TE_R1               0x00F5
#define  TE_R1_2             0x00F6
#define  TE_R1_3             0x00F7
#define  TE_R1_4             0x00F8
#define  TE_R1_5             0x00F9
#define  TE_R1_6             0x00FA
#define  TE_R1_7             0x00FB
#define  TE_HDB3CV           0x00FC
#define  TE_BRCLK            0x00FD
#define  TE_NONCONTINUOUS    0x00FE
#define  TE_MFASCAS          0x0001
#define  TE_MFASCRC4         0x0002
#define  TE_SMFICRC4         0x0003
#define  TE_SMFIICRC4        0x0004
#define  TE_FTFE             0x0055/* this value must be the same as TE_FAS  */
#define  TE_FSCRC            0x0008/* This value must be the same as TE_NFAS */
#define  TE_NFAS             0x0008
#define  TE_FBIT             0x0009
#define  TE_CCS              0x000A
#define  TE_RXHDLC1          0x000D
#define  TE_RXHDLC2          0x000E
#define  TE_RXHDLC3          0x000F
#define  TE_TXHDLC1          0x0010
#define  TE_TXHDLC2          0x0011
#define  TE_TXHDLC3          0x0012
#define  TE_EVENT1           0x0013
#define  TE_EVENT2           0x0014
#define  TE_BERT             0x0015
#define  TE_FDL              0x0019
#define  TE_NEAREND          0x001A
#define  TE_FAREND           0x001B
#define  TE_4K               0x001C
#define  TE_2KODD            0x001D
#define  TE_2KEVEN           0x001E
#define  TE_MFAIS            0x001F
#define  TE_MFRAI            0x0020

/* performance elements */
#define  TE_ESR              0x001F
#define  TE_SESR             0x0020
#define  TE_BBER             0x0021
#define  TE_ETIME            0x0022
#define  TE_UAS              0x0023
#define  TE_AVAILR           0x0024
#define  TE_AVAILT           0x0025
#define  TE_CV_L             0x0026
#define  TE_ES_L             0x0027
#define  TE_SES_L            0x0028
#define  TE_CV_P             0x0029
#define  TE_ES_P             0x002A
#define  TE_SES_P            0x002B
#define  TE_SAS_P            0x002C
#define  TE_UAS_P            0x002D
#define  TE_CSS_P            0x002E
#define  TE_ESA_P            0x002F
#define  TE_ESB_P            0x0030
#define  TE_SEFS_P           0x0031
#define  TE_CRC              0x0032
#define  TE_EBIT             0x0033
#define  TE_FE               0x0034
#define  TE_LCV              0x0035
#define  TE_OOF              0x0036
#define  TE_CSR              0x0037
#define  TE_CST              0x0038
#define  TE_COFA             0x0039
#define  TE_CURRENTDAY       0x003A
#define  TE_PREVIOUSDAY      0x003B
#define  TE_CURRENT15MIN     0x003C
#define  TE_PREVIOUS15MIN    0x003D
#define  TE_RECENT15MIN0     0x003E
#define  TE_RECENT15MIN1     0x003F
#define  TE_RECENT15MIN2     0x0040
#define  TE_RECENT15MIN3     0x0041
#define  TE_RECENT15MIN4     0x0042
#define  TE_RECENT15MIN5     0x0043
#define  TE_RECENT15MIN6     0x0044
#define  TE_RECENT15MIN7     0x0045
#define  TE_RECENT15MIN8     0x0046
#define  TE_RECENT15MIN9     0x0047
#define  TE_RECENT15MIN10    0x0048
#define  TE_RECENT15MIN11    0x0049
#define  TE_RECENT15MIN12    0x004A
#define  TE_RECENT15MIN13    0x004B
#define  TE_RECENT15MIN14    0x004C
#define  TE_RECENT15MIN15    0x004D
#define  TE_RECENT15MIN16    0x004E
#define  TE_RECENT15MIN17    0x004F
#define  TE_RECENT15MIN18    0x0050
#define  TE_RECENT15MIN19    0x0051
#define  TE_RECENT15MIN20    0x0052
#define  TE_RECENT15MIN21    0x0053
#define  TE_RECENT15MIN22    0x0054
#define  TE_RECENT15MIN23    0x0055
#define  TE_RECENT15MIN24    0x0056
#define  TE_RECENT15MIN25    0x0057
#define  TE_RECENT15MIN26    0x0058
#define  TE_RECENT15MIN27    0x0059
#define  TE_RECENT15MIN28    0x005A
#define  TE_RECENT15MIN29    0x005B
#define  TE_RECENT15MIN30    0x005C

#define  TE_SA4              0x005D
#define  TE_SA5              0x005E
#define  TE_SA6              0x005F
#define  TE_SA7              0x0060
#define  TE_SA8              0x0061
#define  TE_SIFAS            0x0062
#define  TE_SINFAS           0x0063
#define  TE_ULAW             0x0064
#define  TE_ALAW             0x0065
#define  TE_192              0x0068
#define  TE_193              0x0069
#define  TE_256              0x006A

#define  TE_TS0              0x0001
#define  TE_TS1              0x0002
#define  TE_TS2              0x0003
#define  TE_TS3              0x0004
#define  TE_TS4              0x0005
#define  TE_TS5              0x0006
#define  TE_TS6              0x0007
#define  TE_TS7              0x0008
#define  TE_TS8              0x0009
#define  TE_TS9              0x000A
#define  TE_TS10             0x000B
#define  TE_TS11             0x000C
#define  TE_TS12             0x000D
#define  TE_TS13             0x000E
#define  TE_TS14             0x000F
#define  TE_TS15             0x0010
#define  TE_TS16             0x0011
#define  TE_TS17             0x0012
#define  TE_TS18             0x0013
#define  TE_TS19             0x0014
#define  TE_TS20             0x0015
#define  TE_TS21             0x0016
#define  TE_TS22             0x0017
#define  TE_TS23             0x0018
#define  TE_TS24             0x0019
#define  TE_TS25             0x001A
#define  TE_TS26             0x001B
#define  TE_TS27             0x001C
#define  TE_TS28             0x001D
#define  TE_TS29             0x001E
#define  TE_TS30             0x001F
#define  TE_TS31             0x0020
#define  TE_DRS0             0x0021
#define  TE_DRS1             0x0022
#define  TE_DRS2             0x0023
#define  TE_DRS3             0x0024
#define  TE_DRS4             0x0025
#define  TE_DRS5             0x0026
#define  TE_DRS6             0x0027
#define  TE_DRS7             0x0028
#define  TE_DMW0             0x0029
#define  TE_DMW1             0x002A
#define  TE_DMW2             0x002B
#define  TE_DMW3             0x002C
#define  TE_DMW4             0x002D
#define  TE_DMW5             0x002E
#define  TE_DMW6             0x002F
#define  TE_DMW7             0x0030
#define  TE_RXALARM1         0x0031
#define  TE_RXALARM2         0x0032
#define  TE_TXALARM          0x0033
#define  TE_12FRAMES         0x0034
#define  TE_16FRAMES         0x0035
#define  TE_24FRAMES         0x0036
#define  TE_72FRAMES         0x0037
#define  TE_STATE_4          0x0038
#define  TE_STATE_9          0x0039
#define  TE_NONAUTO          0x0040

#define TE_E1C4CFG           0x1001
#define TE_DS1GIE            0x1002
#define TE_ALTCRC6           0x1003
#define TE_FCSD              0x1004
#define TE_ESF_TRANS         0x1005
#define TE_D4_TRANS          0x1006
#define TE_CAS_TRANS         0x1007
#define TE_FASNFAS_TRANS     0x1008
#define TE_CRC4_TRANS        0x1009
#define TE_CRC6              0x100A

#define TE_AISOOF            0x1010
#define TE_AISCRC4OOF        0x1011

#define TE_NWCLK             0x1020

#define TE_FE_CRC6_FSYNC     0x1100

#define TE_INFRAME           0x1030
#define TE_REFRAME           0x1031


/* DS3/E3 Line modes */
#define TE_M23               0x1050
#define TE_CBIT              0x1051
#define TE_UNCHAN            0x1052
#define TE_DUAL_RAIL         0x1053
#define TE_SINGLE_RAIL       0x1054

/* STS/STM Overhead byte definitions */
#define TE_OHD_A1            0x1100
#define TE_OHD_A2            0x1101
#define TE_OHD_H1            0x1102
#define TE_OHD_H2            0x1103
#define TE_OHD_H3            0x1104
#define TE_OHD_K1            0x1105
#define TE_OHD_K2            0x1106
#define TE_OHD_S1            0x1107
#define TE_OHD_M1            0x1108
#define TE_OHD_C2            0x1109
#define TE_OHD_G1            0x110A
#define TE_OHD_B1_MASK       0x110B
#define TE_OHD_B2_MASK       0x110C
#define TE_OHD_B3_MASK       0x110D
#define TE_OHD_F2            0x110E
#define TE_OHD_D1            0x110F
#define TE_OHD_D2            0x1110
#define TE_OHD_D3            0x1111
#define TE_OHD_D4            0x1112
#define TE_OHD_D5            0x1113
#define TE_OHD_D6            0x1114
#define TE_OHD_D7            0x1115
#define TE_OHD_D8            0x1116
#define TE_OHD_D9            0x1117
#define TE_OHD_D10           0x1118
#define TE_OHD_D11           0x1119
#define TE_OHD_D12           0x111A
#define TE_OHD_E1            0x111B
#define TE_OHD_E2            0x111C
#define TE_OHD_F1            0x111D
#define TE_OHD_J0            0x111E
#define TE_OHD_J1            0x1123
#define TE_OHD_OBIT_J2       0x1124
#define TE_OHD_OBIT_Z6       0x1125
#define TE_OHD_B3            0x1126
#define TE_OHD_H4            0x1127
#define TE_OHD_E2_NU         0x1128
#define TE_OHD_F1_NU         0x1129
#define TE_OHD_Z5_N1         0x112A
#define TE_OHD_Z4_K3         0x112B
#define TE_OHD_Z3_F3         0x112C
#define TE_OHD_Z0            0x112D
#define TE_OHD_Z1            0x112E
#define TE_OHD_Z2            0x112F
#define TE_OHD_H1_TUG3       0x1130
#define TE_OHD_H2_TUG3       0x1131
#define TE_OHD_H3_TUG3       0x1132

/* VT/TU Overhead bytes */
#define TE_OHD_VTTU_Z7       0x1500
#define TE_OHD_VTTU_Z6       0x1501
#define TE_OHD_VTTU_J2       0x1502
#define TE_OHD_VTTU_V5       0x1503
#define TE_OHD_VTTU_SS       0x1504
#define TE_OHD_VTTU_V1_SIZE  0x1505
#define TE_OHD_VTTU_SIZE     0x1506


#endif

