/*
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

/******************************************************************************
 * File Name:   ini3204.h
 * Description: this file contains the default values of several modules
 *
 ******************************************************************************/

#ifndef _INI_H_
#define _INI_H_
/* create variables with addresses and default values */
TEbyte IXF3204_LIU_num_addr = 9;
TEbyte IXF3204_LIU_def_value[] = {0x01,0x00,0x00,0x00,0x08,0x03,0x00,0x43,0x84};
TEbyte IXF3204_LIU_address_offset[] = {0x00,0x01,0x03,0x04,0x05,0x06,0x07,0x08,
                                       0x09};
TEbyte IXF3204_RXFRAMER_num_addr = 4;
TEbyte IXF3204_RXFRAMER_def_value[] = {0x04,0x80,0x8A,0x00};
TEbyte IXF3204_RXFRAMER_address_offset[] = {0x00,0x01,0x02,0x03};
TEbyte IXF3204_TXFRAMER_num_addr = 2;
TEbyte IXF3204_TXFRAMER_def_value[] = {0x80,0x00};
TEbyte IXF3204_TXFRAMER_address_offset[] = {0x00,0x01};
TEbyte IXF3204_RXFDL_num_addr = 9;
TEbyte IXF3204_RXFDL_def_value[] = {0x04,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00};
TEbyte IXF3204_RXFDL_address_offset[] = {0x00,0x01,0x02,0x03,0x04,0x05,
                                         0x06,0x07,0x08};
TEbyte IXF3204_TXFDL_num_addr = 14;
TEbyte IXF3204_TXFDL_def_value[] = {0x05,0x00,0x00,0x00,0x00,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00,0x00,0x00};
TEbyte IXF3204_TXFDL_address_offset[] = {0x00,0x02,0x05,0x06,0x07,0x08,
                                         0x09,0x0A,0x0B,0x0C,0x0D,0x0F,
                                         0x10,0x11};
TEbyte IXF3204_RXMAP_num_addr = 4;
TEbyte IXF3204_RXMAP_def_value[] = {0x01,0x00,0xFF,0xFF};
TEbyte IXF3204_RXMAP_address_offset[] = {0x00,0x01,0x02,0x03};
TEbyte IXF3204_RXSIG_num_addr = 5;
TEbyte IXF3204_RXSIG_def_value[] = {0xF7,0x00,0x00,0x00,0x00};
TEbyte IXF3204_RXSIG_address_offset[] = {0x00,0x01,0x02,0x03,0x04};
TEbyte IXF3204_TXSIG_num_addr = 12;
TEbyte IXF3204_TXSIG_def_value[] = {0x01,0x00,0xFF,0xFF,0xFF,0x00,0x00,
                                    0x00,0x00,0x00,0x00,0x00};
TEbyte IXF3204_TXSIG_address_offset[] = {0x00,0x01,0x02,0x03,0x04,0x05,
                                         0x06,0x07,0x08,0x09,0x0A,0x0B};
TEbyte IXF3204_RXALRM_num_addr = 1;
TEbyte IXF3204_RXALRM_def_value[] = {0x00};
TEbyte IXF3204_RXALRM_address_offset[] = {0x00};
TEbyte IXF3204_TXALRM_num_addr = 10;
TEbyte IXF3204_TXALRM_def_value[] = {0x06,0x01,0x00,0x08,0x08,0x08,0xCC,
                                     0x0F,0x00,0x00};
TEbyte IXF3204_TXALRM_address_offset[] = {0x00,0x01,0x10,0x11,0x12,0x13,
                                          0x14,0x15,0x16,0x17};
TEbyte IXF3204_SLIP_num_addr = 3;
TEbyte IXF3204_SLIP_def_value[] = {0x02,0x09,0x90};
TEbyte IXF3204_SLIP_address_offset[] = {0x00,0x01,0x02};
TEbyte IXF3204_BP_num_addr = 27;
TEbyte IXF3204_BP_def_value[] = {0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
                                 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                                 0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,
                                 0x00,0x00,0x01};
TEbyte IXF3204_BP_address_offset[] = {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
                                      0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
                                      0x10,0x11,0x12,0x13,0x17,0x18,0x19,0x1A,
                                      0x1B,0x1C,0x1D};
TEbyte IXF3204_RXBPSIG_num_addr = 3;
TEbyte IXF3204_RXBPSIG_def_value[] = {0xF5,0x00,0x00};
TEbyte IXF3204_RXBPSIG_address_offset[] = {0x00,0x01,0x02};
TEbyte IXF3204_TXBPSIG_num_addr = 1;
TEbyte IXF3204_TXBPSIG_def_value[] = {0x01};
TEbyte IXF3204_TXBPSIG_address_offset[] = {0x00};
TEbyte IXF3204_SYNC_num_addr = 4;
TEbyte IXF3204_SYNC_def_value[] = {0x00,0x14,0x51,0x0F};
TEbyte IXF3204_SYNC_address_offset[] = {0x00,0x01,0x02,0x03};
TEbyte IXF3204_NAT_num_addr = 9;
TEbyte IXF3204_NAT_def_value[] = {0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0xFF,0x00};
TEbyte IXF3204_NAT_address_offset[] = {0x00,0x10,0x11,0x12,0x013,0x14,0x15,0x16,
                                       0x17};
TEbyte IXF3204_RXHDLC_num_addr = 9;
TEbyte IXF3204_RXHDLC_def_value[] = {0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,
                                     0x00,0x00};
TEbyte IXF3204_RXHDLC_address_offset[] = {0x00,0x01,0x02,0x03,0x004,0x05,0x06,
                                          0x07,0x08};
TEbyte IXF3204_TXHDLC_num_addr = 1;
TEbyte IXF3204_TXHDLC_def_value[] = {0x04};
TEbyte IXF3204_TXHDLC_address_offset[] = {0x00};
TEbyte IXF3204_BERT_num_addr = 9;
TEbyte IXF3204_BERT_def_value[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
TEbyte IXF3204_BERT_address_offset[] = {0x00,0x01,0x02,0x03,0x004,0x05,0x06,
                                        0x07};

#endif

