/*
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.    THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.    Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.    Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

/******************************************************************************
 * File Name:   ixf3204.h
 * Description: this file contains function prototypes for ixf3204 API
 *
 ******************************************************************************/

#ifndef __IXF3204_H_
#define __IXF3204_H_


#ifdef __cplusplus

extern "C" {

#endif

#include "osal.h"
#include "tecomm.h"
#include "ixf3204d.h"
#include "framer.h"

#ifndef NULL
#define NULL    0
#endif

/*Device Specific Structure*/
typedef struct IXF3204struct{
        volatile TEword base_address;           /* For 16-bit addresses */
        volatile TEdword long_base_address;     /* For 32-bit addresses */
        void *client_handle;
}IXF3204struct;

/* define version numbers */
#define IXF3204_API_VERSION_MJR        1
#define IXF3204_API_VERSION_MNR        00

/* Defines specific to IXF3204 device */
#define TE_BP0                         0x0018
#define TE_BP1                         0x0019
#define TE_BP2                         0x001A
#define TE_BP3                         0x001B
#define TE_BP4	                       0x001C
#define TE_BP5	                       0x001D
#define TE_BP6                         0x001E
#define TE_BP7	                       0x001F

#define TE_W16                         0x0029
#define TE_W32                         0x002A
#define TE_W64                         0x002B
#define TE_W128                        0x002C
#define TE_W256                        0x002D
#define TE_W1024                       0x002E
#define TE_W2048                       0x002F
#define TE_W4096                       0x0030

/* Indicates position */
#define TE_POS0                        0x0050
#define TE_POS1                        0x0051
#define TE_POS2                        0x0052
#define TE_POS3                        0x0053
#define TE_POS4                        0x0054
#define TE_POS5                        0x0055
#define TE_POS6                        0x0056
#define TE_POS7                        0x0057

/* HDLC Buffer length */
#define IXF3204_BUFFER_LENGTH          64

#define IXF3204_MAX_TRIES              200
#define IXF3204_MAX_PRM_MESSAGE_SIZE   11
#define IXF3204_MAX_PORT               4
#define IXF3204_MAX_BP                 4
#define IXF3204_MAX_BERT               4
#define IXF3204_MAX_HDLC               16
#define IXF3204_MAX_TS                 32
#define IXF3204_MAX_RESULTS            11
#define IXF3204_NIBBLE                 4
#define IXF3204_BYTE                   8


/**************************************************************************
 * Declarations for all API entry points                                  *
 **************************************************************************/
/* Slipbuffer - slpb3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetSlipBufferClearCounters(void *handle, 
                               TEword Port, TEword Direction);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSlipBufferConfig(void *handle, 
                               TEword Port, TEword Mode, TEword AutoCenter);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSlipBufferConfig(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSlipBufferCenterPointer(void *handle, 
                               TEword Port, TEword Direction);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSlipBufferSlip(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSlipBufferDistance(void *handle, 
                               TEword Direction, TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSlipBufferReadStatus(void *handle, 
                               TEword Direction, TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSlipBufferWriteStatus(void *handle, 
                               TEword Direction, TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSlipBufferCount(void *handle, 
                               TEword Direction, TEword Port, void *Results);

/* Backplane - bakp3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneConcentration(void *handle, 
                               TEword Port, TEword Direction, TEword Value, 
                               TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneConcentration(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneDataRate(void *handle, 
                               TEword Port ,TEword Direction, TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneDataRate(void *handle, 
                               TEword Port ,TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneMasterSlaveMode(void *handle, 
                               TEword Port, TEword Direction, TEword Clk, 
                               TEword Sync, TEword Msync);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneMasterSlaveMode(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneMapping(void *handle, 
                               TEword Port, TEword Direction, TEword Mapping);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneMapping(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplanePayloadSettings(void *handle, 
                               TEword Port, TEword Direction, TEword ByteRep, 
                               TEword PosSig, TEword PosData);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplanePayloadSettings(void * handle,
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneTSTriState(void *handle, 
                               TEword Port, TEdword TimeSlot);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneTSTriState(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneSettings(void *handle, 
                               TEword Port, TEword Direction, TEword Edge, 
                               TEword Polarity, TEword Width, TEword DataEdge, 
                               TEword ClkRate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneSettings(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneFbitGapped(void *handle, 
                               TEword Port, TEword Direction, TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneFbitGapped(void *handle,
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneTSClkGap(void *handle, 
                               TEword Port, TEword Direction, TEword TS, 
                               TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneTSClkGap(void *handle, 
                               TEword Port, TEword Direction, TEword TS, 
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneInterleaving(void *handle, 
                               TEword Port, TEword Direction, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneInterleaving(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneSyncOffset(void *handle, 
                               TEword Port, TEword Direction, TEword Offset);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneSyncOffset(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneDataInversionMask(
                               void * handle, TEword Port, TEword Direction,
                               TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneDataInversionMask(
                               void * handle, TEword Port, TEword Direction,
                               void * Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBackplaneSignalingInversionMask(
                               void * handle, TEword Port, TEword Direction, 
                               TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBackplaneSignalingInversionMask(
                               void * handle, TEword Port, TEword Direction, 
                               void * Results);

/* Alarms - alrm3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsSend(void *handle, TEword Port, 
                               TEword AlarmSelected);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsSend(void *handle, TEword Port, 
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsSendMFRAI(void *handle,
                               TEword Port,TEword State);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsSendMFRAI(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsSendTS16AIS(void *handle,
                               TEword Port,TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsSendTS16AIS(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsSendREbits(void *handle, 
                               TEword Port, TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsSendREbits(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsSendRAI(void *handle, 
                               TEword Port,TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsSendRAI(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsEBitTransparent(void *handle, 
                               TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsEBitTransparent(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsRAITransparent(void *handle, 
                               TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsRAITransparent(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsTxStatus(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsRxDefect(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsRxFailure(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsThreshold(void *handle, 
                               TEword Defect,TEword SetValue,TEword ResetValue);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsThreshold(void *handle, 
                               TEword Defect, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsToSystem(void *handle, 
                               TEword Port,TEword Selected, TEbyte Pattern);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsToSystem(void *handle,
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsREbitEnable(void *handle,
                               TEword Port, TEword CRCMF, TEword LOS, TEword OOF,
                               TEword Interworking);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsREbitEnable(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsResponseToSys(void *handle, 
                               TEword Port, TEword Condition, TEword Alarm);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsResponseToSys(void *handle,
                               TEword Port,TEword Condition, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsResponseToLine(void *handle, 
                               TEword Port, TEword Condition, TEword Alarm);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsResponseToLine(void *handle, 
                               TEword Port,TEword Condition, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsCodeword(void *handle, 
                               TEword Port, TEword Condition, TEbyte Codeword,
                               TEword RAI_Codeword, TEword Sa5);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsCodeword(void *handle,
                               TEword Port, TEword Condition, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsMFRAITransparent(void *handle, 
                               TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsMFRAITransparent(void *handle,
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsMFAISTransparent(void *handle, 
                               TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsMFAISTransparent(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3208SetAlarmsE1CASResponseToLine(void *handle,
                               TEword Port, TEword condition, TEword alarm,
                               TEword mode);
LINKAGE_SPECIFICATION TEstatus IXF3208GetAlarmsE1CASResponseToLine(void *handle,
                               TEword Port, TEword condition, TEword alarm,
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetAlarmsResponseUponFailure(void *handle,
                                                                   TEword Port, 
                                                                   TEword oof,
                                                                   TEword ais,
                                                                   TEword los);
LINKAGE_SPECIFICATION TEstatus IXF3204GetAlarmsResponseUponFailure(void *handle,
                                                                   TEword Port,
                                                                   void *Results);


/* Clock selector - clks3204.c*/
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelOneSecondConfig(void *handle, 
                               TEword Rate, TEword ClkSource);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelOneSecondConfig(void *handle,
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelReferenceClkSource(void *handle, 
                               TEword Reference);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelReferenceClkSource(void *handle, 
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelPrescaleRateConf(void *handle, 
                               TEword BaseClk, TEword rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelPrescaleRateConf(void *handle, 
                               TEword BaseClk, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelADPLLSource (void *handle, 
                               TEword Direction, TEword Source);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelADPLLSource(void *handle,
                               TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelIntDistributionSource(
                               void *handle, TEword Clk, TEword Source);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelIntDistributionSource(
                               void *handle, TEword Clk, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelClkInputRate(void *handle, 
                               TEword Direction, TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelClkInputRate(void *handle, 
                               TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelClkOutputRate(void *handle, 
                               TEword Direction, TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelClkOutputRate(void *handle, 
                               TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelPortClkSource(void *handle, 
                               TEword Port, TEword Direction, TEword Source);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelPortClkSource(void *handle, 
                               TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelTxSyncPulseConf(void *handle,
                               TEword Port, TEword SyncSource, TEword SyncRate,
                               TEword MFSyncRate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelTxSyncPulseConf(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelSyncPulseFreeRun(void *handle, 
                               TEword Port, TEword BackplaneTx, 
                               TEword BackplaneRx, TEword TxSync, 
                               TEword TxMSync);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelSyncPulseFreeRun(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetClkSelSyncPulseFreeRunRate(void *handle,
                               TEword Port, TEword BackplaneRx, 
                               TEword BackplaneTx);
LINKAGE_SPECIFICATION TEstatus IXF3204GetClkSelSyncPulseFreeRunRate(void *handle,
                               TEword Port, void *Results);

/* BOP - bop3204.c*/
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPMode(void *handle, TEword Port,
                                TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPMode(void *handle, TEword Port,
                                void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPCounterMode(void *handle, 
                               TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPCounterMode(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPRxRAIEnable(void *handle, 
                               TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPRxRAIEnable(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPRxThreshold(void *handle, 
                               TEword Port, TEbyte Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPRxThreshold(void *handle, 
                               TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPClearCounter(void *handle, 
                               TEword Port);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPRxStatus(void *handle, TEword Port,
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPRxCode(void *handle, TEword Port, 
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPTxMode(void *handle, TEword Port, 
                               TEword Mode, TEword Times);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPTxMode(void *handle, TEword Port, 
                               void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBOPTxCode(void *handle, TEword Port,
                               TEbyte Code);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBOPTxCode(void *handle, TEword Port, 
                               void *Results);

/* BERT - bert3204.c*/
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTPattern(void *Results, TEword BERT,
                      TEbyte ps0, TEbyte ps1, TEbyte ps2, TEbyte ps3, TEbyte lr,
                      TEbyte tr, TEbyte ctr);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTPattern(void *handle, TEword BERT,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTRxSyncCriteria(void *handle, 
                      TEword InSyncWindow, TEword OutSyncWindow, 
                      TEword ErrorNubmer);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTRxSyncCriteria(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTControlSync(void *handle, 
                      TEword BERT, TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTControlSync(void *handle, 
                      TEword BERT, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTReSync(void *handle, TEword BERT);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTControlEnable(void *handle, 
                      TEword BERT, TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTControlEnable(void *handle, 
                      TEword BERT, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTTSBitmask(void *handle, TEword Port,
                      TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTTSBitmask(void *handle, TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTTSBitmaskToBP(void *handle, 
                      TEword Port, TEword Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTTSBitmaskToBP(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTControlLoadReg(void *handle, 
                      TEword BERT, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTControlLoadReg(void *handle, 
                      TEword BERT, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTTotalCount(void *handle, 
                      TEword BERT, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTErrorCount(void *handle, 
                      TEword BERT, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetBERTErrorInsert(void *handle, 
                      TEword BERT, TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTErrorInsert(void *handle, 
                      TEword BERT, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetBERTStatus(void *handle, TEword BERT, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetDRSDMPattern(void *handle, TEword BERT,
                      TEword DRSType, TEword DMWType);
LINKAGE_SPECIFICATION TEstatus IXF3204GetDRSDMPattern(void *handle, TEword BERT,
                      void *Results);
/* LIU - pli3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIUPolarity(void *handle, TEword Port,
                      TEword TxPos, TEword TxNeg, TEword TxClk, TEword RxPos, 
                      TEword RxNeg, TEword RxClk);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIUPolarity(void *handle, TEword Port, 
                      void *results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIUNegUnipolarMode(void *handle, 
                      TEword Port, TEword TNegValue, TEword RNegValue, 
                      TEbyte Pattern);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIUNegUnipolarMode(void *handle, 
                      TEword Port, void *results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIULineMode(void *handle, TEword Port,
                      TEword ZCSMode, TEword TxAMIMode, TEword ISDN, 
                      TEword RxAMIMode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIULineMode(void *handle, TEword Port,
                      void *results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIUClearCounter(void *handle, 
                      TEword Port);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIUForceError(void *handle, 
                      TEword Port);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIULOSDetection(void *handle, 
                      TEword Port, TEword Analog, TEword Digital, TEword SetWin,
                      TEword ClearWin, TEword DensityWin, TEword NoEXZ);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIULOSDetection(void *handle, 
                      TEword Port, void *results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLIUAISDetection(void *handle, 
                      TEword Port, TEword AISWindow, TEword UseOOF);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIUAISDetection(void *handle, 
                      TEword Port, void *results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIUStatus(void *handle, TEword Port,
                      void *results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLIUCounter(void *handle, TEword Port,
                      TEword Counter, void *results);

/* DDL - ddl3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetDDLTxMessage(void *handle, TEword Port,
                      TEbyte Byte1, TEbyte Byte2, TEbyte Byte3);
LINKAGE_SPECIFICATION TEstatus IXF3204GetDDLTxMessage(void *handle,TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetDDLRxValid(void *handle, TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetDDLRxMessage(void *handle, TEword Port,
                      void *Results);

/* Codeword - codw3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetCodewordRxMode(void *handle, 
                      TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordRxMode(void *handle,
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordRxValue(void *handle, 
                      TEword Port, TEword Selection, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetCodewordRxCounterMode(void *handle, 
                      TEword Port, TEword Counter, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordRxCounterMode(void *handle, 
                      TEword Port, TEword Counter, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordCounter(void *handle, 
                      TEword Port, TEword Counter, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetCodewordTxMode(void *handle, 
                      TEword Port, TEword Selection, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordTxMode(void *handle, 
                      TEword Port, TEword Selection, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetCodewordTxValue(void *handle, 
                      TEword Port, TEword Selection, TEbyte Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordTxValue(void *handle, 
                      TEword Port, TEword Selection, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCodewordStatus(void *handle, 
                      TEword Port, void *Results);

/* Framer - fram3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerType(void *handle, TEword Port, 
                      TEword Format, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerType(void *handle, TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerTxCRCTransparent(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerTxCRCTransparent(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerTxCASAlignment(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerTxCASAlignment(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerTxMFPulseSource(void *handle, 
                      TEword Port, TEword Source);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerTxMFPulseSource(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerRxMFPulseAlignment(void *handle, 
                      TEword Port, TEword Direction, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerRxMFPulseAlignment(void *handle, 
                      TEword Port, TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerAutoResync(void *handle, 
                      TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerAutoResync(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerRxForceOOF(void *handle, 
                      TEword Port);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerRxCRC(void *handle, TEword Port, 
                      TEword CRC, TEword CRCOOF);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerRxCRC(void *handle, TEword Port, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerRxFbitSync(void *handle, 
                      TEword Port, TEword Value, TEword FtSelected);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerRxFbitSync(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerT1OOFCriteria(void *handle, 
                      TEword Port, TEword Window, TEword Errors);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerT1OOFCriteria(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerE1OOFCriteria(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerE1OOFCriteria(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerE1CRC4Interworking(void *handle, 
                      TEword Port, TEword Criteria, TEword g706);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerE1CRC4Interworking(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerE1OOFonCRCErrorsCriteria(
                      void *handle, TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerE1OOFonCRCErrorsCriteria(
                      void *handle, TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerE1CASLossCriteria(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerE1CASLossCriteria(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFramerCRC4LossCriteria(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerCRC4LossCriteria(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerStatus(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerFBitErrorCounter(void *handle, 
                      TEword Port, TEword Selection, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerOOFCounter(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFramerCRCErrorCounter(void *handle, 
                      TEword Port, void *Results);

/* FDL - fdl3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLResetFIFO(void *handle, TEword Port,
                      TEword Direction);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLDataInv(void *handle, TEword Port,
                      TEword Direction, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLDataInv(void *handle, TEword Port,
                      TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLE1BitMask(void *handle, TEword Port,
                      TEword Direction, TEbyte SaMask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLE1BitMask(void *handle, TEword Port,
                      TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLT1Rate(void *handle, TEword Port, 
                      TEword Direction, TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLT1Rate(void *handle, TEword Port, 
                      TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLTxStatus(void *handle, TEword Port, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLLinkIDV52Enable(void * handle, 
                      TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLLinkIDV52Enable(void * handle, 
                      TEword Port,void * Results);

/* Error insertion - erro3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetErrorRate(void *handle, TEword Port,
                      TEword Rate);
LINKAGE_SPECIFICATION TEstatus IXF3204GetErrorRate(void *handle, TEword Port, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetErrorSend(void *handle, TEword Port, 
                      TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetErrorSend(void *handle, TEword Port, 
                      void *Results);

/* HDLC - hdlc3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCMode(void *handle, TEword HDLC, 
                      TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCMode(void *handle, TEword HDLC, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCAddress(void *handle,TEword HDLC,
                      TEword Address1, TEword Address2, TEword Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCAddress(void *handle, TEword HDLC,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCLength(void *handle, TEword HDLC, 
                      TEword Direction, TEword Length);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCLength(void *handle, TEword HDLC,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCConfig(void *handle,TEword HDLC,
                      TEword Direction, TEword DataInv, TEword CRCEnable);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCConfig(void *handle, TEword HDLC,
                      TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCTSBitmask(void *handle, TEword Port,
                      TEbyte Mask) ;
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCTSBitmask(void *handle, TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCTSBitmaskToBP(void *handle, 
                      TEword Port, TEword Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCTSBitmaskToBP(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCRxFIFODone(void *handle, 
                      TEword HDLC);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCTxFIFOSend(void *handle, 
                      TEword HDLC, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCRxMessageStatus(void *handle, 
                      TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCRxMessageLength(void *handle, 
                      TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCRxMessageAddressCompare(
                      void *handle, TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCRxFIFOStatus(void *handle, 
                      TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCTxFIFOStatus(void *handle, 
                      TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCRxMessageData(void *handle, 
                      TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCTxMessageData(void *handle, 
                      TEword HDLC, TEbyte Data);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCReset(void *handle, TEword HDLC, 
                      TEword Direction);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCTxInterframe(void *handle, 
                      TEword HDLC, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetHDLCTxInterframe(void *handle, 
                      TEword HDLC, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetHDLCOperationMode(void *handle, 
                      TEword HDLC, TEword Mode);

/* General control - gctr3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetSoftReset(void *handle, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSoftReset(void *handle, void * Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetCPUReset(void *handle, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetCPUReset(void *handle, void * Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetPortEnable(void *handle, TEword Port, 
                      TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPortEnable(void *handle, TEword Port, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetPortFunctionReset(void *handle, 
                      TEword Port, TEword Function, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPortFunctionReset(void *handle, 
                      TEword Port, TEword Function, void * Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetDeviceRevisionID(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204Initialize( void **pphandle, 
                      TEbindstruct *p_bind_struct);
LINKAGE_SPECIFICATION TEstatus IXF3204Shutdown( void *handle );
LINKAGE_SPECIFICATION TEstatus IXF3204ControlLoadFirmware(void * handle);
LINKAGE_SPECIFICATION TEstatus IXF3204SetPortSoftReset(void *handle,
                                                       TEword Port);
/*Miscellaneuos functions - misc3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetMapPortSelect(void *handle, 
                      TEword Port, TEword Source);
LINKAGE_SPECIFICATION TEstatus IXF3204GetMapPortSelect(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetMapTSSelect(void *handle, TEword Port,
                      TEword Source, TEword TSSelection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetMapTSSelect(void *handle, TEword Port,
                      TEword TS, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFullPortStatus(void * handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetE1TxCASSpareBits(void *handle,
                                                        TEword Port, 
                                                        TEbyte Spare);

LINKAGE_SPECIFICATION TEstatus IXF3204GetE1TxCASSpareBits(void *handle,
                                                        TEword Port, 
                                                        void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetE1RxCASSpareBits(void *handle,
                                                          TEword Port, 
                                                          void *Results);

/* LoopBack - loop3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetLoopbackMode(void *handle, TEword Port,
                      TEword Loop, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackMode(void *handle, TEword Port,
                      TEword Loop, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLoopbackPayload(void *handle, 
                      TEword Port, TEword TS, TEword Mode, TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackPayload(void *handle, 
                      TEword Port, TEword TS, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLoopbackDetection(void *handle, 
                      TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackDetection(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLoopbackReAction(void *handle, 
                      TEword Port, TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackReAction(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetLoopbackTxInBand(void *handle, 
                      TEword Port, TEword Code);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackTxInBand(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopcodeRxInBand(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackStatus(void *handle, 
                      TEword Port, void *Results );
LINKAGE_SPECIFICATION TEstatus IXF3204SetLoopbackMFSource(void *handle, 
                      TEword Port, TEword Source);
LINKAGE_SPECIFICATION TEstatus IXF3204GetLoopbackMFSource(void *handle, 
                      TEword Port, void *Results );

/* PRM - prm3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetPRMMode(void *handle, TEword Port, 
                      TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPRMMode(void *handle, TEword Port, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPRMRxStatus(void *handle, TEword Port, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetPRMAddress(void *handle, TEword Port, 
                      TEword Direction, TEbyte Byte1, TEbyte Byte2, 
                      TEbyte Byte3);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPRMAddress(void *handle, TEword Port, 
                      TEword Direction, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPRMLastMessage(void *handle, 
                      TEword Port, TEword Direction, void *Results);


/* Performance Elements - perf3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetPEClearCounter (void *handle, 
                      TEword port, TEword database);
LINKAGE_SPECIFICATION TEstatus IXF3204GetPECounterValues(void *handle, 
                      TEword Port, TEword Database, TEword Element, 
                      TEword Bin, void *Results);


/* Interrupts - intr3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptPortMask(void *handle, 
                      TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptPortMask(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptPort(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptHDLCBERTMask(void *handle, 
                      TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptHDLCBERTMask(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptHDLCBERT(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptSourceMask(void *handle, 
                      TEword Port, TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptSourceMask(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptSource(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptAlarmsMask(void *handle, 
                      TEword Port, TEbyte RxAlarms1, TEbyte RxAlarms2, 
                      TEbyte TxAlarms1);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptAlarmsMask(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptAlarms(void *handle, 
                      TEword Port, TEword Alarm, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptFramerMask(void *handle, 
                      TEword Port, TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptFramerMask(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptFramer(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptFDLMask(void *handle, 
                      TEword Port, TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptFDLMask(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptFDL(void *handle, TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptEventsMask(void *handle, 
                      TEword Port, TEbyte Mask1, TEbyte Mask2);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptEventsMask(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptEvent(void *handle, 
                      TEword Port, TEword Event, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptHDLCMask(void *handle, 
                      TEbyte TxMask1, TEbyte TxMask2, TEbyte TxMask3, 
                      TEbyte RxMask4, TEbyte RxMask5, TEbyte RxMask6);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptHDLCMask(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptHDLC(void *handle, TEword HDLC,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptBERTMask(void *handle, 
                      TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptBERTMask(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptBERT(void *handle, 
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptFirmwareMask(void *handle,
                      TEword Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptFirmwareMask(void *handle,
                      void * Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptFirmware(void *handle,
                      void * Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptTxHDLC(void *handle, 
                                                         TEword hdlc, 
                                                         TEword mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptTxHDLC(void *handle,
                                                         TEword hdlc, 
                                                         void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptTxFDL(void *handle,
                                                        TEword port, 
                                                        TEword mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptTxFDL(void *handle,
                                                        TEword port, 
                                                        void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetInterruptRxCodeword(void *handle,
                                                             TEword port, 
                                                             TEword sa5,
                                                             TEword rai);
LINKAGE_SPECIFICATION TEstatus IXF3204GetInterruptRxCodeword(void *handle,
                                                             TEword port, 
                                                             void *Results);

/* MOP - mop3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPSource(void *handle, TEword Port,
                      TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPSource(void *handle, TEword Port,
                      void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPCRCEnable(void *handle, 
                      TEword Port, TEword Selection);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPCRCEnable(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPTransportChannel(void *handle, 
                      TEword Port, TEword Channel);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPTransportChannel(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPCCSMask(void *handle, 
                      TEword Port, TEdword TimeSlotMask, TEbyte BitMask);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPCCSMask(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPRxMaxLength(void *handle, 
                      TEword Port, TEword Length);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPRxMaxLength(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPDone(void *handle, TEword Port);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPRxStatus(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPRxLength(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPRxData(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPTxInterframe(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPTxInterframe(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPTxFIFOSend(void *handle, 
                      TEword HDLC, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPTxLength(void *handle, 
                      TEword Port, TEbyte Length);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPTxLength(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPTxData(void *handle, 
                      TEword Port, TEbyte Data);
LINKAGE_SPECIFICATION TEstatus IXF3204SetFDLMOPRxEnable(void *handle, 
                                                        TEword Port, 
                                                        TEword Mode);
LINKAGE_SPECIFICATION TEstatus IXF3204GetFDLMOPRxEnable(void *handle, 
                                                        TEword Port, 
                                                        void *Results);

/* Signaling - sign3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingMask(void *handle, 
                      TEword Port, TEword TS, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingMask(void *handle, 
                      TEword Port, TEword TS, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingForce(void *handle, 
                      TEword Outgoing_Port, TEword TS, TEbyte Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingForce(void *handle, 
                      TEword Outgoing_Port, TEword TS, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingForceBP(void *handle, 
                      TEword BP, TEword Select, TEword Pattern);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingForceBP(void *handle, 
                      TEword BP, TEword Select, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingRelease(void *handle, 
                      TEword Outgoing_Port, TEword TS);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingByteOnBackplane(void *handle, 
                      TEword Backplane, TEword Layout);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingByteOnBackplane(void *handle, 
                      TEword Backplane, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingStuffValue(void *handle, 
                      TEword Backplane, TEword TimeSlot, TEbyte Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingStuffValue(void *handle, 
                      TEword Backplane, TEword TimeSlot, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingFreeze(void *handle, 
                      TEword Port, TEword Criteria, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingFreeze(void *handle, 
                      TEword Port, TEword Criteria, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingDebounce(void *handle, 
                      TEword Port, TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingDebounce(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204SetSignalingSLC96Mode(void *handle, 
                      TEword Port, TEword State);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingSLC96Mode(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingChange(void *handle, 
                      TEword Port, void *Results);
LINKAGE_SPECIFICATION TEstatus IXF3204GetSignalingStable(void *handle, 
                      TEword Port, TEword TimeSlot, void *Results);

/* Windows Access - wacc3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204SetWinAccess(void *handle, TEword Address,
                      TEbyte Value, TEword Command);
LINKAGE_SPECIFICATION TEstatus IXF3204GetWinAccessStatus(void *handle, 
                      TEword *Status, void *Results);

LINKAGE_SPECIFICATION TEstatus IXF3204GetAPIVersion(void * Results);
                               

/* Read and write functions - enca3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204WriteWord(void *handle, TEword Addr, 
                      TEword Value);
LINKAGE_SPECIFICATION TEstatus IXF3204ReadWord(void *handle, TEword Addr, 
                      TEword *result);
LINKAGE_SPECIFICATION TEstatus IXF3204WriteByte(void *handle, TEword Addr, 
                      TEbyte Value);
LINKAGE_SPECIFICATION TEstatus IXF3204ReadByte(void *handle, TEword Addr, 
                      TEbyte *result);
LINKAGE_SPECIFICATION TEstatus IXF3204WriteBit(void *handle, TEword Addr, 
                      TEbyte Value, TEbyte Mask);
LINKAGE_SPECIFICATION TEstatus IXF3204ReadBit(void *handle, TEword Addr, 
                      TEbyte Mask, TEbyte *result);
LINKAGE_SPECIFICATION TEstatus IXF3204ReaddWord(void *handle, TEword Address, 
                      TEdword *results );
LINKAGE_SPECIFICATION TEstatus IXF3204WritedWord(void *handle, TEword Address, 
                      TEdword Value );

/* OS specific functions - osio3204.c */
LINKAGE_SPECIFICATION TEstatus IXF3204OSWriteByte(void * client_handle, 
                      TEword Address, TEbyte Value);
LINKAGE_SPECIFICATION TEstatus IXF3204OSReadByte(void * client_handle, 
                      TEword Address, TEbyte *rValue);


/* internal functions - util3204.c */
TEword IXF3204FindPortPLI(TEword Port);  
TEword IXF3204TxFindPort(TEword Port);   
TEword IXF3204RxFindPort(TEword Port);
TEword IXF3204FindPortBackPlane(TEword Port);
TEword IXF3204FindPortRAMRx(TEword Port);
TEword IXF3204FindPortRAMTx(TEword Port);
TEword IXF3204FindPortSlipBuffer(TEword Port);
TEword IXF3204FindPortClockSelector(TEword Port);
TEword IXF3204FindBERT(TEword BERT);
TEword IXF3204FindPortTxSignaling_CDR(TEword Port);
TEword IXF3204FindPortTxSignaling_SMD(TEword Port);
TEword IXF3204FindPortRxSignaling_SMD(TEword Port);
TEword IXF3204FindPortRxSignaling_SDM(TEword Port);
TEword IXF3204FindPortRxSignaling_CDM(TEword Port);
TEword IXF3204FindPortTxSignaling_CDM(TEword Port);
TEword IXF3204FindPortTxSignalingLine_CDM(TEword Port);
TEword IXF3204FindPortRxSignaling_CDR(TEword Port);
TEword IXF3204FindPortRxSysSigIF_CDR(TEword BP);
TEword IXF3204FindPortRxSysSigIF_CDM(TEword BP);
TEword IXF3204FindPortTxSysSigIF_CDR(TEword BP);
TEword IXF3204FindPortRxBusIF(TEword Port);
TEword IXF3204FindPortRxBusIF_CDM(TEword Port);
TEword IXF3204FindPortRxHDLC(TEword HDLC);
TEword IXF3204FindPortTxHDLC(TEword HDLC);
TEword IXF3204FindPortTxFDL(TEword FDL);
TEword IXF3204FindPortRxFDL(TEword FDL);
TEword IXF3204FindPortPE(TEword Port);
TEword IXF3204FindPortTxAlarms(TEword Port);
TEword IXF3204FindPortRxAlarms(TEword Port);
TEword IXF3204FindPortMISRC(TEword Port);
TEword IXF3204FindPortISRC(TEword Port);
TEword IXF3204FindPortMR1ALRMI(TEword Port);
TEword IXF3204FindPortMR2ALRMI(TEword Port);
TEword IXF3204FindPortMTXALRM(TEword Port);
TEword IXF3204FindPortR1ALRMI(TEword Port);
TEword IXF3204FindPortR2ALRMI(TEword Port);
TEword IXF3204FindPortTXALRM(TEword Port);
TEword IXF3204FindPortMFRAMEI(TEword Port);
TEword IXF3204FindPortFRAMEI(TEword Port);
TEword IXF3204FindPortMFDLI(TEword Port);
TEword IXF3204FindPortFDLI(TEword Port);
TEword IXF3204FindPortMEVENTS1I(TEword Port);
TEword IXF3204FindPortMEVENTS2I(TEword Port);
TEword IXF3204FindPortEVENTS1I(TEword Port);
TEword IXF3204FindPortEVENTS2I(TEword Port);
TEword IXF3204FindPortStatus(TEword Port);
TEword IXF3204FindCVLBin(TEword Bin);
TEword IXF3204Find_NE_ESL15(TEword Bin);
TEword IXF3204Find_FE_ESL15(TEword Bin);
TEword IXF3204Find_NE_SESL15(TEword Bin);
TEword IXF3204Find_NE_CVP(TEword Bin);
TEword IXF3204Find_FE_CVP(TEword Bin);
TEword IXF3204Find_FE_ESP(TEword Bin);
TEword IXF3204Find_NE_ESP(TEword Bin);
TEword IXF3204Find_FE_SESP(TEword Bin);
TEword IXF3204Find_NE_SESP(TEword Bin);
TEword IXF3204Find_NE_SASP(TEword Bin);
TEword IXF3204Find_FE_UASP(TEword Bin);
TEword IXF3204Find_NE_UASP(TEword Bin);
TEword IXF3204Find_NE_CSSP(TEword Bin);
TEword IXF3204Find_FE_CSSP(TEword Bin);
TEword IXF3204Find_FE_ESAP(TEword Bin);
TEword IXF3204Find_FE_SEFSP(TEword Bin);
TEword IXF3204Find_FE_ESBP(TEword Bin);
TEword IXF3204FindPortNational(TEword Port);
TEbyte IXF3204GetTimeSlot(TEword TS);
TEstatus IXF3204WriteBitAllPortsRegs(void *handle, TEword Address, TEbyte Data,
         TEbyte Mask);
TEstatus IXF3204WriteByteAllPortsRegs(void *handle, TEword Address, TEbyte Data);
TEstatus IXF3204WriteWordAllPortsRegs(void *handle, TEword Address, TEword Data);
TEstatus IXF3204WritedWordAllPortsRegs(void *handle, TEword Address, 
         TEdword Data);
TEstatus IXF3204WriteBitAllPortsMem(void *handle, TEword Address, TEbyte Data,
         TEbyte Mask);
TEstatus IXF3204WriteByteAllPortsMem(void *handle, TEword Address, TEbyte Data);
TEstatus IXF3204WriteWordAllPortsMem(void *handle, TEword Address, TEword Data);
TEstatus IXF3204WriteBitAllHDLCMem(void *handle, TEword Address, TEbyte Data,
         TEbyte Mask);
TEstatus IXF3204WriteByteAllHDLCMem(void *handle, TEword Address, TEbyte Data);
TEstatus IXF3204WriteWordAllHDLCMem(void *handle, TEword Address, TEword Data);
TEstatus IXF3204WriteByteAllInt(void *handle, TEword Address, TEbyte Data,
         TEbyte Offset);
TEstatus IXF3204WriteBitAllPE(void *handle, TEword Address, TEbyte Data, 
         TEbyte Mask, TEword Offset);


#ifdef __cplusplus
};
#endif

#endif

