/*
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

/******************************************************************************
 * File Name:   ixf3204d.h
 * Description: It contains defines for port offsets
 *
 ******************************************************************************/

#ifndef __IXF3204D_H_
#define __IXF3204D_H_

#define IXF3204_PORT_REG_OFFSET              0x280
#define IXF3204_PORT_MEM_OFFSET              0x20
#define IXF3204_SOURCE_INT                   0x01
#define IXF3204_MODULE_INT                   0x18
#define IXF3204_PERF_OFFSET                  0x5A4
#define IXF3204_PRM_ADDRESS_NUM              3
#define IXF3204_MAX_TS_TXMEM_ADDR            0x10
#define IXF3204_MAX_TS_RXMEM_ADDR            0x10

/* offsets */
#define IXF3204_ADDR_OFFSET0                 0x00
#define IXF3204_ADDR_OFFSET1                 0x01
#define IXF3204_ADDR_OFFSET2                 0x02
#define IXF3204_ADDR_OFFSET3                 0x03
#define IXF3204_ADDR_OFFSET4                 0x04
#define IXF3204_ADDR_OFFSET5                 0x05
#define IXF3204_ADDR_OFFSET6                 0x06
#define IXF3204_ADDR_OFFSET7                 0x07
#define IXF3204_ADDR_OFFSET8                 0x08
#define IXF3204_ADDR_OFFSET9                 0x09
#define IXF3204_ADDR_OFFSETA                 0x0A
#define IXF3204_ADDR_OFFSETB                 0x0B
#define IXF3204_ADDR_OFFSETC                 0x0C
#define IXF3204_ADDR_OFFSETD                 0x0D
#define IXF3204_ADDR_OFFSETE                 0x0E
#define IXF3204_ADDR_OFFSETF                 0x0F
#define IXF3204_ADDR_OFFSET10                0x10

/* Host interface */
#define IXF3204_RESET_DEVICE_REG             0x0000
#define IXF3204_RESET_CPU_REG                0x0003
#define IXF3204_ADDR_HW_ID                   0x1D0E
#define IXF3204_ADDR_FW_ID                   0x1D0F

/* Interrupts */

#define IXF3204_IMASKA                       0x0009
#define IXF3204_IMASKB                       0x000A
#define IXF3204_ISTA                         0x000B
#define IXF3204_ISTB                         0x000C

#define IXF3204_MISRC0                       0x0010
#define IXF3204_MISRC1                       0x0011
#define IXF3204_MISRC2                       0x0012
#define IXF3204_MISRC3                       0x0013
#define IXF3204_MISRC4                       0x0014
#define IXF3204_MISRC5                       0x0015
#define IXF3204_MISRC6                       0x0016
#define IXF3204_MISRC7                       0x0017

#define IXF3204_ISRC0                        0x0018
#define IXF3204_ISRC1                        0x0019
#define IXF3204_ISRC2                        0x001A
#define IXF3204_ISRC3                        0x001B
#define IXF3204_ISRC4                        0x001C
#define IXF3204_ISRC5                        0x001D
#define IXF3204_ISRC6                        0x001E
#define IXF3204_ISRC7                        0x001F

#define IXF3204_MR1ALRMI0                    0x0020
#define IXF3204_MR2ALRMI0                    0x0021
#define IXF3204_MTXALRM0                     0x0022
#define IXF3204_MR1ALRMI1                    0x0038
#define IXF3204_MR2ALRMI1                    0x0039
#define IXF3204_MTXALRM1                     0x003A
#define IXF3204_MR1ALRMI2                    0x0050
#define IXF3204_MR2ALRMI2                    0x0051
#define IXF3204_MTXALRM2                     0x0052
#define IXF3204_MR1ALRMI3                    0x0068
#define IXF3204_MR2ALRMI3                    0x0069
#define IXF3204_MTXALRM3                     0x006A
#define IXF3204_MR1ALRMI4                    0x0080
#define IXF3204_MR2ALRMI4                    0x0081
#define IXF3204_MTXALRM4                     0x0082
#define IXF3204_MR1ALRMI5                    0x0098
#define IXF3204_MR2ALRMI5                    0x0099
#define IXF3204_MTXALRM5                     0x009A
#define IXF3204_MR1ALRMI6                    0x00B0
#define IXF3204_MR2ALRMI6                    0x00B1
#define IXF3204_MTXALRM6                     0x00B2
#define IXF3204_MR1ALRMI7                    0x00C8
#define IXF3204_MR2ALRMI7                    0x00C9
#define IXF3204_MTXALRM7                     0x00CA

#define IXF3204_R1ALRMI0                     0x0028
#define IXF3204_R2ALRMI0                     0x0029
#define IXF3204_TXALRM0                      0x002A
#define IXF3204_R1ALRMI1                     0x0040
#define IXF3204_R2ALRMI1                     0x0041
#define IXF3204_TXALRM1                      0x0042
#define IXF3204_R1ALRMI2                     0x0058
#define IXF3204_R2ALRMI2                     0x0059
#define IXF3204_TXALRM2                      0x005A
#define IXF3204_R1ALRMI3                     0x0070
#define IXF3204_R2ALRMI3                     0x0071
#define IXF3204_TXALRM3                      0x0072
#define IXF3204_R1ALRMI4                     0x0088
#define IXF3204_R2ALRMI4                     0x0089
#define IXF3204_TXALRM4                      0x008A
#define IXF3204_R1ALRMI5                     0x00A0
#define IXF3204_R2ALRMI5                     0x00A1
#define IXF3204_TXALRM5                      0x00A2
#define IXF3204_R1ALRMI6                     0x00B8
#define IXF3204_R2ALRMI6                     0x00B9
#define IXF3204_TXALRM6                      0x00BA
#define IXF3204_R1ALRMI7                     0x00D0
#define IXF3204_R2ALRMI7                     0x00D1
#define IXF3204_TXALRM7                      0x00D2

#define IXF3204_MFRAMEI0                     0x0023
#define IXF3204_MFRAMEI1                     0x003B
#define IXF3204_MFRAMEI2                     0x0053
#define IXF3204_MFRAMEI3                     0x006B
#define IXF3204_MFRAMEI4                     0x0083
#define IXF3204_MFRAMEI5                     0x009B
#define IXF3204_MFRAMEI6                     0x00B3
#define IXF3204_MFRAMEI7                     0x00CB

#define IXF3204_FRAMEI0                      0x002B
#define IXF3204_FRAMEI1                      0x0043
#define IXF3204_FRAMEI2                      0x005B
#define IXF3204_FRAMEI3                      0x0073
#define IXF3204_FRAMEI4                      0x008B
#define IXF3204_FRAMEI5                      0x00A3
#define IXF3204_FRAMEI6                      0x00BB
#define IXF3204_FRAMEI7                      0x00D3

#define IXF3204_MFDLI0                       0x0024
#define IXF3204_MFDLI1                       0x003C
#define IXF3204_MFDLI2                       0x0054
#define IXF3204_MFDLI3                       0x006C
#define IXF3204_MFDLI4                       0x0084
#define IXF3204_MFDLI5                       0x009C
#define IXF3204_MFDLI6                       0x00B4
#define IXF3204_MFDLI7                       0x00CC

#define IXF3204_FDLI0                        0x002C
#define IXF3204_FDLI1                        0x0044
#define IXF3204_FDLI2                        0x005C
#define IXF3204_FDLI3                        0x0074
#define IXF3204_FDLI4                        0x008C
#define IXF3204_FDLI5                        0x00A4
#define IXF3204_FDLI6                        0x00BC
#define IXF3204_FDLI7                        0x00D4

#define IXF3204_MEVENTS1I0                   0x0025
#define IXF3204_MEVENTS2I0                   0x0026
#define IXF3204_MEVENTS1I1                   0x003D
#define IXF3204_MEVENTS2I1                   0x003E
#define IXF3204_MEVENTS1I2                   0x0055
#define IXF3204_MEVENTS2I2                   0x0056
#define IXF3204_MEVENTS1I3                   0x006D
#define IXF3204_MEVENTS2I3                   0x006E
#define IXF3204_MEVENTS1I4                   0x0085
#define IXF3204_MEVENTS2I4                   0x0086
#define IXF3204_MEVENTS1I5                   0x009D
#define IXF3204_MEVENTS2I5                   0x009E
#define IXF3204_MEVENTS1I6                   0x00B5
#define IXF3204_MEVENTS2I6                   0x00B6
#define IXF3204_MEVENTS1I7                   0x00CD
#define IXF3204_MEVENTS2I7                   0x00CE

#define IXF3204_EVENTS1I0                    0x002D
#define IXF3204_EVENTS2I0                    0x002E
#define IXF3204_EVENTS1I1                    0x0045
#define IXF3204_EVENTS2I1                    0x0046
#define IXF3204_EVENTS1I2                    0x005D
#define IXF3204_EVENTS2I2                    0x005E
#define IXF3204_EVENTS1I3                    0x0075
#define IXF3204_EVENTS2I3                    0x0076
#define IXF3204_EVENTS1I4                    0x008D
#define IXF3204_EVENTS2I4                    0x008E
#define IXF3204_EVENTS1I5                    0x00A5
#define IXF3204_EVENTS2I5                    0x00A6
#define IXF3204_EVENTS1I6                    0x00BD
#define IXF3204_EVENTS2I6                    0x00BE
#define IXF3204_EVENTS1I7                    0x00D5
#define IXF3204_EVENTS2I7                    0x00D6

#define IXF3204_MTXHDLC0       	             0x00E0
#define IXF3204_MTXHDLC1       	             0x00E1
#define IXF3204_MTXHDLC2       	             0x00E2
#define IXF3204_MRXHDLC0       	             0x00E3
#define IXF3204_MRXHDLC1       	             0x00E4
#define IXF3204_MRXHDLC2       	             0x00E5

#define IXF3204_TXHDLC0       	             0x00E8
#define IXF3204_TXHDLC1       	             0x00E9
#define IXF3204_TXHDLC2       	             0x00EA
#define IXF3204_RXHDLC0       	             0x00EB
#define IXF3204_RXHDLC1       	             0x00EC
#define IXF3204_RXHDLC2       	             0x00ED

#define IXF3204_MBERT       		             0x00F0
#define IXF3204_BERT       		               0x00F1

/* status */
#define IXF3204_R1ALARMS0                    0x0030
#define IXF3204_R2ALARMS0                    0x0031
#define IXF3204_TXALARMS0                    0x0032
#define IXF3204_FRAME0                       0x0033

#define IXF3204_R1ALARMS1                    0x0048
#define IXF3204_R2ALARMS1                    0x0049
#define IXF3204_TXALARMS1                    0x004A
#define IXF3204_FRAME1                       0x004B

#define IXF3204_R1ALARMS2                    0x0060
#define IXF3204_R2ALARMS2                    0x0061
#define IXF3204_TXALARMS2                    0x0062
#define IXF3204_FRAME2                       0x0063

#define IXF3204_R1ALARMS3                    0x0078
#define IXF3204_R2ALARMS3                    0x0079
#define IXF3204_TXALARMS3                    0x007A
#define IXF3204_FRAME3                       0x007B

#define IXF3204_R1ALARMS4                    0x0090
#define IXF3204_R2ALARMS4                    0x0091
#define IXF3204_TXALARMS4                    0x0092
#define IXF3204_FRAME4                       0x0093

#define IXF3204_R1ALARMS5                    0x00A8
#define IXF3204_R2ALARMS5                    0x00A9
#define IXF3204_TXALARMS5                    0x00AA
#define IXF3204_FRAME5                       0x00AB

#define IXF3204_R1ALARMS6                    0x00C0
#define IXF3204_R2ALARMS6                    0x00C1
#define IXF3204_TXALARMS6                    0x00C2
#define IXF3204_FRAME6                       0x00C3

#define IXF3204_R1ALARMS7                    0x00D8
#define IXF3204_R2ALARMS7                    0x00D9
#define IXF3204_TXALARMS7                    0x00DA
#define IXF3204_FRAME7                       0x00DB
/* firmware Interrupts */
#define IXF3204_FW1MASK                      0x00F8
#define IXF3204_FW2MASK                      0x00F9
#define IXF3204_FW1                          0x00FA
#define IXF3204_FW2                          0x00FB

/* Windows Access Registers Addresses */
#define IXF3204_WIN_ADDRESS_LOW              0x0004
#define IXF3204_WIN_ADDRESS_HIGH             0x0005
#define IXF3204_WIN_DATA                     0x0006
#define IXF3204_WIN_COMMAND                  0x0007
#define IXF3204_WIN_STATUS                   0x0008

#define IXF3204_CPU_ROM_ADDRESS              0x8000

/* Windows access valid address range */
#define IXF3204_WIN_LOW_LIMIT                0x0100
#define IXF3204_WIN_HIGH_LIMIT               0x7FFF

/* LIU */

#define IXF3204_PLIOffset1                   0x100
#define IXF3204_PLIOffset2                   0x380
#define IXF3204_PLIOffset3                   0x600
#define IXF3204_PLIOffset4                   0x880
#define IXF3204_PLIOffset5                   0xB00
#define IXF3204_PLIOffset6                   0xD80
#define IXF3204_PLIOffset7                   0x1000
#define IXF3204_PLIOffset8                   0x1280

/* LIU Registers */
#define IXF3204_LIPOL                        0x00
#define IXF3204_LINEGU                       0x01
#define IXF3204_LIMODE                       0x02
#define IXF3204_LIPATH                       0x03
#define IXF3204_LIERR                        0x04
#define IXF3204_LIERST                       0x05
#define IXF3204_LIEI                         0x06
#define IXF3204_LIGPB                        0x07
#define IXF3204_LISET0                       0x08 
#define IXF3204_LISET1                       0x09
#define IXF3204_LISTS                        0x0A
#define IXF3204_LILSTS                       0x0B
#define IXF3204_LIZL                         0x0C
#define IXF3204_LILH                         0x0D
#define IXF3204_LIVL                         0x0E
#define IXF3204_LIVH                         0x0F
#define IXF3204_LICVL                        0x10
#define IXF3204_LICVH                        0x11
#define IXF3204_LILOOP                       0x12

/* Framer */

#define IXF3204_TxFramerOffset1              0x140
#define IXF3204_TxFramerOffset2              0x3C0
#define IXF3204_TxFramerOffset3              0x640
#define IXF3204_TxFramerOffset4              0x8C0
#define IXF3204_TxFramerOffset5              0xB40
#define IXF3204_TxFramerOffset6              0xDC0
#define IXF3204_TxFramerOffset7              0x1040
#define IXF3204_TxFramerOffset8              0x12C0

#define IXF3204_RxFramerOffset1              0x120
#define IXF3204_RxFramerOffset2              0x3A0
#define IXF3204_RxFramerOffset3              0x620
#define IXF3204_RxFramerOffset4              0x8A0
#define IXF3204_RxFramerOffset5              0xB20
#define IXF3204_RxFramerOffset6              0xDA0
#define IXF3204_RxFramerOffset7              0x1020
#define IXF3204_RxFramerOffset8              0x12A0

/* Rx Framer Registers */
#define IXF3204_RXFRAMER_CR0                 0x00
#define IXF3204_RXFRAMER_CR1                 0x01
#define IXF3204_RXFRAMER_CR2                 0x02
#define IXF3204_RXFRAMER_CR3                 0x03
#define IXF3204_RXFRAMER_SR0                 0x10
#define IXF3204_RXFRAMER_SR1                 0x11
#define IXF3204_RXFRAMER_SR2                 0x12
#define IXF3204_RXFRAMER_SR3                 0x13
#define IXF3204_RXFRAMER_SR4                 0x14
#define IXF3204_RXFRAMER_SR5                 0x15
#define IXF3204_RXFRAMER_SR6                 0x16
#define IXF3204_RXFRAMER_SR7                 0x17
#define IXF3204_RXFRAMER_SR8                 0x18

#define IXF3204_TXFRAMER_FF                  0x00
#define IXF3204_TXFRAMER_MP                  0x01

/* Backplane */

#define IXF3204_BackplaneOffset1             0x260
#define IXF3204_BackplaneOffset2             0x4E0
#define IXF3204_BackplaneOffset3             0x760
#define IXF3204_BackplaneOffset4             0x9E0
#define IXF3204_BackplaneOffset5             0xC60
#define IXF3204_BackplaneOffset6             0xEE0
#define IXF3204_BackplaneOffset7             0x1160
#define IXF3204_BackplaneOffset8             0x13E0

#define IXF3204_Backplane_RAM_Rxoffset1      0x6C00
#define IXF3204_Backplane_RAM_Rxoffset2      0x6C20
#define IXF3204_Backplane_RAM_Rxoffset3      0x6C40
#define IXF3204_Backplane_RAM_Rxoffset4      0x6C60
#define IXF3204_Backplane_RAM_Rxoffset5      0x6C80
#define IXF3204_Backplane_RAM_Rxoffset6      0x6CA0
#define IXF3204_Backplane_RAM_Rxoffset7      0x6CC0
#define IXF3204_Backplane_RAM_Rxoffset8      0x6CE0

#define IXF3204_Backplane_RAM_Txoffset1      0x6D00
#define IXF3204_Backplane_RAM_Txoffset2      0x6D20
#define IXF3204_Backplane_RAM_Txoffset3      0x6D40
#define IXF3204_Backplane_RAM_Txoffset4      0x6D60
#define IXF3204_Backplane_RAM_Txoffset5      0x6D80
#define IXF3204_Backplane_RAM_Txoffset6      0x6DA0
#define IXF3204_Backplane_RAM_Txoffset7      0x6DC0
#define IXF3204_Backplane_RAM_Txoffset8      0x6DE0

/* backplane registers */
#define IXF3204_BPRMODE                      0x00
#define IXF3204_BPRMASTER                    0x01
#define IXF3204_BPRREPLIC                    0x02
#define IXF3204_BPRTSDIS0_7                  0x03
#define IXF3204_BPRTSDIS8_15                 0x04
#define IXF3204_BPRTSDIS16_23                0x05
#define IXF3204_BPRTSDID24_31                0x06
#define IXF3204_BPRWAVE                      0x07
#define IXF3204_BPROFFSETA                   0x08
#define IXF3204_BPROFFSETB                   0x09
#define IXF3204_BPRMASKB                     0x0A
#define IXF3204_BPRMASKH                     0x0B
#define IXF3204_BPRMASK8                     0x0C
#define IXF3204_BPRFORCE                     0x0D
#define IXF3204_BPRPATTERN                   0x0E
#define IXF3204_BPRXINVMSK                   0x0F
#define IXF3204_BPTMODE                      0x10
#define IXF3204_BPTMASTER                    0x11
#define IXF3204_BPTREPLIC                    0x12
#define IXF3204_BPTXINVMSK0                  0x13
#define IXF3204_BPTXINVMSK1                  0x14
#define IXF3204_BPTXINVMSK2                  0x15
#define IXF3204_BPTXINVMSK3                  0x16
#define IXF3204_BPTWAVE                      0x17
#define IXF3204_BPTOFFSETA                   0x18
#define IXF3204_BPTOFFSETB                   0x19
#define IXF3204_BPTMASKB                     0x1A
#define IXF3204_BPTMASKH                     0x1B
#define IXF3204_BPTMASK8                     0x1C
#define IXF3204_BPUSE                        0x1D

/* SlipBuffer */

#define IXF3204_SlipBufferOffset1            0x240
#define IXF3204_SlipBufferOffset2            0x4C0
#define IXF3204_SlipBufferOffset3            0x740
#define IXF3204_SlipBufferOffset4            0x9C0
#define IXF3204_SlipBufferOffset5            0xC40
#define IXF3204_SlipBufferOffset6            0xEC0
#define IXF3204_SlipBufferOffset7            0x1140
#define IXF3204_SlipBufferOffset8            0x13C0

/* Slip buffer registers */
#define IXF3204_SBUSET                       0x250 /* remove on C0 */
#define IXF3204_SBRPTRR                      0x257 /* remove on C0 */
#define IXF3204_SB_SBUSER                    0x00
#define IXF3204_SB_SBMODER                   0x01
#define IXF3204_SB_SBMODEAR                  0x02
#define IXF3204_SB_SBSTSR                    0x03
#define IXF3204_SB_SBSTSAR                   0x04
#define IXF3204_SB_SBDSTR                    0x05
#define IXF3204_SB_SBDSTAR                   0x06
#define IXF3204_SB_SBRPTRR                   0x07
#define IXF3204_SB_SBRPTRAR                  0x08
#define IXF3204_SB_SBWPTRR                   0x09
#define IXF3204_SB_SBWPTRCR                  0x0A
#define IXF3204_SB_SBCSCLR                   0x0B
#define IXF3204_SB_SBCSCHR                   0x0C
#define IXF3204_SB_SBCSCALR                  0x0D
#define IXF3204_SB_SBCSAHR                   0x0E
#define IXF3204_SB_SBFMINGR                  0x0F
#define IXF3204_SB_SBUSET                    0x10
#define IXF3204_SB_SBMODET                   0x11
#define IXF3204_SB_SBMODEAT                  0x12
#define IXF3204_SB_SBSTST                    0x13
#define IXF3204_SB_SBSTSAT                   0x14
#define IXF3204_SB_SBDSTT                    0x15
#define IXF3204_SB_SBDSTAT                   0x16
#define IXF3204_SB_SBRPTRT                   0x17
#define IXF3204_SB_SBRPTRAT                  0x18
#define IXF3204_SB_SBWPTRT                   0x19
#define IXF3204_SB_SBWPTRCT                  0x1A
#define IXF3204_SB_SBCSCLT                   0x1B
#define IXF3204_SB_SBCSCHT                   0x1C
#define IXF3204_SB_SBCSCALT                  0x1D
#define IXF3204_SB_SBCSAHT                   0x1E
#define IXF3204_SB_SBFMINGT                  0x1F

/* Clock selector */
#define IXF3204_ClockSelectorOffset          0x1E00
#define IXF3204_ClkSelectorAddr0             0x00
#define IXF3204_ClkSelectorAddr1             0x01
#define IXF3204_ClkSelectorAddr2             0x02
#define IXF3204_ClkSelectorAddr3             0x03
#define IXF3204_ClkSelectorAddr4             0x04

#define IXF3204_PerPortRegister1             0x02C0
#define IXF3204_PerPortRegister2             0x0540
#define IXF3204_PerPortRegister3             0x07C0
#define IXF3204_PerPortRegister4             0x0A40
#define IXF3204_PerPortRegister5             0x0CC0
#define IXF3204_PerPortRegister6             0x0F40
#define IXF3204_PerPortRegister7             0x11C0
#define IXF3204_PerPortRegister8             0x1440

/* BERT */

#define IXF3204_BERTOffset1                  0x1B00
#define IXF3204_BERTOffset2                  0x1B20
#define IXF3204_BERTOffset3                  0x1B40
#define IXF3204_BERTOffset4                  0x1B60
#define IXF3204_BERTOffset5                  0x1B80
#define IXF3204_BERTOffset6                  0x1BA0
#define IXF3204_BERTOffset7                  0x1BC0
#define IXF3204_BERTOffset8                  0x1BE0

/* BERT Global registers */
#define IXF3204_BERT_INSYNC_W0               0x1C00
#define IXF3204_BERT_INSYNC_W1               0x1C01
#define IXF3204_BERT_OUTSYNC_W0              0x1C02
#define IXF3204_BERT_OUTSYNC_W1              0x1C03
#define IXF3204_BERT_OUTSYNC_T0              0x1C04
#define IXF3204_BERT_OUTSYNC_T1              0x1C05

/* BERT per module registers */
#define IXF3204_BERT_PATTERN_CFG_0           0x00
#define IXF3204_BERT_PATTERN_CFG_1           0x01
#define IXF3204_BERT_PATTERN_CFG_2           0x02
#define IXF3204_BERT_PATTERN_CFG_3           0x03
#define IXF3204_BERT_PATTERN_LENGTH          0x04
#define IXF3204_BERT_PATTERN_TAP             0x05
#define IXF3204_BERT_MODE_CFG                0x06
#define IXF3204_BERT_RXCTRL                  0x07
#define IXF3204_BERT_ERROR_CNT0              0x08
#define IXF3204_BERT_ERROR_CNT1              0x09
#define IXF3204_BERT_ERROR_CNT2              0x0A
#define IXF3204_BERT_TOTAL_CNT0              0x0B
#define IXF3204_BERT_TOTAL_CNT1              0x0C
#define IXF3204_BERT_TOTAL_CNT2              0x0D
#define IXF3204_BERT_RXSTATUS                0x0E
#define IXF3204_BERT_TXCTRL                  0x0F
#define IXF3204_BERT_DRS_DMW_CNT             0x10


/* Signaling */

#define IXF3204_TxSignaling_CDR_Offset1      0x1E0
#define IXF3204_TxSignaling_CDR_Offset2      0x460
#define IXF3204_TxSignaling_CDR_Offset3      0x6E0
#define IXF3204_TxSignaling_CDR_Offset4      0x960
#define IXF3204_TxSignaling_CDR_Offset5      0xBE0
#define IXF3204_TxSignaling_CDR_Offset6      0xE60
#define IXF3204_TxSignaling_CDR_Offset7      0x10E0
#define IXF3204_TxSignaling_CDR_Offset8      0x1360

#define IXF3204_RxSignaling_CDR_Offset1      0x1C0
#define IXF3204_RxSignaling_CDR_Offset2      0x440
#define IXF3204_RxSignaling_CDR_Offset3      0x6C0
#define IXF3204_RxSignaling_CDR_Offset4      0x940
#define IXF3204_RxSignaling_CDR_Offset5      0xBC0
#define IXF3204_RxSignaling_CDR_Offset6      0xE40
#define IXF3204_RxSignaling_CDR_Offset7      0x10C0
#define IXF3204_RxSignaling_CDR_Offset8      0x1340

#define IXF3204_RxSysSigIF_CDR_Offset1       0x280
#define IXF3204_RxSysSigIF_CDR_Offset2       0x500
#define IXF3204_RxSysSigIF_CDR_Offset3       0x780
#define IXF3204_RxSysSigIF_CDR_Offset4       0xA00
#define IXF3204_RxSysSigIF_CDR_Offset5       0xC80
#define IXF3204_RxSysSigIF_CDR_Offset6       0xF00
#define IXF3204_RxSysSigIF_CDR_Offset7       0x1180
#define IXF3204_RxSysSigIF_CDR_Offset8       0x1400

#define IXF3204_TxSysSigIF_CDR_Offset1       0x2A0
#define IXF3204_TxSysSigIF_CDR_Offset2       0x520
#define IXF3204_TxSysSigIF_CDR_Offset3       0x7A0
#define IXF3204_TxSysSigIF_CDR_Offset4       0xA20
#define IXF3204_TxSysSigIF_CDR_Offset5       0xCA0
#define IXF3204_TxSysSigIF_CDR_Offset6       0xF20
#define IXF3204_TxSysSigIF_CDR_Offset7       0x11A0
#define IXF3204_TxSysSigIF_CDR_Offset8       0x1420

#define IXF3204_RxSysSigIF_CDM_Offset1       0x6400
#define IXF3204_RxSysSigIF_CDM_Offset2       0x6420
#define IXF3204_RxSysSigIF_CDM_Offset3       0x6440
#define IXF3204_RxSysSigIF_CDM_Offset4       0x6460
#define IXF3204_RxSysSigIF_CDM_Offset5       0x6480
#define IXF3204_RxSysSigIF_CDM_Offset6       0x64A0
#define IXF3204_RxSysSigIF_CDM_Offset7       0x64C0
#define IXF3204_RxSysSigIF_CDM_Offset8       0x64E0

#define IXF3204_TxSignaling_SDM_Offset1      0x2400
#define IXF3204_TxSignaling_SDM_Offset2      0x2410
#define IXF3204_TxSignaling_SDM_Offset3      0x2420
#define IXF3204_TxSignaling_SDM_Offset4      0x2430
#define IXF3204_TxSignaling_SDM_Offset5      0x2440
#define IXF3204_TxSignaling_SDM_Offset6      0x2450
#define IXF3204_TxSignaling_SDM_Offset7      0x2460
#define IXF3204_TxSignaling_SDM_Offset8      0x2470

#define IXF3204_RxSignaling_SDM_Offset1      0x2800
#define IXF3204_RxSignaling_SDM_Offset2      0x2820
#define IXF3204_RxSignaling_SDM_Offset3      0x2840
#define IXF3204_RxSignaling_SDM_Offset4      0x2860
#define IXF3204_RxSignaling_SDM_Offset5      0x2880
#define IXF3204_RxSignaling_SDM_Offset6      0x28A0
#define IXF3204_RxSignaling_SDM_Offset7      0x28C0
#define IXF3204_RxSignaling_SDM_Offset8      0x28E0

#define IXF3204_RxBusIFOffset1               0x1A0
#define IXF3204_RxBusIFOffset2               0x420
#define IXF3204_RxBusIFOffset3               0x6A0
#define IXF3204_RxBusIFOffset4               0x920
#define IXF3204_RxBusIFOffset5               0xBA0
#define IXF3204_RxBusIFOffset6               0xE20
#define IXF3204_RxBusIFOffset7               0x10A0
#define IXF3204_RxBusIFOffset8               0x1320

#define IXF3204_TxSignaling_CDM_Offset1      0x6800
#define IXF3204_TxSignaling_CDM_Offset2      0x6820
#define IXF3204_TxSignaling_CDM_Offset3      0x6840
#define IXF3204_TxSignaling_CDM_Offset4      0x6860
#define IXF3204_TxSignaling_CDM_Offset5      0x6880
#define IXF3204_TxSignaling_CDM_Offset6      0x68A0
#define IXF3204_TxSignaling_CDM_Offset7      0x68C0
#define IXF3204_TxSignaling_CDM_Offset8      0x68E0

#define IXF3204_TxSignaling_CDM_Line_Offset1 0x2000
#define IXF3204_TxSignaling_CDM_Line_Offset2 0x2020
#define IXF3204_TxSignaling_CDM_Line_Offset3 0x2040
#define IXF3204_TxSignaling_CDM_Line_Offset4 0x2060
#define IXF3204_TxSignaling_CDM_Line_Offset5 0x2080
#define IXF3204_TxSignaling_CDM_Line_Offset6 0x20A0
#define IXF3204_TxSignaling_CDM_Line_Offset7 0x20C0
#define IXF3204_TxSignaling_CDM_Line_Offset8 0x20E0

#define IXF3204_RxBusIF_CDM_Offset1          0x5800
#define IXF3204_RxBusIF_CDM_Offset2          0x5820
#define IXF3204_RxBusIF_CDM_Offset3          0x5840
#define IXF3204_RxBusIF_CDM_Offset4          0x5860
#define IXF3204_RxBusIF_CDM_Offset5          0x5880
#define IXF3204_RxBusIF_CDM_Offset6          0x58A0
#define IXF3204_RxBusIF_CDM_Offset7          0x58C0
#define IXF3204_RxBusIF_CDM_Offset8          0x58E0

/* Rx system signaling registers */
#define IXF3204_RXSYS_CR0                    0x00
#define IXF3204_RXSYS_CR1                    0x01
#define IXF3204_RXSYS_CR2                    0x02

/* Rx BUS IF registers */
#define IXF3204_RXBUSIF_CR0                  0x00
#define IXF3204_RXBUSIF_CR1                  0x01
#define IXF3204_RXBUSIF_CR2                  0x02
#define IXF3204_RXBUSIF_CR3                  0x03
#define IXF3204_RXBUSIF_MEM_TS0              0x00
#define IXF3204_RXBUSIF_MEM_TS1              0x01
#define IXF3204_RXBUSIF_MEM_TS2              0x02
#define IXF3204_RXBUSIF_MEM_TS3              0x03
#define IXF3204_RXBUSIF_MEM_TS4              0x04
#define IXF3204_RXBUSIF_MEM_TS5              0x05
#define IXF3204_RXBUSIF_MEM_TS6              0x06
#define IXF3204_RXBUSIF_MEM_TS7              0x07
#define IXF3204_RXBUSIF_MEM_TS8              0x08
#define IXF3204_RXBUSIF_MEM_TS9              0x09
#define IXF3204_RXBUSIF_MEM_TSA              0x0A
#define IXF3204_RXBUSIF_MEM_TSB              0x0B
#define IXF3204_RXBUSIF_MEM_TSC              0x0C
#define IXF3204_RXBUSIF_MEM_TSD              0x0D
#define IXF3204_RXBUSIF_MEM_TSE              0x0E
#define IXF3204_RXBUSIF_MEM_TSF              0x0F
#define IXF3204_RXBUSIF_MEM_TS10             0x10
#define IXF3204_RXBUSIF_MEM_TS11             0x11
#define IXF3204_RXBUSIF_MEM_TS12             0x12
#define IXF3204_RXBUSIF_MEM_TS13             0x13
#define IXF3204_RXBUSIF_MEM_TS14             0x14
#define IXF3204_RXBUSIF_MEM_TS15             0x15
#define IXF3204_RXBUSIF_MEM_TS16             0x16
#define IXF3204_RXBUSIF_MEM_TS17             0x17
#define IXF3204_RXBUSIF_MEM_TS18             0x18
#define IXF3204_RXBUSIF_MEM_TS19             0x19
#define IXF3204_RXBUSIF_MEM_TS1A             0x1A
#define IXF3204_RXBUSIF_MEM_TS1B             0x1B
#define IXF3204_RXBUSIF_MEM_TS1C             0x1C
#define IXF3204_RXBUSIF_MEM_TS1D             0x1D
#define IXF3204_RXBUSIF_MEM_TS1E             0x1E
#define IXF3204_RXBUSIF_MEM_TS1F             0x1F

/* Tx signaling registers */
#define IXF3204_TXSIG_CFG                    0x00
#define IXF3204_TXSIG_MAP                    0x01
#define IXF3204_TXSIG_LOOPM                  0x02
#define IXF3204_TXSIG_BERTM                  0x03
#define IXF3204_TXSIG_HDLCM                  0x04
#define IXF3204_TXSIG_DIS0                   0x05
#define IXF3204_TXSIG_DIS1                   0x06
#define IXF3204_TXSIG_DIS2                   0x07
#define IXF3204_TXSIG_FORCE0                 0x08
#define IXF3204_TXSIG_FORCE1                 0x09
#define IXF3204_TXSIG_FORCE2                 0x0A
#define IXF3204_TXSIG_FORCE3                 0x0B
#define IXF3204_TXSIG_LOOPST                 0x10

/* Rx Signaling */
#define IXF3204_RXSIG_GCF                    0x00
#define IXF3204_RXSIG_CHGMASK0               0x01
#define IXF3204_RXSIG_CHGMASK1               0x02
#define IXF3204_RXSIG_CHGMASK2               0x03
#define IXF3204_RXSIG_CHGMASK3               0x04
#define IXF3204_RXSIG_CHGSTATUS0             0x10
#define IXF3204_RXSIG_CHGSTATUS1             0x11
#define IXF3204_RXSIG_CHGSTATUS2             0x12
#define IXF3204_RXSIG_CHGSTATUS3             0x13


/* HDLC */

#define IXF3204_Rx_HDLC1_Offset              0x1500
#define IXF3204_Rx_HDLC2_Offset              0x1520
#define IXF3204_Rx_HDLC3_Offset              0x1540
#define IXF3204_Rx_HDLC4_Offset              0x1560
#define IXF3204_Rx_HDLC5_Offset              0x1580
#define IXF3204_Rx_HDLC6_Offset              0x15A0
#define IXF3204_Rx_HDLC7_Offset              0x15C0
#define IXF3204_Rx_HDLC8_Offset              0x15E0
#define IXF3204_Rx_HDLC9_Offset              0x1600
#define IXF3204_Rx_HDLC10_Offset             0x1620
#define IXF3204_Rx_HDLC11_Offset             0x1640
#define IXF3204_Rx_HDLC12_Offset             0x1660
#define IXF3204_Rx_HDLC13_Offset             0x1680
#define IXF3204_Rx_HDLC14_Offset             0x16A0
#define IXF3204_Rx_HDLC15_Offset             0x16C0
#define IXF3204_Rx_HDLC16_Offset             0x16E0
#define IXF3204_Rx_HDLC17_Offset             0x1700
#define IXF3204_Rx_HDLC18_Offset             0x1720
#define IXF3204_Rx_HDLC19_Offset             0x1740
#define IXF3204_Rx_HDLC20_Offset             0x1760
#define IXF3204_Rx_HDLC21_Offset             0x1780
#define IXF3204_Rx_HDLC22_Offset             0x17A0
#define IXF3204_Rx_HDLC23_Offset             0x17C0
#define IXF3204_Rx_HDLC24_Offset             0x17E0

#define IXF3204_Tx_HDLC1_Offset              0x1800
#define IXF3204_Tx_HDLC2_Offset              0x1820
#define IXF3204_Tx_HDLC3_Offset              0x1840
#define IXF3204_Tx_HDLC4_Offset              0x1860
#define IXF3204_Tx_HDLC5_Offset              0x1880
#define IXF3204_Tx_HDLC6_Offset              0x18A0
#define IXF3204_Tx_HDLC7_Offset              0x18C0
#define IXF3204_Tx_HDLC8_Offset              0x18E0
#define IXF3204_Tx_HDLC9_Offset              0x1900
#define IXF3204_Tx_HDLC10_Offset             0x1920
#define IXF3204_Tx_HDLC11_Offset             0x1940
#define IXF3204_Tx_HDLC12_Offset             0x1960
#define IXF3204_Tx_HDLC13_Offset             0x1980
#define IXF3204_Tx_HDLC14_Offset             0x19A0
#define IXF3204_Tx_HDLC15_Offset             0x19C0
#define IXF3204_Tx_HDLC16_Offset             0x19E0
#define IXF3204_Tx_HDLC17_Offset             0x1A00
#define IXF3204_Tx_HDLC18_Offset             0x1A20
#define IXF3204_Tx_HDLC19_Offset             0x1A40
#define IXF3204_Tx_HDLC20_Offset             0x1A60
#define IXF3204_Tx_HDLC21_Offset             0x1A80
#define IXF3204_Tx_HDLC22_Offset             0x1AA0
#define IXF3204_Tx_HDLC23_Offset             0x1AC0
#define IXF3204_Tx_HDLC24_Offset             0x1AE0

/* Rx HDLC registers */
#define IXF3204_RXHDLC_GCR                   0x00
#define IXF3204_RXHDLC_HAMR                  0x01
#define IXF3204_RXHDLC_LAMR                  0x02
#define IXF3204_RXHDLC_HAR1                  0x03
#define IXF3204_RXHDLC_HAR2                  0x04
#define IXF3204_RXHDLC_LAR1                  0x05
#define IXF3204_RXHDLC_LAR2                  0x06
#define IXF3204_RXHDLC_MLR1                  0x07
#define IXF3204_RXHDLC_MLR2                  0x08
#define IXF3204_RXHDLC_HCR                   0x09
#define IXF3204_RXHDLC_IR                    0x0A
#define IXF3204_RXHDLC_RMLR1                 0x0B
#define IXF3204_RXHDLC_RMLR2                 0x0C
#define IXF3204_RXHDLC_SR                    0x0D
#define IXF3204_RXHDLC_AMSR                  0x0E
#define IXF3204_RXHDLC_FIFORD                0x0F

/* Tx HDLC Registers */
#define IXF3204_TXHDLC_GCR                   0x00
#define IXF3204_TXHDLC_HCR                   0x01
#define IXF3204_TXHDLC_HLR                   0x02
#define IXF3204_TXHDLC_IR                    0x03
#define IXF3204_TXHDLC_FIFOWR                0x04


/* FDL */

#define IXF3204_Rx_FDL1_Offset               0x160
#define IXF3204_Rx_FDL2_Offset               0x3E0
#define IXF3204_Rx_FDL3_Offset               0x660
#define IXF3204_Rx_FDL4_Offset               0x8E0
#define IXF3204_Rx_FDL5_Offset               0xB60
#define IXF3204_Rx_FDL6_Offset               0xDE0
#define IXF3204_Rx_FDL7_Offset               0x1060
#define IXF3204_Rx_FDL8_Offset               0x12E0

#define IXF3204_Tx_FDL1_Offset               0x180
#define IXF3204_Tx_FDL2_Offset               0x400
#define IXF3204_Tx_FDL3_Offset               0x680
#define IXF3204_Tx_FDL4_Offset               0x900
#define IXF3204_Tx_FDL5_Offset               0xB80
#define IXF3204_Tx_FDL6_Offset               0xE00
#define IXF3204_Tx_FDL7_Offset               0x1080
#define IXF3204_Tx_FDL8_Offset               0x1300

/* Rx FDL registers */
#define IXF3204_RXFDL_GCR                    0x00
#define IXF3204_RXFDL_DLCR                   0x01
#define IXF3204_RXFDL_CCSTSR1                0x02
#define IXF3204_RXFDL_CCSTSR2                0x03
#define IXF3204_RXFDL_CCSTSR3                0x04
#define IXF3204_RXFDL_CCSTSR4                0x05
#define IXF3204_RXFDL_CCSBR                  0x06
#define IXF3204_RXFDL_MMLR1                  0x07
#define IXF3204_RXFDL_MMLR2                  0x08
#define IXF3204_RXFDL_HCR                    0x09
#define IXF3204_RXFDL_IR                     0x0A
#define IXF3204_RXFDL_RLR1                   0x0B
#define IXF3204_RXFDL_RLR2                   0x0C
#define IXF3204_RXFDL_SR                     0x0D
#define IXF3204_RXFDL_PRMSR                  0x0E
#define IXF3204_RXFDL_FIFORD                 0x0F
#define IXF3204_RXFDL_PRMAD1R                0x10
#define IXF3204_RXFDL_PRMAD2R                0x11
#define IXF3204_RXFDL_PRMCR                  0x12
#define IXF3204_RXFDL_PRMR1                  0x13
#define IXF3204_RXFDL_PRMR2                  0x14
#define IXF3204_RXFDL_PRMR3                  0x15
#define IXF3204_RXFDL_PRMR4                  0x16
#define IXF3204_RXFDL_PRMR5                  0x17
#define IXF3204_RXFDL_PRMR6                  0x18
#define IXF3204_RXFDL_PRMR7                  0x19
#define IXF3204_RXFDL_PRMR8                  0x1A
#define IXF3204_RXFDL_BOPSR                  0x1B
#define IXF3204_RXFDL_BOPCR                  0x1C
#define IXF3204_RXFDL_DDLSR1                 0x1D
#define IXF3204_RXFDL_DDLSR2                 0x1E
#define IXF3204_RXFDL_DDLSR3                 0x1F

/* Tx FDL registers */
#define IXF3204_TXFDL_GCR                    0x00
#define IXF3204_TXFDL_HCR                    0x01
#define IXF3204_TXFDL_HLR                    0x02
#define IXF3204_TXFDL_IR                     0x03
#define IXF3204_TXFDL_FIFOWR                 0x04
#define IXF3204_TXFDL_DLCR                   0x05
#define IXF3204_TXFDL_CCSTSR1                0x06
#define IXF3204_TXFDL_CCSTSR2                0x07
#define IXF3204_TXFDL_CCSTSR3                0x08
#define IXF3204_TXFDL_CCSTSR4                0x09
#define IXF3204_TXFDL_CCSBR                  0x0A
#define IXF3204_TXFDL_BOPCR                  0x0B
#define IXF3204_TXFDL_BOPNR1                 0x0C
#define IXF3204_TXFDL_BOPNR2                 0x0D
#define IXF3204_TXFDL_PRMCR                  0x0E
#define IXF3204_TXFDL_PRMAD1R                0x0F
#define IXF3204_TXFDL_PRMAD2R                0x10
#define IXF3204_TXFDL_PRMCRW                 0x11
#define IXF3204_TXFDL_PRMR1                  0x12
#define IXF3204_TXFDL_PRMR2                  0x13
#define IXF3204_TXFDL_PRMR3                  0x14
#define IXF3204_TXFDL_PRMR4                  0x15
#define IXF3204_TXFDL_PRMR5                  0x16
#define IXF3204_TXFDL_PRMR6                  0x17
#define IXF3204_TXFDL_PRMR7                  0x18
#define IXF3204_TXFDL_PRMR8                  0x19
#define IXF3204_TXFDL_DDLSR1                 0x1A
#define IXF3204_TXFDL_DDLSR2                 0x1B
#define IXF3204_TXFDL_DDLSR3                 0x1C


/* performance elements database */
#define IXF3204_PE_Port1_Offset	             0xD2D0
#define IXF3204_PE_Port2_Offset	             0xD874
#define IXF3204_PE_Port3_Offset	             0xDE18
#define IXF3204_PE_Port4_Offset	             0xE3BC
#define IXF3204_PE_Port5_Offset	             0xE960
#define IXF3204_PE_Port6_Offset	             0xEF04
#define IXF3204_PE_Port7_Offset	             0xF4A8
#define IXF3204_PE_Port8_Offset	             0xFA4C

#define IXF3204_PRM_ENABLE_REG               0x05A0

/* Alarms */
#define IXF3204_RX_ALARMS_MEM_OFFSET         0x5C00

#define IXF3204_Rx_Alarms1_Offset            0x200
#define IXF3204_Rx_Alarms2_Offset            0x480
#define IXF3204_Rx_Alarms3_Offset            0x700
#define IXF3204_Rx_Alarms4_Offset            0x980
#define IXF3204_Rx_Alarms5_Offset            0xC00
#define IXF3204_Rx_Alarms6_Offset            0xE80
#define IXF3204_Rx_Alarms7_Offset            0x1100
#define IXF3204_Rx_Alarms8_Offset            0x1380

#define IXF3204_Tx_Alarms1_Offset            0x220
#define IXF3204_Tx_Alarms2_Offset            0x4A0
#define IXF3204_Tx_Alarms3_Offset            0x720
#define IXF3204_Tx_Alarms4_Offset            0x9A0
#define IXF3204_Tx_Alarms5_Offset            0xC20
#define IXF3204_Tx_Alarms6_Offset            0xEA0
#define IXF3204_Tx_Alarms7_Offset            0x1120
#define IXF3204_Tx_Alarms8_Offset            0x13A0

/* National Bits */
#define IXF3204_National_Offset0             0x02E0
#define IXF3204_National_Offset1             0x0560
#define IXF3204_National_Offset2             0x07E0
#define IXF3204_National_Offset3             0x0A60
#define IXF3204_National_Offset4             0x0CE0
#define IXF3204_National_Offset5             0x0F60
#define IXF3204_National_Offset6             0x11E0
#define IXF3204_National_Offset7             0x1460

/* Tx Alarms Registers */
#define IXF3204_TXALRM_HCR                   0x00
#define IXF3204_TXALRM_ECR                   0x01
#define IXF3204_TXALRM_SR                    0x02
#define IXF3204_TXALRM_SPARE                 0x03

#define IXF3204_TXALRM_CACR                  0x10
#define IXF3204_TXALRM_CAOOF                 0x11
#define IXF3204_TXALRM_CALOS                 0x12
#define IXF3204_TXALRM_CAAIS                 0x13
#define IXF3204_TXALRM_CWOOFLOS              0x14
#define IXF3204_TXALRM_CWAIS                 0x15
#define IXF3204_TXALRM_CAINTCRC              0x16
#define IXF3204_TXALRM_CACAS                 0x17
#define IXF3204_TXALRM_CASR                  0x18
#define IXF3204_TXALRM_CABOPLOOP             0x19
#define IXF3204_TXALRM_FAILDEFSEL            0x1A

/* Rx Alarms Registers */
#define IXF3204_RXALRM_ECR                   0x00
#define IXF3204_RXALRM_DSR                   0x01
#define IXF3204_RXALRM_FSR                   0x02
#define IXF3204_RXALRM_SR                    0x03
#define IXF3204_RXALRM_SPARE                 0x06
#define IXF3204_RXALRM_OOFL0                 0x00
#define IXF3204_RXALRM_OOFH0                 0x01
#define IXF3204_RXALRM_OOFL1                 0x02
#define IXF3204_RXALRM_OOFH1                 0x03
#define IXF3204_RXALRM_OOFL2                 0x04
#define IXF3204_RXALRM_OOFH2                 0x05
#define IXF3204_RXALRM_OOFL3                 0x06
#define IXF3204_RXALRM_OOFH3                 0x07
#define IXF3204_RXALRM_OOFL4                 0x08
#define IXF3204_RXALRM_OOFH4                 0x09
#define IXF3204_RXALRM_OOFL5                 0x0A
#define IXF3204_RXALRM_OOFH5                 0x0B
#define IXF3204_RXALRM_OOFL6                 0x0C
#define IXF3204_RXALRM_OOFH6                 0x0D
#define IXF3204_RXALRM_OOFL7                 0x0E
#define IXF3204_RXALRM_OOFH7                 0x0F
#define IXF3204_RXALRM_LOSL0                 0x10
#define IXF3204_RXALRM_LOSH0                 0x11
#define IXF3204_RXALRM_LOSL1                 0x12
#define IXF3204_RXALRM_LOSH1                 0x13
#define IXF3204_RXALRM_LOSL2                 0x14
#define IXF3204_RXALRM_LOSH2                 0x15
#define IXF3204_RXALRM_LOSL3                 0x16
#define IXF3204_RXALRM_LOSH3                 0x17
#define IXF3204_RXALRM_LOSL4                 0x18
#define IXF3204_RXALRM_LOSH4                 0x19
#define IXF3204_RXALRM_LOSL5                 0x1A
#define IXF3204_RXALRM_LOSH5                 0x1B
#define IXF3204_RXALRM_LOSL6                 0x1C
#define IXF3204_RXALRM_LOSH6                 0x1D
#define IXF3204_RXALRM_LOSL7                 0x1E
#define IXF3204_RXALRM_LOSH7                 0x1F
#define IXF3204_RXALRM_AISL0                 0x20
#define IXF3204_RXALRM_AISH0                 0x21
#define IXF3204_RXALRM_AISL1                 0x22
#define IXF3204_RXALRM_AISH1                 0x23
#define IXF3204_RXALRM_AISL2                 0x24
#define IXF3204_RXALRM_AISH2                 0x25
#define IXF3204_RXALRM_AISL3                 0x26
#define IXF3204_RXALRM_AISH3                 0x27
#define IXF3204_RXALRM_AISL4                 0x28
#define IXF3204_RXALRM_AISH4                 0x29
#define IXF3204_RXALRM_AISL5                 0x2A
#define IXF3204_RXALRM_AISH5                 0x2B
#define IXF3204_RXALRM_AISL6                 0x2C
#define IXF3204_RXALRM_AISH6                 0x2D
#define IXF3204_RXALRM_AISL7                 0x2E
#define IXF3204_RXALRM_AISH7                 0x2F
#define IXF3204_RXALRM_RAIL0                 0x30
#define IXF3204_RXALRM_RAIH0                 0x31
#define IXF3204_RXALRM_RAIL1                 0x32
#define IXF3204_RXALRM_RAIH1                 0x33
#define IXF3204_RXALRM_RAIL2                 0x34
#define IXF3204_RXALRM_RAIH2                 0x35
#define IXF3204_RXALRM_RAIL3                 0x36
#define IXF3204_RXALRM_RAIH3                 0x37
#define IXF3204_RXALRM_RAIL4                 0x38
#define IXF3204_RXALRM_RAIH4                 0x39
#define IXF3204_RXALRM_RAIL5                 0x3A
#define IXF3204_RXALRM_RAIH5                 0x3B
#define IXF3204_RXALRM_RAIL6                 0x3C
#define IXF3204_RXALRM_RAIH6                 0x3D
#define IXF3204_RXALRM_RAIL7                 0x3E
#define IXF3204_RXALRM_RAIH7                 0x3F

#define IXF3204_RXALRM_TH_SET_T1_OOFL        0x40
#define IXF3204_RXALRM_TH_SET_T1_OOFH        0x41
#define IXF3204_RXALRM_TH_SET_T1_LOSL        0x42
#define IXF3204_RXALRM_TH_SET_T1_LOSH        0x43
#define IXF3204_RXALRM_TH_SET_T1_AISL        0x44
#define IXF3204_RXALRM_TH_SET_T1_AISH        0x45
#define IXF3204_RXALRM_TH_SET_T1_RAIL        0x46
#define IXF3204_RXALRM_TH_SET_T1_RAIH        0x47
#define IXF3204_RXALRM_TH_SET_E1_OOFL        0x48
#define IXF3204_RXALRM_TH_SET_E1_OOFH        0x49
#define IXF3204_RXALRM_TH_SET_E1_LOSL        0x4A
#define IXF3204_RXALRM_TH_SET_E1_LOSH        0x4B
#define IXF3204_RXALRM_TH_SET_E1_AISL        0x4C
#define IXF3204_RXALRM_TH_SET_E1_AISH        0x4D
#define IXF3204_RXALRM_TH_SET_E1_RAIL        0x4E
#define IXF3204_RXALRM_TH_SET_E1_RAIH        0x4F
#define IXF3204_RXALRM_TH_RSET_T1_OOFL       0x60
#define IXF3204_RXALRM_TH_RSET_T1_OOFH       0x61
#define IXF3204_RXALRM_TH_RSET_T1_LOSL       0x62
#define IXF3204_RXALRM_TH_RSET_T1_LOSH       0x63
#define IXF3204_RXALRM_TH_RSET_T1_AISL       0x64
#define IXF3204_RXALRM_TH_RSET_T1_AISH       0x65
#define IXF3204_RXALRM_TH_RSET_T1_RAIL       0x66
#define IXF3204_RXALRM_TH_RSET_T1_RAIH       0x67
#define IXF3204_RXALRM_TH_RSET_E1_OOFL       0x68
#define IXF3204_RXALRM_TH_RSET_E1_OOFH       0x69
#define IXF3204_RXALRM_TH_RSET_E1_LOSL       0x6A
#define IXF3204_RXALRM_TH_RSET_E1_LOSH       0x6B
#define IXF3204_RXALRM_TH_RSET_E1_AISL       0x6C
#define IXF3204_RXALRM_TH_RSET_E1_AISH       0x6D
#define IXF3204_RXALRM_TH_RSET_E1_RAIL       0x6E
#define IXF3204_RXALRM_TH_RSET_E1_RAIH       0x6F

/* national bits module registers */
#define IXF3204_NATBITS_CR                   0x00
#define IXF3204_NATBITS_SR                   0x01
#define IXF3204_NATBITS_SIFR                 0x02
#define IXF3204_NATBITS_SINFR                0x03
#define IXF3204_NATBITS_SA4R                 0x04
#define IXF3204_NATBITS_SA5R                 0x05
#define IXF3204_NATBITS_SA6R                 0x06
#define IXF3204_NATBITS_SA7R                 0x07
#define IXF3204_NATBITS_SA8R                 0x08
#define IXF3204_NATBITS_ECR1                 0x09
#define IXF3204_NATBITS_ECR2                 0x0A
#define IXF3204_NATBITS_CRCCR1               0x0B
#define IXF3204_NATBITS_CRCCR2               0x0C
#define IXF3204_NATBITS_TXENABLE             0x10
#define IXF3204_NATBITS_TXSIFAS              0x11
#define IXF3204_NATBITS_TXSINFAS             0x12
#define IXF3204_NATBITS_TXSA4                0x13
#define IXF3204_NATBITS_TXSA5                0x14
#define IXF3204_NATBITS_TXSA6                0x15
#define IXF3204_NATBITS_TXSA7                0x16
#define IXF3204_NATBITS_TXSA8                0x17


/* Performance Elements */
#define IXF3204_T1NEAREND_INIOFFSET          0x000
#define IXF3204_T1NEAREND_ENDOFFSET          0x2AB

#define IXF3204_T1FAREND_INIOFFSET	         0x2AC
#define IXF3204_T1FAREND_ENDOFFSET	         0x557

#define IXF3204_E1NEAREND_INIOFFSET          0x568
#define IXF3204_E1NEAREND_ENDOFFSET          0x583

#define IXF3204_E1FAREND_INIOFFSET	         0x584
#define IXF3204_E1FAREND_ENDOFFSET	         0x59F

#define IXF3204_GENERIC_INIOFFSET            0x558
#define IXF3204_GENERIC_ENDOFFSET            0x565

#define	IXF3204_NE_ESRL                      0x0578
#define	IXF3204_FE_ESRL                      0x0594

#define	IXF3204_NE_SESRL                     0x057C
#define	IXF3204_FE_SESRL                     0x0598

#define	IXF3204_NE_BBERL                     0x0580
#define	IXF3204_FE_BBERL                     0x059C

#define IXF3204_NE_TIMEL                     0x0568
#define IXF3204_FE_TIMEL                     0x0584

#define IXF3204_NE_UASTIMEL                  0x056C
#define IXF3204_FE_UASTIMEL                  0x0588

#define IXF3204_NE_ATIMEL                    0x0570
#define IXF3204_FE_ATIMEL                    0x058C

#define IXF3204_NE_ARTIMEL                   0x0574
#define IXF3204_FE_ARTIMEL                   0x0590

#define IXF3204_NE_CVL15C_L                  0x0000
#define IXF3204_NE_CVL15P_L                  0x0002
#define IXF3204_NE_CVL15R_0L                 0x0004
#define IXF3204_NE_CVL15R_1L                 0x0006
#define IXF3204_NE_CVL15R_2L                 0x0008
#define IXF3204_NE_CVL15R_3L                 0x000A
#define IXF3204_NE_CVL15R_4L                 0x000C
#define IXF3204_NE_CVL15R_5L                 0x000E
#define IXF3204_NE_CVL15R_6L                 0x0010
#define IXF3204_NE_CVL15R_7L                 0x0012
#define IXF3204_NE_CVL15R_8L                 0x0014
#define IXF3204_NE_CVL15R_9L                 0x0016
#define IXF3204_NE_CVL15R_10L                0x0018
#define IXF3204_NE_CVL15R_11L                0x001A
#define IXF3204_NE_CVL15R_12L                0x001C
#define IXF3204_NE_CVL15R_13L                0x001E
#define IXF3204_NE_CVL15R_14L                0x0020
#define IXF3204_NE_CVL15R_15L                0x0022
#define IXF3204_NE_CVL15R_16L                0x0024
#define IXF3204_NE_CVL15R_17L                0x0026
#define IXF3204_NE_CVL15R_18L                0x0028
#define IXF3204_NE_CVL15R_19L                0x002A
#define IXF3204_NE_CVL15R_20L                0x002C
#define IXF3204_NE_CVL15R_21L                0x002E
#define IXF3204_NE_CVL15R_22L                0x0030
#define IXF3204_NE_CVL15R_23L                0x0032
#define IXF3204_NE_CVL15R_24L                0x0034
#define IXF3204_NE_CVL15R_25L                0x0036
#define IXF3204_NE_CVL15R_26L                0x0038
#define IXF3204_NE_CVL15R_27L                0x003A
#define IXF3204_NE_CVL15R_28L                0x003C
#define IXF3204_NE_CVL15R_29L                0x003E
#define IXF3204_NE_CVL15R_30L                0x0040

#define IXF3204_NE_CVLCURRDAYL               0x0044
#define IXF3204_NE_CVLPREVDAYL               0x0048

#define IXF3204_NE_ESL15C_L                  0x004C
#define IXF3204_NE_ESL15P_L                  0x004E
#define IXF3204_NE_ESL15R_0L                 0x0050
#define IXF3204_NE_ESL15R_1L                 0x0052
#define IXF3204_NE_ESL15R_2L                 0x0054
#define IXF3204_NE_ESL15R_3L                 0x0056
#define IXF3204_NE_ESL15R_4L                 0x0058
#define IXF3204_NE_ESL15R_5L                 0x005A
#define IXF3204_NE_ESL15R_6L                 0x005C
#define IXF3204_NE_ESL15R_7L                 0x005E
#define IXF3204_NE_ESL15R_8L                 0x0060
#define IXF3204_NE_ESL15R_9L                 0x0062
#define IXF3204_NE_ESL15R_10L                0x0064
#define IXF3204_NE_ESL15R_11L                0x0066
#define IXF3204_NE_ESL15R_12L                0x0068
#define IXF3204_NE_ESL15R_13L                0x006A
#define IXF3204_NE_ESL15R_14L                0x006C
#define IXF3204_NE_ESL15R_15L                0x006E
#define IXF3204_NE_ESL15R_16L                0x0070
#define IXF3204_NE_ESL15R_17L                0x0072
#define IXF3204_NE_ESL15R_18L                0x0074
#define IXF3204_NE_ESL15R_19L                0x0076
#define IXF3204_NE_ESL15R_20L                0x0078
#define IXF3204_NE_ESL15R_21L                0x007A
#define IXF3204_NE_ESL15R_22L                0x007C
#define IXF3204_NE_ESL15R_23L                0x007E
#define IXF3204_NE_ESL15R_24L                0x0080
#define IXF3204_NE_ESL15R_25L                0x0082
#define IXF3204_NE_ESL15R_26L                0x0084
#define IXF3204_NE_ESL15R_27L                0x0086
#define IXF3204_NE_ESL15R_28L                0x0088
#define IXF3204_NE_ESL15R_29L                0x008A
#define IXF3204_NE_ESL15R_30L                0x008C

#define IXF3204_NE_ESLCURRDAYL               0x0090
#define IXF3204_NE_ESLPREVDAYL               0x0094


#define IXF3204_NE_SESL15C_L                 0x0098
#define IXF3204_NE_SESL15P_L                 0x009A
#define IXF3204_NE_SESL15R_0L                0x009C
#define IXF3204_NE_SESL15R_1L                0x009E
#define IXF3204_NE_SESL15R_2L                0x00A0
#define IXF3204_NE_SESL15R_3L                0x00A2
#define IXF3204_NE_SESL15R_4L                0x00A4
#define IXF3204_NE_SESL15R_5L                0x00A6
#define IXF3204_NE_SESL15R_6L                0x00A8
#define IXF3204_NE_SESL15R_7L                0x00AA
#define IXF3204_NE_SESL15R_8L                0x00AC
#define IXF3204_NE_SESL15R_9L                0x00AE
#define IXF3204_NE_SESL15R_10L               0x00B0
#define IXF3204_NE_SESL15R_11L               0x00B2
#define IXF3204_NE_SESL15R_12L               0x00B4
#define IXF3204_NE_SESL15R_13L               0x00B6
#define IXF3204_NE_SESL15R_14L               0x00B8
#define IXF3204_NE_SESL15R_15L               0x00BA
#define IXF3204_NE_SESL15R_16L               0x00BC
#define IXF3204_NE_SESL15R_17L               0x00BE
#define IXF3204_NE_SESL15R_18L               0x00C0
#define IXF3204_NE_SESL15R_19L               0x00C2
#define IXF3204_NE_SESL15R_20L               0x00C4
#define IXF3204_NE_SESL15R_21L               0x00C6
#define IXF3204_NE_SESL15R_22L               0x00C8
#define IXF3204_NE_SESL15R_23L               0x00CA
#define IXF3204_NE_SESL15R_24L               0x00CC
#define IXF3204_NE_SESL15R_25L               0x00CE
#define IXF3204_NE_SESL15R_26L               0x00D0
#define IXF3204_NE_SESL15R_27L               0x00D2
#define IXF3204_NE_SESL15R_28L               0x00D4
#define IXF3204_NE_SESL15R_29L               0x00D6
#define IXF3204_NE_SESL15R_30L               0x00D8

#define IXF3204_NE_SESLCURRDAYL              0x00DC
#define IXF3204_NE_SESLPREVDAYL              0x00E0

#define IXF3204_NE_CVP15C_L                  0x00E4
#define IXF3204_NE_CVP15P_L                  0x00E6
#define IXF3204_NE_CVP15R_0L                 0x00E8
#define IXF3204_NE_CVP15R_1L                 0x00EA
#define IXF3204_NE_CVP15R_2L                 0x00EC
#define IXF3204_NE_CVP15R_3L                 0x00EE
#define IXF3204_NE_CVP15R_4L                 0x00F0
#define IXF3204_NE_CVP15R_5L                 0x00F2
#define IXF3204_NE_CVP15R_6L                 0x00F4
#define IXF3204_NE_CVP15R_7L                 0x00F6
#define IXF3204_NE_CVP15R_8L                 0x00F8
#define IXF3204_NE_CVP15R_9L                 0x00FA
#define IXF3204_NE_CVP15R_10L                0x00FC
#define IXF3204_NE_CVP15R_11L                0x00FE
#define IXF3204_NE_CVP15R_12L                0x0100
#define IXF3204_NE_CVP15R_13L                0x0102
#define IXF3204_NE_CVP15R_14L                0x0104
#define IXF3204_NE_CVP15R_15L                0x0106
#define IXF3204_NE_CVP15R_16L                0x0108
#define IXF3204_NE_CVP15R_17L                0x010A
#define IXF3204_NE_CVP15R_18L                0x010C
#define IXF3204_NE_CVP15R_19L                0x010E
#define IXF3204_NE_CVP15R_20L                0x0110
#define IXF3204_NE_CVP15R_21L                0x0112
#define IXF3204_NE_CVP15R_22L                0x0114
#define IXF3204_NE_CVP15R_23L                0x0116
#define IXF3204_NE_CVP15R_24L                0x0118
#define IXF3204_NE_CVP15R_25L                0x011A
#define IXF3204_NE_CVP15R_26L                0x011C
#define IXF3204_NE_CVP15R_27L                0x011E
#define IXF3204_NE_CVP15R_28L                0x0120
#define IXF3204_NE_CVP15R_29L                0x0122
#define IXF3204_NE_CVP15R_30L                0x0124

#define IXF3204_NE_CVPCURRDAYL               0x0128
#define IXF3204_NE_CVPPREVDAYL               0x012C

#define IXF3204_NE_ESP15C_L                  0x0130
#define IXF3204_NE_ESP15P_L                  0x0132
#define IXF3204_NE_ESP15R_0L                 0x0134
#define IXF3204_NE_ESP15R_1L                 0x0136
#define IXF3204_NE_ESP15R_2L                 0x0138
#define IXF3204_NE_ESP15R_3L                 0x013A
#define IXF3204_NE_ESP15R_4L                 0x013C
#define IXF3204_NE_ESP15R_5L                 0x013E
#define IXF3204_NE_ESP15R_6L                 0x0140
#define IXF3204_NE_ESP15R_7L                 0x0142
#define IXF3204_NE_ESP15R_8L                 0x0144
#define IXF3204_NE_ESP15R_9L                 0x0146
#define IXF3204_NE_ESP15R_10L                0x0148
#define IXF3204_NE_ESP15R_11L                0x014A
#define IXF3204_NE_ESP15R_12L                0x014C
#define IXF3204_NE_ESP15R_13L                0x014E
#define IXF3204_NE_ESP15R_14L                0x0150
#define IXF3204_NE_ESP15R_15L                0x0152
#define IXF3204_NE_ESP15R_16L                0x0154
#define IXF3204_NE_ESP15R_17L                0x0156
#define IXF3204_NE_ESP15R_18L                0x0158
#define IXF3204_NE_ESP15R_19L                0x015A
#define IXF3204_NE_ESP15R_20L                0x015C
#define IXF3204_NE_ESP15R_21L                0x015E
#define IXF3204_NE_ESP15R_22L                0x0160
#define IXF3204_NE_ESP15R_23L                0x0162
#define IXF3204_NE_ESP15R_24L                0x0164
#define IXF3204_NE_ESP15R_25L                0x0166
#define IXF3204_NE_ESP15R_26L                0x0168
#define IXF3204_NE_ESP15R_27L                0x016A
#define IXF3204_NE_ESP15R_28L                0x016C
#define IXF3204_NE_ESP15R_29L                0x016E
#define IXF3204_NE_ESP15R_30L                0x0170

#define IXF3204_NE_ESPCURRDAYL               0x0174
#define IXF3204_NE_ESPPREVDAYL               0x0178

#define IXF3204_NE_SESP15C_L                 0x017C
#define IXF3204_NE_SESP15P_L                 0x017E
#define IXF3204_NE_SESP15R_0L                0x0180
#define IXF3204_NE_SESP15R_1L                0x0182
#define IXF3204_NE_SESP15R_2L                0x0184
#define IXF3204_NE_SESP15R_3L                0x0186
#define IXF3204_NE_SESP15R_4L                0x0188
#define IXF3204_NE_SESP15R_5L                0x018A
#define IXF3204_NE_SESP15R_6L                0x018C
#define IXF3204_NE_SESP15R_7L                0x018E
#define IXF3204_NE_SESP15R_8L                0x0190
#define IXF3204_NE_SESP15R_9L                0x0192
#define IXF3204_NE_SESP15R_10L               0x0194
#define IXF3204_NE_SESP15R_11L               0x0196
#define IXF3204_NE_SESP15R_12L               0x0198
#define IXF3204_NE_SESP15R_13L               0x019A
#define IXF3204_NE_SESP15R_14L               0x019C
#define IXF3204_NE_SESP15R_15L               0x019E
#define IXF3204_NE_SESP15R_16L               0x01A0
#define IXF3204_NE_SESP15R_17L               0x01A2
#define IXF3204_NE_SESP15R_18L               0x01A4
#define IXF3204_NE_SESP15R_19L               0x01A6
#define IXF3204_NE_SESP15R_20L               0x01A8
#define IXF3204_NE_SESP15R_21L               0x01AA
#define IXF3204_NE_SESP15R_22L               0x01AC
#define IXF3204_NE_SESP15R_23L               0x01AE
#define IXF3204_NE_SESP15R_24L               0x01B0
#define IXF3204_NE_SESP15R_25L               0x01B2
#define IXF3204_NE_SESP15R_26L               0x01B4
#define IXF3204_NE_SESP15R_27L               0x01B6
#define IXF3204_NE_SESP15R_28L               0x01B8
#define IXF3204_NE_SESP15R_29L               0x01BA
#define IXF3204_NE_SESP15R_30L               0x01BC

#define IXF3204_NE_SESPCURRDAYL              0x01C0
#define IXF3204_NE_SESPPREVDAYL              0x01C4

#define IXF3204_NE_SASP15C_L                 0x01C8
#define IXF3204_NE_SASP15P_L                 0x01CA
#define IXF3204_NE_SASP15R_0L                0x01CC
#define IXF3204_NE_SASP15R_1L                0x01CE
#define IXF3204_NE_SASP15R_2L                0x01D0
#define IXF3204_NE_SASP15R_3L                0x01D2
#define IXF3204_NE_SASP15R_4L                0x01D4
#define IXF3204_NE_SASP15R_5L                0x01D6
#define IXF3204_NE_SASP15R_6L                0x01D8
#define IXF3204_NE_SASP15R_7L                0x01DA
#define IXF3204_NE_SASP15R_8L                0x01DC
#define IXF3204_NE_SASP15R_9L                0x01DE
#define IXF3204_NE_SASP15R_10L               0x01E0
#define IXF3204_NE_SASP15R_11L               0x01E2
#define IXF3204_NE_SASP15R_12L               0x01E4
#define IXF3204_NE_SASP15R_13L               0x01E6
#define IXF3204_NE_SASP15R_14L               0x01E8
#define IXF3204_NE_SASP15R_15L               0x01EA
#define IXF3204_NE_SASP15R_16L               0x01EC
#define IXF3204_NE_SASP15R_17L               0x01EE
#define IXF3204_NE_SASP15R_18L               0x01F0
#define IXF3204_NE_SASP15R_19L               0x01F2
#define IXF3204_NE_SASP15R_20L               0x01F4
#define IXF3204_NE_SASP15R_21L               0x01F6
#define IXF3204_NE_SASP15R_22L               0x01F8
#define IXF3204_NE_SASP15R_23L               0x01FA
#define IXF3204_NE_SASP15R_24L               0x01FC
#define IXF3204_NE_SASP15R_25L               0x01FE
#define IXF3204_NE_SASP15R_26L               0x0200
#define IXF3204_NE_SASP15R_27L               0x0202
#define IXF3204_NE_SASP15R_28L               0x0204
#define IXF3204_NE_SASP15R_29L               0x0206
#define IXF3204_NE_SASP15R_30L               0x0208

#define IXF3204_NE_SASPCURRDAYL              0x020C
#define IXF3204_NE_SASPPREVDAYL              0x0210

#define IXF3204_NE_UASP15C_L                 0x0214
#define IXF3204_NE_UASP15P_L                 0x0216
#define IXF3204_NE_UASP15R_0L                0x0218
#define IXF3204_NE_UASP15R_1L                0x021A
#define IXF3204_NE_UASP15R_2L                0x021C
#define IXF3204_NE_UASP15R_3L                0x021E
#define IXF3204_NE_UASP15R_4L                0x0220
#define IXF3204_NE_UASP15R_5L                0x0222
#define IXF3204_NE_UASP15R_6L                0x0224
#define IXF3204_NE_UASP15R_7L                0x0226
#define IXF3204_NE_UASP15R_8L                0x0228
#define IXF3204_NE_UASP15R_9L                0x022A
#define IXF3204_NE_UASP15R_10L               0x022C
#define IXF3204_NE_UASP15R_11L               0x022E
#define IXF3204_NE_UASP15R_12L               0x0230
#define IXF3204_NE_UASP15R_13L               0x0232
#define IXF3204_NE_UASP15R_14L               0x0234
#define IXF3204_NE_UASP15R_15L               0x0236
#define IXF3204_NE_UASP15R_16L               0x0238
#define IXF3204_NE_UASP15R_17L               0x023A
#define IXF3204_NE_UASP15R_18L               0x023C
#define IXF3204_NE_UASP15R_19L               0x023E
#define IXF3204_NE_UASP15R_20L               0x0240
#define IXF3204_NE_UASP15R_21L               0x0242
#define IXF3204_NE_UASP15R_22L               0x0244
#define IXF3204_NE_UASP15R_23L               0x0246
#define IXF3204_NE_UASP15R_24L               0x0248
#define IXF3204_NE_UASP15R_25L               0x024A
#define IXF3204_NE_UASP15R_26L               0x024C
#define IXF3204_NE_UASP15R_27L               0x024E
#define IXF3204_NE_UASP15R_28L               0x0250
#define IXF3204_NE_UASP15R_29L               0x0252
#define IXF3204_NE_UASP15R_30L               0x0254

#define IXF3204_NE_UASPCURRDAYL              0x0258
#define IXF3204_NE_UASPPREVDAYL              0x025C

#define IXF3204_NE_CSSP15C_L                 0x0260
#define IXF3204_NE_CSSP15P_L                 0x0262
#define IXF3204_NE_CSSP15R_0L                0x0264
#define IXF3204_NE_CSSP15R_1L                0x0266
#define IXF3204_NE_CSSP15R_2L                0x0268
#define IXF3204_NE_CSSP15R_3L                0x026A
#define IXF3204_NE_CSSP15R_4L                0x026C
#define IXF3204_NE_CSSP15R_5L                0x026E
#define IXF3204_NE_CSSP15R_6L                0x0270
#define IXF3204_NE_CSSP15R_7L                0x0272
#define IXF3204_NE_CSSP15R_8L                0x0274
#define IXF3204_NE_CSSP15R_9L                0x0276
#define IXF3204_NE_CSSP15R_10L               0x0278
#define IXF3204_NE_CSSP15R_11L               0x027A
#define IXF3204_NE_CSSP15R_12L               0x027C
#define IXF3204_NE_CSSP15R_13L               0x027E
#define IXF3204_NE_CSSP15R_14L               0x0280
#define IXF3204_NE_CSSP15R_15L               0x0282
#define IXF3204_NE_CSSP15R_16L               0x0284
#define IXF3204_NE_CSSP15R_17L               0x0286
#define IXF3204_NE_CSSP15R_18L               0x0288
#define IXF3204_NE_CSSP15R_19L               0x028A
#define IXF3204_NE_CSSP15R_20L               0x028C
#define IXF3204_NE_CSSP15R_21L               0x028E
#define IXF3204_NE_CSSP15R_22L               0x0290
#define IXF3204_NE_CSSP15R_23L               0x0292
#define IXF3204_NE_CSSP15R_24L               0x0294
#define IXF3204_NE_CSSP15R_25L               0x0296
#define IXF3204_NE_CSSP15R_26L               0x0298
#define IXF3204_NE_CSSP15R_27L               0x029A
#define IXF3204_NE_CSSP15R_28L               0x029C
#define IXF3204_NE_CSSP15R_29L               0x029E
#define IXF3204_NE_CSSP15R_30L               0x02A0

#define IXF3204_NE_CSSPCURRDAYL              0x02A4
#define IXF3204_NE_CSSPPREVDAYL              0x02A8

#define IXF3204_FE_ESL15C_L                  0x02AC
#define IXF3204_FE_ESL15P_L                  0x02AE
#define IXF3204_FE_ESL15R_0L                 0x02B0
#define IXF3204_FE_ESL15R_1L                 0x02B2
#define IXF3204_FE_ESL15R_2L                 0x02B4
#define IXF3204_FE_ESL15R_3L                 0x02B6
#define IXF3204_FE_ESL15R_4L                 0x02B8
#define IXF3204_FE_ESL15R_5L                 0x02BA
#define IXF3204_FE_ESL15R_6L                 0x02BC
#define IXF3204_FE_ESL15R_7L                 0x02BE
#define IXF3204_FE_ESL15R_8L                 0x02C0
#define IXF3204_FE_ESL15R_9L                 0x02C2
#define IXF3204_FE_ESL15R_10L                0x02C4
#define IXF3204_FE_ESL15R_11L                0x02C6
#define IXF3204_FE_ESL15R_12L                0x02C8
#define IXF3204_FE_ESL15R_13L                0x02CA
#define IXF3204_FE_ESL15R_14L                0x02CC
#define IXF3204_FE_ESL15R_15L                0x02CE
#define IXF3204_FE_ESL15R_16L                0x02D0
#define IXF3204_FE_ESL15R_17L                0x02D2
#define IXF3204_FE_ESL15R_18L                0x02D4
#define IXF3204_FE_ESL15R_19L                0x02D6
#define IXF3204_FE_ESL15R_20L                0x02D8
#define IXF3204_FE_ESL15R_21L                0x02DA
#define IXF3204_FE_ESL15R_22L                0x02DC
#define IXF3204_FE_ESL15R_23L                0x02DE
#define IXF3204_FE_ESL15R_24L                0x02E0
#define IXF3204_FE_ESL15R_25L                0x02E2
#define IXF3204_FE_ESL15R_26L                0x02E4
#define IXF3204_FE_ESL15R_27L                0x02E6
#define IXF3204_FE_ESL15R_28L                0x02E8
#define IXF3204_FE_ESL15R_29L                0x02EA
#define IXF3204_FE_ESL15R_30L                0x02EC

#define IXF3204_FE_ESLCURRDAYL               0x02F0
#define IXF3204_FE_ESLPREVDAYL               0x02F4

#define IXF3204_FE_CVP15C_L                  0x02F8
#define IXF3204_FE_CVP15P_L                  0x02FA
#define IXF3204_FE_CVP15R_0L                 0x02FC
#define IXF3204_FE_CVP15R_1L                 0x02FE
#define IXF3204_FE_CVP15R_2L                 0x0300
#define IXF3204_FE_CVP15R_3L                 0x0302
#define IXF3204_FE_CVP15R_4L                 0x0304
#define IXF3204_FE_CVP15R_5L                 0x0306
#define IXF3204_FE_CVP15R_6L                 0x0308
#define IXF3204_FE_CVP15R_7L                 0x030A
#define IXF3204_FE_CVP15R_8L                 0x030C
#define IXF3204_FE_CVP15R_9L                 0x030E
#define IXF3204_FE_CVP15R_10L                0x0310
#define IXF3204_FE_CVP15R_11L                0x0312
#define IXF3204_FE_CVP15R_12L                0x0314
#define IXF3204_FE_CVP15R_13L                0x0316
#define IXF3204_FE_CVP15R_14L                0x0318
#define IXF3204_FE_CVP15R_15L                0x031A
#define IXF3204_FE_CVP15R_16L                0x031C
#define IXF3204_FE_CVP15R_17L                0x031E
#define IXF3204_FE_CVP15R_18L                0x0320
#define IXF3204_FE_CVP15R_19L                0x0322
#define IXF3204_FE_CVP15R_20L                0x0324
#define IXF3204_FE_CVP15R_21L                0x0326
#define IXF3204_FE_CVP15R_22L                0x0328
#define IXF3204_FE_CVP15R_23L                0x032A
#define IXF3204_FE_CVP15R_24L                0x032C
#define IXF3204_FE_CVP15R_25L                0x032E
#define IXF3204_FE_CVP15R_26L                0x0330
#define IXF3204_FE_CVP15R_27L                0x0332
#define IXF3204_FE_CVP15R_28L                0x0334
#define IXF3204_FE_CVP15R_29L                0x0336
#define IXF3204_FE_CVP15R_30L                0x0338

#define IXF3204_FE_CVPCURRDAYL               0x033C
#define IXF3204_FE_CVPPREVDAYL               0x0340

#define IXF3204_FE_ESP15C_L                  0x0344
#define IXF3204_FE_ESP15P_L                  0x0346
#define IXF3204_FE_ESP15R_0L                 0x0348
#define IXF3204_FE_ESP15R_1L                 0x034A
#define IXF3204_FE_ESP15R_2L                 0x034C
#define IXF3204_FE_ESP15R_3L                 0x034E
#define IXF3204_FE_ESP15R_4L                 0x0350
#define IXF3204_FE_ESP15R_5L                 0x0352
#define IXF3204_FE_ESP15R_6L                 0x0354
#define IXF3204_FE_ESP15R_7L                 0x0356
#define IXF3204_FE_ESP15R_8L                 0x0358
#define IXF3204_FE_ESP15R_9L                 0x035A
#define IXF3204_FE_ESP15R_10L                0x035C
#define IXF3204_FE_ESP15R_11L                0x035E
#define IXF3204_FE_ESP15R_12L                0x0360
#define IXF3204_FE_ESP15R_13L                0x0362
#define IXF3204_FE_ESP15R_14L                0x0364
#define IXF3204_FE_ESP15R_15L                0x0366
#define IXF3204_FE_ESP15R_16L                0x0368
#define IXF3204_FE_ESP15R_17L                0x036A
#define IXF3204_FE_ESP15R_18L                0x036C
#define IXF3204_FE_ESP15R_19L                0x036E
#define IXF3204_FE_ESP15R_20L                0x0370
#define IXF3204_FE_ESP15R_21L                0x0372
#define IXF3204_FE_ESP15R_22L                0x0374
#define IXF3204_FE_ESP15R_23L                0x0376
#define IXF3204_FE_ESP15R_24L                0x0378
#define IXF3204_FE_ESP15R_25L                0x037A
#define IXF3204_FE_ESP15R_26L                0x037C
#define IXF3204_FE_ESP15R_27L                0x037E
#define IXF3204_FE_ESP15R_28L                0x0380
#define IXF3204_FE_ESP15R_29L                0x0382
#define IXF3204_FE_ESP15R_30L                0x0384

#define IXF3204_FE_ESPCURRDAYL               0x0388
#define IXF3204_FE_ESPPREVDAYL               0x038C

#define IXF3204_FE_SESP15C_L                 0x0390
#define IXF3204_FE_SESP15P_L                 0x0392
#define IXF3204_FE_SESP15R_0L                0x0394
#define IXF3204_FE_SESP15R_1L                0x0396
#define IXF3204_FE_SESP15R_2L                0x0398
#define IXF3204_FE_SESP15R_3L                0x039A
#define IXF3204_FE_SESP15R_4L                0x039C
#define IXF3204_FE_SESP15R_5L                0x039E
#define IXF3204_FE_SESP15R_6L                0x03A0
#define IXF3204_FE_SESP15R_7L                0x03A2
#define IXF3204_FE_SESP15R_8L                0x03A4
#define IXF3204_FE_SESP15R_9L                0x03A6
#define IXF3204_FE_SESP15R_10L               0x03A8
#define IXF3204_FE_SESP15R_11L               0x03AA
#define IXF3204_FE_SESP15R_12L               0x03AC
#define IXF3204_FE_SESP15R_13L               0x03AE
#define IXF3204_FE_SESP15R_14L               0x03B0
#define IXF3204_FE_SESP15R_15L               0x03B2
#define IXF3204_FE_SESP15R_16L               0x03B4
#define IXF3204_FE_SESP15R_17L               0x03B6
#define IXF3204_FE_SESP15R_18L               0x03B8
#define IXF3204_FE_SESP15R_19L               0x03BA
#define IXF3204_FE_SESP15R_20L               0x03BC
#define IXF3204_FE_SESP15R_21L               0x03BE
#define IXF3204_FE_SESP15R_22L               0x03C0
#define IXF3204_FE_SESP15R_23L               0x03C2
#define IXF3204_FE_SESP15R_24L               0x03C4
#define IXF3204_FE_SESP15R_25L               0x03C6
#define IXF3204_FE_SESP15R_26L               0x03C8
#define IXF3204_FE_SESP15R_27L               0x03CA
#define IXF3204_FE_SESP15R_28L               0x03CC
#define IXF3204_FE_SESP15R_29L               0x03CE
#define IXF3204_FE_SESP15R_30L               0x03D0

#define IXF3204_FE_SESPCURRDAYL              0x03D4
#define IXF3204_FE_SESPPREVDAYL              0x03D8

#define IXF3204_FE_UASP15C_L                 0x03DC
#define IXF3204_FE_UASP15P_L                 0x03DE
#define IXF3204_FE_UASP15R_0L                0x03E0
#define IXF3204_FE_UASP15R_1L                0x03E2
#define IXF3204_FE_UASP15R_2L                0x03E4
#define IXF3204_FE_UASP15R_3L                0x03E6
#define IXF3204_FE_UASP15R_4L                0x03E8
#define IXF3204_FE_UASP15R_5L                0x03EA
#define IXF3204_FE_UASP15R_6L                0x03EC
#define IXF3204_FE_UASP15R_7L                0x03EE
#define IXF3204_FE_UASP15R_8L                0x03F0
#define IXF3204_FE_UASP15R_9L                0x03F2
#define IXF3204_FE_UASP15R_10L               0x03F4
#define IXF3204_FE_UASP15R_11L               0x03F6
#define IXF3204_FE_UASP15R_12L               0x03F8
#define IXF3204_FE_UASP15R_13L               0x03FA
#define IXF3204_FE_UASP15R_14L               0x03FC
#define IXF3204_FE_UASP15R_15L               0x03FE
#define IXF3204_FE_UASP15R_16L               0x0400
#define IXF3204_FE_UASP15R_17L               0x0402
#define IXF3204_FE_UASP15R_18L               0x0404
#define IXF3204_FE_UASP15R_19L               0x0406
#define IXF3204_FE_UASP15R_20L               0x0408
#define IXF3204_FE_UASP15R_21L               0x040A
#define IXF3204_FE_UASP15R_22L               0x040C
#define IXF3204_FE_UASP15R_23L               0x040E
#define IXF3204_FE_UASP15R_24L               0x0410
#define IXF3204_FE_UASP15R_25L               0x0412
#define IXF3204_FE_UASP15R_26L               0x0414
#define IXF3204_FE_UASP15R_27L               0x0416
#define IXF3204_FE_UASP15R_28L               0x0418
#define IXF3204_FE_UASP15R_29L               0x041A
#define IXF3204_FE_UASP15R_30L               0x041C

#define IXF3204_FE_UASPCURRDAYL              0x0420
#define IXF3204_FE_UASPPREVDAYL              0x0424

#define IXF3204_FE_CSSP15C_L                 0x0428
#define IXF3204_FE_CSSP15P_L                 0x042A
#define IXF3204_FE_CSSP15R_0L                0x042C
#define IXF3204_FE_CSSP15R_1L                0x042E
#define IXF3204_FE_CSSP15R_2L                0x0430
#define IXF3204_FE_CSSP15R_3L                0x0432
#define IXF3204_FE_CSSP15R_4L                0x0434
#define IXF3204_FE_CSSP15R_5L                0x0436
#define IXF3204_FE_CSSP15R_6L                0x0438
#define IXF3204_FE_CSSP15R_7L                0x043A
#define IXF3204_FE_CSSP15R_8L                0x043C
#define IXF3204_FE_CSSP15R_9L                0x043E
#define IXF3204_FE_CSSP15R_10L               0x0440
#define IXF3204_FE_CSSP15R_11L               0x0442
#define IXF3204_FE_CSSP15R_12L               0x0444
#define IXF3204_FE_CSSP15R_13L               0x0446
#define IXF3204_FE_CSSP15R_14L               0x0448
#define IXF3204_FE_CSSP15R_15L               0x044A
#define IXF3204_FE_CSSP15R_16L               0x044C
#define IXF3204_FE_CSSP15R_17L               0x044E
#define IXF3204_FE_CSSP15R_18L               0x0450
#define IXF3204_FE_CSSP15R_19L               0x0452
#define IXF3204_FE_CSSP15R_20L               0x0454
#define IXF3204_FE_CSSP15R_21L               0x0456
#define IXF3204_FE_CSSP15R_22L               0x0458
#define IXF3204_FE_CSSP15R_23L               0x045A
#define IXF3204_FE_CSSP15R_24L               0x045C
#define IXF3204_FE_CSSP15R_25L               0x045E
#define IXF3204_FE_CSSP15R_26L               0x0460
#define IXF3204_FE_CSSP15R_27L               0x0462
#define IXF3204_FE_CSSP15R_28L               0x0464
#define IXF3204_FE_CSSP15R_29L               0x0466
#define IXF3204_FE_CSSP15R_30L               0x0468

#define IXF3204_FE_CSSPCURRDAYL              0x046C
#define IXF3204_FE_CSSPPREVDAYL              0x0470

#define IXF3204_FE_ESAP15C_L                 0x0474
#define IXF3204_FE_ESAP15P_L                 0x0476
#define IXF3204_FE_ESAP15R_0L                0x0478
#define IXF3204_FE_ESAP15R_1L                0x047A
#define IXF3204_FE_ESAP15R_2L                0x047C
#define IXF3204_FE_ESAP15R_3L                0x047E
#define IXF3204_FE_ESAP15R_4L                0x0480
#define IXF3204_FE_ESAP15R_5L                0x0482
#define IXF3204_FE_ESAP15R_6L                0x0484
#define IXF3204_FE_ESAP15R_7L                0x0486
#define IXF3204_FE_ESAP15R_8L                0x0488
#define IXF3204_FE_ESAP15R_9L                0x048A
#define IXF3204_FE_ESAP15R_10L               0x048C
#define IXF3204_FE_ESAP15R_11L               0x048E
#define IXF3204_FE_ESAP15R_12L               0x0490
#define IXF3204_FE_ESAP15R_13L               0x0492
#define IXF3204_FE_ESAP15R_14L               0x0494
#define IXF3204_FE_ESAP15R_15L               0x0496
#define IXF3204_FE_ESAP15R_16L               0x0498
#define IXF3204_FE_ESAP15R_17L               0x049A
#define IXF3204_FE_ESAP15R_18L               0x049C
#define IXF3204_FE_ESAP15R_19L               0x049E
#define IXF3204_FE_ESAP15R_20L               0x04A0
#define IXF3204_FE_ESAP15R_21L               0x04A2
#define IXF3204_FE_ESAP15R_22L               0x04A4
#define IXF3204_FE_ESAP15R_23L               0x04A6
#define IXF3204_FE_ESAP15R_24L               0x04A8
#define IXF3204_FE_ESAP15R_25L               0x04AA
#define IXF3204_FE_ESAP15R_26L               0x04AC
#define IXF3204_FE_ESAP15R_27L               0x04AE
#define IXF3204_FE_ESAP15R_28L               0x04B0
#define IXF3204_FE_ESAP15R_29L               0x04B2
#define IXF3204_FE_ESAP15R_30L               0x04B4

#define IXF3204_FE_ESAPCURRDAYL              0x04B8
#define IXF3204_FE_ESAPPREVDAYL              0x04BC

#define IXF3204_FE_ESBP15C_L                 0x04C0
#define IXF3204_FE_ESBP15P_L                 0x04C2
#define IXF3204_FE_ESBP15R_0L                0x04C4
#define IXF3204_FE_ESBP15R_1L                0x04C6
#define IXF3204_FE_ESBP15R_2L                0x04C8
#define IXF3204_FE_ESBP15R_3L                0x04CA
#define IXF3204_FE_ESBP15R_4L                0x04CC
#define IXF3204_FE_ESBP15R_5L                0x04CE
#define IXF3204_FE_ESBP15R_6L                0x04D0
#define IXF3204_FE_ESBP15R_7L                0x04D2
#define IXF3204_FE_ESBP15R_8L                0x04D4
#define IXF3204_FE_ESBP15R_9L                0x04D6
#define IXF3204_FE_ESBP15R_10L               0x04D8
#define IXF3204_FE_ESBP15R_11L               0x04DA
#define IXF3204_FE_ESBP15R_12L               0x04DC
#define IXF3204_FE_ESBP15R_13L               0x04DE
#define IXF3204_FE_ESBP15R_14L               0x04E0
#define IXF3204_FE_ESBP15R_15L               0x04E2
#define IXF3204_FE_ESBP15R_16L               0x04E4
#define IXF3204_FE_ESBP15R_17L               0x04E6
#define IXF3204_FE_ESBP15R_18L               0x04E8
#define IXF3204_FE_ESBP15R_19L               0x04EA
#define IXF3204_FE_ESBP15R_20L               0x04EC
#define IXF3204_FE_ESBP15R_21L               0x04EE
#define IXF3204_FE_ESBP15R_22L               0x04F0
#define IXF3204_FE_ESBP15R_23L               0x04F2
#define IXF3204_FE_ESBP15R_24L               0x04F4
#define IXF3204_FE_ESBP15R_25L               0x04F6
#define IXF3204_FE_ESBP15R_26L               0x04F8
#define IXF3204_FE_ESBP15R_27L               0x04FA
#define IXF3204_FE_ESBP15R_28L               0x04FC
#define IXF3204_FE_ESBP15R_29L               0x04FE
#define IXF3204_FE_ESBP15R_30L               0x0500

#define IXF3204_FE_ESBPCURRDAYL              0x0504
#define IXF3204_FE_ESBPPREVDAYL              0x0508

#define IXF3204_FE_SEFSP15C_L                0x050C
#define IXF3204_FE_SEFSP15P_L                0x050E
#define IXF3204_FE_SEFSP15R_0L               0x0510
#define IXF3204_FE_SEFSP15R_1L               0x0512
#define IXF3204_FE_SEFSP15R_2L               0x0514
#define IXF3204_FE_SEFSP15R_3L               0x0516
#define IXF3204_FE_SEFSP15R_4L               0x0518
#define IXF3204_FE_SEFSP15R_5L               0x051A
#define IXF3204_FE_SEFSP15R_6L               0x051C
#define IXF3204_FE_SEFSP15R_7L               0x051E
#define IXF3204_FE_SEFSP15R_8L               0x0520
#define IXF3204_FE_SEFSP15R_9L               0x0522
#define IXF3204_FE_SEFSP15R_10L              0x0524
#define IXF3204_FE_SEFSP15R_11L              0x0526
#define IXF3204_FE_SEFSP15R_12L              0x0528
#define IXF3204_FE_SEFSP15R_13L              0x052A
#define IXF3204_FE_SEFSP15R_14L              0x052C
#define IXF3204_FE_SEFSP15R_15L              0x052E
#define IXF3204_FE_SEFSP15R_16L              0x0530
#define IXF3204_FE_SEFSP15R_17L              0x0532
#define IXF3204_FE_SEFSP15R_18L              0x0534
#define IXF3204_FE_SEFSP15R_19L              0x0536
#define IXF3204_FE_SEFSP15R_20L              0x0538
#define IXF3204_FE_SEFSP15R_21L              0x053A
#define IXF3204_FE_SEFSP15R_22L              0x053C
#define IXF3204_FE_SEFSP15R_23L              0x053E
#define IXF3204_FE_SEFSP15R_24L              0x0540
#define IXF3204_FE_SEFSP15R_25L              0x0542
#define IXF3204_FE_SEFSP15R_26L              0x0544
#define IXF3204_FE_SEFSP15R_27L              0x0546
#define IXF3204_FE_SEFSP15R_28L              0x0548
#define IXF3204_FE_SEFSP15R_29L              0x054A
#define IXF3204_FE_SEFSP15R_30L              0x054C

#define IXF3204_FE_SEFSPCURRDAYL             0x0550
#define IXF3204_FE_SEFSPPREVDAYL             0x0554

/* Generic Counters */
#define IXF3204_CRCL                         0x0558
#define IXF3204_CRCH                         0x0559
#define IXF3204_FEL                          0x055A
#define IXF3204_FEH                          0x055B
#define IXF3204_LCVL                         0x055C
#define IXF3204_LCVH                         0x055D
#define IXF3204_OOFL                         0x055E
#define IXF3204_OOFH                         0x055F
#define IXF3204_CSRL                         0x0560
#define IXF3204_CSRH                         0x0561
#define IXF3204_CSLL                         0x0562
#define IXF3204_CSLH                         0x0563
#define IXF3204_COFAL                        0x0564
#define IXF3204_COFAH                        0x0565


#endif

