/*
 * Copyright c Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

/*  *********************************************************************** 
 *  File name:    osal.h                                                  
 *  Description:  This is the Operating System Abstraction Layer header
 *                file.  It's purpose is to provide OS services to the 
 *                API.
 *
 *                Users should modify this file to support their 
 *                specific OS.  Look for the TO DO comments for guidance.
 *  *********************************************************************** */
#ifndef __OSAL_H__
#define __OSAL_H__


/* TO DO:   Enter the size of an integer, specific to your environment.
 *          Default is 32-bit.
 */
#define INT_SIZE  32

/* Interface with the microprocessor MSB/LSB */
/* TO DO:	Change POSITIVE_BIT_ORDER if LSB is in leftmost position.
 *
 */
#define POSITIVE_BIT_ORDER      1

/* TO DO:   Enter your linkage specification here if required.  Linkage
 *          specification can refer to language type, for example "C".
 */
#define LINKAGE_SPECIFICATION 

/* Memory Allocation/Deallocation routine macros */

/* TO DO:   Change memory allocation functions here if required
 */
#define TE_OS_ALLOC_MEM( size )             malloc(size)
#define TE_OS_DEALLOC_MEM( pbuffer )        free( (void *)pbuffer )


#endif /* __OSAL_H__ */

