/*
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

/******************************************************************************
 * File Name:   osio3204.c
 * Description: This file contains the necessary instructions to read 
 *              and write a byte across whatever interface the end user 
 *              requires.  End user will have to insert applicable 
 *              instructions here. 
 *
 ******************************************************************************/

#include "ixf3204.h"

/*******************************************************************************
 * Function Name: IXF3204OSWriteByte
 * Returns: TEstatus
 * Description: This is the function that writes data in a manner 
 *              specific to the Operating System being used.  The 
 *              user needs to write code in this function that will
 *              allow other IXF3204 functions to write data, using 
 *              the specified Operating System.  Look for the
 *              *** TO DO *** comments for futrher instructions.
 ******************************************************************************/
TEstatus IXF3204OSWriteByte(void * handle, TEword Address, TEbyte Value)
{
    /* Variable declaration */
    IXF3204struct *pIXF3204handle = (IXF3204struct *)handle;
    TEword deviceAddress;
    TEword addressToWriteTo;

    CHK_NULL( pIXF3204handle );

    /* The physical address of the device must be retrieved from the handle */
    deviceAddress = pIXF3204handle->base_address;

    /* The address to Write to is the deviceAddress + Register */
    addressToWriteTo = (TEword)(deviceAddress + Address);

    /*
     * TO DO:   Finish this function with code required to write Value 
     *          to the addressToWriteTo.  This method is dependent on
     *          Application and Operating System.
     */

    return TE_STATUS_SUCCESS;
}

/*******************************************************************************
 * Function Name: IXF3204OSReadByte
 * Returns: TEstatus
 * Description: This is the function that reads data in a manner
 *              specific to the Operating System being used.  The
 *              user needs to write code in this function that will
 *              allow other IXF3204 functions to read data, using
 *              the specified Operating System.  Look for the
 *              *** TO DO *** comments for futrher instructions.
 ******************************************************************************/
TEstatus IXF3204OSReadByte(void * handle, TEword Address, TEbyte *rValue)
{
    /* Variable declaration */
    IXF3204struct *pIXF3204handle = (IXF3204struct *)handle;
    TEword deviceAddress;
    TEword addressToReadFrom;

    CHK_NULL( pIXF3204handle );

    /* The physical address of the device must be retrieved from the handle */
    deviceAddress = pIXF3204handle->base_address;

    /* The address to Read from is the deviceAddress + Register */
    addressToReadFrom = (TEword)(deviceAddress + Address);

    /*
     * TO DO:   Finish this function with code required to read rValue 
     *          from the addressToReadFrom.  This method is dependent on
     *          Application and Operating System.
     */

    return TE_STATUS_SUCCESS;
}


