/* 
 * Copyright  Intel Corporation (2002).
 *
 * INTEL MAKES NO WARRANTY OF ANY KIND REGARDING THE CODE.  THIS CODE
 * IS LICENSED ON AN "AS IS" BASIS AND INTEL WILL NOT PROVIDE ANY
 * SUPPORT, ASSISTANCE, INSTALLATION, TRAINING OR OTHER SERVICES.
 * INTEL DOES NOT PROVIDE ANY UPDATES, ENHANCEMENTS OR EXTENSIONS.
 * INTEL SPECIFICALLY DISCLAIMS ANY WARRANTY OF MERCHANTABILITY,
 * NONINFRINGEMENT, FITNESS FOR ANY PARTICULAR PURPOSE, OR ANY OTHER
 * WARRANTY.  Further, Intel disclaims all liability of any kind,
 * including but not limited to liability for infringement of any
 * proprietary rights, relating to the use of the code, even if Intel
 * is notified of the possibility of such liability.  Except as expressly
 * stated in an Intel license agreement provided with this code and
 * agreed upon with Intel, no license, express or implied, by estoppel
 * or otherwise, to any intellectual property rights is granted herein.
 *
 */

/*  ***********************************************************************
 *	File name:      tecomm.h
 *	Description:    This is the common header file for all device APIs.
 *                      It contains all common parameter values, error codes,
 *                      and data type definitions
 *  *********************************************************************** */

#ifndef __TECOMM_H__
#define __TECOMM_H__

/* ************************************************************************ */
/* Data Type Definitions                                                    */
/* ************************************************************************ */
typedef unsigned char       TEbyte;         /* 8-bit  */
typedef signed char         TEsbyte;        /* 8-bit  */
typedef unsigned short      TEword;         /* 16-bit */
typedef signed short        TEsword;        /* 16-bit */
#if (INT_SIZE == 16)
typedef unsigned long int   TEdword;        /* 32-bit */
#else
typedef unsigned int        TEdword;        /* 32-bit */
#endif
#if (INT_SIZE == 16)
typedef signed long int     TEsdword;       /* 32-bit */
#else
typedef signed int          TEsdword;       /* 32-bit */
#endif
typedef TEbyte              TEstatus;       /* 8-bit  */
typedef TEword              TEaddress;      /* 16-bit address */
typedef TEdword             TElongAddress;  /* 32-bit address */

typedef struct TEbindstruct{
    volatile TEword base_address;           /* For 16-bit addresses */
    volatile TEdword long_base_address;     /* For 32-bit addresses */
    void *client_handle;
} TEbindstruct;

/* ************************************************************************ */
/* Definition for all return codes used by the API                          */
/* ************************************************************************ */
#define TE_STATUS_SUCCESS                          0
#define TE_STATUS_ERROR_UNKNOWN_CHAR               1
#define TE_STATUS_ERROR_LOAD_VERIFY                2
#define TE_STATUS_CALL_DEFERRED                    3
#define TE_STATUS_NO_DEFERRED                      4
#define TE_STATUS_BAD_PARAMS                       5
#define TE_STATUS_MEM_ALLOC_FAILURE		   6
#define TE_STATUS_BADWRITE                         7
#define TE_STATUS_BADREAD                          8
#define TE_STATUS_BUSY                             9
#define TE_STATUS_BAD_CONFIG                       10

/* ************************************************************************ */
/* Common API parameter definitions                                         */
/* ************************************************************************ */
/* Port definitions */
#define TE_ALL      0
#define TE_PORT0    1
#define TE_PORT1    2
#define TE_PORT2    3
#define TE_PORT3    4
#define TE_PORT4    5
#define TE_PORT5    6
#define TE_PORT6    7
#define TE_PORT7    8
#define TE_PORT8    9
#define TE_PORT9    10
#define TE_PORT10   11
#define TE_PORT11   12
#define TE_PORT12   13
#define TE_PORT13   14
#define TE_PORT14   15
#define TE_PORT15   16
#define TE_PORT16   17
#define TE_PORT17   18
#define TE_PORT18   19
#define TE_PORT19   20
#define TE_PORT20   21
#define TE_PORT21   22
#define TE_PORT22   23
#define TE_PORT23   24
#define TE_PORT24   25
#define TE_PORT25   26
#define TE_PORT26   27
#define TE_PORT27   28
#define TE_PORT28   29
#define TE_PORT29   30
#define TE_PORT30   31
#define TE_PORT31   32
#define TE_PORT32   33
#define TE_PORT33   34
#define TE_PORT34   35
#define TE_PORT35   36
#define TE_PORT36   37
#define TE_PORT37   38
#define TE_PORT38   39
#define TE_PORT39   40
#define TE_PORT40   41
#define TE_PORT41   42
#define TE_PORT42   43
#define TE_PORT43   44
#define TE_PORT44   45
#define TE_PORT45   46
#define TE_PORT46   47
#define TE_PORT47   48
#define TE_PORT48   49
#define TE_PORT49   50
#define TE_PORT50   51
#define TE_PORT51   52
#define TE_PORT52   53
#define TE_PORT53   54
#define TE_PORT54   55
#define TE_PORT55   56
#define TE_PORT56   57
#define TE_PORT57   58
#define TE_PORT58   59
#define TE_PORT59   60
#define TE_PORT60   61
#define TE_PORT61   62
#define TE_PORT62   63
#define TE_PORT63   64

/* Channel definitions */
#define TE_CHAN0        0     
#define TE_CHAN1        1    
#define TE_CHAN2        2    
#define TE_CHAN3        3    
#define TE_CHAN4        4    
#define TE_CHAN5        5    
#define TE_CHAN6        6    
#define TE_CHAN7        7    
#define TE_CHAN8        8    
#define TE_CHAN9        9      
#define TE_CHAN10      10      
#define TE_CHAN11      11      
#define TE_CHAN12      12      
#define TE_CHAN13      13      
#define TE_CHAN14      14      
#define TE_CHAN15      15      
#define TE_CHAN16      16      
#define TE_CHAN17      17      
#define TE_CHAN18      18      
#define TE_CHAN19      19      
#define TE_CHAN20      20      
#define TE_CHAN21      21      
#define TE_CHAN22      22      
#define TE_CHAN23      23      
#define TE_CHAN24      24      
#define TE_CHAN25      25      
#define TE_CHAN26      26      
#define TE_CHAN27      27      
#define TE_CHAN28      28      
#define TE_CHAN29      29      
#define TE_CHAN30      30      
#define TE_CHAN31      31      
#define TE_CHAN32      32      
#define TE_CHAN33      33      
#define TE_CHAN34      34      
#define TE_CHAN35      35      
#define TE_CHAN36      36      
#define TE_CHAN37      37      
#define TE_CHAN38      38      
#define TE_CHAN39      39      
#define TE_CHAN40      40      
#define TE_CHAN41      41      
#define TE_CHAN42      42      
#define TE_CHAN43      43      
#define TE_CHAN44      44      
#define TE_CHAN45      45      
#define TE_CHAN46      46      
#define TE_CHAN47      47      
#define TE_CHAN48      48      
#define TE_CHAN49      49      
#define TE_CHAN50      50      
#define TE_CHAN51      51      
#define TE_CHAN52      52      
#define TE_CHAN53      53      
#define TE_CHAN54      54      
#define TE_CHAN55      55      
#define TE_CHAN56      56      
#define TE_CHAN57      57      
#define TE_CHAN58      58      
#define TE_CHAN59      59      
#define TE_CHAN60      60      
#define TE_CHAN61      61      
#define TE_CHAN62      62      
#define TE_CHAN63      63      
#define TE_CHAN64      64      
#define TE_CHAN65      65      
#define TE_CHAN66      66      
#define TE_CHAN67      67      
#define TE_CHAN68      68      
#define TE_CHAN69      69      
#define TE_CHAN70      70      
#define TE_CHAN71      71      
#define TE_CHAN72      72      
#define TE_CHAN73      73      
#define TE_CHAN74      74      
#define TE_CHAN75      75      
#define TE_CHAN76      76      
#define TE_CHAN77      77      
#define TE_CHAN78      78      
#define TE_CHAN79      79      
#define TE_CHAN80      80      
#define TE_CHAN81      81      
#define TE_CHAN82      82      
#define TE_CHAN83      83      
#define TE_CHAN84      84      
#define TE_CHAN85      85      
#define TE_CHAN86      86      
#define TE_CHAN87      87      
#define TE_CHAN88      88      
#define TE_CHAN89      89      
#define TE_CHAN90      90      
#define TE_CHAN91      91      
#define TE_CHAN92      92      
#define TE_CHAN93      93      
#define TE_CHAN94      94      
#define TE_CHAN95      95      
#define TE_CHAN96      96         
#define TE_CHAN97      97      
#define TE_CHAN98      98      
#define TE_CHAN99      99      
#define TE_CHAN100    100       
#define TE_CHAN101    101       
#define TE_CHAN102    102       
#define TE_CHAN103    103       
#define TE_CHAN104    104       
#define TE_CHAN105    105       
#define TE_CHAN106    106       
#define TE_CHAN107    107       
#define TE_CHAN108    108       
#define TE_CHAN109    109       
#define TE_CHAN110    110       
#define TE_CHAN111    111       
#define TE_CHAN112    112       
#define TE_CHAN113    113       
#define TE_CHAN114    114       
#define TE_CHAN115    115       
#define TE_CHAN116    116       
#define TE_CHAN117    117       
#define TE_CHAN118    118       
#define TE_CHAN119    119       
#define TE_CHAN120    120       
#define TE_CHAN121    121       
#define TE_CHAN122    122       
#define TE_CHAN123    123       
#define TE_CHAN124    124       
#define TE_CHAN125    125       
#define TE_CHAN126    126       
#define TE_CHAN127    127       
#define TE_CHAN128    128       
#define TE_CHAN129    129       
#define TE_CHAN130    130       
#define TE_CHAN131    131       
#define TE_CHAN132    132       
#define TE_CHAN133    133       
#define TE_CHAN134    134       
#define TE_CHAN135    135       
#define TE_CHAN136    136       
#define TE_CHAN137    137       
#define TE_CHAN138    138       
#define TE_CHAN139    139       
#define TE_CHAN140    140       
#define TE_CHAN141    141       
#define TE_CHAN142    142       
#define TE_CHAN143    143       
#define TE_CHAN144    144       
#define TE_CHAN145    145       
#define TE_CHAN146    146       
#define TE_CHAN147    147       
#define TE_CHAN148    148       
#define TE_CHAN149    149       
#define TE_CHAN150    150       
#define TE_CHAN151    151       
#define TE_CHAN152    152       
#define TE_CHAN153    153       
#define TE_CHAN154    154       
#define TE_CHAN155    155       
#define TE_CHAN156    156       
#define TE_CHAN157    157       
#define TE_CHAN158    158       
#define TE_CHAN159    159       
#define TE_CHAN160    160       
#define TE_CHAN161    161       
#define TE_CHAN162    162       
#define TE_CHAN163    163       
#define TE_CHAN164    164       
#define TE_CHAN165    165       
#define TE_CHAN166    166       
#define TE_CHAN167    167       
#define TE_CHAN168    168       
#define TE_CHAN169    169       
#define TE_CHAN170    170       
#define TE_CHAN171    171       
#define TE_CHAN172    172       
#define TE_CHAN173    173       
#define TE_CHAN174    174       
#define TE_CHAN175    175       
#define TE_CHAN176    176       
#define TE_CHAN177    177       
#define TE_CHAN178    178       
#define TE_CHAN179    179       
#define TE_CHAN180    180       
#define TE_CHAN181    181       
#define TE_CHAN182    182       
#define TE_CHAN183    183       
#define TE_CHAN184    184       
#define TE_CHAN185    185       
#define TE_CHAN186    186       
#define TE_CHAN187    187       
#define TE_CHAN188    188       
#define TE_CHAN189    189       
#define TE_CHAN190    190       
#define TE_CHAN191    191       
#define TE_CHAN192    192       
#define TE_CHAN193    193       
#define TE_CHAN194    194       
#define TE_CHAN195    195       
#define TE_CHAN196    196       
#define TE_CHAN197    197       
#define TE_CHAN198    198       
#define TE_CHAN199    199       
#define TE_CHAN200    200       
#define TE_CHAN201    201       
#define TE_CHAN202    202       
#define TE_CHAN203    203       
#define TE_CHAN204    204       
#define TE_CHAN205    205       
#define TE_CHAN206    206       
#define TE_CHAN207    207       
#define TE_CHAN208    208       
#define TE_CHAN209    209       
#define TE_CHAN210    210       
#define TE_CHAN211    211       
#define TE_CHAN212    212       
#define TE_CHAN213    213       
#define TE_CHAN214    214       
#define TE_CHAN215    215       
#define TE_CHAN216    216       
#define TE_CHAN217    217       
#define TE_CHAN218    218       
#define TE_CHAN219    219       
#define TE_CHAN220    220       
#define TE_CHAN221    221       
#define TE_CHAN222    222       
#define TE_CHAN223    223       
#define TE_CHAN224    224       
#define TE_CHAN225    225       
#define TE_CHAN226    226       
#define TE_CHAN227    227       
#define TE_CHAN228    228       
#define TE_CHAN229    229       
#define TE_CHAN230    230       
#define TE_CHAN231    231       
#define TE_CHAN232    232       
#define TE_CHAN233    233       
#define TE_CHAN234    234       
#define TE_CHAN235    235       
#define TE_CHAN236    236       
#define TE_CHAN237    237       
#define TE_CHAN238    238       
#define TE_CHAN239    239       
#define TE_CHAN240    240       
#define TE_CHAN241    241       
#define TE_CHAN242    242       
#define TE_CHAN243    243       
#define TE_CHAN244    244       
#define TE_CHAN245    245       
#define TE_CHAN246    246       
#define TE_CHAN247    247       
#define TE_CHAN248    248       
#define TE_CHAN249    249       
#define TE_CHAN250    250       
#define TE_CHAN251    251       
#define TE_CHAN252    252       
#define TE_CHAN253    253       
#define TE_CHAN254    254       
#define TE_CHAN255    255       

/* Enable/Disable */
#define TE_DISABLE  0
#define TE_ENABLE   1

/* Bit Definitions */

#if POSITIVE_BIT_ORDER

#define TE_BIT0         0x00000001
#define TE_BIT1         0x00000002
#define TE_BIT2         0x00000004
#define TE_BIT3         0x00000008
#define TE_BIT4         0x00000010
#define TE_BIT5         0x00000020
#define TE_BIT6         0x00000040
#define TE_BIT7         0x00000080
#define TE_BIT8         0x00000100
#define TE_BIT9         0x00000200
#define TE_BIT10        0x00000400
#define TE_BIT11        0x00000800
#define TE_BIT12        0x00001000
#define TE_BIT13        0x00002000
#define TE_BIT14        0x00004000
#define TE_BIT15        0x00008000
#define TE_BIT16        0x00010000
#define TE_BIT17        0x00020000
#define TE_BIT18        0x00040000
#define TE_BIT19        0x00080000
#define TE_BIT20        0x00100000
#define TE_BIT21        0x00200000
#define TE_BIT22        0x00400000
#define TE_BIT23        0x00800000
#define TE_BIT24        0x01000000
#define TE_BIT25        0x02000000
#define TE_BIT26        0x04000000
#define TE_BIT27        0x08000000
#define TE_BIT28        0x10000000
#define TE_BIT29        0x20000000
#define TE_BIT30        0x40000000
#define TE_BIT31        0x80000000

#else

#define TE_BIT0         0x10000000
#define TE_BIT1         0x20000000
#define TE_BIT2         0x40000000
#define TE_BIT3         0x80000000
#define TE_BIT4         0x01000000
#define TE_BIT5         0x02000000
#define TE_BIT6         0x04000000
#define TE_BIT7         0x08000000
#define TE_BIT8         0x00100000
#define TE_BIT9         0x00200000
#define TE_BIT10        0x00400000
#define TE_BIT11        0x00800000
#define TE_BIT12        0x00010000
#define TE_BIT13        0x00020000
#define TE_BIT14        0x00040000
#define TE_BIT15        0x00080000
#define TE_BIT16        0x00001000
#define TE_BIT17        0x00002000
#define TE_BIT18        0x00004000
#define TE_BIT19        0x00008000
#define TE_BIT20        0x00000100
#define TE_BIT21        0x00000200
#define TE_BIT22        0x00000400
#define TE_BIT23        0x00000800
#define TE_BIT24        0x00000010
#define TE_BIT25        0x00000020
#define TE_BIT26        0x00000040
#define TE_BIT27        0x00000080
#define TE_BIT28        0x00000001
#define TE_BIT29        0x00000002
#define TE_BIT30        0x00000004
#define TE_BIT31        0x00000008

#endif /* POSITIVE_BIT_ORDER */

#define TE_CLEAR_BITS   0x00000000
#define TE_ALL_BITS     0xFFFFFFFF

/* Bit Masks */
#define TE_BIT0_3     /* bits 0-3 */     (TE_BIT0+TE_BIT1+TE_BIT2+TE_BIT3)
#define TE_BIT4_7     /* bits 4-7 */     (TE_BIT4+TE_BIT5+TE_BIT6+TE_BIT7)
#define TE_BIT8_11    /* bits 8-11 */    (TE_BIT8+TE_BIT9+TE_BIT10+TE_BIT11)
#define TE_BIT12_15   /* bits 12-15 */   (TE_BIT12+TE_BIT13+TE_BIT14+TE_BIT15)
#define TE_BIT16_19   /* bits 16-19 */   (TE_BIT16+TE_BIT17+TE_BIT18+TE_BIT19)
#define TE_BIT20_23   /* bits 20-23 */   (TE_BIT20+TE_BIT21+TE_BIT22+TE_BIT23)
#define TE_BIT24_27   /* bits 24-27 */   (TE_BIT24+TE_BIT25+TE_BIT26+TE_BIT27)
#define TE_BIT28_31   /* bits 28-31 */   (TE_BIT28+TE_BIT29+TE_BIT30+TE_BIT31)
#define TE_BIT0_7     /* Byte 0 */       (TE_BIT0_3+TE_BIT4_7)
#define TE_BIT8_15       /* Byte 1 */    (TE_BIT8_11+TE_BIT12_15)
#define TE_BIT16_23      /* Byte 2 */    (TE_BIT16_19+TE_BIT20_23)
#define TE_BIT24_31      /* Byte 3 */    (TE_BIT24_27+TE_BIT28_31)
#define TE_BIT0_15       /* Word 1 */    (TE_BIT0_7+TE_BIT8_15)
#define TE_BIT16_31      /* Word 2 */    (TE_BIT16_23+TE_BIT24_31)
#define TE_BIT0_31    /* All 32 bits */  (TE_BIT0_15+TE_BIT16_31)

/* Defines for the 32 bit registers */
#define TE_BYTE0               (TEdword) (TE_BIT0+TE_BIT1+TE_BIT2+TE_BIT3+ \
                                         TE_BIT4+TE_BIT5+TE_BIT6+TE_BIT7)
#define TE_BYTE1               (TEdword) (TE_BIT8+TE_BIT9+TE_BIT10+TE_BIT11+ \
                                         TE_BIT12+TE_BIT13+TE_BIT14+TE_BIT15)
#define TE_BYTE2               (TEdword) (TE_BIT16+TE_BIT17+TE_BIT18+TE_BIT19+ \
                                         TE_BIT20+TE_BIT21+TE_BIT22+TE_BIT23)
#define TE_BYTE3               (TEdword) (TE_BIT24+TE_BIT25+TE_BIT26+TE_BIT27+ \
                                         TE_BIT28+TE_BIT29+TE_BIT30+TE_BIT31)
#define TE_WORD0               (TEdword) (TE_BYTE0+TE_BYTE1)
#define TE_WORD1               (TEdword) (TE_BYTE2+TE_BYTE3)
#define TE_32BITS              (TEdword) (TE_WORD0+TE_WORD1)


/* Device Module Definitions */
#define TE_SIGNALING      1
#define TE_HDLC           2
#define TE_ALARMS         3
#define TE_RCLK	          4
#define TE_FIFO           5
/*                        6 - 30 reserved for future modules */

/* Protocol Definitions */
#define TE_LAPB           31
#define TE_LAPD           32
#define TE_LAPV5          33
#define TE_OSIF           34
#define TE_HMVIP          35
#define TE_DLDC           36
#define TE_B8ZS           37     /* Bipolar Eight Zero Substitution */
#define TE_HDB3           38     /* High Density Bipolar Three */
/*                        39 - 50 reserved for future protocols */

/* Alarm Definitions */
#define TE_LOS            51     /* Loss Of Signal */
#define TE_AIS            52     /* Alarm Indication Signal */
#define TE_BPV            53     /* Bipolar Violations */
#define TE_EXZ            54     /* Excess Zeroes */
#define TE_AMI            55     /* Alternate Mark Inversion */
#define TE_BLUE           56
#define TE_AI             57
/*                        58 - 70 reserved for future alarms */

/* Multiplier Definitions */
#define TE_1X             71   
#define TE_2X             72
#define TE_4X             73
#define TE_8X             74
#define TE_16X            75
#define TE_24X            76
/*                        77 - 80 reserved for future rates */

/* Ratio Definitions */
#define TE_2OF4           81  
#define TE_2OF5           82
#define TE_2OF6           83
#define TE_4OF5           84
#define TE_3OF5           85
#define TE_8OF10          86
/*                        87 - 90 reserved for future ratios */

/* Frequency Definitions */
#define TE_R1536          91
#define TE_R1544          92
#define TE_R2048          93
#define TE_R8KHZ          94
/*                        95 - 99 reserved for future frequencies */

/* Data Stream (Line Rate) Definitions */
#define TE_T1       100
#define TE_DS1      TE_T1
#define TE_E1       101
#define TE_J1       102
#define TE_DS3      103
#define TE_E3       104
#define TE_STS3     105
#define TE_STM1_AU3 106
#define TE_STM1_AU4 107
#define TE_VT15     108
#define TE_TU11     109
#define TE_TU12     110
#define TE_STS1     111
#define TE_TUG3     112
#define TE_DS2      113
#define TE_DS0      114
#define TE_E0       115
#define TE_VC4      116
/*                  117 - 130 reserved for future stream speeds */

/* Standards Definitions */
#define TE_G775         131  /* G.775 compliance */
#define TE_I431         132  /* I.431 compliance */
#define TE_ETSI300233   133  /* ETSI 300233 compliance */
#define TE_T1_231       134  /* T1.231 compliance */
#define TE_T1_403       135  /* T1.403 compliance */
#define TE_ANSI         136
#define TE_FCC          137
#define TE_ITU          138
#define TE_G802         139
#define TE_G707         140
/*                      141 - 160 reserved for more standards */

/* Loopback Definitions */
#define TE_LOOPUP       161
#define TE_LOOPDOWN     162
#define TE_REMOTE       163
#define TE_ANALOG       164
#define TE_DIGITAL      165
#define TE_PAYLOAD      166
#define TE_LOCAL        167
#define TE_SYSTEM       168
#define TE_NLOOP        169 /* Network Loopback */
#define TE_LINE         170
#define TE_ACTIVATE     171
#define TE_DEACTIVATE   172
#define TE_DIAGNOSTIC   173
/*                      174 - 180 reserved for other loopback definitions */

/* Other Common Parameter Definitions */
#define TE_TX           181   
#define TE_RX           182
#define TE_BOTH         183
#define TE_USER         184
#define TE_NA           185 /* Not Applicable */
#define TE_UNIPOLAR     186 
#define TE_BIPOLAR      187
#define TE_EVEN         188
#define TE_ODD          189
#define TE_PRIMARY      190
#define TE_SECONDARY    191
#define TE_MAX          192
#define TE_MIN          193
#define TE_DUMP         194
#define TE_MONITOR      195
#define TE_IDLE         196
#define TE_INTERNAL     197
#define TE_SERIAL       198
#define TE_BIT_ERROR    199
#define TE_BLOCK_ERROR  200
#define TE_PATH         201
#define TE_SECTION      202
#define TE_TRISTATE     203
#define TE_INPUT        204
#define TE_OUTPUT       205
#define TE_POS          206
#define TE_NEG          207
#define TE_TRANS        208
#define TE_SYS          209
#define TE_SLAVE        210
#define TE_MASTER       211
#define TE_RISING       212
#define TE_FALLING      213
#define TE_HIGH	        214
#define TE_LOW          215
#define TE_MANUAL       216
#define TE_AUTO	        217
#define TE_RESYNC       218
#define TE_TRANSPARENT  219	
#define TE_NORMAL       220
#define TE_ENHANCED     221
#define TE_ABORT        222
#define TE_IGNORE       223
#define TE_VALID        224
#define TE_INVALID      225
#define TE_DEFECT       226
#define TE_FAILURE      227
#define TE_NATIONAL     228
#define TE_READ         229
#define TE_WRITE        230
#define TE_GENERIC      231
/*                      232-255 reserved for future parameter definitions */
/*                      Most parameters are passed in as TEbyte (8bit),   */
/*                      so in future, it may be neccessary to up those to */
/*                      TEword (16 bit) if 255 reserved parameters are    */
/*                      exceeded.                                         */


/* Window Definitions */
#define TE_WIN1              0x0034 
#define TE_WIN2              0x0035
#define TE_WIN3              0x0036 
#define TE_WIN4              0x0037 
#define TE_WIN5              0x0038 
#define TE_WIN6              0x0039 
#define TE_WIN7              0x003A

/* Error Count Definitions */
#define TE_ERR1              0x003B 
#define TE_ERR2              0x003C
#define TE_ERR3              0x003D 
#define TE_ERR4              0x003E 
#define TE_ERR5              0x003F 
#define TE_ERR6              0x0040 
#define TE_ERR7              0x0041 

#define TE_FALSE        0
#define TE_TRUE         1
#define TE_DUMMY        0x00

/***************************************************************
 *  Macro Definitions                                          *
 ***************************************************************/

/* ************************************************************************* 
 *  Macro Name:     CHK_STATUS
 *  Description:    This macro checks the return value of the passed in
 *                  parameter (function).  If something other then
 *                  TE_STATUS_SUCCESS is returned by the function, the
 *                  return status is passed back to the caller.
 * ************************************************************************* */ 
#define CHK_STATUS(x)                              \
{                                                  \
    TEstatus err = (x);                            \
    if (err != TE_STATUS_SUCCESS)                  \
    {                                              \
        return err;                                \
    }                                              \
}                                                  

/* ************************************************************************* 
 *  Macro Name:     CHK_NULL
 *  Description:    This macro checks to see if the parameter passed
 *                  in (pointer) is NULL or not.  It will return 
 *                  TE_STATUS_BAD_PARAMS if the parameter is NULL.
 * ************************************************************************* */ 
#define CHK_NULL(p)                                    \
{                                                      \
    if (NULL == (p))                                   \
    {                                                  \
        return TE_STATUS_BAD_PARAMS;                   \
    }                                                  \
}

#endif   /* __TECOMM_H_ */

