#!/bin/sh
#
#
# Start RAID Configuration service srcd.
#

# load config
. /etc/rc.conf

SRCD=/usr/sbin/srcd
RETVAL=0
rc_done=" done"
rc_failed=" failed"

return="$rc_done"

case "$1" in
    'start')
	if [ -x $SRCD ]; then
		# start it.
		echo -n "Starting srcd"
		$SRCD || return="$rc_failed"
		RETVAL=$?
		echo -e "$return"
	else
		echo "Could not find $SRCD."
		RETVAL=1
	fi
	;;

    'stop')
	echo -n "Shutting down srcd"
	killall srcd || return="$rc_failed"
	RETVAL=$?
	echo -e "$return"
	;;

    'restart'|'reload')
	$0 stop
	$0 start
	RETVAL=$?
	;;

    *)
	echo "Usage: $0 { start | stop | restart | reload }"
	exit 1
	;;
esac
exit $RETVAL

