/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.GenericLinuxDesktopManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.io.File;
import java.util.Properties;

class GNOMEDesktopManager
extends GenericLinuxDesktopManager {
    private static final String desktopRootSuffix = "apps/";
    static final String GNOME = "GNOME";
    private File gnomeSystemDesktopRoot;
    private File gnomeUserDesktopRoot;

    GNOMEDesktopManager(WizardServices wizardServices) {
        super(wizardServices);
    }

    final String[] createDotDirectoryFileProps(String string, String string2) {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "[Desktop Entry]";
        stringArray[n++] = "Name=" + new File(string).getName();
        stringArray[n++] = "Type=Directory";
        stringArray[n++] = "Icon=" + string2;
        stringArray[n] = "MiniIcon=" + string2;
        return stringArray;
    }

    final String[] createProgramShortCutProps(String string, String string2, String string3, String string4, String string5, Properties properties) {
        String[] stringArray = new String[7];
        int n = 0;
        stringArray[n++] = "[Desktop Entry]";
        stringArray[n++] = "Name=" + string4;
        stringArray[n++] = "Comment=";
        stringArray[n++] = "Exec=\"" + string + "\" " + string2;
        stringArray[n++] = "Icon=" + string3;
        stringArray[n++] = "Terminal=" + (this.getShowTerminal() ? "1" : "0");
        stringArray[n] = "Type=Application";
        return stringArray;
    }

    final File getDesktopRoot(String string) throws ServiceException {
        int n = this.resolveFolderContext(string);
        if (n == 4) {
            if (this.gnomeSystemDesktopRoot == null) {
                String string2 = this.getGNOMEDesktopRoot(4);
                if (string2 == null) {
                    throw new ServiceException(1, "cannot resolve desktop root for GNOME desktop manager");
                }
                this.gnomeSystemDesktopRoot = new File(string2);
            }
            return this.gnomeSystemDesktopRoot;
        }
        if (n == 8) {
            if (this.gnomeUserDesktopRoot == null) {
                this.gnomeUserDesktopRoot = new File(this.getGNOMEDesktopRoot(8));
            }
            return this.gnomeUserDesktopRoot;
        }
        return null;
    }

    String getFileExtension() {
        return ".desktop";
    }

    private String getGNOMEDesktopRoot(int n) {
        String string = null;
        if (n == 4) {
            String string2 = "gnome-wm";
            String string3 = new GenericLinuxCommands().locateExecutable(string2);
            if (string3 != null && string3.length() > 0 && string3.startsWith(File.separator)) {
                string = new File(string3.substring(0, string3.indexOf("/bin")), "share/gnome/apps/").getAbsolutePath();
            }
        } else if (n == 8) {
            string = new File(System.getProperty("user.home"), ".gnome" + File.separator + desktopRootSuffix).getAbsolutePath();
        }
        return string;
    }

    public String getID() {
        return GNOME;
    }
}

