/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.LinuxDesktopManager;
import com.installshield.util.FileAttributes;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
abstract class GenericLinuxDesktopManager
implements LinuxDesktopManager {
    static final String dotDirectory = "/.directory";
    WizardServices services;
    private boolean showTerminal = false;

    GenericLinuxDesktopManager(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    void assert(String string, boolean bl) throws ServiceException {
        if (bl) {
            throw new ServiceException(2, string);
        }
    }

    public void createDesktopFolder(String string, String string2) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        fileService.createDirectory(this.getFolderContextAsFile(string, string2).getAbsolutePath());
    }

    public void createDesktopItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, Properties properties) throws ServiceException {
        this.assert("DesktopItem title is null or empty.", string == null || string3 == null || string3.length() == 0);
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.createDirectory(file.getAbsolutePath());
        this.createDotDirectoryFile(file.getAbsolutePath(), this.getDesktopRoot(string).getAbsolutePath(), string6);
        File file2 = new File(this.getFolderContextAsFile(string, string2).getAbsolutePath(), String.valueOf(string3) + this.getFileExtension());
        String[] stringArray = this.createProgramShortCutProps(string4, string5, string6, string3, string7, properties);
        this.writeAsciiFile(file2.getAbsolutePath(), stringArray);
    }

    void createDotDirectoryFile(String string, String string2, String string3) throws ServiceException {
        File file = new File(string);
        if (!file.getAbsolutePath().equals(new File(string2).getAbsolutePath())) {
            FileService fileService = (FileService)this.services.getService("fileService");
            fileService.createAsciiFile(new File(file.getAbsolutePath(), dotDirectory).getAbsolutePath(), this.createDotDirectoryFileProps(string, string3));
            this.createDotDirectoryFile(file.getParent(), string2, string3);
        }
    }

    abstract String[] createDotDirectoryFileProps(String var1, String var2);

    abstract String[] createProgramShortCutProps(String var1, String var2, String var3, String var4, String var5, Properties var6);

    void deleteFolder(String string, String string2) {
        File file = new File(string);
        File file2 = new File(file, dotDirectory);
        if (file2.exists() && !file2.getAbsolutePath().equals(new File(string2, dotDirectory).getAbsolutePath())) {
            file2.delete();
        }
        if (!file.exists() || file.list().length > 0 || file.getAbsolutePath().equals(string2)) {
            return;
        }
        file.delete();
        this.deleteFolder(file.getParent(), string2);
    }

    public FileAttributes getDesktopFolderAttributes(String string, String string2) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        this.assert("Cannot find attributes for desktop folder:  desktop folder does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        return ((FileService)this.services.getService("fileService")).getFileAttributes(file.getAbsolutePath());
    }

    public String getDesktopFolderOwner(String string, String string2) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        this.assert("Cannot find owner for desktop folder:  desktop folder does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        return ((FileService)this.services.getService("fileService")).getFileOwner(file.getAbsolutePath());
    }

    public String getDesktopFolderOwnerGroup(String string, String string2) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        this.assert("Cannot find owner group for desktop folder:  desktop folder does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        return ((FileService)this.services.getService("fileService")).getFileOwnerGroup(file.getAbsolutePath());
    }

    public FileAttributes getDesktopItemAttributes(String string, String string2, String string3) throws ServiceException {
        this.assert("Desktop item title is null or empty while finding desktop item attributes.", string == null || string3 == null || string3.length() == 0);
        File file = new File(this.getFolderContextAsFile(string, string2), String.valueOf(string3) + this.getFileExtension());
        this.assert("Cannot find attributes for desktop shortcut:  desktop icon file does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        return ((FileService)this.services.getService("fileService")).getFileAttributes(file.getAbsolutePath());
    }

    public String getDesktopItemOwner(String string, String string2, String string3) throws ServiceException {
        this.assert("Desktop item title is null or empty while finding desktop item owner.", string == null || string3 == null || string3.length() == 0);
        File file = new File(this.getFolderContextAsFile(string, string2), String.valueOf(string3) + this.getFileExtension());
        this.assert("Cannot find owner for desktop shortcut:  desktop icon file does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        return ((FileService)this.services.getService("fileService")).getFileOwner(file.getAbsolutePath());
    }

    public String getDesktopItemOwnerGroup(String string, String string2, String string3) throws ServiceException {
        this.assert("Desktop item title is null or empty while finding desktop item owner group.", string == null || string3 == null || string3.length() == 0);
        File file = new File(this.getFolderContextAsFile(string, string2), String.valueOf(string3) + this.getFileExtension());
        this.assert("Cannot find owner group for desktop shortcut:  desktop icon file does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        return ((FileService)this.services.getService("fileService")).getFileOwnerGroup(file.getAbsolutePath());
    }

    abstract File getDesktopRoot(String var1) throws ServiceException;

    abstract String getFileExtension();

    File getFolderContextAsFile(String string, String string2) throws ServiceException {
        this.assert("Desktop item context and program group are null.", string == null && string2 == null);
        if (string2 == null) {
            string2 = "";
        }
        return new File(this.getDesktopRoot(string), string2);
    }

    public abstract String getID();

    public boolean getShowTerminal() {
        return this.showTerminal;
    }

    public void removeDesktopFolder(String string, String string2) throws ServiceException {
        this.deleteFolder(this.getFolderContextAsFile(string, string2).getAbsolutePath(), this.getDesktopRoot(string).getAbsolutePath());
    }

    public void removeDesktopItem(String string, String string2, String string3) throws ServiceException {
        this.assert("DesktopItem title is null or empty.", string == null || string3 == null || string3.length() == 0);
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = new File(this.getFolderContextAsFile(string, string2).getAbsolutePath(), String.valueOf(string3) + this.getFileExtension());
        if (file.exists()) {
            fileService.deleteFile(file.getAbsolutePath());
            this.deleteFolder(file.getParent(), this.getDesktopRoot(string).getAbsolutePath());
        }
    }

    int resolveFolderContext(String string) throws ServiceException {
        int n = 4;
        if (string != null && string.trim().length() > 0) {
            n = string.equals("$System Wide Desktop Icon$") ? 4 : 8;
        }
        return n;
    }

    public void setDesktopFolderAttributes(String string, String string2, FileAttributes fileAttributes) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        this.assert("File attributes object is null while setting attributes for desktop folder (" + file.getAbsolutePath() + ")", fileAttributes == null);
        this.assert("Cannot set desktop folder attributes for desktop folder:  desktop folder does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        ((FileService)this.services.getService("fileService")).setFileAttributes(file.getAbsolutePath(), fileAttributes);
    }

    public void setDesktopFolderOwner(String string, String string2, String string3) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        this.assert("Owner object is null while setting owner for desktop folder (" + file.getAbsolutePath() + ")", string3 == null);
        this.assert("Cannot set owner for desktop folder:  desktop folder does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        ((FileService)this.services.getService("fileService")).setFileOwner(file.getAbsolutePath(), string3);
    }

    public void setDesktopFolderOwnerGroup(String string, String string2, String string3) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        this.assert("Owner object is null while setting group for desktop folder (" + file.getAbsolutePath() + ")", string3 == null);
        this.assert("Cannot set owner group for desktop folder:  desktop folder does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        ((FileService)this.services.getService("fileService")).setFileOwner(file.getAbsolutePath(), string3);
    }

    public void setDesktopItemAttributes(String string, String string2, String string3, FileAttributes fileAttributes) throws ServiceException {
        this.assert("Desktop item title is null or empty while setting desktop item attributes.", string == null || string3 == null || string3.length() == 0);
        File file = new File(this.getFolderContextAsFile(string, string2), String.valueOf(string3) + this.getFileExtension());
        this.assert("File attributes object is null while setting attributes for desktop item (" + file.getAbsolutePath() + ")", fileAttributes == null);
        this.assert("Cannot set attributes for desktop shortcut:  desktop icon file does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        ((FileService)this.services.getService("fileService")).setFileAttributes(file.getAbsolutePath(), fileAttributes);
    }

    public void setDesktopItemOwner(String string, String string2, String string3, String string4) throws ServiceException {
        this.assert("Desktop item title is null or empty while setting desktop item owner.", string == null || string3 == null || string3.length() == 0);
        File file = new File(this.getFolderContextAsFile(string, string2), String.valueOf(string3) + this.getFileExtension());
        this.assert("Owner object is null while setting owner for desktop item (" + file.getAbsolutePath() + ")", string4 == null);
        this.assert("Cannot set DesktopItemOwner for desktop shortcut:  desktop icon file does not exist. " + file.getAbsolutePath(), file.exists() ^ true);
        ((FileService)this.services.getService("fileService")).setFileOwner(file.getAbsolutePath(), string4);
    }

    public void setDesktopItemOwnerGroup(String string, String string2, String string3, String string4) throws ServiceException {
        this.assert("DesktopItem title is null or empty while setting desktop item owner group.", string == null || string3 == null || string3.length() == 0);
        File file = new File(this.getFolderContextAsFile(string, string2), String.valueOf(string3) + this.getFileExtension());
        this.assert("Owner object is null while setting group for desktop item (" + file.getAbsolutePath() + ")", string4 == null);
        this.assert("Cannot set owner group for desktop shortcut:  desktop icon file does not exist (" + file.getAbsolutePath() + ")", file.exists() ^ true);
        ((FileService)this.services.getService("fileService")).setFileOwner(file.getAbsolutePath(), string4);
    }

    public void setShowTerminal(boolean bl) {
        this.showTerminal = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeAsciiFile(String string, String[] stringArray) throws ServiceException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            try {
                String string2 = System.getProperty("line.separator");
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF8");
                String string3 = "Encoding=UTF-8";
                outputStreamWriter.write(string3, 0, string3.length());
                outputStreamWriter.write(string2, 0, string2.length());
                int n = 0;
                while (n < stringArray.length) {
                    outputStreamWriter.write(stringArray[n], 0, stringArray[n].length());
                    outputStreamWriter.write(string2, 0, string2.length());
                    ++n;
                }
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException);
            }
            Object var5_8 = null;
            if (outputStreamWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

