/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GNOME2DesktopManager;
import com.ibm.wizard.platform.linux.GNOMEDesktopManager;
import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.KDEDesktopManager;
import com.ibm.wizard.platform.linux.LinuxDesktopManager;
import com.ibm.wizard.platform.linux.LinuxDesktopManagerGroup;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.SuseKDEDesktopManager;
import com.installshield.product.service.desktop.PureJavaDesktopServiceImpl;
import com.installshield.util.FileAttributes;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.SecurityService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class LinuxDesktopServiceImpl
extends PureJavaDesktopServiceImpl {
    private boolean KDEInstalled = false;
    private boolean GNOMEInstalled = false;
    private boolean suseKDEInstalled = false;
    private boolean GNOME2Installed = false;
    private LinuxDesktopManagerGroup desktopManagerGroup = new LinuxDesktopManagerGroup();
    private String currentDesktopManager = "";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void createDesktopFolder(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderProgramGroup(string);
        this.createDesktopFolder(string2, string3);
    }

    public void createDesktopFolder(String string, String string2) throws ServiceException {
        Enumeration enumeration = this.desktopManagerGroup.getDesktopManagers();
        while (enumeration.hasMoreElements()) {
            ((LinuxDesktopManager)enumeration.nextElement()).createDesktopFolder(string, string2);
        }
    }

    public void createDesktopItem(String string, String string2, String string3, String string4, String string5, String string6) throws ServiceException {
        String string7 = this.parseFolderContext(string);
        String string8 = this.parseFolderProgramGroup(string);
        this.createDesktopItem(string7, string8, string2, string3, string4, string5, string6, null);
    }

    public void createDesktopItem(String string, String string2, String string3, String string4, String string5, String string6, String string7, Properties properties) throws ServiceException {
        Enumeration enumeration = this.desktopManagerGroup.getDesktopManagers();
        while (enumeration.hasMoreElements()) {
            LinuxDesktopManager linuxDesktopManager = (LinuxDesktopManager)enumeration.nextElement();
            Object object = this.getServices().getValue("linux.desktop.extra.showTerminal");
            if (object != null && (class$java$lang$Object != null ? class$java$lang$Object : LinuxDesktopServiceImpl.class$("java.lang.Object")).isAssignableFrom(class$java$lang$Boolean != null ? class$java$lang$Boolean : LinuxDesktopServiceImpl.class$("java.lang.Boolean"))) {
                linuxDesktopManager.setShowTerminal((Boolean)object);
            }
            linuxDesktopManager.createDesktopItem(string, string2, string3, string4, string5, string6, string7, properties);
            linuxDesktopManager.setShowTerminal(false);
        }
    }

    private String createFolderDisplayName(String string, String string2) {
        return String.valueOf(string) + File.separator + string2;
    }

    private String createItemDisplayName(String string, String string2, String string3) {
        return String.valueOf(string) + File.separator + string2 + File.separator + string3;
    }

    void detectCurrentDesktopManager() {
        block7: {
            File file = new File(System.getProperty("user.home"), ".Xclients-default");
            try {
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n = fileInputStream.available();
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 <= n && (n3 = fileInputStream.read(byArray)) != -1) {
                        n2 += n3;
                    }
                    String string = new String(byArray);
                    if (string.indexOf("gnome-session") >= 0) {
                        this.currentDesktopManager = "GNOME";
                    } else if (string.indexOf("startkde") >= 0) {
                        this.currentDesktopManager = "KDE";
                    }
                }
            }
            catch (IOException iOException) {
                this.logEvent(this, "wrn", "Cannot detect current desktop manager: Linux desktop service APIs may not work properly. " + iOException);
                if (System.getProperty("is.debug") == null) break block7;
                iOException.printStackTrace();
            }
        }
    }

    String getCurrentDesktopManager() {
        return this.currentDesktopManager;
    }

    public FileAttributes getDesktopFolderAttributes(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderProgramGroup(string);
        return this.getDesktopFolderAttributes(string2, string3);
    }

    public FileAttributes getDesktopFolderAttributes(String string, String string2) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string3 = this.createFolderDisplayName(string, string2);
            throw new ServiceException(2, "Cannot find attributes for the desktop folder " + string3 + " - unable to detect the current desktop manager.");
        }
        return linuxDesktopManager.getDesktopFolderAttributes(string, string2);
    }

    public String getDesktopFolderOwner(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderProgramGroup(string);
        return this.getDesktopFolderOwner(string2, string3);
    }

    public String getDesktopFolderOwner(String string, String string2) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string3 = this.createFolderDisplayName(string, string2);
            throw new ServiceException(2, "Cannot find owner for the desktop folder " + string3 + " - unable to detect the current desktop manager.");
        }
        return linuxDesktopManager.getDesktopFolderOwner(string, string2);
    }

    public String getDesktopFolderOwnerGroup(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderProgramGroup(string);
        return this.getDesktopFolderOwnerGroup(string2, string3);
    }

    public String getDesktopFolderOwnerGroup(String string, String string2) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string3 = this.createFolderDisplayName(string, string2);
            throw new ServiceException(2, "Cannot get group for the desktop folder " + string3 + " - unable to detect the current desktop manager.");
        }
        return linuxDesktopManager.getDesktopFolderOwnerGroup(string, string2);
    }

    public FileAttributes getDesktopItemAttributes(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        return this.getDesktopItemAttributes(string3, string4, string2);
    }

    public FileAttributes getDesktopItemAttributes(String string, String string2, String string3) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string4 = this.createItemDisplayName(string, string2, string3);
            throw new ServiceException(2, "Cannot get attributes for the desktop item " + string4 + " - unable to detect the current desktop manager.");
        }
        return linuxDesktopManager.getDesktopItemAttributes(string, string2, string3);
    }

    public String getDesktopItemOwner(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        return this.getDesktopItemOwner(string3, string4, string2);
    }

    public String getDesktopItemOwner(String string, String string2, String string3) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string4 = this.createItemDisplayName(string, string2, string3);
            throw new ServiceException(2, "Cannot get owner for the desktop item " + string4 + " - unable to detect the current desktop manager.");
        }
        return linuxDesktopManager.getDesktopItemOwner(string, string2, string3);
    }

    public String getDesktopItemOwnerGroup(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        return this.getDesktopItemOwnerGroup(string3, string4, string2);
    }

    public String getDesktopItemOwnerGroup(String string, String string2, String string3) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string4 = this.createItemDisplayName(string, string2, string3);
            throw new ServiceException(2, "Cannot find group for the desktop item " + string4 + " - unable to detect the current desktop manager.");
        }
        return linuxDesktopManager.getDesktopItemOwnerGroup(string, string2, string3);
    }

    public String getName() {
        return "LinuxDesktopServiceImpl";
    }

    public String[] getNamedFolderList(String string, String string2) throws ServiceException {
        throw new ServiceException(305);
    }

    public String getPlatformId() throws ServiceException {
        return "linux.desktop";
    }

    public int getSystemCompatibility() {
        int n = 0;
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            if (this.isGNOMEInstalled()) {
                n = 5;
            }
            if (this.isKDEInstalled()) {
                n = 5;
            }
            if (this.isSuseKDEInstalled()) {
                n = 5;
            }
            if (this.isGNOME2Installed()) {
                n = 5;
            }
        }
        return n;
    }

    protected void initialized() {
        if (this.KDEInstalled) {
            this.desktopManagerGroup.addDesktopManager(new KDEDesktopManager(this.getServices()));
        }
        if (this.GNOMEInstalled) {
            this.desktopManagerGroup.addDesktopManager(new GNOMEDesktopManager(this.getServices()));
        }
        if (this.suseKDEInstalled) {
            this.desktopManagerGroup.addDesktopManager(new SuseKDEDesktopManager(this.getServices()));
        }
        try {
            SecurityService securityService = (SecurityService)this.getServices().getService("securityService");
            if (this.GNOME2Installed && securityService.isCurrentUserAdmin()) {
                this.desktopManagerGroup.addDesktopManager(new GNOME2DesktopManager(this.getServices()));
            }
        }
        catch (ServiceException serviceException) {}
        this.detectCurrentDesktopManager();
    }

    public boolean isContextOwnershipSupported(String string) throws ServiceException {
        boolean bl = false;
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager != null) {
            bl = true;
        }
        return bl;
    }

    private boolean isGNOME2Installed() {
        this.GNOME2Installed = new File("/usr/share/applications").exists();
        return this.GNOME2Installed;
    }

    private boolean isGNOMEInstalled() {
        String string = "gnome-wm";
        String string2 = new GenericLinuxCommands().locateExecutable(string);
        if (string2 != null && string2.length() > 0 && string2.startsWith(File.separator)) {
            this.GNOMEInstalled = true;
        }
        return this.GNOMEInstalled;
    }

    private boolean isKDEInstalled() {
        String string = "startkde";
        String string2 = new GenericLinuxCommands().locateExecutable(string);
        if (string2 != null && string2.length() > 0 && string2.startsWith(File.separator)) {
            this.KDEInstalled = true;
        }
        return this.KDEInstalled;
    }

    private boolean isSuseKDEInstalled() {
        String string = "startkde";
        String string2 = new GenericLinuxCommands().locateExecutable(string);
        if (string2 != null && string2.length() > 0 && string2.startsWith(File.separator)) {
            this.suseKDEInstalled = new File("/etc" + string2.substring(0, string2.indexOf("/bin")), "/share/applnk/SuSE").exists();
        }
        return this.suseKDEInstalled;
    }

    private String parseFolderContext(String string) {
        String string2 = "";
        int n = string.indexOf(File.separator);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private String parseFolderProgramGroup(String string) {
        String string2 = string;
        int n = string.indexOf(File.separator);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public void removeDesktopFolder(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderProgramGroup(string);
        this.removeDesktopFolder(string2, string3);
    }

    public void removeDesktopFolder(String string, String string2) throws ServiceException {
        Enumeration enumeration = this.desktopManagerGroup.getDesktopManagers();
        while (enumeration.hasMoreElements()) {
            ((LinuxDesktopManager)enumeration.nextElement()).removeDesktopFolder(string, string2);
        }
    }

    public void removeDesktopItem(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        this.removeDesktopItem(string3, string4, string2);
    }

    public void removeDesktopItem(String string, String string2, String string3) throws ServiceException {
        Enumeration enumeration = this.desktopManagerGroup.getDesktopManagers();
        while (enumeration.hasMoreElements()) {
            ((LinuxDesktopManager)enumeration.nextElement()).removeDesktopItem(string, string2, string3);
        }
    }

    public void setDesktopFolderAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderProgramGroup(string);
        this.setDesktopFolderAttributes(string2, string3, fileAttributes);
    }

    public void setDesktopFolderAttributes(String string, String string2, FileAttributes fileAttributes) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string3 = this.createFolderDisplayName(string, string2);
            throw new ServiceException(2, "Cannot set attributes for the desktop folder " + string3 + " - unable to detect the current desktop manager.");
        }
        linuxDesktopManager.setDesktopFolderAttributes(string, string2, fileAttributes);
    }

    public void setDesktopFolderOwner(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        this.setDesktopFolderOwner(string3, string4, string2);
    }

    public void setDesktopFolderOwner(String string, String string2, String string3) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string4 = this.createFolderDisplayName(string, string2);
            throw new ServiceException(2, "Cannot set owner for the desktop folder " + string4 + " - unable to detect the current desktop manager.");
        }
        linuxDesktopManager.setDesktopFolderOwner(string, string2, string3);
    }

    public void setDesktopFolderOwnerGroup(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        this.setDesktopFolderOwnerGroup(string3, string4, string2);
    }

    public void setDesktopFolderOwnerGroup(String string, String string2, String string3) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string4 = this.createFolderDisplayName(string, string2);
            throw new ServiceException(2, "Cannot set group for the desktop folder " + string4 + " - unable to detect the current desktop manager.");
        }
        linuxDesktopManager.setDesktopFolderOwnerGroup(string, string2, string3);
    }

    public void setDesktopItemAttributes(String string, String string2, FileAttributes fileAttributes) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderProgramGroup(string);
        this.setDesktopItemAttributes(string3, string4, string2, fileAttributes);
    }

    public void setDesktopItemAttributes(String string, String string2, String string3, FileAttributes fileAttributes) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string4 = this.createItemDisplayName(string, string2, string3);
            throw new ServiceException(2, "Cannot set attributes for the desktop item " + string4 + " - unable to detect the current desktop manager.");
        }
        linuxDesktopManager.setDesktopItemAttributes(string, string2, string3, fileAttributes);
    }

    public void setDesktopItemOwner(String string, String string2, String string3) throws ServiceException {
        String string4 = this.parseFolderContext(string);
        String string5 = this.parseFolderProgramGroup(string);
        this.setDesktopItemOwner(string4, string5, string2, string3);
    }

    public void setDesktopItemOwner(String string, String string2, String string3, String string4) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string5 = this.createItemDisplayName(string, string2, string3);
            throw new ServiceException(2, "Cannot set owner for the desktop item " + string5 + " - unable to detect the current desktop manager.");
        }
        linuxDesktopManager.setDesktopItemOwner(string, string2, string3, string4);
    }

    public void setDesktopItemOwnerGroup(String string, String string2, String string3) throws ServiceException {
        String string4 = this.parseFolderContext(string);
        String string5 = this.parseFolderProgramGroup(string);
        this.setDesktopItemOwnerGroup(string4, string5, string2, string3);
    }

    public void setDesktopItemOwnerGroup(String string, String string2, String string3, String string4) throws ServiceException {
        LinuxDesktopManager linuxDesktopManager = this.desktopManagerGroup.getDesktopManager(this.getCurrentDesktopManager());
        if (linuxDesktopManager == null) {
            String string5 = this.createItemDisplayName(string, string2, string3);
            throw new ServiceException(2, "Cannot set group for the desktop item " + string5 + " - unable to detect the current desktop manager.");
        }
        linuxDesktopManager.setDesktopItemOwnerGroup(string, string2, string3, string4);
    }
}

