/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinuxFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2000, 2001.";
    private static String UX = "u+x";
    private static int S_ISUID = 2048;
    private static int S_ISGID = 1024;
    private static int S_ISVTX = 512;
    private static int S_IRWXU = 448;
    private static int S_IRUSR = 256;
    private static int S_IWUSR = 128;
    private static int S_IXUSR = 64;
    private static int S_IRWXG = 56;
    private static int S_IRGRP = 32;
    private static int S_IWGRP = 16;
    private static int S_IXGRP = 8;
    private static int S_IRWXO = 7;
    private static int S_IROTH = 4;
    private static int S_IWOTH = 2;
    private static int S_IXOTH = 1;
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String var1_1, boolean var2_2, boolean var3_3) throws ServiceException {
        var4_4 = 0;
        var5_5 = false;
        var6_6 = "";
        var7_7 = this.createFileName(this.getCurrentDirectory(), var1_1);
        if (this.fileExists(var7_7) && this.isDirectory(var7_7) && this.getParent(var7_7) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(var7_7)) {
            if (!var2_2 && !var3_3) {
                try {
                    var8_8 = String.valueOf(FileUtils.appendSeparator(var7_7, this.getSeparator())) + "*";
                    var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + var8_8 + "\""});
                    if (var9_14.getExitCode() == 0) {
                        var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                        if (var9_14.getExitCode() == 0) ** GOTO lbl42
                        var5_5 = true;
                        var6_6 = var9_14.getStderr();
                    }
                    var5_5 = true;
                    var6_6 = var9_14.getStderr();
                }
                catch (Exception var8_9) {
                    throw new ServiceException(var8_9);
                }
            } else if (var2_2 && !var3_3) {
                try {
                    var8_10 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                    if (var8_10.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_10.getStderr();
                }
                catch (Exception var8_11) {
                    throw new ServiceException(var8_11);
                }
            } else if (!var2_2 && var3_3) {
                try {
                    var8_12 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + var7_7 + "\""});
                    if (var8_12.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_12.getStderr();
                }
                catch (Exception var8_13) {
                    throw new ServiceException(var8_13);
                }
            } else {
                var4_4 = super.deleteDirectory(var1_1, var2_2, var3_3);
            }
        }
lbl42:
        // 10 sources

        if (var5_5) {
            throw new ServiceException(2, "Error deleting directory: " + var6_6);
        }
        return var4_4;
    }

    private static FileAttributes getAttributeObject(int n) {
        FileAttributes fileAttributes = new FileAttributes();
        if ((n & S_IRUSR) == S_IRUSR) {
            fileAttributes.setAttributeState(1, true);
        }
        if ((n & S_IRGRP) == S_IRGRP) {
            fileAttributes.setAttributeState(8, true);
        }
        if ((n & S_IROTH) == S_IROTH) {
            fileAttributes.setAttributeState(64, true);
        }
        if ((n & S_IWUSR) == S_IWUSR) {
            fileAttributes.setAttributeState(2, true);
        }
        if ((n & S_IWGRP) == S_IWGRP) {
            fileAttributes.setAttributeState(16, true);
        }
        if ((n & S_IWOTH) == S_IWOTH) {
            fileAttributes.setAttributeState(128, true);
        }
        if ((n & S_IXUSR) == S_IXUSR) {
            fileAttributes.setAttributeState(4, true);
        }
        if ((n & S_IXGRP) == S_IXGRP) {
            fileAttributes.setAttributeState(32, true);
        }
        if ((n & S_IXOTH) == S_IXOTH) {
            fileAttributes.setAttributeState(256, true);
        }
        return fileAttributes;
    }

    private String getCalendarField(Calendar calendar, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 2) {
            stringBuffer.append(calendar.get(n) + 1);
        } else {
            stringBuffer.append(calendar.get(n));
        }
        if (n != 1 && stringBuffer.length() < 2) {
            stringBuffer.insert(0, 0);
        }
        return stringBuffer.toString();
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        String string2 = this.commandLineInterface.listContents(string, 0);
        int n = Integer.parseInt(string2);
        return LinuxFileServiceImpl.getAttributeObject(n);
    }

    public String getFileOwner(String string) throws ServiceException {
        String string2 = this.commandLineInterface.listContents(string, 1);
        return string2;
    }

    public String getFileOwnerGroup(String string) throws ServiceException {
        String string2 = this.commandLineInterface.listContents(string, 2);
        return string2;
    }

    private static int getMode(FileAttributes fileAttributes) {
        int n = 0;
        if (fileAttributes.getAttributeState(1)) {
            n |= S_IRUSR;
        }
        if (fileAttributes.getAttributeState(8)) {
            n |= S_IRGRP;
        }
        if (fileAttributes.getAttributeState(64)) {
            n |= S_IROTH;
        }
        if (fileAttributes.getAttributeState(2)) {
            n |= S_IWUSR;
        }
        if (fileAttributes.getAttributeState(16)) {
            n |= S_IWGRP;
        }
        if (fileAttributes.getAttributeState(128)) {
            n |= S_IWOTH;
        }
        if (fileAttributes.getAttributeState(4)) {
            n |= S_IXUSR;
        }
        if (fileAttributes.getAttributeState(32)) {
            n |= S_IXGRP;
        }
        if (fileAttributes.getAttributeState(256)) {
            n |= S_IXOTH;
        }
        return n;
    }

    public String getName() {
        return "LinuxFileServiceImpl";
    }

    public String getNamedDirectory(String string) throws ServiceException {
        if (string.equals("home")) {
            return System.getProperty("user.home");
        }
        if (string.equals("install")) {
            return "/opt";
        }
        if (string.equals("lib")) {
            return "/usr/lib";
        }
        if (string.equals("log")) {
            return "/var/log";
        }
        if (string.equals("temp")) {
            return "/tmp";
        }
        if (string.equals("timestamp")) {
            return String.valueOf(new Date().getTime());
        }
        return super.getNamedDirectory(string);
    }

    public String getPartitionFormat(String string) throws ServiceException {
        String string2 = this.commandLineInterface.fileSystemType(string);
        int n = string2.indexOf(10);
        return this.getToken(string2.substring(n), " ", 2);
    }

    public long getPartitionFreeSpace(String string) throws ServiceException {
        String string2 = this.commandLineInterface.fileSystemInfo(string);
        string2 = string2.trim();
        int n = string2.lastIndexOf(10);
        try {
            String string3 = this.getToken(string2.substring(n), " ", 4);
            return Long.valueOf(string3) * 1024L;
        }
        catch (Exception exception) {
            throw new ServiceException(200, exception.getMessage());
        }
    }

    public String[] getPartitionNames() throws ServiceException {
        Object object;
        String string = this.commandLineInterface.mountInfo();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = string.indexOf(10);
        while (n2 != -1) {
            object = new StringTokenizer(string.substring(n, n2), " ");
            String string2 = ((StringTokenizer)object).nextToken();
            if (string2.indexOf("/") >= 0) {
                string2 = ((StringTokenizer)object).nextToken();
                vector.addElement(((StringTokenizer)object).nextToken());
            }
            n = n2 + 1;
            n2 = string.indexOf(10, n);
        }
        object = new String[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public int getPartitionType(String string) throws ServiceException {
        return !(string = string.trim()).startsWith("/dev/") || !string.substring(5).endsWith("cd") && !string.substring(5).endsWith("fd") && !string.substring(5).endsWith("rmt") ? 1 : 2;
    }

    public String getSeparator() {
        return "/";
    }

    public int getSystemCompatibility() {
        int n = 0;
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            n = 5;
        }
        return n;
    }

    public native int getSystemUMask() throws ServiceException;

    private String getToken(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return string3;
    }

    protected void initialized() {
        super.initialized();
        try {
            LibraryLoader.loadLibrary(this.getResource("linuxppk/liblinuxppk.so"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Error error) {
            error.printStackTrace();
            throw error;
        }
    }

    public boolean isPartitionWritable(String string) throws ServiceException {
        String string2 = this.commandLineInterface.mountInfo();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        int n2 = string2.indexOf(10);
        while (n2 != -1 && !bl) {
            String string3 = string2.substring(n, n2);
            if (this.getToken(string3, " ", 3).compareTo(string) == 0) {
                bl = true;
                if (this.getToken(string3, " ", 6).indexOf(119) != -1) {
                    bl2 = true;
                }
            }
            n = n2 + 1;
            n2 = string2.indexOf(10, n);
        }
        return bl2;
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        int n = LinuxFileServiceImpl.getMode(fileAttributes);
        this.commandLineInterface.changeFilePermissions(n, string);
    }

    public void setFileCreated(String string, long l) throws ServiceException {
        throw new ServiceException(305);
    }

    public void setFileExecutable(String string) throws ServiceException {
        FileAttributes fileAttributes = this.getFileAttributes(string);
        int n = 292;
        fileAttributes.setAttributeState(n, true);
        this.commandLineInterface.changeFilePermissions(LinuxFileServiceImpl.getMode(fileAttributes), string);
    }

    public void setFileModified(String string, long l) throws ServiceException {
        this.commandLineInterface.touchFile(l, string);
    }

    public void setFileOwner(String string, String string2) throws ServiceException {
        this.commandLineInterface.changeFileOwner(string2, string);
    }

    public void setFileOwnerGroup(String string, String string2) throws ServiceException {
        this.commandLineInterface.changeFileGroup(string2, string);
    }

    public void setFileTimes(String string, long l, long l2, long l3) throws ServiceException {
        this.setFileModified(string, l3);
    }

    public native void setSystemUMask(int var1) throws ServiceException;

    public boolean supportsLongFileNames(String string) throws ServiceException {
        try {
            File file = new File(String.valueOf(string) + "\\Longfilename.test.temporary");
            if (!file.exists()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.close();
                file.delete();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void validateFileName(String string) throws ServiceException {
        String string2 = ":*?\"<>|";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) != -1) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{string2}));
            }
            ++n;
        }
    }
}

