/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxDesktopIconExtra;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.LinuxProductComponentExtra;
import com.ibm.wizard.platform.linux.utils.RPM;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionListener;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.service.product.ProductServiceImplementor;
import com.installshield.product.service.product.PureJavaProductServiceImpl;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceFactory;
import com.installshield.wizard.service.security.SecurityService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LinuxProductServiceImpl
extends PureJavaProductServiceImpl
implements ProductServiceImplementor,
ProductActionListener {
    private static String specFileDir = "/tmp/specFile/";
    private static String SPEC = ".spec";
    private static String packageName = new String();
    private static String SUCCESS = "The installation completed without errors.";
    private static Vector specFiles = new Vector();
    private boolean isHostRPMSupported = false;
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();
    private boolean isCurrentUserAdmin = false;
    static /* synthetic */ Class class$com$installshield$product$actions$DesktopIcon;
    static /* synthetic */ Class class$com$ibm$wizard$platform$linux$LinuxDesktopIconExtra;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void createSpecFile(ProductComponent productComponent) {
        Vector vector = this.getComponentInfo(productComponent);
        try {
            File file = new File(packageName);
            FileWriter fileWriter = new FileWriter(String.valueOf(specFileDir) + file + SPEC);
            int n = 0;
            while (n < vector.size()) {
                fileWriter.write((String)vector.elementAt(n));
                fileWriter.write("\n");
                ++n;
            }
            fileWriter.write("\n%files\n");
            fileWriter.close();
        }
        catch (IOException iOException) {
            this.getServices().logEvent(this, "wrn", "Could not create SPEC File");
        }
        specFiles.addElement(String.valueOf(specFileDir) + packageName + SPEC);
    }

    private Vector getComponentInfo(ProductComponent productComponent) {
        Object object;
        Object object2;
        Dictionary dictionary = productComponent.getExtendedProperties();
        LinuxProductComponentExtra linuxProductComponentExtra = new LinuxProductComponentExtra();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = dictionary.get(object2);
            if (!object2.equals("linux") || !(object instanceof LinuxProductComponentExtra)) continue;
            linuxProductComponentExtra = (LinuxProductComponentExtra)object;
        }
        packageName = String.valueOf(this.getFullPackageName(productComponent)) + "-" + this.getPackageVersion(productComponent) + "-" + this.getPackageRelease(productComponent);
        object2 = this.getPackageVendor(productComponent);
        object = this.getPackageWebsite(productComponent);
        Vector<String> vector = new Vector<String>();
        vector.addElement("Name: " + this.getFullPackageName(productComponent));
        vector.addElement("Version: " + this.getPackageVersion(productComponent));
        vector.addElement("Release: " + this.getPackageRelease(productComponent));
        if (linuxProductComponentExtra.getSummary() != null && !linuxProductComponentExtra.getSummary().equals("") && !linuxProductComponentExtra.getSummary().equals("Required")) {
            vector.addElement("Summary: " + linuxProductComponentExtra.getSummary());
        } else {
            vector.addElement("Summary: NA");
        }
        if (linuxProductComponentExtra.getCopyright() != null && !linuxProductComponentExtra.getCopyright().equals("") && !linuxProductComponentExtra.getCopyright().equals("Required")) {
            vector.addElement("License: " + linuxProductComponentExtra.getCopyright());
        } else {
            vector.addElement("License: NA");
        }
        if (linuxProductComponentExtra.getGroup() != null && !linuxProductComponentExtra.getGroup().equals("") && !linuxProductComponentExtra.getGroup().equals("Required")) {
            vector.addElement("Group: " + linuxProductComponentExtra.getGroup());
        } else {
            vector.addElement("Group: NA");
        }
        if (!((String)object2).equals("") || object2 == null) {
            vector.addElement("Vendor: " + this.getPackageVendor(productComponent));
        }
        if (!((String)object).equals("") || object == null) {
            vector.addElement("URL: " + this.getPackageWebsite(productComponent));
        }
        if (!linuxProductComponentExtra.getDistribution().equals("") && linuxProductComponentExtra.getDistribution() != null) {
            vector.addElement("Distribution: " + linuxProductComponentExtra.getDistribution());
        }
        if (!linuxProductComponentExtra.getPackager().equals("") && linuxProductComponentExtra.getPackager() != null) {
            vector.addElement("Packager: " + linuxProductComponentExtra.getPackager());
        }
        if (!linuxProductComponentExtra.getProvides().equals("") && linuxProductComponentExtra.getProvides() != null) {
            vector.addElement("Provides: " + linuxProductComponentExtra.getProvides());
        }
        if (linuxProductComponentExtra.getAutoReqProv()) {
            vector.addElement("AutoReqProv: Yes");
        } else if (!linuxProductComponentExtra.getAutoReqProv()) {
            vector.addElement("AutoReqProv: No");
        }
        if (!linuxProductComponentExtra.getSource().equals("") && linuxProductComponentExtra.getSource() != null) {
            vector.addElement("Source: " + linuxProductComponentExtra.getSource());
        }
        if (!linuxProductComponentExtra.getPatch().equals("") && linuxProductComponentExtra.getPatch() != null) {
            vector.addElement("Patch: " + linuxProductComponentExtra.getPatch());
        }
        vector.addElement("\n%description\n" + linuxProductComponentExtra.getDescription());
        return vector;
    }

    private String getFullPackageName(ProductComponent productComponent) {
        Object object;
        Dictionary dictionary = productComponent.getExtendedProperties();
        LinuxProductComponentExtra linuxProductComponentExtra = new LinuxProductComponentExtra();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object v = dictionary.get(object);
            if (!object.equals("linux") || !(v instanceof LinuxProductComponentExtra)) continue;
            linuxProductComponentExtra = (LinuxProductComponentExtra)v;
        }
        this.getPackageVersion(productComponent);
        object = this.getPackageName(productComponent);
        this.getPackageRelease(productComponent);
        return object;
    }

    public String getName() {
        return "LinuxProductServiceImpl";
    }

    private String getPackageName(ProductComponent productComponent) {
        return productComponent.getKey().getUID().replace(' ', '_');
    }

    private String getPackageRelease(ProductComponent productComponent) {
        SoftwareObjectKey softwareObjectKey = productComponent.getKey();
        SoftwareVersion softwareVersion = softwareObjectKey.getVersion();
        String string = null;
        if (softwareVersion.getMaintenance().equals("")) {
            GenericSoftwareObject genericSoftwareObject = productComponent.getParent();
            softwareObjectKey = genericSoftwareObject.getKey();
            softwareVersion = softwareObjectKey.getVersion();
            if (softwareVersion.getMaintenance().equals("")) {
                if ((genericSoftwareObject = genericSoftwareObject.getParent()) != null && (softwareVersion = (softwareObjectKey = genericSoftwareObject.getKey()).getVersion()).getMaintenance().equals("")) {
                    string = softwareVersion.getMaintenance();
                }
            } else {
                string = softwareVersion.getMaintenance();
            }
        } else {
            string = softwareVersion.getMaintenance();
        }
        if (string == null || string.equals("")) {
            string = "1";
        }
        return string;
    }

    private String getPackageVendor(ProductComponent productComponent) {
        GenericSoftwareObject genericSoftwareObject;
        String string = productComponent.getVendor();
        if (string == null && (string = (genericSoftwareObject = productComponent.getParent()).getVendor()) == null && (genericSoftwareObject = genericSoftwareObject.getParent()) != null) {
            string = genericSoftwareObject.getVendor();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String getPackageVersion(ProductComponent productComponent) {
        SoftwareObjectKey softwareObjectKey = productComponent.getKey();
        SoftwareVersion softwareVersion = softwareObjectKey.getVersion();
        String string = null;
        if (softwareVersion.getMajor().equals("") && softwareVersion.getMinor().equals("")) {
            GenericSoftwareObject genericSoftwareObject = productComponent.getParent();
            softwareObjectKey = genericSoftwareObject.getKey();
            softwareVersion = softwareObjectKey.getVersion();
            if (softwareVersion.getMajor().equals("") && softwareVersion.getMinor().equals("")) {
                if ((genericSoftwareObject = genericSoftwareObject.getParent()) != null && !(softwareVersion = (softwareObjectKey = genericSoftwareObject.getKey()).getVersion()).getMajor().equals("") && !softwareVersion.getMinor().equals("")) {
                    string = String.valueOf(softwareVersion.getMajor()) + "." + softwareVersion.getMinor();
                }
            } else {
                string = String.valueOf(softwareVersion.getMajor()) + "." + softwareVersion.getMinor();
            }
        } else {
            string = String.valueOf(softwareVersion.getMajor()) + "." + softwareVersion.getMinor();
        }
        if (string == null || string.equals("")) {
            string = "1.0";
        }
        return string;
    }

    private String getPackageWebsite(ProductComponent productComponent) {
        GenericSoftwareObject genericSoftwareObject;
        String string = productComponent.getVendorWebsite();
        if (string == null && (string = (genericSoftwareObject = productComponent.getParent()).getVendorWebsite()) == null && (genericSoftwareObject = genericSoftwareObject.getParent()) != null) {
            string = genericSoftwareObject.getVendorWebsite();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int getSystemCompatibility() {
        int n = 0;
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            this.isHostRPMSupported = RPM.isHostRPMSupported();
            if (this.isHostRPMSupported) {
                n = 5;
            }
        }
        GenericLinuxCommands.linuxPPKDebugPrint("linux product service - host supports RPM. Returning system compatibility-" + n);
        return n;
    }

    private String getToken(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return string3;
    }

    protected void initialized() {
        try {
            this.isCurrentUserAdmin = ((SecurityService)this.getServices().getService("securityService")).isCurrentUserAdmin();
        }
        catch (ServiceException serviceException) {
            serviceException.printStackTrace();
        }
    }

    protected void installProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        try {
            Object v;
            Class<?> clazz = Class.forName((class$com$installshield$product$actions$DesktopIcon != null ? class$com$installshield$product$actions$DesktopIcon : (class$com$installshield$product$actions$DesktopIcon = LinuxProductServiceImpl.class$("com.installshield.product.actions.DesktopIcon"))).getName());
            if (productAction.getClass().isAssignableFrom(class$com$installshield$product$actions$DesktopIcon != null ? class$com$installshield$product$actions$DesktopIcon : (class$com$installshield$product$actions$DesktopIcon = LinuxProductServiceImpl.class$("com.installshield.product.actions.DesktopIcon"))) && (v = productAction.getExtendedProperties().get("linux.desktop.extra")) != null && v.getClass().isAssignableFrom(class$com$ibm$wizard$platform$linux$LinuxDesktopIconExtra != null ? class$com$ibm$wizard$platform$linux$LinuxDesktopIconExtra : (class$com$ibm$wizard$platform$linux$LinuxDesktopIconExtra = LinuxProductServiceImpl.class$("com.ibm.wizard.platform.linux.LinuxDesktopIconExtra")))) {
                productAction.getServices().setValue("linux.desktop.extra.showTerminal", new Boolean(((LinuxDesktopIconExtra)v).getShowTerminal()));
            }
        }
        catch (Throwable throwable) {}
        super.installProductAction(productAction, productActionSupport);
    }

    private boolean integrateWithRPM() {
        try {
            RegistryService registryService = (RegistryService)this.getServices().getService("registryService");
            String string = ServiceFactory.getCurrentImplementorType(registryService);
            return string.endsWith("LinuxRegistryServiceImpl");
        }
        catch (ServiceException serviceException) {
            return false;
        }
    }

    protected void postInstallProduct(ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        block9: {
            super.postInstallProduct(productTree, productActionSupport);
            if (!this.isCurrentUserAdmin || !this.integrateWithRPM()) break block9;
            boolean bl = false;
            try {
                if (this.isHostRPMSupported) {
                    Object object;
                    String string = FileUtils.createTempFile();
                    String string2 = null;
                    int n = 0;
                    while (n < specFiles.size()) {
                        string2 = (String)specFiles.elementAt(n);
                        object = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf(46));
                        if (!RPM.queryRPMDB((String)object).startsWith((String)object)) {
                            RPM.createRPMPackage(string2, string);
                            RPM.registerRPMPackage(string);
                            if (RPM.queryRPMDB((String)object).startsWith((String)object)) {
                                GenericLinuxCommands.linuxPPKDebugPrint("The RPM package " + (String)object + " entered into RPM Db");
                                FileUtils.deleteTempFile(string);
                            } else {
                                String string3 = "The installer could not successfully add the product information into the RPM database. Installation will continue as this is not critical to the installation of the product.";
                                this.getServices().logEvent(this, "wrn", string3);
                            }
                        } else {
                            GenericLinuxCommands.linuxPPKDebugPrint("The RPM Package " + (String)object + " is already present in the RPM DB. Duplicates can not be entered.");
                        }
                        ++n;
                    }
                    if (System.getProperty("is.debug") != null) break block9;
                    object = specFiles.elements();
                    while (object.hasMoreElements()) {
                        new File((String)object.nextElement()).delete();
                    }
                    break block9;
                }
                GenericLinuxCommands.linuxPPKDebugPrint("The RPM Package is not entered into RPM DB. RPM is not installed or not supported.");
            }
            catch (Exception exception) {
                if (System.getProperty("is.debug") == null) break block9;
                exception.printStackTrace();
            }
        }
    }

    protected boolean preInstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport) throws ServiceException {
        boolean bl = super.preInstallProductComponent(productBean, productActionSupport);
        if (bl && this.isCurrentUserAdmin && this.integrateWithRPM() && productBean instanceof ProductComponent && this.isHostRPMSupported) {
            this.commandLineInterface.makeDirectory(specFileDir);
            this.createSpecFile((ProductComponent)productBean);
        }
        return bl;
    }

    public void productActionPerformed(ProductActionEvent productActionEvent) {
    }

    protected void uninstallProductComponent(ProductBean productBean, ProductActionSupport productActionSupport, int n) throws ServiceException {
        String string = null;
        super.uninstallProductComponent(productBean, productActionSupport, n);
        if (this.integrateWithRPM() && this.isCurrentUserAdmin && productBean instanceof ProductComponent) {
            String string2 = String.valueOf(this.getFullPackageName((ProductComponent)productBean)) + "-" + this.getPackageVersion((ProductComponent)productBean) + "-" + this.getPackageRelease((ProductComponent)productBean);
            GenericLinuxCommands.linuxPPKDebugPrint("querying the RPM DB for package " + string2);
            string = RPM.queryRPMDB(string2);
            if (string.startsWith(string2)) {
                RPM.removeRPMPackage(string2);
                string = RPM.queryRPMDB(string2);
                if (!string.startsWith(string2)) {
                    GenericLinuxCommands.linuxPPKDebugPrint("removed the package " + string2 + " from RPM DB");
                } else {
                    this.getServices().logEvent(this, "wrn", "The RPM package " + string2 + " could not be removed from RPM");
                }
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("query result = " + string + " doesn't match " + string2);
            }
        }
    }
}

