/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.CommandLineListener;
import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.JProcessCommand;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.utils.RPM;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.service.registry.PureJavaRegistryServiceImpl;
import com.installshield.product.service.registry.RegistryServiceImplementor;
import com.installshield.wizard.service.ServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class LinuxRegistryServiceImpl
extends PureJavaRegistryServiceImpl
implements RegistryServiceImplementor {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    private static String SH = "sh";
    private static String C = "-c";
    private static String RPMQ = "rpm -q ";
    private static String RPMQUERY = "rpm -q --queryformat ";
    private static String NAME = "'%{NAME}-%{VERSION}-%{RELEASE}'";
    private static String VENDOR = "'%{VENDOR}'";
    private static String URL = "'%{URL}'";
    private static String DESCRIPTION = "'%{DESCRIPTION}'";
    GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();

    private void debug(String string) {
        if (System.getProperty("is.debug.linux.registry") != null) {
            System.out.println(string);
        }
    }

    private String[] getCommandArray(String string) {
        String[] stringArray = new String[]{SH, C, string};
        return stringArray;
    }

    public int getInstalledInstance(SoftwareObjectKey softwareObjectKey, String string) throws ServiceException {
        int n = super.getInstalledInstance(softwareObjectKey, string);
        if (n == -1) {
            CommandLineListener commandLineListener = new CommandLineListener();
            String string2 = String.valueOf(RPMQ) + softwareObjectKey.getUID() + "-" + softwareObjectKey.getVersion().getMajor() + "." + softwareObjectKey.getVersion().getMinor() + "-" + softwareObjectKey.getVersion().getMaintenance();
            String[] stringArray = this.getCommandArray(string2);
            JProcessCommand jProcessCommand = new JProcessCommand(commandLineListener, stringArray, null, true);
            if (commandLineListener.getReturnCode() == 0) {
                n = 1;
            }
        }
        return n;
    }

    public String getName() {
        return "LinuxRegistryServiceImpl";
    }

    public int getNewestInstance(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        int n = this.getInstalledInstance(softwareObjectKey, "");
        if (n != -1) {
            SoftwareObjectKey softwareObjectKey2 = (SoftwareObjectKey)softwareObjectKey.clone();
            do {
                softwareObjectKey2.setInstance(softwareObjectKey2.getInstance() + 1);
            } while (this.getInstalledInstance(softwareObjectKey2, "") != -1);
            n = softwareObjectKey2.getInstance() - 1;
        }
        return n;
    }

    private String getPackageInfo(SoftwareObjectKey softwareObjectKey, String string) throws ServiceException {
        CommandLineListener commandLineListener = new CommandLineListener();
        String[] stringArray = this.getCommandArray(String.valueOf(RPMQUERY) + string + " " + softwareObjectKey.getUID() + "-" + softwareObjectKey.getVersion().getMajor() + "." + softwareObjectKey.getVersion().getMinor() + "-" + softwareObjectKey.getVersion().getMaintenance());
        JProcessCommand jProcessCommand = new JProcessCommand(commandLineListener, stringArray, null, true);
        if (commandLineListener.getReturnCode() != 0) {
            this.debug("process return code = " + commandLineListener.getReturnCode());
            throw new ServiceException(315, commandLineListener.getOutput());
        }
        return commandLineListener.getOutput();
    }

    public SoftwareObject getSoftwareObject(SoftwareObjectKey softwareObjectKey) throws ServiceException {
        Object object;
        SoftwareObject softwareObject = super.getSoftwareObject(softwareObjectKey);
        if (softwareObject != null) {
            return softwareObject;
        }
        String string = String.valueOf(RPMQ) + softwareObjectKey.getUID() + "-" + softwareObjectKey.getVersion().getMajor() + "." + softwareObjectKey.getVersion().getMinor() + "-" + softwareObjectKey.getVersion().getMaintenance();
        String[] stringArray = this.getCommandArray(string);
        try {
            object = Runtime.getRuntime().exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                string2 = bufferedReader.readLine();
            }
            ((Process)object).waitFor();
            if (((Process)object).exitValue() != 0) {
                return null;
            }
        }
        catch (IOException iOException) {
            System.out.println("Error in rpm query process in getSoftwareObject");
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error in process.waitFor().");
        }
        object = new GenericSoftwareObject();
        ((GenericSoftwareObject)object).setKey(softwareObjectKey);
        ((ProductBean)object).setDisplayName(softwareObjectKey.getUID());
        ((GenericSoftwareObject)object).setName(this.getPackageInfo(softwareObjectKey, NAME));
        ((GenericSoftwareObject)object).setVendor(this.getPackageInfo(softwareObjectKey, VENDOR));
        ((GenericSoftwareObject)object).setVendorWebsite(this.getPackageInfo(softwareObjectKey, URL));
        ((GenericSoftwareObject)object).setDescription(this.getPackageInfo(softwareObjectKey, DESCRIPTION));
        return object;
    }

    public int getSystemCompatibility() {
        int n = 0;
        RPM rPM = new RPM(Integer.toString(3), "");
        RPM rPM2 = new RPM(Integer.toString(4), "");
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            if (this.commandLineInterface.isHostRPMSupported(rPM)) {
                n = 5;
            } else if (this.commandLineInterface.isHostRPMSupported(rPM2)) {
                n = 5;
            }
        }
        if (System.getProperty("is.debug") != null) {
            System.out.println("rpmspec.debug - registry service - returning system compatability " + n);
        }
        return n;
    }

    private String getToken(String string, String string2, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return string3;
    }
}

