/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.LinuxPlatform;
import com.ibm.wizard.platform.linux.utils.LibraryLoader;
import com.ibm.wizard.platform.linux.utils.LinuxEnvironment;
import com.ibm.wizard.platform.linux.utils.ProcessEnvironmentVariableManager;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.common.environment.BashShellManager;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import java.io.File;
import java.io.IOException;

public class LinuxSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl {
    private static final String copyright = "(C) Copyright IBM Corporation 2000.";
    public static final String PLATFORM_ID = "linux";
    private GenericLinuxCommands commandLineInterface = new GenericLinuxCommands();
    private static final String systemCshScript = "/etc/.login";
    private static final String userCshScript = ".login";
    private static final String systemBourneScript = "/etc/profile";
    private static final String userBourneScript = ".profile";
    private static final String userBashProfileScript = ".bash_profile";
    private static final String userBashLoginScript = ".bash_login";
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private ProcessEnvironmentVariableManager currentProcessEnvVarManager;
    private static boolean envVarsCleanedUp;

    static {
        envVarsCleanedUp = false;
    }

    public void appendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.appendVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.appendVariable(string, string2, string3);
    }

    public void cleanup() throws ServiceException {
        if (!envVarsCleanedUp) {
            if (userEnvVarGroup != null) {
                userEnvVarGroup.makeUpdatePersistent();
            }
            if (systemEnvVarGroup != null) {
                systemEnvVarGroup.makeUpdatePersistent();
            }
            envVarsCleanedUp = true;
        }
    }

    public void deleteEnvironmentVariable(String string) throws ServiceException {
        this.deleteEnvironmentVariable(string, 2);
    }

    public void deleteEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.deleteVariable(string);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.deleteVariable(string);
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int n) throws ServiceException {
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = null;
        ScriptEnvironmentVariableManager scriptEnvironmentVariableManager = null;
        if (this.currentProcessEnvVarManager == null) {
            this.currentProcessEnvVarManager = new ProcessEnvironmentVariableManager();
        }
        try {
            if (n == 1 && System.getProperty("user.name").equals("root")) {
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String string = systemBourneScript;
                    if (new File(string).exists()) {
                        scriptEnvironmentVariableManager = new BourneShellManager(string);
                        scriptEnvironmentVariableManager.initialize();
                        systemEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if (new File(string = systemCshScript).exists()) {
                        scriptEnvironmentVariableManager = new CShellManager(string);
                        scriptEnvironmentVariableManager.initialize();
                        systemEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                }
                environmentVariableManagerGroup = systemEnvVarGroup;
            } else if (n == 2) {
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    File file = new File(System.getProperty("user.home"), userBourneScript);
                    if (file.exists()) {
                        scriptEnvironmentVariableManager = new BourneShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if ((file = new File(System.getProperty("user.home"), userBashProfileScript)).exists()) {
                        scriptEnvironmentVariableManager = new BashShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if ((file = new File(System.getProperty("user.home"), userBashLoginScript)).exists()) {
                        scriptEnvironmentVariableManager = new BashShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if ((file = new File(System.getProperty("user.home"), userCshScript)).exists()) {
                        scriptEnvironmentVariableManager = new CShellManager(file.getAbsolutePath());
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                }
                environmentVariableManagerGroup = userEnvVarGroup;
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return environmentVariableManagerGroup;
    }

    public String getEnvironmentVariable(String string) throws ServiceException {
        return LinuxEnvironment.getProcessEnvironmentVariable(string);
    }

    public String getName() {
        return "systemUtilService";
    }

    public String getOSServiceLevel() throws ServiceException {
        return this.commandLineInterface.getKernelVersion();
    }

    protected String getPlatformIdImpl() {
        return PLATFORM_ID;
    }

    public String getRawEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            return environmentVariableManagerGroup.getVariable(string);
        }
        return null;
    }

    public int getSystemCompatibility() {
        int n = 0;
        if (LinuxPlatform.isCompatibleWith(1, 0)) {
            n = 5;
        }
        return n;
    }

    protected void initialized() {
        super.initialized();
        LibraryLoader.loadLibrary(this.getServices());
    }

    public void prependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.prependVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.prependVariable(string, string2, string3);
    }

    public void setEnvironmentVariable(String string, String string2) throws ServiceException {
        this.setEnvironmentVariable(string, string2, 2);
    }

    public void setEnvironmentVariable(String string, String string2, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.setVariable(string, string2);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.setVariable(string, string2);
    }

    public void unAppendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.unAppendVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unAppendVariable(string, string2, string3);
    }

    public void unPrependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.unPrependVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
        this.currentProcessEnvVarManager.unPrependVariable(string, string2, string3);
    }

    private void verifyVariableName(String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.ibm.wizard.platform.linux.LinuxResources", "systemUtil.variableNameRequired"));
        }
    }
}

