/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.ibm.wizard.platform.linux.GenericLinuxDesktopManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.util.Properties;

class SuseKDEDesktopManager
extends GenericLinuxDesktopManager {
    static final String desktopRootSuffix = "/share/applnk/SuSE";
    static final String SUSEKDE = "SUSEKDE";
    private File suseSystemKDEdesktopRoot;
    private File suseUserKDEdesktopRoot;

    SuseKDEDesktopManager(WizardServices wizardServices) {
        super(wizardServices);
    }

    final String[] createDotDirectoryFileProps(String string, String string2) {
        String[] stringArray = new String[5];
        int n = 0;
        stringArray[n++] = "# KDE Config File";
        stringArray[n++] = "[KDE Desktop Entry]";
        stringArray[n++] = "Name=" + new File(string).getName();
        stringArray[n++] = "Icon=" + string2;
        stringArray[n] = "MiniIcon=" + string2;
        return stringArray;
    }

    final String[] createProgramShortCutProps(String string, String string2, String string3, String string4, String string5, Properties properties) {
        String[] stringArray = new String[12];
        int n = 0;
        stringArray[n++] = "# KDE Config File";
        stringArray[n++] = "[KDE Desktop Entry]";
        stringArray[n++] = "Exec=\"" + string + "\" " + string2;
        stringArray[n++] = "Icon=" + string3;
        stringArray[n++] = "MiniIcon=" + string3;
        stringArray[n++] = "Type=Application";
        stringArray[n++] = "DocPath=";
        stringArray[n++] = "Comment[en_US.ISO8859-1]=";
        stringArray[n++] = "Name=" + string4;
        stringArray[n++] = "Init=";
        stringArray[n++] = "Terminal=" + this.getShowTerminal();
        stringArray[n] = "Path=" + string5;
        return stringArray;
    }

    final File getDesktopRoot(String string) throws ServiceException {
        int n = this.resolveFolderContext(string);
        if (n == 4) {
            if (this.suseSystemKDEdesktopRoot == null) {
                String string2 = this.getSUSEKDEDesktopRoot(4);
                if (string2 == null) {
                    throw new ServiceException(1, "cannot resolve desktop root for SUSEKDE desktop manager");
                }
                this.suseSystemKDEdesktopRoot = new File(string2);
            }
            return this.suseSystemKDEdesktopRoot;
        }
        if (n == 8) {
            if (this.suseUserKDEdesktopRoot == null) {
                this.suseUserKDEdesktopRoot = new File(this.getSUSEKDEDesktopRoot(8));
            }
            return this.suseUserKDEdesktopRoot;
        }
        return null;
    }

    String getFileExtension() {
        return ".kdelnk";
    }

    public String getID() {
        return SUSEKDE;
    }

    private String getSUSEKDEDesktopRoot(int n) {
        String string = null;
        if (n == 4) {
            String string2 = "startkde";
            String string3 = new GenericLinuxCommands().locateExecutable(string2);
            if (string3 != null && string3.length() > 0 && string3.startsWith(File.separator)) {
                string = new File("/etc" + string3.substring(0, string3.indexOf("/bin")), desktopRootSuffix).getAbsolutePath();
            }
        } else if (n == 8) {
            string = new File(System.getProperty("user.home"), ".kde" + File.separator + desktopRootSuffix).getAbsolutePath();
        }
        return string;
    }

    public void removeDesktopFolder(String string, String string2) throws ServiceException {
        super.removeDesktopFolder(string, string2);
        ((SystemUtilService)this.services.getService("systemUtilService")).setLogoutRequired(true);
    }

    public void removeDesktopItem(String string, String string2, String string3) throws ServiceException {
        super.removeDesktopItem(string, string2, string3);
        ((SystemUtilService)this.services.getService("systemUtilService")).setLogoutRequired(true);
    }
}

