/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wizard.platform.linux.utils;

import com.ibm.wizard.platform.linux.GenericLinuxCommands;
import com.installshield.util.CommandResult;
import com.installshield.util.CommandUtils;
import com.installshield.util.FileUtils;
import com.installshield.util.MemoryProcessOutputHandler;
import com.installshield.util.ProcessExec;
import com.installshield.util.ProcessExecException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

public class RPM {
    public String major = "";
    public String minor = "";
    public String update = "";
    public String arch = "";
    public String OS = "";
    public static String RPM_VERSION = "RPM_VERSION";
    public static String RPMSPEC = "rpmspec";
    public static String RPMSPEC4 = "rpmspec4";
    private static final String spaceSeparator = new String(new byte[]{32});

    public RPM(String string, String string2) {
        this.major = string;
        this.minor = string2;
    }

    private static String RPMCommandLineInterface(String string) throws IOException, ProcessExecException {
        ProcessExec processExec = new ProcessExec("sh", new String[]{"-c", string});
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        processExec.setProcessOutputHandler(new MemoryProcessOutputHandler(byteArrayOutputStream, null));
        processExec.executeProcess();
        byteArrayOutputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static void createRPMPackage(String string, String string2) {
        try {
            String string3 = RPM.formatRPMBuildCommand(string, string2);
            if (string3 != null) {
                String string4 = RPM.RPMCommandLineInterface(string3);
                GenericLinuxCommands.linuxPPKDebugPrint(string4);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMBuildcommand. RPM package can not be created ");
            }
        }
        catch (Exception exception) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while creating RPM Package. ISMP Components will not be registered in RPM DB.");
            exception.printStackTrace();
        }
    }

    private static String formatRPMBuildCommand(String string, String string2) throws IOException, Exception {
        String string3 = "rpm";
        CommandResult commandResult = CommandUtils.executeCommand("sh", new String[]{"-c", "rpmbuild --version"});
        if (commandResult.getExitCode() == 0) {
            string3 = "rpmbuild";
        }
        File file = new File(string);
        if (string != null && file.exists()) {
            File file2 = new File(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string3).append(spaceSeparator);
            stringBuffer.append("--define").append(spaceSeparator);
            stringBuffer.append("'");
            stringBuffer.append("_rpmdir").append(spaceSeparator);
            stringBuffer.append(FileUtils.getParent(file2.getAbsolutePath()));
            stringBuffer.append("'").append(spaceSeparator);
            stringBuffer.append("--define").append(spaceSeparator);
            stringBuffer.append("'");
            stringBuffer.append("_rpmfilename").append(spaceSeparator);
            stringBuffer.append(FileUtils.getName(file2.getAbsolutePath()));
            stringBuffer.append("'").append(spaceSeparator);
            stringBuffer.append("-bb").append(spaceSeparator);
            string = file.getAbsolutePath();
            stringBuffer.append(string);
            string3 = stringBuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmbuildCommand = " + string3);
        return string3;
    }

    private static String formatRPMRemoveCommand(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rpm").append(spaceSeparator);
            stringBuffer.append("-e").append(spaceSeparator);
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmRemoveCommand = " + string2);
        return string2;
    }

    private static String formatRPMinstallCommand(String string) throws IOException {
        String string2 = null;
        File file = new File(string);
        if (string != null && file.exists()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rpm").append(spaceSeparator);
            stringBuffer.append("-i").append(spaceSeparator);
            string = file.getAbsolutePath();
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpminstallCommand = " + string2);
        return string2;
    }

    private static String formatRPMqueryCommand(String string) {
        String string2 = null;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("rpm").append(spaceSeparator);
            stringBuffer.append("-q").append(spaceSeparator);
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
        }
        GenericLinuxCommands.linuxPPKDebugPrint("rpmqueryCommand = " + string2);
        return string2;
    }

    public static boolean isHostRPMSupported() {
        boolean bl = false;
        try {
            String string = RPM.RPMCommandLineInterface("rpm --version");
            bl = string != null && string.length() > 0;
            GenericLinuxCommands.linuxPPKDebugPrint(string);
        }
        catch (Exception exception) {
            GenericLinuxCommands.linuxPPKDebugPrint("Host RPM is not supported. ISMP Components will not be registered in RPM DB.");
            exception.printStackTrace();
        }
        return bl;
    }

    public static String queryRPMDB(String string) {
        String string2 = "";
        try {
            String string3 = RPM.formatRPMqueryCommand(string);
            if (string3 != null) {
                string2 = RPM.RPMCommandLineInterface(string3);
                GenericLinuxCommands.linuxPPKDebugPrint(string2);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMQuerycommand. RPMDB can not be queried.");
            }
        }
        catch (Exception exception) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while querying RPMDB. RPMDB can not be queried for the RPM Package " + string);
            exception.printStackTrace();
        }
        return string2;
    }

    public static void registerRPMPackage(String string) {
        try {
            String string2 = RPM.formatRPMinstallCommand(string);
            if (string2 != null) {
                String string3 = RPM.RPMCommandLineInterface(string2);
                GenericLinuxCommands.linuxPPKDebugPrint(string3);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating RPMInstallcommand. ISMP Components will not be entered in RPM DB.");
            }
        }
        catch (Exception exception) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while installing RPM Package. ISMP Components is not entered in RPM DB.");
            exception.printStackTrace();
        }
    }

    public static void removeRPMPackage(String string) {
        try {
            String string2 = RPM.formatRPMRemoveCommand(string);
            if (string2 != null) {
                String string3 = RPM.RPMCommandLineInterface(string2);
                GenericLinuxCommands.linuxPPKDebugPrint(string3);
            } else {
                GenericLinuxCommands.linuxPPKDebugPrint("Error creating rpm remove command. RPM package can not be removed.");
            }
        }
        catch (Exception exception) {
            GenericLinuxCommands.linuxPPKDebugPrint("Process error while removing RPM Package. ISMP Components is not removed from RPM DB.");
            exception.printStackTrace();
        }
    }
}

