/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceReader;
import com.installshield.util.MD5;
import com.installshield.util.URLUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

public class URLResourceReader
implements ResourceReader {
    private URL url;
    private int hashCode;
    private int size = -1;
    private long date = -1L;

    public URLResourceReader(String string) throws MalformedURLException {
        this(new URL(string));
    }

    public URLResourceReader(URL uRL) {
        this.url = uRL;
        this.createHash(uRL.toExternalForm());
    }

    public void close(InputStream inputStream) throws IOException {
        inputStream.close();
    }

    private void createHash(String string) {
        MD5 mD5 = new MD5();
        mD5.write(string.getBytes());
        this.hashCode = mD5.hashCode();
    }

    public Date getDate() {
        try {
            this.verifyURLData();
            if (this.date >= 0L) {
                return new Date(this.date);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public String getId() {
        return this.url.toExternalForm();
    }

    public int getSize() throws IOException {
        this.verifyURLData();
        return this.size;
    }

    public static String getTypeDescription() {
        return "file resources";
    }

    public int hashCode() {
        return this.hashCode;
    }

    public InputStream open() throws IOException {
        if (this.getSize() > 0 || !this.url.getProtocol().equals("file")) {
            return this.url.openStream();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public String toString() {
        return "URLResourceReader for " + this.url.toExternalForm();
    }

    private void verifyURLData() throws IOException {
        if (this.size == -1) {
            String string = this.url.getProtocol();
            if (string.equals("file") || string.equals("ismpfile")) {
                String string2 = string.equals("ismpfile") ? URLUtils.decode(this.url.getFile()) : this.url.getFile();
                File file = new File(string2);
                if (!file.exists()) {
                    throw new FileNotFoundException("The system cannot find the file specified: " + string2);
                }
                this.date = file.lastModified();
                this.size = (int)file.length();
            } else {
                URLConnection uRLConnection = this.url.openConnection();
                uRLConnection.connect();
                this.size = Math.max(0, uRLConnection.getContentLength());
                this.date = uRLConnection.getDate();
            }
        }
    }
}

