/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.LauncherExtra;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.jvm.Instructions;
import com.installshield.util.jvm.JVMFile;
import com.installshield.util.jvm.LaunchScript;
import com.installshield.util.jvm.LauncherWriter;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.jvm.JVMService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;

public class Launcher
extends ProductAction {
    public static final int EST_TIME_TO_INSTALL = 10;
    private String title = "";
    private String mainClass = "";
    private String mainClassArgs = "";
    private String[] classPath = new String[0];
    private String[] systemProperties = new String[0];
    private String javaArgs = "";
    private String jvmId = "jvm";
    private String installedFileName = null;
    private Object wrapper = null;
    private byte launcherPurpose = 1;
    static /* synthetic */ Class class$com$installshield$product$actions$LauncherExtra;

    public Launcher() {
    }

    Launcher(Object object) {
        this.wrapper = object;
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        if (this.jvmId == null || this.jvmId.trim().length() == 0) {
            productBuilderSupport.logEvent(this.getEventOrigin(), "wrn", "JVM Id is not specified -- this property must be specified to create a launcher");
        }
        if (this.title == null || this.title.length() <= 0) {
            productBuilderSupport.logEvent(this.getEventOrigin(), "wrn", "Title is not specified -- the title bar in the launcher UI will be blank");
        }
        Enumeration enumeration = this.getExtras();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            LauncherExtra launcherExtra = (LauncherExtra)enumeration.nextElement();
            if (launcherExtra.getFileName() == null || launcherExtra.getFileName().length() <= 0) {
                productBuilderSupport.logEvent(this.getEventOrigin(), "err", "File Name for " + launcherExtra.getPlatformId() + " is not specified -- this property must " + "be specified to create a launcher");
            }
            bl = true;
        }
        if (this.isActive() && !bl) {
            productBuilderSupport.logEvent(this.getEventOrigin(), "wrn", "No platform specific launcher properties included -- will not create a launcher at runtime");
        }
        try {
            productBuilderSupport.putPackage("com.installshield.util.jvm");
            productBuilderSupport.putRequiredService("jvmService");
            productBuilderSupport.putRequiredService("fileService");
            productBuilderSupport.putClass((class$com$installshield$product$actions$LauncherExtra != null ? class$com$installshield$product$actions$LauncherExtra : (class$com$installshield$product$actions$LauncherExtra = Launcher.class$("com.installshield.product.actions.LauncherExtra"))).getName());
        }
        catch (IOException iOException) {
            productBuilderSupport.logEvent(this.getEventOrigin(), "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public int getEstimatedTimeToInstall() {
        return 10;
    }

    public int getEstimatedTimeToReplace() {
        return this.getEstimatedTimeToInstall();
    }

    private Object getEventOrigin() {
        return this.wrapper != null ? this.wrapper : this;
    }

    private LauncherExtra getExtra(String string) {
        LauncherExtra launcherExtra = null;
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements() && launcherExtra == null) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (v == null || !(v instanceof LauncherExtra) || !string.equals(((LauncherExtra)v).getPlatformId())) continue;
                launcherExtra = (LauncherExtra)v;
            }
        }
        return launcherExtra;
    }

    private Enumeration getExtras() {
        Vector<LauncherExtra> vector = new Vector<LauncherExtra>();
        Dictionary dictionary = this.getExtendedProperties();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!(dictionary.get(string) instanceof LauncherExtra)) continue;
            vector.addElement((LauncherExtra)dictionary.get(string));
        }
        return vector.elements();
    }

    public String getInstalledFileName() {
        return this.installedFileName;
    }

    public String getJVMId() {
        return this.jvmId;
    }

    public String getJavaArguments() {
        return this.javaArgs;
    }

    byte getLauncherPurpose() {
        return this.launcherPurpose;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainClassArguments() {
        return this.mainClassArgs;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        try {
            JVMService jVMService = (JVMService)this.getService("jvmService");
            LauncherExtra launcherExtra = this.getExtra(jVMService.getPlatformId());
            if (launcherExtra != null) {
                String string = this.getProductTree().getInstallLocation(this);
                File file = new File(string, this.resolveString(launcherExtra.getFileName()));
                return this.getRequiredBytes(launcherExtra, file.getAbsolutePath());
            }
            return new RequiredBytesTable();
        }
        catch (ServiceException serviceException) {
            throw new ProductException(serviceException);
        }
    }

    public RequiredBytesTable getRequiredBytes(LauncherExtra launcherExtra, String string) throws ProductException {
        String string2 = FileUtils.getParent(string);
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        try {
            Object object;
            URL uRL = this.getResource(launcherExtra.getPlatformLauncherResource());
            if (uRL != null) {
                object = uRL.openStream();
                requiredBytesTable.addBytes(string2, ((InputStream)object).available());
                ((InputStream)object).close();
            }
            object = this.getResource(launcherExtra.getVerifyClassResource());
            if (uRL != null) {
                InputStream inputStream = ((URL)object).openStream();
                requiredBytesTable.addBytes(string2, inputStream.available());
                inputStream.close();
            }
            return requiredBytesTable;
        }
        catch (IOException iOException) {
            throw new ProductException(iOException);
        }
    }

    public RequiredBytesTable getRequiredBytesForReplace() throws ProductException {
        return this.getRequiredBytes();
    }

    public String[] getSystemProperties() {
        return this.systemProperties;
    }

    public String getTitle() {
        return this.title;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        try {
            JVMService jVMService = (JVMService)this.getService("jvmService");
            LauncherExtra launcherExtra = this.getExtra(jVMService.getPlatformId());
            if (launcherExtra != null) {
                this.install(launcherExtra, productActionSupport);
            } else {
                this.logEvent(this, "msg1", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Launcher.extraNotFound"));
            }
            productActionSupport.getOperationState().updatePercentComplete(10, 10L, 10L);
        }
        catch (ProductException productException) {
            throw productException;
        }
        catch (Exception exception) {
            this.logEvent(this.getEventOrigin(), "err", exception);
            throw new ProductException(exception);
        }
    }

    private void install(LauncherExtra launcherExtra, ProductActionSupport productActionSupport) throws ProductException, ServiceException, IOException {
        String string = this.getProductTree().getInstallLocation(this);
        File file = new File(string, this.resolveString(launcherExtra.getFileName()));
        this.install(launcherExtra, file.getAbsolutePath(), productActionSupport);
    }

    public void install(LauncherExtra launcherExtra, String string, ProductActionSupport productActionSupport) throws ProductException, ServiceException, IOException {
        JVMService jVMService = (JVMService)this.getService("jvmService");
        if (!jVMService.isJVMDefined(this.jvmId)) {
            this.installFailed("jvm \"" + this.jvmId + "\" is not defined");
        }
        String string2 = jVMService.getJVMFile(this.jvmId);
        LauncherWriter launcherWriter = launcherExtra.createLauncherWriter();
        launcherWriter.setLauncherPurpose(this.launcherPurpose);
        launcherWriter.setFileName(string);
        launcherWriter.setLauncherStub(this.getResource(launcherExtra.getPlatformLauncherResource()));
        launcherWriter.setVerifyClass(this.getResource(launcherExtra.getVerifyClassResource()));
        LaunchScript launchScript = launcherExtra.createLaunchScript();
        launcherWriter.setLaunchScript(launchScript);
        launchScript.setTitle(this.resolveString(this.title));
        launchScript.setMainClass(this.resolveString(this.mainClass));
        launchScript.setMainClassArgs(this.resolveString(this.mainClassArgs));
        launchScript.setClassPath(this.resolveStrings(launchScript.createLaunchScriptClassPath(this.classPath)));
        launchScript.setSystemProperties(launchScript.createLaunchScriptSystemProperties(this.systemProperties, this.getServices()));
        launchScript.setOtherArgs(this.resolveString(this.javaArgs));
        launchScript.setConsoleVisible(launcherExtra.getShowConsole());
        launchScript.setAutoSetWorkingDir(false);
        JVMFile jVMFile = new JVMFile(string2, this.getServices());
        launcherWriter.addJVMFile(jVMFile);
        String[] stringArray = jVMService.getJVMSearchFiles(this.jvmId);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                launcherWriter.addJVMFile(new JVMFile(stringArray[n], this.getServices()));
                ++n;
            }
        }
        Instructions instructions = launcherExtra.createInstructions();
        launcherWriter.setInstructions(instructions);
        launcherExtra.configureInstructions(instructions, launcherExtra.getLauncherUIDisplayTime(), launcherWriter.getLauncherEntryIndex(jVMFile.getType(), 0));
        String[] stringArray2 = FileUtils.createDirs(new File(FileUtils.getParent(string)));
        int n = 0;
        while (n < stringArray2.length) {
            productActionSupport.putInstalledDirectory(stringArray2[n]);
            ++n;
        }
        this.setInstalledFileName(string);
        launcherWriter.write();
        FileService fileService = (FileService)this.getServices().getService("fileService");
        fileService.setFileExecutable(string);
    }

    private void installFailed(String string) throws ProductException {
        throw new ProductException(601, string);
    }

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        this.install(productActionSupport);
    }

    private String[] resolveStrings(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = this.resolveString(stringArray[n]);
            ++n;
        }
        return stringArray2;
    }

    public void setClassPath(String[] stringArray) {
        this.classPath = stringArray;
    }

    public void setInstalledFileName(String string) {
        this.installedFileName = string;
    }

    public void setJVMId(String string) {
        this.jvmId = string;
    }

    public void setJavaArguments(String string) {
        this.javaArgs = string;
    }

    void setLauncherPurpose(byte by) {
        this.launcherPurpose = by;
    }

    public void setMainClass(String string) {
        this.mainClass = string;
    }

    public void setMainClassArguments(String string) {
        this.mainClassArgs = string;
    }

    public void setSystemProperties(String[] stringArray) {
        this.systemProperties = stringArray;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void uninstall(ProductActionSupport productActionSupport) {
        try {
            FileService fileService;
            JVMService jVMService = (JVMService)this.getService("jvmService");
            LauncherExtra launcherExtra = this.getExtra(jVMService.getPlatformId());
            if (launcherExtra != null && this.installedFileName != null && this.installedFileName.length() > 0 && (fileService = (FileService)this.getService("fileService")).fileExists(this.installedFileName)) {
                fileService.deleteFile(this.installedFileName);
            }
        }
        catch (ServiceException serviceException) {
            productActionSupport.logEvent(this.getEventOrigin(), "err", serviceException);
        }
    }
}

