/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.BaseProductTreeIterator;
import com.installshield.product.DynamicProductReference;
import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.util.Log;
import com.installshield.wizard.service.ServiceException;
import java.util.Hashtable;

public class MultiProductTreeIterator
implements FilteredProductTreeIterator {
    public static final String ITERATOR_KEY = "iterator";
    private BaseProductTreeIterator iter;
    private ProductTreeSource productTreeSource;
    private Log log;
    private Hashtable roots = new Hashtable();
    private Hashtable productRefs = new Hashtable();

    public MultiProductTreeIterator(BaseProductTreeIterator baseProductTreeIterator, ProductTreeSource productTreeSource, Log log) {
        this.iter = baseProductTreeIterator;
        this.productTreeSource = productTreeSource;
        this.log = log;
        this.roots.put(baseProductTreeIterator.getRoot().getProductTree(), baseProductTreeIterator.getRoot());
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    private ProductBean dereferenceNext(DynamicProductReference dynamicProductReference) throws ProductException {
        this.updateIterator(dynamicProductReference);
        ProductBean productBean = this.iter.getNext(this.iter.begin());
        return productBean == this.iter.end() ? null : productBean;
    }

    private ProductBean dereferencePrevious(DynamicProductReference dynamicProductReference) throws ProductException {
        this.updateIterator(dynamicProductReference);
        ProductBean productBean = this.iter.getPrevious(this.iter.end());
        return productBean == this.iter.begin() ? null : productBean;
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2;
        block7: {
            DynamicProductReference dynamicProductReference;
            ProductTree productTree = productBean.getProductTree();
            if (productTree != null && (productBean2 = (ProductBean)this.roots.get(productBean.getProductTree())) != null && productBean2 != this.iter.getRoot()) {
                this.iter.setRoot(productBean2);
            }
            if ((productBean2 = this.iter.getNext(productBean)) instanceof DynamicProductReference) {
                try {
                    ProductBean productBean3 = this.dereferenceNext((DynamicProductReference)productBean2);
                    if (productBean3 == null) {
                        productBean2 = this.getNext(productBean2);
                        break block7;
                    }
                    productBean2 = productBean3;
                }
                catch (ProductException productException) {
                    this.logError(productException);
                    productBean2 = this.getNext(productBean2);
                }
            } else if (productBean2 == this.iter.end() && productTree != null && (dynamicProductReference = (DynamicProductReference)this.productRefs.get(productBean.getProductTree())) != null) {
                productBean2 = this.getNext(dynamicProductReference);
            }
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2;
        block7: {
            DynamicProductReference dynamicProductReference;
            ProductTree productTree = productBean.getProductTree();
            if (productTree != null && (productBean2 = (ProductBean)this.roots.get(productBean.getProductTree())) != null && productBean2 != this.iter.getRoot()) {
                this.iter.setRoot(productBean2);
            }
            if ((productBean2 = this.iter.getPrevious(productBean)) instanceof DynamicProductReference) {
                try {
                    ProductBean productBean3 = this.dereferencePrevious((DynamicProductReference)productBean2);
                    if (productBean3 == null) {
                        productBean2 = this.getPrevious(productBean2);
                        break block7;
                    }
                    productBean2 = productBean3;
                }
                catch (ProductException productException) {
                    this.logError(productException);
                    productBean2 = this.getPrevious(productBean2);
                }
            } else if (productBean2 == this.iter.begin() && productTree != null && (dynamicProductReference = (DynamicProductReference)this.productRefs.get(productTree)) != null) {
                productBean2 = this.getPrevious(dynamicProductReference);
            }
        }
        return productBean2;
    }

    private void logError(Exception exception) {
        if (this.log != null) {
            this.log.logEvent(this, "err", exception);
        } else {
            exception.printStackTrace();
        }
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }

    private void updateIterator(DynamicProductReference dynamicProductReference) throws ProductException {
        try {
            ProductTree productTree = this.productTreeSource.getProductTree(dynamicProductReference.getInstaller(), "/product.xml");
            this.roots.put(productTree, productTree.getRoot());
            this.productRefs.put(productTree, dynamicProductReference);
            this.iter.setRoot(productTree.getRoot());
        }
        catch (ServiceException serviceException) {
            throw new ProductException(serviceException);
        }
    }
}

