/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.service.product;

import com.installshield.product.DynamicSuite;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductException;
import com.installshield.product.ProductTree;
import com.installshield.product.ProductTreeIterator;
import com.installshield.product.ProductTreeIteratorFactory;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.SoftwareObject;
import com.installshield.product.StaticSuite;
import com.installshield.product.UninstallProductAction;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerJVMResolution;
import com.installshield.product.actions.UninstallerLauncher;
import com.installshield.product.service.product.InstallableObjectVisitor;
import com.installshield.product.service.product.ProductTreeSource;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.util.Log;
import com.installshield.wizard.service.ServiceException;

public class RequiredBytes
extends InstallableObjectVisitor {
    private static final String DEBUG_REQUIREDBYTES = "is.debug.requiredbytes";
    static /* synthetic */ Class class$com$installshield$product$Product;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Object getDefaultResult() {
        return new RequiredBytesTable();
    }

    public RequiredBytesTable getEstimatedRequiredBytes(ProductBean productBean, ProductTree productTree, ProductTreeSource productTreeSource, RegistryService registryService, Log log) throws ServiceException {
        Object object = this.getDefaultResult();
        if (productBean instanceof DynamicSuite) {
            ProductTreeIterator productTreeIterator = ProductTreeIteratorFactory.createDynamicSuiteProductIterator(productTree, productTreeSource, log);
            ProductBean productBean2 = productTreeIterator.getNext(productTreeIterator.begin());
            while (this.shouldContinue(object) && productBean2 != productTreeIterator.end()) {
                if (productBean2 != productBean) {
                    RequiredBytesTable requiredBytesTable = new RequiredBytes().getEstimatedRequiredBytes(productBean2, productBean2.getProductTree(), productTreeSource, registryService, log);
                    if (System.getProperty(DEBUG_REQUIREDBYTES) != null) {
                        System.out.println("Required bytes for " + productBean2.getBeanId() + " - " + productBean2.getClass().getName());
                        System.out.println("    " + ((Object)requiredBytesTable).toString());
                    }
                    object = this.processNewResult(object, requiredBytesTable);
                }
                productBean2 = productTreeIterator.getNext(productBean2);
            }
        } else {
            Object object2 = this.visitProductBeans(productBean, productTreeSource, null, registryService, log);
            object = this.processNewResult(object, object2);
        }
        return (RequiredBytesTable)object;
    }

    boolean getResolveProductReferences() {
        return true;
    }

    Object getResultForAppendProductAction(ProductAction productAction, SoftwareObject softwareObject, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        return this.getResultForProductAction(productAction, productActionSupport);
    }

    Object getResultForProductAction(ProductAction productAction, ProductActionSupport productActionSupport) throws ServiceException {
        try {
            RequiredBytesTable requiredBytesTable = productAction.getRequiredBytes();
            if (System.getProperty(DEBUG_REQUIREDBYTES) != null) {
                System.out.println("Required bytes for installing " + productAction.getBeanId() + " - " + productAction.getClass().getName());
                System.out.println("    " + requiredBytesTable.toString());
            }
            return requiredBytesTable;
        }
        catch (ProductException productException) {
            throw new ServiceException(productException);
        }
    }

    Object getResultForRemoveProductAction(SoftwareObject softwareObject, UninstallProductAction uninstallProductAction, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        return this.getDefaultResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getResultForReplaceProductAction(ProductAction productAction, ProductAction productAction2, SoftwareObject softwareObject, ProductTree productTree, ProductActionSupport productActionSupport) throws ServiceException {
        RequiredBytesTable requiredBytesTable = null;
        if (softwareObject.getInstallStatus() != 3) return (RequiredBytesTable)this.getResultForProductAction(productAction2, productActionSupport);
        try {
            requiredBytesTable = productAction2.getRequiredBytesForReplace();
            if (System.getProperty(DEBUG_REQUIREDBYTES) == null) return requiredBytesTable;
            System.out.println("Required bytes for replacing " + productAction2.getBeanId() + " - " + productAction2.getClass().getName());
            System.out.println("    " + ((Object)requiredBytesTable).toString());
            return requiredBytesTable;
        }
        catch (ProductException productException) {
            throw new ServiceException(productException);
        }
    }

    private RequiredBytesTable getUninstallerSize(ProductTree productTree) throws ProductException {
        UninstallerLauncher uninstallerLauncher;
        UninstallerJVMResolution uninstallerJVMResolution;
        UninstallerArchive uninstallerArchive;
        if (productTree.getUninstallTree() == null) {
            uninstallerArchive = productTree.getUninstallerArchive();
            uninstallerJVMResolution = productTree.getUninstallerJVMResolution();
            uninstallerLauncher = productTree.getUninstallerLauncher();
        } else {
            uninstallerArchive = productTree.getUninstallTree().getUninstallerArchive();
            uninstallerJVMResolution = productTree.getUninstallTree().getUninstallerJVMResolution();
            uninstallerLauncher = productTree.getUninstallTree().getUninstallerLauncher();
        }
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        requiredBytesTable.addBytes(uninstallerArchive.getRequiredBytes());
        if (uninstallerJVMResolution.isActive()) {
            requiredBytesTable.addBytes(uninstallerJVMResolution.getRequiredBytes());
            if (uninstallerLauncher.isActive() && uninstallerLauncher.getInstalledFileName() == null) {
                requiredBytesTable.addBytes(uninstallerLauncher.getRequiredBytes());
            }
        }
        return requiredBytesTable;
    }

    Object processNewResult(Object object, Object object2) {
        RequiredBytesTable requiredBytesTable = (RequiredBytesTable)object;
        if (object2 != null) {
            requiredBytesTable.addBytes((RequiredBytesTable)object2);
        }
        return requiredBytesTable;
    }

    Object visitSoftwareObject(ProductBean productBean, ProductTreeSource productTreeSource, ProductActionSupport productActionSupport, RegistryService registryService, Log log) throws ServiceException {
        Object object;
        block2: {
            object = super.visitSoftwareObject(productBean, productTreeSource, productActionSupport, registryService, log);
            if (!(productBean instanceof StaticSuite) && productBean.getClass() != (class$com$installshield$product$Product != null ? class$com$installshield$product$Product : (class$com$installshield$product$Product = RequiredBytes.class$("com.installshield.product.Product"))) || productBean != productBean.getProductTree().getRoot()) break block2;
            try {
                RequiredBytesTable requiredBytesTable = this.getUninstallerSize(productBean.getProductTree());
                ((RequiredBytesTable)object).addBytes(requiredBytesTable);
            }
            catch (ProductException productException) {
                log.logEvent(this, "err", productException);
                log.logEvent(this, "wrn", "unable to include required bytes for uninstaller");
            }
        }
        return object;
    }
}

