/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.OperationRejectedException;
import com.installshield.wizard.CancelableWizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.progress.StandardProgressRenderer;
import java.io.IOException;

public class InstallAction
extends CancelableWizardAction {
    private String productURL = "/product.xml";
    private OperationKey key = null;
    private WizardUI ui = null;
    static /* synthetic */ Class class$com$installshield$wizardx$progress$StandardProgressRenderer;

    public InstallAction() {
        this.setCancelable(true);
        this.setProgressRenderer(new StandardProgressRenderer());
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("productService");
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$progress$StandardProgressRenderer != null ? class$com$installshield$wizardx$progress$StandardProgressRenderer : (class$com$installshield$wizardx$progress$StandardProgressRenderer = InstallAction.class$("com.installshield.wizardx.progress.StandardProgressRenderer"))).getName());
            new StandardProgressRenderer().build(wizardBuilderSupport);
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public void cancel() throws OperationRejectedException {
        block2: {
            super.cancel();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.cancelOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        this.ui = wizardBeanEvent.getUserInterface();
        try {
            ProductService productService = (ProductService)this.getService("productService");
            this.key = productService.installProduct(this.productURL);
            while (!productService.isOperationEnded(this.key)) {
                PropertyAccessible propertyAccessible;
                if (this.getState().isSuspended()) {
                    this.getState().setStatusDescription(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "UninstallAction.operationSuspended"));
                    PropertyAccessible propertyAccessible2 = propertyAccessible = this.getState();
                    synchronized (propertyAccessible2) {
                        try {
                            propertyAccessible.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.getState().update(productService.getOperationProgress(this.key));
                propertyAccessible = this;
                synchronized (propertyAccessible) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new Error();
                    }
                }
            }
            this.getState().update(productService.getOperationProgress(this.key));
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public void resume() {
        block2: {
            super.resume();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.resumeOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void suspend() throws OperationRejectedException {
        block2: {
            super.suspend();
            if (this.key == null) break block2;
            try {
                ProductService productService = (ProductService)this.getService("productService");
                productService.suspendOperation(this.key);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
    }
}

