/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.util.rex.Rex;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardSequence;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Method;

public class SetupTypeSequence
extends WizardSequence {
    private String setupTypePanel = "";
    private String setupType = "";

    private PropertyDescriptor getPropertyDescriptor(WizardBean wizardBean, String string) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(wizardBean.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getName().equals(string)) {
                    return propertyDescriptorArray[n];
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
        return null;
    }

    public String getSetupType() {
        return this.setupType;
    }

    public String getSetupTypePanel() {
        return this.setupTypePanel;
    }

    private Object getValue(WizardBean wizardBean, PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getReadMethod();
        if (method != null && method.getParameterTypes().length == 0) {
            try {
                return method.invoke((Object)wizardBean, new Object[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public boolean isActive() {
        try {
            PropertyDescriptor propertyDescriptor;
            WizardBean wizardBean = this.getWizardTree().findWizardBean(this.getWizardTree().getRoot(), this.getSetupTypePanel());
            if (wizardBean != null && (propertyDescriptor = this.getPropertyDescriptor(wizardBean, "selectedSetupTypeId")) != null) {
                PropertyEditor propertyEditor = PropertyEditorManager.findEditor(propertyDescriptor.getPropertyType());
                Object object = this.getValue(wizardBean, propertyDescriptor);
                if (object != null) {
                    propertyEditor.setValue(object);
                    String string = propertyEditor.getAsText();
                    return Rex.matches(string, this.getSetupType());
                }
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
        return false;
    }

    public void setSetupType(String string) {
        this.setupType = string;
    }

    public void setSetupTypePanel(String string) {
        this.setupTypePanel = string;
    }
}

