/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Progress;

public class GenericProgress
implements Progress {
    private String title = "";
    private String statusDescription = "";
    private String statusDetail = "";
    private int percentComplete = 0;
    private boolean redisplayProgress = false;
    private String lastMessage = null;

    public GenericProgress() {
    }

    public GenericProgress(Progress progress) {
        this.update(progress);
    }

    public void clear() {
        this.title = "";
        this.statusDescription = "";
        this.statusDetail = "";
        this.percentComplete = 0;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public boolean getRedisplayProgress() {
        return this.redisplayProgress;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getTitle() {
        return this.title;
    }

    public void incrementProgress(int n) {
        this.setPercentComplete(this.getPercentComplete() + n);
    }

    public void setLastMessage(String string) {
        this.lastMessage = string;
    }

    public void setPercentComplete(int n) {
        this.percentComplete = n;
    }

    public void setPercentComplete(long l, long l2) {
        if (l2 != 0L) {
            this.setPercentComplete(Math.round(l * 100L / l2));
        }
    }

    public void setRedisplayProgress(boolean bl) {
        this.redisplayProgress = bl;
    }

    public void setStatusDescription(String string) {
        if (string == null) {
            string = "";
        }
        this.statusDescription = string;
    }

    public void setStatusDetail(String string) {
        if (string == null) {
            string = "";
        }
        this.statusDetail = string;
    }

    public void setTitle(String string) {
        if (string == null) {
            string = "";
        }
        this.title = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.statusDescription != null && this.statusDescription.length() > 0) {
            stringBuffer.append(this.statusDescription);
        }
        if (this.statusDetail != null && this.statusDetail.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" - ");
            }
            stringBuffer.append(this.statusDetail);
        }
        if (this.percentComplete > 0) {
            String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "percentCompleteAt", new String[]{String.valueOf(this.percentComplete)});
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" (" + string + ")");
            } else {
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public void update(Progress progress) {
        this.setTitle(progress.getTitle());
        this.setStatusDescription(progress.getStatusDescription());
        this.setStatusDetail(progress.getStatusDetail());
        this.setPercentComplete(progress.getPercentComplete());
        this.setLastMessage(progress.getLastMessage());
    }
}

