/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.TTYDisplay;
import java.util.Vector;

public class TTYTable {
    private Vector rows = new Vector();
    private Vector colWeights = new Vector();
    private int indent = 0;
    private int colSpacing = 1;
    private int maxCols = 0;
    private Vector colWidths = new Vector();

    public void addRow(String[] stringArray) {
        this.rows.addElement(stringArray);
        this.refreshMetaData(stringArray);
    }

    public void clear() {
        this.rows.removeAllElements();
        this.refreshMetaData();
    }

    public void deleteRow(int n) {
        this.rows.removeElementAt(n);
        this.refreshMetaData();
    }

    public int getColCount() {
        return this.maxCols;
    }

    public int getColSpacing() {
        return this.colSpacing;
    }

    public int getColWeight(int n) {
        if (n >= 0 && n < this.colWeights.size()) {
            Integer n2 = (Integer)this.colWeights.elementAt(n);
            return n2 != null ? n2 : 0;
        }
        return 0;
    }

    public int getColWidth(int n) {
        return (Integer)this.colWidths.elementAt(n);
    }

    public int getIndent() {
        return this.indent;
    }

    public String[] getRow(int n) {
        return (String[])this.rows.elementAt(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getValue(int n, int n2) {
        String[] stringArray = this.getRow(n);
        return n2 >= 0 && n2 < stringArray.length ? stringArray[n2] : "";
    }

    public static void main(String[] stringArray) {
        TTYDisplay tTYDisplay = new TTYDisplay();
        tTYDisplay.setWidth(50);
        TTYTable tTYTable = new TTYTable();
        tTYTable.addRow(new String[]{"Port:", "22", "Note: this is a non-standard port"});
        tTYTable.addRow(new String[]{"User:", "root"});
        tTYTable.addRow(new String[]{"Socket type:", "stream"});
        tTYTable.addRow(new String[]{"FTP server:", "vsftpd"});
        tTYTable.addRow(new String[]{"Disable:", "no"});
        tTYTable.setColWeight(0, 0);
        tTYTable.setColWeight(1, 0);
        tTYTable.setColWeight(2, 1);
        tTYTable.setColSpacing(3);
        tTYTable.setIndent(3);
        tTYDisplay.printLine("Please review the settings below before continuing:");
        tTYDisplay.printLine();
        tTYDisplay.printTable(tTYTable);
    }

    private void refreshMetaData() {
        this.maxCols = 0;
        this.colWidths.removeAllElements();
        int n = 0;
        while (n < this.getRowCount()) {
            this.refreshMetaData(this.getRow(n));
            ++n;
        }
    }

    private void refreshMetaData(String[] stringArray) {
        this.maxCols = Math.max(this.maxCols, stringArray.length);
        if (this.maxCols > this.colWidths.size()) {
            this.colWidths.setSize(this.maxCols);
        }
        int n = 0;
        while (n < this.colWidths.size()) {
            int n2 = n < stringArray.length ? stringArray[n].length() : 0;
            Integer n3 = (Integer)this.colWidths.elementAt(n);
            if (n3 != null && n2 <= n3) {
                n2 = n3;
            }
            this.colWidths.setElementAt(new Integer(n2), n);
            ++n;
        }
    }

    public void setColSpacing(int n) {
        this.colSpacing = n;
    }

    public void setColWeight(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            if (this.colWeights.size() < n + 1) {
                this.colWeights.setSize(n + 1);
            }
            this.colWeights.setElementAt(new Integer(n2), n);
        }
    }

    public void setIndent(int n) {
        this.indent = n;
    }
}

