/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.util.MnemonicString;
import com.installshield.wizard.awt.ButtonPanel;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.InsetsPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MessageDialog
extends Dialog
implements ActionListener {
    private int result = 0;
    private Button[] buttons;
    private int transferFocusCount = 0;
    private final int captionWidth = 10;

    public MessageDialog(Frame frame, String string, String string2, String[] stringArray) {
        this(frame, string, string2, MessageDialog.removeAsterix(stringArray), MessageDialog.convertAsterixToDefaultIndex(stringArray));
    }

    public MessageDialog(Frame frame, String string, String string2, String[] stringArray, int n) {
        super(frame, string2, true);
        Component component;
        if (stringArray == null) {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        if (n < 0 || n >= stringArray.length) {
            throw new IllegalArgumentException("defaultOptionIndex parameter must indicate acceptable index within the options array");
        }
        this.transferFocusCount = n;
        this.result = n;
        this.setForeground(SystemColor.controlText);
        this.setLayout(new ColumnLayout());
        InsetsPanel insetsPanel = new InsetsPanel(10, 10, 5, 10);
        insetsPanel.setLayout(new ColumnLayout(5));
        this.add((Component)insetsPanel, ColumnConstraints.createLeftAlign());
        ((Component)this).setBackground(SystemColor.control);
        FlowLabel flowLabel = new FlowLabel(string);
        flowLabel.setMinimumSize(new Dimension(500, 0));
        insetsPanel.add((Component)flowLabel, ColumnConstraints.createLeftAlign());
        Panel panel = new Panel(new FlowLayout(1));
        insetsPanel.add((Component)panel, ColumnConstraints.createCenterAlign());
        ButtonPanel buttonPanel = new ButtonPanel(1);
        panel.add(buttonPanel);
        this.buttons = new Button[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            component = new Button(this.pad(MnemonicString.stripMn(stringArray[n2])));
            buttonPanel.addButton((Button)component);
            ((Button)component).addActionListener(this);
            component.addKeyListener(new KeyAdapter((Button)component, this){
                private final /* synthetic */ MessageDialog this$0;
                private final /* synthetic */ Button val$b;
                {
                    this.val$b = button;
                    this.this$0 = messageDialog;
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        this.this$0.actionPerformed(new ActionEvent(this.val$b, 1, this.val$b.getActionCommand()));
                    }
                }
            });
            this.buttons[n2] = component;
            ++n2;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MessageDialog.this.result = -1;
                ((Component)MessageDialog.this).setVisible(false);
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (MessageDialog.this.transferFocusCount >= 0 && MessageDialog.this.buttons != null && MessageDialog.this.transferFocusCount < MessageDialog.this.buttons.length) {
                    MessageDialog.this.buttons[MessageDialog.this.transferFocusCount].requestFocus();
                }
            }
        });
        this.pack();
        component = frame;
        synchronized (component) {
            Dimension dimension = frame.isVisible() ? frame.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
            Point point = frame.isVisible() ? frame.getLocation() : new Point(0, 0);
            ((Component)this).setLocation(point.x + (dimension.width - this.getSize().width) / 2, point.y + (dimension.height - this.getSize().height) / 2);
        }
        this.setResizable(false);
    }

    static /* synthetic */ int access$0(MessageDialog messageDialog) {
        return messageDialog.result;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.result = -1;
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == actionEvent.getSource()) {
                this.result = n;
                break;
            }
            ++n;
        }
        ((Component)this).setVisible(false);
    }

    private static int convertAsterixToDefaultIndex(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].startsWith("*")) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public static Frame getParentFrame(Component component) {
        Container container = component.getParent();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        if (container != null) {
            return MessageDialog.getParentFrame(container);
        }
        return null;
    }

    public int getResult() {
        return this.result;
    }

    private String pad(String string) {
        int n = 10 - string.length();
        if (n > 0) {
            n /= 2;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append(string);
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(' ');
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    private static String[] removeAsterix(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n].startsWith("*") ? stringArray[n].substring(1) : stringArray[n];
            ++n;
        }
        return stringArray2;
    }
}

