/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.cim;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.Product;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.SoftwareVersion;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.qjml.QJML;
import com.installshield.util.FileUtils;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.CommandLineBean;
import com.installshield.wizard.CommandLineOption;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.platform.cim.CIMProductComponentExtension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class CIMCommandLineBean
extends CommandLineBean {
    private String productURL = "/product.xml";
    private int currentCheckIdNumber = 1;
    private int currentProductRefNumber = 0;
    private int currentFeatureRefNumber = 0;
    private int currentSoftwareElmtRefNumber = 0;
    private int currentCheckRefNumber = 0;
    private static int IN_STATE = 0;
    private static int NEXT_STATE = 1;
    private static String DEFAULT_LANGUAGE = "multilingual";
    static /* synthetic */ Class class$com$installshield$product$ProductTree;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String convertStringToUtf8(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getMessage());
            return null;
        }
    }

    private String createArchitectureCheckInstance(ProductComponent productComponent) {
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        string = "instance of CIM_ArchitectureCheck as " + this.getNextCheckRef() + "\n";
        string = String.valueOf(string) + "{\n";
        string = String.valueOf(string) + this.getGenericCheckInfo(productComponent);
        string = String.valueOf(string) + "\tArchitectureType=" + cIMProductComponentExtension.getArchitectureType() + ";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createComponentInstance(ProductComponent productComponent) {
        GenericSoftwareObject genericSoftwareObject;
        Object object;
        Object object2;
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        string = "instance of CIM_SoftwareElement as " + this.getNextSoftwareElmtRef() + "\n";
        string = String.valueOf(string) + "{\n";
        string = String.valueOf(string) + "\tName=\"" + this.getStringValue(productComponent.getName()) + "\";\n";
        String string2 = this.getVersionString(productComponent.getKey().getVersion());
        if (string2 == null) {
            if (productComponent.getParent() instanceof ProductFeature) {
                object2 = (ProductFeature)productComponent.getParent();
                string2 = this.getVersionString(((GenericSoftwareObject)object2).getKey().getVersion());
                if (string2 == null) {
                    object = (Product)((GenericSoftwareObject)object2).getParent();
                    string2 = this.getVersionString(((GenericSoftwareObject)object).getKey().getVersion());
                }
            } else {
                object2 = (Product)productComponent.getParent();
                string2 = this.getVersionString(((GenericSoftwareObject)object2).getKey().getVersion());
            }
        }
        string = String.valueOf(string) + "\tVersion=\"" + this.getStringValue(string2) + "\";\n";
        string = String.valueOf(string) + "\tSoftwareElementState=1;\n";
        string = String.valueOf(string) + "\tSoftwareElementID=\"" + this.getStringValue(productComponent.getKey().getUID()) + "\";\n";
        string = String.valueOf(string) + "\tTargetOperatingSystem=" + cIMProductComponentExtension.getTargetOperatingSystem() + ";\n";
        object2 = null;
        if (productComponent.getKey().getVersion().getUpdate().length() != 0) {
            object2 = productComponent.getKey().getVersion().getUpdate();
        } else if (productComponent.getParent() instanceof ProductFeature) {
            object = (ProductFeature)productComponent.getParent();
            if (((GenericSoftwareObject)object).getKey().getVersion().getUpdate().length() != 0) {
                object2 = ((GenericSoftwareObject)object).getKey().getVersion().getUpdate();
            } else {
                genericSoftwareObject = (Product)((GenericSoftwareObject)object).getParent();
                if (genericSoftwareObject.getKey().getVersion().getUpdate().length() != 0) {
                    object2 = genericSoftwareObject.getKey().getVersion().getUpdate();
                }
            }
        } else {
            object = (Product)productComponent.getParent();
            if (((GenericSoftwareObject)object).getKey().getVersion().getUpdate().length() != 0) {
                object2 = ((GenericSoftwareObject)object).getKey().getVersion().getUpdate();
            }
        }
        string = String.valueOf(string) + "\tBuildNumber=\"" + this.getStringValue((String)object2) + "\";\n";
        object = DEFAULT_LANGUAGE;
        if (productComponent.getLocale() != null && productComponent.getLocale().length() != 0) {
            object = this.getLanguageFromLocale(productComponent.getLocale());
        } else if (productComponent.getParent() instanceof ProductFeature) {
            genericSoftwareObject = (ProductFeature)productComponent.getParent();
            if (genericSoftwareObject.getLocale() != null && genericSoftwareObject.getLocale().length() != 0) {
                object = this.getLanguageFromLocale(genericSoftwareObject.getLocale());
            } else {
                Product product = (Product)genericSoftwareObject.getParent();
                if (product.getLocale() != null && product.getLocale().length() != 0) {
                    object = this.getLanguageFromLocale(product.getLocale());
                }
            }
        } else {
            genericSoftwareObject = (Product)productComponent.getParent();
            if (genericSoftwareObject.getLocale() != null && genericSoftwareObject.getLocale().length() != 0) {
                object = this.getLanguageFromLocale(genericSoftwareObject.getLocale());
            }
        }
        string = String.valueOf(string) + "\tLanguageEdition=\"" + (String)object + "\";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createDiskSpaceCheckInstance(ProductComponent productComponent) {
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        if (cIMProductComponentExtension.getAvailableDiskSpace() != null && cIMProductComponentExtension.getAvailableDiskSpace().length() != 0) {
            string = "instance of CIM_DiskSpaceCheck as " + this.getNextCheckRef() + "\n";
            string = String.valueOf(string) + "{\n";
            string = String.valueOf(string) + this.getGenericCheckInfo(productComponent);
            string = String.valueOf(string) + "\tAvailableDiskSpace=" + cIMProductComponentExtension.getAvailableDiskSpace() + ";\n";
            string = String.valueOf(string) + "};\n";
        }
        return this.convertStringToUtf8(string);
    }

    private String createFeatureInstance(ProductFeature productFeature) {
        String string = new String();
        Product product = (Product)productFeature.getParent();
        string = "instance of CIM_SoftwareFeature as " + this.getNextFeatureRef() + "\n";
        string = String.valueOf(string) + "{\n";
        String string2 = productFeature.getProductNumber();
        if (string2 == null || string2.length() == 0) {
            string2 = product.getProductNumber();
        }
        string = String.valueOf(string) + "\tIdentifyingNumber=\"" + this.getStringValue(string2) + "\";\n";
        string = String.valueOf(string) + "\tProductName=\"" + this.getStringValue(product.getName()) + "\";\n";
        String string3 = productFeature.getVendor();
        if (string3 == null || string3.length() == 0) {
            string3 = product.getVendor();
        }
        string = String.valueOf(string) + "\tVendor=\"" + this.getStringValue(string3) + "\";\n";
        String string4 = this.getVersionString(productFeature.getKey().getVersion());
        if (string4 == null) {
            string4 = this.getVersionString(product.getKey().getVersion());
        }
        string = String.valueOf(string) + "\tVersion=\"" + this.getStringValue(string4) + "\";\n";
        string = String.valueOf(string) + "\tName=\"" + this.getStringValue(productFeature.getName()) + "\";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createMemoryCheckInstance(ProductComponent productComponent) {
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        if (cIMProductComponentExtension.getMemorySize() != null && cIMProductComponentExtension.getMemorySize().length() != 0) {
            string = "instance of CIM_MemoryCheck as " + this.getNextCheckRef() + "\n";
            string = String.valueOf(string) + "{\n";
            string = String.valueOf(string) + this.getGenericCheckInfo(productComponent);
            string = String.valueOf(string) + "\tMemorySize=" + cIMProductComponentExtension.getMemorySize() + ";\n";
            string = String.valueOf(string) + "};\n";
        }
        return this.convertStringToUtf8(string);
    }

    private void createMofFile(ProductBean productBean, OutputStreamWriter outputStreamWriter) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
        ProductBean productBean2 = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        try {
            while (productBean2 != standardProductTreeIterator.end()) {
                Object object;
                Object object2;
                if (productBean2 instanceof SoftwareObject) {
                    object2 = (SoftwareObject)((Object)productBean2);
                    object = new String();
                    if (object2 instanceof Product) {
                        object = this.createProductInstance((Product)object2);
                        outputStreamWriter.write((String)object, 0, ((String)object).length());
                    } else if (object2 instanceof ProductFeature) {
                        object = this.createFeatureInstance((ProductFeature)object2);
                        outputStreamWriter.write((String)object, 0, ((String)object).length());
                        object = this.createProductSoftwareFeaturesInstance();
                        outputStreamWriter.write((String)object, 0, ((String)object).length());
                    } else if (object2 instanceof ProductComponent) {
                        Object v = ((ProductComponent)object2).getExtendedProperties().get("cim");
                        if (v != null) {
                            object = this.createComponentInstance((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                            if (((ProductComponent)object2).getParent() instanceof ProductFeature) {
                                object = this.createSoftwareFeatureSoftwareElementsInstance();
                                outputStreamWriter.write((String)object, 0, ((String)object).length());
                            }
                            object = this.createArchitectureCheckInstance((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                            if (((String)object).length() != 0) {
                                object = this.createSoftwareElementChecksInstance(IN_STATE);
                                outputStreamWriter.write((String)object, 0, ((String)object).length());
                            }
                            object = this.createMemoryCheckInstance((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                            if (((String)object).length() != 0) {
                                object = this.createSoftwareElementChecksInstance(NEXT_STATE);
                                outputStreamWriter.write((String)object, 0, ((String)object).length());
                            }
                            object = this.createDiskSpaceCheckInstance((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                            if (((String)object).length() != 0) {
                                object = this.createSoftwareElementChecksInstance(IN_STATE);
                                outputStreamWriter.write((String)object, 0, ((String)object).length());
                            }
                            object = this.createSwapSpaceCheckInstance((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                            if (((String)object).length() != 0) {
                                object = this.createSoftwareElementChecksInstance(NEXT_STATE);
                                outputStreamWriter.write((String)object, 0, ((String)object).length());
                            }
                            object = this.createOSVersionCheckInstance((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                            if (((String)object).length() != 0) {
                                object = this.createSoftwareElementChecksInstance(IN_STATE);
                                outputStreamWriter.write((String)object, 0, ((String)object).length());
                            }
                            object = this.createSoftwareElementVersionCheckInstances((ProductComponent)object2);
                            outputStreamWriter.write((String)object, 0, ((String)object).length());
                        } else {
                            System.err.println("CIM properties were not enabled for component bean '" + ((ProductComponent)object2).getBeanId() + "'");
                        }
                    }
                } else if (productBean2 instanceof SoftwareObjectReference) {
                    object2 = (SoftwareObjectReference)productBean2;
                    object = ((SoftwareObjectReference)object2).resolve();
                    this.createMofFile((ProductBean)object, outputStreamWriter);
                }
                productBean2 = standardProductTreeIterator.getNext(productBean2);
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
    }

    private String createOSVersionCheckInstance(ProductComponent productComponent) {
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        if (cIMProductComponentExtension.getMinimumOSVersion() != null && cIMProductComponentExtension.getMinimumOSVersion().length() != 0) {
            string = "instance of CIM_OSVersionCheck as " + this.getNextCheckRef() + "\n";
            string = String.valueOf(string) + "{\n";
            string = String.valueOf(string) + this.getGenericCheckInfo(productComponent);
            string = String.valueOf(string) + "\tMinimumVersion=\"" + cIMProductComponentExtension.getMinimumOSVersion() + "\";\n";
            string = String.valueOf(string) + "};\n";
        }
        return this.convertStringToUtf8(string);
    }

    private String createProductInstance(Product product) {
        String string = new String();
        string = "instance of CIM_Product as " + this.getNextProductRef() + "\n";
        string = String.valueOf(string) + "{\n";
        string = String.valueOf(string) + "\tDescription=\"" + this.getStringValue(product.getDescription()) + "\";\n";
        string = String.valueOf(string) + "\tIdentifyingNumber=\"" + this.getStringValue(product.getProductNumber()) + "\";\n";
        string = String.valueOf(string) + "\tName=\"" + this.getStringValue(product.getName()) + "\";\n";
        string = String.valueOf(string) + "\tVendor=\"" + this.getStringValue(product.getVendor()) + "\";\n";
        string = String.valueOf(string) + "\tVersion=\"" + this.getStringValue(this.getVersionString(product.getKey().getVersion())) + "\";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createProductSoftwareFeaturesInstance() {
        String string = new String();
        string = "instance of CIM_ProductSoftwareFeatures\n";
        string = String.valueOf(string) + "{\n";
        string = String.valueOf(string) + "\tProduct=" + this.getCurrentProductRef() + ";\n";
        string = String.valueOf(string) + "\tComponent=" + this.getCurrentFeatureRef() + ";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createSoftwareElementChecksInstance(int n) {
        String string = new String();
        string = "instance of CIM_SoftwareElementChecks\n";
        string = String.valueOf(string) + "{\n";
        string = String.valueOf(string) + "\tElement=" + this.getCurrentSoftwareElmtRef() + ";\n";
        string = String.valueOf(string) + "\tCheck=" + this.getCurrentCheckRef() + ";\n";
        string = String.valueOf(string) + "\tPhase=" + n + ";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createSoftwareElementVersionCheckInstances(ProductComponent productComponent) {
        String string = new String();
        SoftwareObjectReference[] softwareObjectReferenceArray = productComponent.getRequired();
        int n = 0;
        while (n < softwareObjectReferenceArray.length) {
            SoftwareObject softwareObject = productComponent.getProductTree().resolveKey(softwareObjectReferenceArray[n].getKey());
            if (softwareObject == null || softwareObject instanceof ProductComponent) {
                string = String.valueOf(string) + "instance of CIM_SoftwareElementVersionCheck as " + this.getNextCheckRef() + "\n";
                string = String.valueOf(string) + "{\n";
                string = String.valueOf(string) + this.getGenericCheckInfo(productComponent);
                if (softwareObject == null) {
                    string = String.valueOf(string) + "\tSoftwareElementName=\"" + this.getStringValue(softwareObjectReferenceArray[n].getName()) + "\";\n";
                    string = String.valueOf(string) + "\tLowerSoftwareElementVersion=\"" + this.getStringValue(this.getVersionString(softwareObjectReferenceArray[n].getKey().getVersion())) + "\";\n";
                    string = String.valueOf(string) + "\tSoftwareElementStateDesired=2;\n";
                } else {
                    string = String.valueOf(string) + "\tSoftwareElementName=\"" + this.getStringValue(softwareObject.getName()) + "\";\n";
                    string = String.valueOf(string) + "\tLowerSoftwareElementVersion=\"" + this.getStringValue(this.getVersionString(softwareObject.getKey().getVersion())) + "\";\n";
                    string = String.valueOf(string) + "\tSoftwareElementStateDesired=1;\n";
                }
                string = String.valueOf(string) + "};\n";
                string = String.valueOf(string) + this.createSoftwareElementChecksInstance(IN_STATE);
            }
            ++n;
        }
        return this.convertStringToUtf8(string);
    }

    private String createSoftwareFeatureSoftwareElementsInstance() {
        String string = new String();
        string = "instance of CIM_SoftwareFeatureSoftwareElements\n";
        string = String.valueOf(string) + "{\n";
        string = String.valueOf(string) + "\tGroupComponent=" + this.getCurrentFeatureRef() + ";\n";
        string = String.valueOf(string) + "\tPartComponent=" + this.getCurrentSoftwareElmtRef() + ";\n";
        string = String.valueOf(string) + "};\n";
        return this.convertStringToUtf8(string);
    }

    private String createSwapSpaceCheckInstance(ProductComponent productComponent) {
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        if (cIMProductComponentExtension.getSwapSpaceSize() != null && cIMProductComponentExtension.getSwapSpaceSize().length() != 0) {
            string = "instance of CIM_SwapSpaceCheck as " + this.getNextCheckRef() + "\n";
            string = String.valueOf(string) + "{\n";
            string = String.valueOf(string) + this.getGenericCheckInfo(productComponent);
            string = String.valueOf(string) + "\tSwapSpaceSize=" + cIMProductComponentExtension.getSwapSpaceSize() + ";\n";
            string = String.valueOf(string) + "};\n";
        }
        return this.convertStringToUtf8(string);
    }

    public boolean execute(Wizard wizard, String[] stringArray) {
        if (stringArray.length > 1) {
            wizard.setExitCode(1001);
            System.err.println("Invalid command line option: CIM can have at most one argument");
            return false;
        }
        try {
            ProductTree productTree = (ProductTree)QJML.read(wizard.getServices().getResource(this.productURL), class$com$installshield$product$ProductTree != null ? class$com$installshield$product$ProductTree : (class$com$installshield$product$ProductTree = CIMCommandLineBean.class$("com.installshield.product.ProductTree")));
            if (stringArray.length == 1) {
                Object object;
                File file = null;
                if (FileUtils.isAbsolute(stringArray[0])) {
                    file = new File(FileUtils.normalizeFileName(stringArray[0]));
                } else {
                    object = FileUtils.getParent(new File(wizard.getHome()).getAbsolutePath());
                    file = new File(FileUtils.createFileName((String)object, stringArray[0]));
                }
                object = new File(file.getParent());
                if (!((File)object).exists()) {
                    FileUtils.createDirs((File)object);
                }
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
                this.createMofFile(productTree.getRoot(), outputStreamWriter);
                outputStreamWriter.close();
            } else {
                this.outputMof(productTree.getRoot());
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return false;
    }

    private String getCurrentCheckRef() {
        return "$chck" + this.currentCheckRefNumber;
    }

    private String getCurrentFeatureRef() {
        return "$feat" + this.currentFeatureRefNumber;
    }

    private String getCurrentProductRef() {
        return "$prod" + this.currentProductRefNumber;
    }

    private String getCurrentSoftwareElmtRef() {
        return "$elmt" + this.currentSoftwareElmtRefNumber;
    }

    private String getGenericCheckInfo(ProductComponent productComponent) {
        CIMProductComponentExtension cIMProductComponentExtension = (CIMProductComponentExtension)productComponent.getExtendedProperties().get("cim");
        String string = new String();
        string = String.valueOf(string) + "\tName=\"" + this.getStringValue(productComponent.getName()) + "\";\n";
        String string2 = this.getVersionString(productComponent.getKey().getVersion());
        if (string2 == null) {
            if (productComponent.getParent() instanceof ProductFeature) {
                ProductFeature productFeature = (ProductFeature)productComponent.getParent();
                string2 = this.getVersionString(productFeature.getKey().getVersion());
                if (string2 == null) {
                    Product product = (Product)productFeature.getParent();
                    string2 = this.getVersionString(product.getKey().getVersion());
                }
            } else {
                Product product = (Product)productComponent.getParent();
                string2 = this.getVersionString(product.getKey().getVersion());
            }
        }
        string = String.valueOf(string) + "\tVersion=\"" + this.getStringValue(string2) + "\";\n";
        string = String.valueOf(string) + "\tSoftwareElementState=1;\n";
        string = String.valueOf(string) + "\tSoftwareElementID=\"" + this.getStringValue(productComponent.getKey().getUID()) + "\";\n";
        string = String.valueOf(string) + "\tTargetOperatingSystem=" + cIMProductComponentExtension.getTargetOperatingSystem() + ";\n";
        string = String.valueOf(string) + "\tCheckID=\"" + this.currentCheckIdNumber++ + "\";\n";
        string = String.valueOf(string) + "\tCheckMode=true;\n";
        return string;
    }

    private String getLanguageFromLocale(String string) {
        Locale locale = PropertyUtils.createLocale(string);
        return locale.getLanguage();
    }

    private String getNextCheckRef() {
        return "$chck" + ++this.currentCheckRefNumber;
    }

    private String getNextFeatureRef() {
        return "$feat" + ++this.currentFeatureRefNumber;
    }

    private String getNextProductRef() {
        return "$prod" + ++this.currentProductRefNumber;
    }

    private String getNextSoftwareElmtRef() {
        return "$elmt" + ++this.currentSoftwareElmtRefNumber;
    }

    public CommandLineOption getOption() {
        return new CommandLineOption("CIM");
    }

    private String getStringValue(String string) {
        if (string == null) {
            return " ";
        }
        return string;
    }

    private String getVersionString(SoftwareVersion softwareVersion) {
        String string = null;
        if (softwareVersion.getMajor().length() != 0) {
            string = softwareVersion.getMajor();
            if (softwareVersion.getMinor().length() != 0) {
                string = String.valueOf(string) + "." + softwareVersion.getMinor();
                if (softwareVersion.getMaintenance().length() != 0) {
                    string = String.valueOf(string) + "." + softwareVersion.getMaintenance();
                }
            }
        }
        return string;
    }

    public boolean isRepeatable() {
        return false;
    }

    private void outputMof(ProductBean productBean) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(productBean);
        ProductBean productBean2 = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean2 != standardProductTreeIterator.end()) {
            Object object;
            Object object2;
            if (productBean2 instanceof SoftwareObject) {
                object2 = (SoftwareObject)((Object)productBean2);
                object = new String();
                if (object2 instanceof Product) {
                    System.out.print(this.createProductInstance((Product)object2));
                }
                if (object2 instanceof ProductFeature) {
                    System.out.print(this.createFeatureInstance((ProductFeature)object2));
                    System.out.print(this.createProductSoftwareFeaturesInstance());
                }
                if (object2 instanceof ProductComponent) {
                    Object v = ((ProductComponent)object2).getExtendedProperties().get("cim");
                    if (v != null) {
                        System.out.print(this.createComponentInstance((ProductComponent)object2));
                        if (((ProductComponent)object2).getParent() instanceof ProductFeature) {
                            System.out.print(this.createSoftwareFeatureSoftwareElementsInstance());
                        }
                        object = this.createArchitectureCheckInstance((ProductComponent)object2);
                        System.out.print((String)object);
                        if (((String)object).length() != 0) {
                            object = this.createSoftwareElementChecksInstance(IN_STATE);
                            System.out.print((String)object);
                        }
                        object = this.createMemoryCheckInstance((ProductComponent)object2);
                        System.out.print((String)object);
                        if (((String)object).length() != 0) {
                            object = this.createSoftwareElementChecksInstance(NEXT_STATE);
                            System.out.print((String)object);
                        }
                        object = this.createDiskSpaceCheckInstance((ProductComponent)object2);
                        System.out.print((String)object);
                        if (((String)object).length() != 0) {
                            object = this.createSoftwareElementChecksInstance(IN_STATE);
                            System.out.print((String)object);
                        }
                        object = this.createSwapSpaceCheckInstance((ProductComponent)object2);
                        System.out.print((String)object);
                        if (((String)object).length() != 0) {
                            object = this.createSoftwareElementChecksInstance(NEXT_STATE);
                            System.out.print((String)object);
                        }
                        object = this.createOSVersionCheckInstance((ProductComponent)object2);
                        System.out.print((String)object);
                        if (((String)object).length() != 0) {
                            object = this.createSoftwareElementChecksInstance(IN_STATE);
                            System.out.print((String)object);
                        }
                        object = this.createSoftwareElementVersionCheckInstances((ProductComponent)object2);
                        System.out.print((String)object);
                    } else {
                        System.err.println("CIM properties were not enabled for component bean '" + ((ProductComponent)object2).getBeanId() + "'");
                    }
                }
            } else if (productBean2 instanceof SoftwareObjectReference) {
                object2 = (SoftwareObjectReference)productBean2;
                object = ((SoftwareObjectReference)object2).resolve();
                this.outputMof((ProductBean)object);
            }
            productBean2 = standardProductTreeIterator.getNext(productBean2);
        }
    }
}

