/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.desktop.cde;

import com.installshield.wizard.platform.common.desktop.cde.DesktopItem;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;

public class Action {
    public static final String TYPE_COMMAND = "COMMAND";
    public static final String TYPE_MAP = "MAP";
    public static final String TYPE_TT_MSG = "TT_MSG";
    private static final String NAME = "NAME";
    private static final String CWD = "CWD";
    private static final String ICON = "ICON";
    private static final String LABEL = "LABEL";
    private static final String EXEC_STRING = "EXEC_STRING";
    private Hashtable fields = new Hashtable();

    public Action(DesktopItem desktopItem) {
        this.setField(TYPE_COMMAND, TYPE_COMMAND);
        this.setField(LABEL, desktopItem.getAppItem().replace(' ', '_'));
        this.setField(EXEC_STRING, String.valueOf(desktopItem.getAppCommand()) + new String(new byte[]{32}) + desktopItem.getAppArguments());
        this.setField(ICON, desktopItem.getIconFile());
        this.setField(CWD, desktopItem.getCdw());
    }

    private String getDtScript() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringBuffer stringBuffer = null;
        int n = this.getMaxFieldLength();
        printWriter.println("ACTION " + (String)this.fields.get(LABEL));
        printWriter.println("{");
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.fields.get(string);
            stringBuffer = new StringBuffer();
            stringBuffer.append("     ").append(string);
            int n2 = string.length();
            while (n2 <= n) {
                stringBuffer.append(" ");
                ++n2;
            }
            stringBuffer.append(string2);
            printWriter.println(stringBuffer.toString());
        }
        printWriter.println("}");
        printWriter.flush();
        printWriter.close();
        return stringWriter.getBuffer().toString();
    }

    private int getMaxFieldLength() {
        int n = 1;
        Enumeration enumeration = this.fields.keys();
        while (enumeration.hasMoreElements()) {
            int n2 = ((String)enumeration.nextElement()).length();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private void setField(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            this.fields.remove(string);
        } else {
            this.fields.put(string, string2);
        }
    }

    public void store(OutputStream outputStream, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        if (string != null) {
            printWriter.println("# " + string);
            printWriter.println("# " + Calendar.getInstance().getTime().toString());
        }
        printWriter.println(this.getDtScript());
        printWriter.println();
        printWriter.flush();
        printWriter.close();
    }
}

