/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.common.desktop.cde;

import com.installshield.util.FileAttributes;
import com.installshield.wizard.platform.common.desktop.cde.Action;
import com.installshield.wizard.platform.common.desktop.cde.ActionFile;
import com.installshield.wizard.platform.common.desktop.cde.CDEDesktopItem;
import com.installshield.wizard.platform.common.desktop.cde.DesktopItem;
import com.installshield.wizard.platform.common.desktop.cde.DesktopManager;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CDEDesktopManager
implements DesktopManager {
    private static int APP_MANAGER = 4;
    private static int WORK_SPACE_MENU = 8;
    private static int FRONT_PANEL = 10;
    private static int DATA_TYPES = 16;
    public static String CDE = "CDE";
    public static final String SYSTEM_WIDE_APPLICATION_MANAGER = "System Wide Application Manager";
    public static final String USER_SPECIFIC_APPLICATION_MANAGER = "User Specific Application Manager";
    public static final String SYSTEM_WIDE_APPLICATION_MANAGER_DIR = "/etc/dt/appconfig/appmanager";
    public static final String USER_SPECIFIC_APPLICATION_MANAGER_DIR = ".dt/appmanager";
    private boolean refreshRequired = false;
    private WizardServices services;

    public CDEDesktopManager(WizardServices wizardServices) {
        this.services = wizardServices;
    }

    public CDEDesktopItem createCDEDesktopItem(String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = this.parseFolderContext(string);
        String string8 = this.parseFolderAppGroup(string);
        return this.createCDEDesktopItem(string7, string8, string2, string3, string4, string5, string6);
    }

    public CDEDesktopItem createCDEDesktopItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return new CDEDesktopItem(string, string2, string3, string4, string5, string6, string7);
    }

    public void createDesktopFolder(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderAppGroup(string);
        this.createDesktopFolder(string2, string3);
    }

    public void createDesktopFolder(String string, String string2) throws ServiceException {
        File file = this.getFolderContextAsFile(string, string2);
        if (file != null && !file.exists()) {
            ((FileService)this.services.getService("fileService")).createDirectory(file.getAbsolutePath());
        }
        this.refreshRequired = true;
    }

    public void createDesktopItem(DesktopItem desktopItem) throws ServiceException {
        if (!(desktopItem instanceof CDEDesktopItem)) {
            throw new ServiceException(315, "Incorrect desktop item type:  Expected CDEDesktopItem.");
        }
        this.createDesktopFolder(desktopItem.getContext(), desktopItem.getAppGroup());
        this.writeActionScript(desktopItem);
        this.writeDtScript(desktopItem);
        this.refreshRequired = true;
    }

    private void deleteActionScript(DesktopItem desktopItem) throws ServiceException {
        if (desktopItem.getAppItem().length() <= 0) {
            throw new ServiceException(2, "Desktop Item not specified.");
        }
        File file = new File(this.getFolderContextAsFile(desktopItem.getContext(), desktopItem.getAppGroup()), desktopItem.getAppItem().replace(' ', '_'));
        ((FileService)this.services.getService("fileService")).deleteFile(file.getAbsolutePath());
    }

    public void deleteDesktopFolder(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderAppGroup(string);
        this.deleteDesktopFolder(string2, string3);
    }

    public void deleteDesktopFolder(String string, String string2) throws ServiceException {
        this.deleteFolder(this.getFolderContextAsFile(string, string2).getAbsolutePath(), this.getAppManagerRootFolder(string));
        this.refreshRequired = true;
    }

    private void deleteDtScript(DesktopItem desktopItem) throws ServiceException {
        if (desktopItem.getAppItem().length() <= 0) {
            throw new ServiceException(2, "Desktop Item not specified.");
        }
        File file = new File(this.getTypesFolder(desktopItem.getContext()), String.valueOf(desktopItem.getAppItem().replace(' ', '_')) + ".dt");
        ((FileService)this.services.getService("fileService")).deleteFile(file.getAbsolutePath());
    }

    private void deleteFolder(String string, String string2) {
        File file = new File(string);
        if (file.list().length > 0 || file.getAbsolutePath().equals(string2)) {
            return;
        }
        file.delete();
        this.deleteFolder(file.getParent(), string2);
    }

    private String getAppManagerRootFolder(String string) throws ServiceException {
        if (this.isValidContext(string)) {
            int n = this.resolveFolderContext(string);
            File file = null;
            if (n == (1 | APP_MANAGER)) {
                String string2 = ((SystemUtilService)this.services.getService("systemUtilService")).getEnvironmentVariable("LANG");
                if (string2 == null) {
                    string2 = "C";
                }
                file = new File(SYSTEM_WIDE_APPLICATION_MANAGER_DIR, string2);
            } else if (n == (2 | APP_MANAGER)) {
                file = new File(System.getProperty("user.home"), USER_SPECIFIC_APPLICATION_MANAGER_DIR);
            } else {
                throw new ServiceException(1, "Unable to resolve folder context");
            }
            return file.getAbsolutePath();
        }
        throw new ServiceException(1, "Unable to resolve folder context");
    }

    public FileAttributes getDesktopFolderAttributes(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderAppGroup(string);
        return this.getDesktopFolderAttributes(string2, string3);
    }

    public FileAttributes getDesktopFolderAttributes(String string, String string2) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        return fileService.getFileAttributes(file.getAbsolutePath());
    }

    public String getDesktopFolderOwner(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderAppGroup(string);
        return this.getDesktopFolderOwner(string2, string3);
    }

    public String getDesktopFolderOwner(String string, String string2) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        return fileService.getFileOwner(file.getAbsolutePath());
    }

    public String getDesktopFolderOwnerGroup(String string) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderAppGroup(string);
        return this.getDesktopFolderOwnerGroup(string2, string3);
    }

    public String getDesktopFolderOwnerGroup(String string, String string2) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        return fileService.getFileOwnerGroup(file.getAbsolutePath());
    }

    public FileAttributes getDesktopItemAttributes(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderAppGroup(string);
        return this.getDesktopItemAttributes(string3, string, string2);
    }

    public FileAttributes getDesktopItemAttributes(String string, String string2, String string3) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        return fileService.getFileAttributes(new File(file, string3).getAbsolutePath());
    }

    public String getDesktopItemOwner(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderAppGroup(string);
        return this.getDesktopItemOwner(string3, string4, string2);
    }

    public String getDesktopItemOwner(String string, String string2, String string3) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        return fileService.getFileOwner(new File(file, string3).getAbsolutePath());
    }

    public String getDesktopItemOwnerGroup(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderAppGroup(string);
        return this.getDesktopItemOwnerGroup(string3, string4, string2);
    }

    public String getDesktopItemOwnerGroup(String string, String string2, String string3) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        return fileService.getFileOwnerGroup(new File(file, string3).getAbsolutePath());
    }

    private File getFolderContextAsFile(String string, String string2) throws ServiceException {
        if (string2 == null || string2.trim().length() <= 0) {
            throw new ServiceException(2, "Desktop app group not specified");
        }
        if (this.isValidContext(string)) {
            int n = this.resolveFolderContext(string);
            File file = null;
            if (n == (1 | APP_MANAGER)) {
                String string3 = ((SystemUtilService)this.services.getService("systemUtilService")).getEnvironmentVariable("LANG");
                if (string3 == null) {
                    string3 = "C";
                }
                file = new File(SYSTEM_WIDE_APPLICATION_MANAGER_DIR, String.valueOf(string3) + File.separator + string2);
            } else if (n == (2 | APP_MANAGER)) {
                file = new File(System.getProperty("user.home"), USER_SPECIFIC_APPLICATION_MANAGER_DIR + File.separator + string2);
            } else {
                throw new ServiceException(2, "Unable to resolve folder context");
            }
            return file;
        }
        throw new ServiceException(2, "Unable to resolve folder context");
    }

    private File getTypesFolder(String string) throws ServiceException {
        if (this.isValidContext(string)) {
            int n = this.resolveFolderContext(string);
            File file = null;
            if ((n & 1) == 1) {
                String string2 = ((SystemUtilService)this.services.getService("systemUtilService")).getEnvironmentVariable("LANG");
                if (string2 == null) {
                    string2 = "C";
                }
                file = new File("/etc/dt/appconfig/types/" + string2);
            } else if ((n & 2) == 2) {
                file = new File(String.valueOf(System.getProperty("user.home")) + "/.dt/types");
            } else {
                throw new ServiceException(2, "Unable to resolve types folder");
            }
            return file;
        }
        throw new ServiceException(2, "Unable to resolve types folder");
    }

    private boolean hasProcessEnded(Process process) {
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
        return true;
    }

    public boolean isContextOwnershipSupported(String string) throws ServiceException {
        return this.isValidContext(string);
    }

    private boolean isValidContext(String string) {
        boolean bl = false;
        int n = this.resolveFolderContext(string);
        if (n == (1 | APP_MANAGER)) {
            bl = true;
        } else if (n == (2 | APP_MANAGER)) {
            bl = true;
        }
        return bl;
    }

    final synchronized boolean monitorProcess(Process process, long l) {
        boolean bl = true;
        if (System.getProperty("is.debug") != null) {
            System.out.println("process timeout set to = " + l + " milliseconds.");
        }
        long l2 = System.currentTimeMillis() + l;
        while (!this.hasProcessEnded(process) && l2 > System.currentTimeMillis()) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.hasProcessEnded(process)) {
            process.destroy();
            if (System.getProperty("is.debug") != null) {
                System.out.println("process terminated after timeout.");
            }
            bl = false;
        }
        return bl;
    }

    private String parseFolderAppGroup(String string) {
        String string2 = string;
        int n = string.indexOf(File.separator);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    private String parseFolderContext(String string) {
        String string2 = "";
        int n = string.indexOf(File.separator);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public void refreshDesktop() throws ServiceException {
        block3: {
            if (!this.refreshRequired) break block3;
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"/usr/dt/bin/dtaction", "ReloadActions"});
                if (this.monitorProcess(process, Long.getLong("cde.desktop.timeout", 30L) * 1000L)) {
                    process = Runtime.getRuntime().exec(new String[]{"/usr/dt/bin/dtaction", "ReloadApps"});
                    this.monitorProcess(process, Long.getLong("cde.desktop.timeout", 30L) * 1000L);
                }
            }
            catch (Exception exception) {
                this.services.logEvent("wrn", "Unable to update desktop manager during the current log-in session.The desktop manager will be updated when you log-in the next time. Exception: " + exception, new ServiceException(1).fillInStackTrace());
            }
        }
    }

    public void removeDesktopItem(DesktopItem desktopItem) throws ServiceException {
        if (!(desktopItem instanceof CDEDesktopItem)) {
            throw new ServiceException(315, "Incorrect desktop item type:  Expected CDEDesktopItem.");
        }
        this.deleteDtScript(desktopItem);
        this.deleteActionScript(desktopItem);
        this.deleteDesktopFolder(desktopItem.getContext(), desktopItem.getAppGroup());
        this.refreshRequired = true;
    }

    private int resolveFolderContext(String string) {
        int n = 0;
        if (string != null && string.trim().length() > 0) {
            n = string.equals(SYSTEM_WIDE_APPLICATION_MANAGER) ? 1 | APP_MANAGER : 2 | APP_MANAGER;
        }
        return n;
    }

    public void setDesktopFolderAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        String string2 = this.parseFolderContext(string);
        String string3 = this.parseFolderAppGroup(string);
        this.setDesktopFolderAttributes(string2, string3, fileAttributes);
    }

    public void setDesktopFolderAttributes(String string, String string2, FileAttributes fileAttributes) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.setFileAttributes(file.getAbsolutePath(), fileAttributes);
    }

    public void setDesktopFolderOwner(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderAppGroup(string);
        this.setDesktopFolderOwner(string3, string4, string2);
    }

    public void setDesktopFolderOwner(String string, String string2, String string3) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.setFileOwner(file.getAbsolutePath(), string3);
    }

    public void setDesktopFolderOwnerGroup(String string, String string2) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderAppGroup(string);
        this.setDesktopFolderOwnerGroup(string3, string4, string2);
    }

    public void setDesktopFolderOwnerGroup(String string, String string2, String string3) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.setFileOwnerGroup(file.getAbsolutePath(), string3);
    }

    public void setDesktopItemAttributes(String string, String string2, FileAttributes fileAttributes) throws ServiceException {
        String string3 = this.parseFolderContext(string);
        String string4 = this.parseFolderAppGroup(string);
        this.setDesktopItemAttributes(string3, string4, string2, fileAttributes);
    }

    public void setDesktopItemAttributes(String string, String string2, String string3, FileAttributes fileAttributes) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.setFileAttributes(new File(file, string3).getAbsolutePath(), fileAttributes);
    }

    public void setDesktopItemOwner(String string, String string2, String string3) throws ServiceException {
        String string4 = this.parseFolderContext(string);
        String string5 = this.parseFolderAppGroup(string);
        this.setDesktopItemOwner(string4, string5, string2, string3);
    }

    public void setDesktopItemOwner(String string, String string2, String string3, String string4) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.setFileOwner(new File(file, string3).getAbsolutePath(), string4);
    }

    public void setDesktopItemOwnerGroup(String string, String string2, String string3) throws ServiceException {
        String string4 = this.parseFolderContext(string);
        String string5 = this.parseFolderAppGroup(string);
        this.setDesktopItemOwnerGroup(string4, string5, string2, string3);
    }

    public void setDesktopItemOwnerGroup(String string, String string2, String string3, String string4) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        File file = this.getFolderContextAsFile(string, string2);
        fileService.setFileOwnerGroup(new File(file, string3).getAbsolutePath(), string4);
    }

    private void setExecutable(String string) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        FileAttributes fileAttributes = fileService.getFileAttributes(string);
        fileAttributes.setAttributeState(292, true);
        fileService.setFileAttributes(string, fileAttributes);
    }

    private void setReadable(String string) throws ServiceException {
        FileService fileService = (FileService)this.services.getService("fileService");
        FileAttributes fileAttributes = fileService.getFileAttributes(string);
        fileAttributes.setAttributeState(73, true);
        fileService.setFileAttributes(string, fileAttributes);
    }

    private void writeActionScript(DesktopItem desktopItem) throws ServiceException {
        if (desktopItem.getAppItem().length() <= 0) {
            throw new ServiceException(2, "Desktop Item not specified.");
        }
        try {
            String string = new File(this.getFolderContextAsFile(desktopItem.getContext(), desktopItem.getAppGroup()), desktopItem.getAppItem().replace(' ', '_')).getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ActionFile.store(fileOutputStream, null);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setExecutable(string);
            this.setReadable(string);
        }
        catch (IOException iOException) {
            throw new ServiceException(2, "error deleting desktop action file", iOException);
        }
    }

    private void writeDeskTopWorkSpaceMenuItem(String string, String string2) {
    }

    private void writeDtScript(DesktopItem desktopItem) throws ServiceException {
        File file = this.getTypesFolder(desktopItem.getContext());
        try {
            if (file != null && !file.exists()) {
                ((FileService)this.services.getService("fileService")).createDirectory(file.getAbsolutePath());
            }
            this.setReadable(file.getPath());
            if (desktopItem.getAppItem().length() <= 0) {
                throw new ServiceException(2, "Desktop Item not specified.");
            }
            String string = new File(file, String.valueOf(desktopItem.getAppItem().replace(' ', '_')) + ".dt").getAbsolutePath();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Action action = new Action(desktopItem);
            action.store(fileOutputStream, null);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.setReadable(string);
            String string2 = desktopItem.getIconFile();
            if (string2 != null) {
                if (new File(string2).exists()) {
                    this.setReadable(string2);
                }
            } else {
                this.services.logEvent(this, "wrn", "desktop icon file missing or not specified");
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(2, "error creating desktop dt script file", iOException);
        }
    }
}

