/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.file;

import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixFileAttributes;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class GenericUnixFileServiceImpl
extends PureJavaFileServiceImpl {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");

    private static String convertDate(long l) {
        return sdf.format(new Date(l));
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String var1_1, boolean var2_2, boolean var3_3) throws ServiceException {
        var4_4 = 0;
        var5_5 = false;
        var6_6 = "";
        var7_7 = this.createFileName(this.getCurrentDirectory(), var1_1);
        if (this.fileExists(var7_7) && this.isDirectory(var7_7) && this.getParent(var7_7) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(var7_7)) {
            if (!var2_2 && !var3_3) {
                try {
                    var8_8 = String.valueOf(FileUtils.appendSeparator(var7_7, this.getSeparator())) + "*";
                    var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f \"" + var8_8 + "\""});
                    if (var9_14.getExitCode() == 0) {
                        var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                        if (var9_14.getExitCode() == 0) ** GOTO lbl42
                        var5_5 = true;
                        var6_6 = var9_14.getStderr();
                    }
                    var5_5 = true;
                    var6_6 = var9_14.getStderr();
                }
                catch (Exception var8_9) {
                    throw new ServiceException(var8_9);
                }
            } else if (var2_2 && !var3_3) {
                try {
                    var8_10 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir \"" + var7_7 + "\""});
                    if (var8_10.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_10.getStderr();
                }
                catch (Exception var8_11) {
                    throw new ServiceException(var8_11);
                }
            } else if (!var2_2 && var3_3) {
                try {
                    var8_12 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf \"" + var7_7 + "\""});
                    if (var8_12.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_12.getStderr();
                }
                catch (Exception var8_13) {
                    throw new ServiceException(var8_13);
                }
            } else {
                var4_4 = super.deleteDirectory(var1_1, var2_2, var3_3);
            }
        }
lbl42:
        // 10 sources

        if (var5_5) {
            throw new ServiceException(2, "Error deleting directory: " + var6_6);
        }
        return var4_4;
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        try {
            String string2 = GenericUnixUtils.invokeShellScriptSupport(new String[]{"getFileAttributes", string});
            return GenericUnixFileAttributes.getAttributeObject(Integer.parseInt(string2));
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getFileAttributes for " + string + " Got exception: " + processExecException);
        }
    }

    public String getFileOwner(String string) throws ServiceException {
        try {
            return GenericUnixUtils.invokeShellScriptSupport(new String[]{"getFileOwner", string});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getFileOwner for " + string + " Got exception: " + processExecException);
        }
    }

    public String getFileOwnerGroup(String string) throws ServiceException {
        try {
            return GenericUnixUtils.invokeShellScriptSupport(new String[]{"getFileOwnerGroup", string});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getFileOwnerGroup for " + string + " Got exception: " + processExecException);
        }
    }

    protected String getLibraryDirectory() throws ServiceException {
        return "/usr/lib";
    }

    public String getPartitionFormat(String string) throws ServiceException {
        try {
            return GenericUnixUtils.invokeShellScriptSupport(new String[]{"getPartitionFormat", string});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getPartitionFormat for " + string + " Got exception: " + processExecException);
        }
    }

    public long getPartitionFreeSpace(String string) throws ServiceException {
        try {
            return Long.parseLong(GenericUnixUtils.invokeShellScriptSupport(new String[]{"getPartitionFreeSpace", string}));
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getPartitionFreeSpace for partition" + string + " Got exception: " + processExecException);
        }
    }

    public String[] getPartitionNames() throws ServiceException {
        try {
            File file = null;
            String string = null;
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(GenericUnixUtils.invokeShellScriptSupport(new String[]{"getPartitionNames"}), ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                file = new File(string);
                if (!file.exists() || !file.isDirectory()) continue;
                vector.addElement(string);
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getPartitionNames - Got exception: " + processExecException);
        }
    }

    public int getPartitionType(String string) throws ServiceException {
        return !(string = string.trim()).startsWith("/dev/") || !string.substring(5).endsWith("cd") && !string.substring(5).endsWith("fd") && !string.substring(5).endsWith("rmt") ? 1 : 2;
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return "/opt";
    }

    public int getSystemCompatibility() {
        if (System.getProperty("is.debug") != null) {
            System.out.println("GenericUnixFileServiceImpl returns compatibility: " + GenericUnixPlatform.getSystemCompatibility());
        }
        return GenericUnixPlatform.getSystemCompatibility();
    }

    public int getSystemUMask() throws ServiceException {
        try {
            return Integer.parseInt(GenericUnixUtils.invokeShellScriptSupport(new String[]{"getSystemUMask"}));
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking getSystemUMask Got exception: " + processExecException);
        }
    }

    protected String getTempDirectory() throws ServiceException {
        return "/tmp";
    }

    protected void initialized() {
        super.initialized();
        try {
            URL uRL = this.getResource(String.valueOf(GenericUnixUtils.getGenericUnixPPKHome()) + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixUtils.initializeShellScriptSupport(uRL, GenericUnixUtils.getGenericUnixShellScriptSupport());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{"fileService", GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            exception.printStackTrace();
        }
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"setFileAttributes", string, GenericUnixFileAttributes.getGUMode(fileAttributes)});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking setFileAttributes for " + string + " Got exception: " + processExecException);
        }
    }

    public void setFileCreated(String string, long l) throws ServiceException {
    }

    public void setFileExecutable(String string) throws ServiceException {
        try {
            FileAttributes fileAttributes = this.getFileAttributes(string);
            fileAttributes.setAttributeState(292, true);
            this.setFileAttributes(string, fileAttributes);
        }
        catch (ServiceException serviceException) {
            throw new ServiceException(2, "fileService:Error invoking setFileExecutable for " + string + " Got exception: " + serviceException);
        }
    }

    public void setFileModified(String string, long l) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"setFileModified", string, GenericUnixFileServiceImpl.convertDate(l)});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking setFileModified for " + string + " Got exception: " + processExecException);
        }
    }

    public void setFileOwner(String string, String string2) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"setFileOwner", string, string2});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking setFileOwner for " + string + " Got exception: " + processExecException);
        }
    }

    public void setFileOwnerGroup(String string, String string2) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"setFileOwnerGroup", string, string2});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking setFileOwnerGroup for " + string + " Got exception: " + processExecException);
        }
    }

    public void setFileTimes(String string, long l, long l2, long l3) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"setFileTimes", string, GenericUnixFileServiceImpl.convertDate(l), GenericUnixFileServiceImpl.convertDate(l2), GenericUnixFileServiceImpl.convertDate(l3)});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "fileService:Error invoking setFileTimes for " + string + " Got exception: " + processExecException);
        }
    }

    public void setSystemUMask(int n) throws ServiceException {
        throw new ServiceException(305, "fileServiceSetting umask is not supported by GenericUnixFileService");
    }

    public boolean supportsLongFileNames(String string) throws ServiceException {
        try {
            File file = new File(string, "com.installshield.wizard.platform.genericunix.service.file.GenericUnixFileService");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.close();
            file.delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void validateFileName(String string) throws ServiceException {
        String string2 = ":*?\"<>|";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) != -1) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{string2}));
            }
            ++n;
        }
    }
}

