/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.jvm;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.jvm.PureJavaJVMServiceImpl;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;

public class GenericUnixJVMServiceImpl
extends PureJavaJVMServiceImpl {
    public long calculateJVMInstallerSize(String string, String string2) throws ServiceException {
        long l = 0L;
        String string3 = String.valueOf(string) + ";" + FileUtils.normalizeFileName(string2);
        if (this.getJVMInstallerSizesTable().get(string3) == null) {
            try {
                String string4 = FileUtils.createTempFile(this.getResource(string2), FileUtils.getName(string2));
                l = Long.parseLong(GenericUnixUtils.invokeShellScriptSupport(new String[]{"calculateJVMInstallerSize", string4}));
                this.getJVMInstallerSizesTable().put(string3, new Long(l));
            }
            catch (IOException iOException) {
                throw new ServiceException(315, "cannot extract JVM installer resource for size calculation: " + string2 + " Got exception: " + iOException);
            }
            catch (ProcessExecException processExecException) {
                throw new ServiceException(2, "jvmService:Error invoking calculateJVMInstallerSize Got exception: " + processExecException);
            }
        } else {
            l = (Long)this.getJVMInstallerSizesTable().get(string3);
        }
        return l;
    }

    protected String createInstallInput(String string, String string2, String string3) throws ServiceException {
        try {
            String string4 = FileUtils.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string4);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
            bufferedWriter.write("ACTION=INSTALL_JVM");
            bufferedWriter.newLine();
            bufferedWriter.write("BUNDLED_JRE=" + string);
            bufferedWriter.newLine();
            bufferedWriter.write("DESTINATION_DIR=" + string3);
            bufferedWriter.newLine();
            if (System.getProperty("is.debug") != null) {
                bufferedWriter.write("LOG=jvminst.log");
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            fileOutputStream.close();
            return string4;
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "could not write JVM search input file: " + iOException);
        }
    }

    protected String createSearchInput(String[] stringArray) throws ServiceException {
        String string;
        try {
            string = FileUtils.createTempFile();
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("ACTION=SEARCHJVM");
            bufferedWriter.newLine();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    bufferedWriter.write("JVMFILE");
                    bufferedWriter.write(String.valueOf(n));
                    bufferedWriter.write("=");
                    bufferedWriter.write(stringArray[n]);
                    bufferedWriter.newLine();
                    ++n;
                }
            }
            bufferedWriter.write("VERIFY_JAR");
            bufferedWriter.write("=");
            bufferedWriter.write(this.getVerifyClasspath());
            bufferedWriter.newLine();
            if (System.getProperty("is.debug") != null) {
                bufferedWriter.write("LOG=jvmfind.log");
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "could not write JVM search input file: " + iOException);
        }
        return string;
    }

    public String getPlatformId() {
        return "genericunixppk";
    }

    public String getPlatformLauncherResource() throws ServiceException {
        return GenericUnixUtils.getPlatformLauncherResource();
    }

    public int getSystemCompatibility() {
        return GenericUnixPlatform.getSystemCompatibility();
    }

    public String getVerifyClassResource() throws ServiceException {
        return GenericUnixUtils.getVerifyClassResource();
    }

    protected void initialized() {
        super.initialized();
        try {
            URL uRL = this.getResource(String.valueOf(GenericUnixUtils.getGenericUnixPPKHome()) + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixUtils.initializeShellScriptSupport(uRL, GenericUnixUtils.getGenericUnixShellScriptSupport());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{"jvmService", GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            exception.printStackTrace();
        }
    }
}

