/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.security;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.security.GroupSpecification;
import com.installshield.wizard.service.security.PureJavaSecurityServiceImpl;
import com.installshield.wizard.service.security.UserSpecification;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GenericUnixSecurityServiceImpl
extends PureJavaSecurityServiceImpl {
    private static String EMPTY_OPTION_PLACEHOLDER = "IS_NULL";

    public void createGroup(GroupSpecification groupSpecification) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"createGroup", groupSpecification.getGroupName()});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "securityService:Error invoking createGroup for group " + groupSpecification.getGroupName() + " Got exception: " + processExecException);
        }
    }

    public void createUser(UserSpecification userSpecification) throws ServiceException {
        StringBuffer stringBuffer = new StringBuffer();
        if (userSpecification.getUserFullName() != null) {
            stringBuffer.append(userSpecification.getUserFullName());
        } else {
            stringBuffer.append(EMPTY_OPTION_PLACEHOLDER);
        }
        if (userSpecification.getGroups() != null) {
            String[] stringArray = userSpecification.getGroups();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer2.append(',');
                }
                stringBuffer2.append(stringArray[n]);
                ++n;
            }
            stringBuffer.append((Object)stringBuffer2);
        } else {
            stringBuffer.append(EMPTY_OPTION_PLACEHOLDER);
        }
        stringBuffer.append('+');
        if (userSpecification.getHomeDirectory() != null) {
            stringBuffer.append(userSpecification.getHomeDirectory());
        } else {
            stringBuffer.append(EMPTY_OPTION_PLACEHOLDER);
        }
        stringBuffer.append('+');
        if (userSpecification.getAccountExpirationDate() > 0L) {
            stringBuffer.append(new SimpleDateFormat("yyyy/MM/dd/hh/m").format(new Date(userSpecification.getAccountExpirationDate())));
        } else {
            stringBuffer.append(EMPTY_OPTION_PLACEHOLDER);
        }
        stringBuffer.append('+');
        stringBuffer.append(userSpecification.getUserName());
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"createUser", stringBuffer.toString()});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "securityService:Error invoking createUser for user " + userSpecification.getUserName() + " Got exception: " + processExecException);
        }
    }

    public void deleteGroup(String string) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"deleteGroup", string});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "securityService:Error invoking deleteGroup for group " + string + " Got exception: " + processExecException);
        }
    }

    public void deleteUser(String string) throws ServiceException {
        try {
            GenericUnixUtils.invokeShellScriptSupport(new String[]{"deleteUser", string});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "securityService:Error invoking deleteUser for user " + string + " Got exception: " + processExecException);
        }
    }

    public int getSystemCompatibility() {
        return GenericUnixPlatform.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            URL uRL = this.getResource(String.valueOf(GenericUnixUtils.getGenericUnixPPKHome()) + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixUtils.initializeShellScriptSupport(uRL, GenericUnixUtils.getGenericUnixShellScriptSupport());
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{"securityService", GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            exception.printStackTrace();
        }
    }

    public boolean isCurrentUserAdmin() throws ServiceException {
        try {
            return Boolean.valueOf(GenericUnixUtils.invokeShellScriptSupport(new String[]{"isCurrentUserAdmin"}));
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "securityService:Error invoking isCurrentUserAdmin Got exception: " + processExecException);
        }
    }
}

