/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.service.system;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.ProcessExecException;
import com.installshield.wizard.platform.common.environment.BourneShellManager;
import com.installshield.wizard.platform.common.environment.CShellManager;
import com.installshield.wizard.platform.common.environment.EnvironmentVariableManagerGroup;
import com.installshield.wizard.platform.common.environment.ScriptEnvironmentVariableManager;
import com.installshield.wizard.platform.genericunix.GenericUnixPlatform;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.system.PureJavaSystemUtilServiceImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;

public class GenericUnixSystemUtilServiceImpl
extends PureJavaSystemUtilServiceImpl {
    private static final String systemCshScript = "/etc/.login";
    private static final String userCshScript = ".login";
    private static final String systemBourneScript = "/etc/profile";
    private static final String userBourneScript = ".profile";
    private static EnvironmentVariableManagerGroup userEnvVarGroup;
    private static EnvironmentVariableManagerGroup systemEnvVarGroup;
    private static boolean envVarsCleanedUp;

    static {
        envVarsCleanedUp = false;
    }

    public void appendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.appendVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
    }

    private boolean checkScriptFile(String string) throws ServiceException {
        boolean bl = false;
        File file = new File(string);
        if (file.exists()) {
            try {
                if (!file.canWrite()) {
                    throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "systemUtil.cannotWriteScript", new String[]{string}));
                }
                bl = true;
            }
            catch (SecurityException securityException) {
                throw new ServiceException(securityException);
            }
        }
        return bl;
    }

    public void cleanup() throws ServiceException {
        if (!envVarsCleanedUp) {
            if (userEnvVarGroup != null) {
                userEnvVarGroup.makeUpdatePersistent();
            }
            if (systemEnvVarGroup != null) {
                systemEnvVarGroup.makeUpdatePersistent();
            }
            envVarsCleanedUp = true;
        }
    }

    public void deleteEnvironmentVariable(String string) throws ServiceException {
        this.deleteEnvironmentVariable(string, 2);
    }

    public void deleteEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.deleteVariable(string);
            this.setLogoutRequired(true);
        }
    }

    public void deleteFilesAfterExit() {
        String string = GenericUnixUtils.getgulfHandler();
        if (!new File(string).exists()) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("Cleanup script does not exist: " + string);
            }
            return;
        }
        this.removeFileToDeleteOnExit(string);
        String string2 = this.writeDirsToDelete();
        FileUtils.clearTempFile(string2);
        this.removeFileToDeleteOnExit(string2);
        Enumeration enumeration = this.filesToDeleteOnExit();
        if (enumeration.hasMoreElements()) {
            FileOutputStream fileOutputStream = null;
            PrintWriter printWriter = null;
            try {
                try {
                    String string3 = FileUtils.createTempFile();
                    fileOutputStream = new FileOutputStream(string3);
                    printWriter = new PrintWriter(fileOutputStream);
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        printWriter.println(string4);
                        this.removeFileToDeleteOnExit(string4);
                    }
                    printWriter.println(string);
                    printWriter.println(string3);
                    printWriter.println(string2);
                    printWriter.flush();
                    printWriter.close();
                    printWriter = null;
                    FileUtils.clearTempFile(string3);
                    StringBuffer stringBuffer = new StringBuffer(256);
                    stringBuffer.append(string);
                    stringBuffer.append(" -F ");
                    stringBuffer.append(string3);
                    if (string2 != null && string2.length() > 0) {
                        stringBuffer.append(" -R ");
                        stringBuffer.append(string2);
                    }
                    if (System.getProperty("is.debug") != null) {
                        stringBuffer.append(" -d");
                    }
                    String string5 = stringBuffer.toString();
                    Runtime.getRuntime().exec(string5);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Object var7_11 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
        }
    }

    private EnvironmentVariableManagerGroup getEnvVarGroup(int n) throws ServiceException {
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = null;
        ScriptEnvironmentVariableManager scriptEnvironmentVariableManager = null;
        try {
            if (n == 1 && System.getProperty("user.name").equals("root")) {
                if (systemEnvVarGroup == null) {
                    systemEnvVarGroup = new EnvironmentVariableManagerGroup();
                    if (this.checkScriptFile(systemBourneScript)) {
                        scriptEnvironmentVariableManager = new BourneShellManager(systemBourneScript);
                        scriptEnvironmentVariableManager.initialize();
                        systemEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if (this.checkScriptFile(systemCshScript)) {
                        scriptEnvironmentVariableManager = new CShellManager(systemCshScript);
                        scriptEnvironmentVariableManager.initialize();
                        systemEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                }
                environmentVariableManagerGroup = systemEnvVarGroup;
            } else if (n == 2) {
                if (userEnvVarGroup == null) {
                    userEnvVarGroup = new EnvironmentVariableManagerGroup();
                    String string = FileUtils.createFileName(System.getProperty("user.home"), userBourneScript);
                    if (this.checkScriptFile(string)) {
                        scriptEnvironmentVariableManager = new BourneShellManager(string);
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                    if (this.checkScriptFile(string = FileUtils.createFileName(System.getProperty("user.home"), userCshScript))) {
                        scriptEnvironmentVariableManager = new CShellManager(string);
                        scriptEnvironmentVariableManager.initialize();
                        userEnvVarGroup.add(scriptEnvironmentVariableManager);
                    }
                }
                environmentVariableManagerGroup = userEnvVarGroup;
            }
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
        return environmentVariableManagerGroup;
    }

    public String getEnvironmentVariable(String string) throws ServiceException {
        try {
            return GenericUnixUtils.invokeShellScriptSupport(new String[]{"getEnvironmentVariable", string});
        }
        catch (ProcessExecException processExecException) {
            throw new ServiceException(2, "systemUtilService:Error invoking getEnvironmentVariable for " + string + " Got exception: " + processExecException);
        }
    }

    protected String getPlatformIdImpl() {
        return "genericunixppk";
    }

    public String getRawEnvironmentVariable(String string, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            return environmentVariableManagerGroup.getVariable(string);
        }
        return null;
    }

    public int getSystemCompatibility() {
        return GenericUnixPlatform.getSystemCompatibility();
    }

    protected void initialized() {
        super.initialized();
        try {
            URL uRL = this.getResource(String.valueOf(GenericUnixUtils.getGenericUnixPPKHome()) + GenericUnixUtils.getGenericUnixShellScriptSupport());
            GenericUnixUtils.initializeShellScriptSupport(uRL, GenericUnixUtils.getGenericUnixShellScriptSupport());
            uRL = this.getResource(String.valueOf(GenericUnixUtils.getGenericUnixPPKHome()) + GenericUnixUtils.getGenericUnixLockedFileSupport());
            GenericUnixUtils.initializeLockedFilesHandlerSupport(uRL, GenericUnixUtils.getGenericUnixLockedFileSupport());
            FileUtils.setLockedFilesHandler(this);
        }
        catch (Exception exception) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "genericunix.scriptInitializationFailure", new String[]{"systemUtilService", GenericUnixUtils.getGenericUnixShellScriptSupport()}));
            exception.printStackTrace();
        }
    }

    public void prependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.prependVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
    }

    public void setEnvironmentVariable(String string, String string2) throws ServiceException {
        this.setEnvironmentVariable(string, string2, 2);
    }

    public void setEnvironmentVariable(String string, String string2, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.setVariable(string, string2);
            this.setLogoutRequired(true);
        }
    }

    public void unAppendEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.unAppendVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
    }

    public void unPrependEnvironmentVariable(String string, String string2, String string3, int n) throws ServiceException {
        this.verifyVariableName(string);
        EnvironmentVariableManagerGroup environmentVariableManagerGroup = this.getEnvVarGroup(n);
        if (environmentVariableManagerGroup != null) {
            environmentVariableManagerGroup.unPrependVariable(string, string2, string3);
            this.setLogoutRequired(true);
        }
    }

    private void verifyVariableName(String string) throws ServiceException {
        if (string == null || string.length() == 0) {
            throw new ServiceException(399, LocalizedStringResolver.resolve("com.installshield.wizard.platform.genericunix.i18n.GenericUnixResources", "systemUtil.variableNameRequired"));
        }
    }

    private String writeDirsToDelete() {
        FileOutputStream fileOutputStream = null;
        PrintWriter printWriter = null;
        String string = "";
        try {
            block7: {
                try {
                    Enumeration enumeration = super.directoriesToRecursivelyDeleteOnExit();
                    string = FileUtils.createTempFile();
                    fileOutputStream = new FileOutputStream(string);
                    printWriter = new PrintWriter(fileOutputStream);
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        printWriter.println(string2);
                        this.removeFileToDeleteOnExit(string2);
                    }
                }
                catch (IOException iOException) {
                    if (System.getProperty("is.debug") == null) break block7;
                    System.out.println("Unable to write file containing directories to recursively delete: " + iOException);
                    iOException.printStackTrace();
                }
            }
            Object var5_7 = null;
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (printWriter != null) {
                printWriter.close();
            }
            throw throwable;
        }
        return string;
    }
}

