/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.utils;

import com.installshield.util.ProcessExec;
import com.installshield.util.ProcessExecException;
import com.installshield.util.ProcessOutputHandler;
import com.installshield.wizard.platform.genericunix.utils.GenericUnixUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GenericUnixShellInterface
implements ProcessOutputHandler {
    private static int SLEEP_TIME = 5;
    private static byte[] stdout = new byte[0];
    private static byte[] stderr = new byte[0];
    private static String shellScriptSupport;
    private ByteArrayOutputStream stdoutstream = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderrstream = new ByteArrayOutputStream();
    public static int PROCESSIO_BUFFERSIZE;
    private ProcessExec ps;

    static {
        PROCESSIO_BUFFERSIZE = 512;
    }

    public byte[] getErrOutput() {
        return stderr;
    }

    public byte[] getStdOutput() {
        return stdout;
    }

    public static void main(String[] stringArray) {
        try {
            GenericUnixShellInterface genericUnixShellInterface = new GenericUnixShellInterface();
            File file = new File(stringArray[0]);
            genericUnixShellInterface.setShellScriptSupport(file.getAbsolutePath());
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 5) {
                genericUnixShellInterface.runShellScriptSupport(new String[]{"getFileOwner", stringArray[1]});
                System.out.print("stdout= " + new String(genericUnixShellInterface.getStdOutput()).trim());
                System.out.println("stderr= " + new String(genericUnixShellInterface.getErrOutput()).trim());
                ++n;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("total time=" + (l2 - l) / 1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void processErrorData(InputStream inputStream) {
        this.stderrstream.reset();
        this.readProcessStream(inputStream, this.stderrstream);
        stderr = this.stderrstream.toByteArray();
    }

    public void processOutputData(InputStream inputStream) {
        this.stdoutstream.reset();
        this.readProcessStream(inputStream, this.stdoutstream);
        stdout = this.stdoutstream.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readProcessStream(InputStream inputStream, OutputStream outputStream) {
        int n = 0;
        byte[] byArray = new byte[PROCESSIO_BUFFERSIZE];
        try {
            while (true) {
                if ((n = inputStream.read(byArray, 0, byArray.length)) == -1) {
                    outputStream.flush();
                    outputStream.close();
                    return;
                }
                outputStream.write(byArray, 0, n);
                try {
                    Thread.sleep(SLEEP_TIME);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {}
    }

    public void runShellScriptSupport(String[] stringArray) throws ProcessExecException {
        this.ps.setArguments(stringArray);
        this.ps.executeProcess();
        if (this.ps.getExitCode() != 0) {
            String string = new String(this.getErrOutput());
            GenericUnixUtils.debug("stderr invoking script method " + stringArray[0] + "=" + string);
            throw new ProcessExecException(string);
        }
    }

    public void setShellScriptSupport(String string) {
        if (!new File(string).exists()) {
            throw new Error("shell script support is missing");
        }
        shellScriptSupport = string;
        this.ps = new ProcessExec(shellScriptSupport);
        this.ps.setProcessOutputHandler(this);
        this.ps.setProcessExecDelay(5L);
        GenericUnixUtils.debug("shellScriptSupport=" + shellScriptSupport);
    }
}

