/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux;

import com.installshield.util.FileUtils;
import com.installshield.util.LibraryLoader;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.WizardServices;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class HpuxUtils {
    private static final String PPK_SUB_DIR = "hpuxppk";
    private static final String NATIVE_LIB_NAME = "libhpuxppk.1";
    private static final String JUDY_LIB_NAME = "libJudy.1";
    private static final String LAUNCHER_NAME = "launcher";
    private static final String RMLF_EXE = "rmlf.sh";
    private static final String PARISC_NATIVE_LIB = "parisc/libhpuxppk.1";
    private static final String PARISC_JUDY_LIB = "parisc/libJudy.1";
    private static final String PARISC_LAUNCHER = "parisc/launcher";
    private static final String IA64N_NATIVE_LIB = "ia64n/libhpuxppk.1";
    private static final String IA64N_JUDY_LIB = "ia64n/libJudy.1";
    private static final String IA64W_NATIVE_LIB = "ia64w/libhpuxppk.1";
    private static final String IA64W_JUDY_LIB = "ia64w/libJudy.1";
    private static final String IA64_LAUNCHER = "ia64n/launcher";
    private static final String JVM_VERIFY_CLASS_RESOURCE = "Verify.jar";
    private static int score = -1;
    private static Vector osName = new Vector();
    private static Vector osArch = new Vector();
    private static Vector osVers10 = new Vector();
    private static Vector osVers11 = new Vector();
    private static String archDir;
    private static String rmlfDest;
    private static boolean libLoaded;
    public static final String HPUX_1020_PARISC_ID = "HPUX_1020_PARISC_ID";
    public static final String HPUX_11x_PARISC_ID = "HPUX_11x_PARISC_ID";
    public static final String HPUX_11x_IA64_ID = "HPUX_11x_IA64_ID";

    static {
        rmlfDest = null;
        libLoaded = false;
        osName.addElement("HP-UX");
        osArch.addElement("PA-RISC");
        osArch.addElement("PA_RISC");
        osArch.addElement("IA64");
        osVers11.addElement("^.\\.11\\.22");
        osVers11.addElement("^.\\.11\\.23");
        osVers11.addElement("^.\\.1[1-2]\\..+");
        String string = System.getProperty("os.arch").toLowerCase();
        try {
            if (Rex.matches(string, "pa.?risc")) {
                archDir = "parisc";
            } else if (Rex.matches(string, "ia.?64")) {
                archDir = "ia64n";
                if (Rex.matches(string, "ia.?64w")) {
                    archDir = "ia64w";
                }
            } else {
                archDir = "";
            }
        }
        catch (RegExprSyntaxException regExprSyntaxException) {
            regExprSyntaxException.printStackTrace();
        }
    }

    public static void addHelperClassesToArchive(ServiceBuilderSupport serviceBuilderSupport) throws IOException {
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.hpux.HpuxUtils");
    }

    public static void addNativeSupportToArchive(ServiceBuilderSupport serviceBuilderSupport, WizardServices wizardServices) throws IOException {
        String[] stringArray = new String[]{JVM_VERIFY_CLASS_RESOURCE, RMLF_EXE, PARISC_NATIVE_LIB, PARISC_JUDY_LIB, PARISC_LAUNCHER, IA64N_NATIVE_LIB, IA64N_JUDY_LIB, IA64W_NATIVE_LIB, IA64W_JUDY_LIB, IA64_LAUNCHER};
        int n = 0;
        while (n < stringArray.length) {
            String string = PPK_SUB_DIR + File.separator + stringArray[n];
            URL uRL = wizardServices.getResource(string);
            serviceBuilderSupport.putResource(uRL, string);
            ++n;
        }
    }

    private static boolean containsStringLike(Vector vector, String string) {
        int n = 0;
        boolean bl = false;
        while (!bl && n < vector.size()) {
            HpuxUtils.say("Comparing " + vector.elementAt(n) + " to " + string);
            if (string.toLowerCase().indexOf(((String)vector.elementAt(n)).toLowerCase()) >= 0) {
                bl = true;
                HpuxUtils.say("  match = true");
                continue;
            }
            ++n;
            HpuxUtils.say("  match = false");
        }
        return bl;
    }

    public static int getCompatibilityScore() {
        HpuxUtils.say("getCompatibilityScore()");
        if (score == -1) {
            score = HpuxUtils.isSystemCompatible(osVers10) || HpuxUtils.isSystemCompatible(osVers11) ? 5 : 0;
        }
        HpuxUtils.say("  score = " + score);
        return score;
    }

    public static int getHpux10CompatibilityScore() {
        int n = 0;
        HpuxUtils.say("getHpux10CompatibilityScore()");
        if (HpuxUtils.isSystemCompatible(osVers10)) {
            n = 5;
        }
        HpuxUtils.say("  result = " + n);
        return n;
    }

    public static int getHpux11CompatibilityScore() {
        int n = 0;
        HpuxUtils.say("getHpux11CompatibilityScore()");
        if (HpuxUtils.isSystemCompatible(osVers11)) {
            n = 5;
        }
        HpuxUtils.say("  result = " + n);
        return n;
    }

    public static String getLockedFileRemover() {
        return rmlfDest;
    }

    public static String getPlatformID() {
        String string = System.getProperty("os.version");
        if (string != null && string.indexOf(".11.22") != -1) {
            return HPUX_11x_IA64_ID;
        }
        if (string != null && string.indexOf(".11.23") != -1) {
            return HPUX_11x_IA64_ID;
        }
        if (string != null && string.indexOf(".11.") != -1) {
            return HPUX_11x_PARISC_ID;
        }
        if (string != null && string.indexOf(".10.") != -1) {
            return HPUX_1020_PARISC_ID;
        }
        return "hpux_generic";
    }

    public static String getPlatformLauncherResource() {
        String string = PPK_SUB_DIR + File.separator + (new String(archDir).startsWith("ia") ? "ia64n" : "parisc") + File.separator + LAUNCHER_NAME;
        return string;
    }

    public static String getVerifyClassResource() {
        return PPK_SUB_DIR + File.separator + JVM_VERIFY_CLASS_RESOURCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSystemCompatible(Vector vector) {
        boolean bl = false;
        if (!HpuxUtils.containsStringLike(osName, System.getProperty("os.name"))) return bl;
        if (!HpuxUtils.containsStringLike(osArch, System.getProperty("os.arch"))) return bl;
        Enumeration enumeration = vector.elements();
        String string = System.getProperty("os.version");
        try {
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    return bl;
                }
                String string2 = (String)enumeration.nextElement();
                HpuxUtils.say("  nextElement: " + string2);
                if (!Rex.matches(string, string2)) continue;
                bl = true;
                HpuxUtils.say("  match = true");
            }
            return bl;
        }
        catch (RegExprSyntaxException regExprSyntaxException) {
            regExprSyntaxException.printStackTrace();
            HpuxUtils.say("Got exception from regular expression : " + regExprSyntaxException);
            return bl;
        }
    }

    public static void loadLibrary(WizardServices wizardServices) {
        block3: {
            if (libLoaded) break block3;
            try {
                String string = PPK_SUB_DIR + File.separator + archDir;
                String string2 = String.valueOf(string) + File.separator + JUDY_LIB_NAME;
                String string3 = String.valueOf(string) + File.separator + NATIVE_LIB_NAME;
                String string4 = PPK_SUB_DIR + File.separator + RMLF_EXE;
                HpuxUtils.say("loadLibrary() " + string2 + " " + string3 + " " + string4);
                URL uRL = wizardServices.getResource(string2);
                URL uRL2 = wizardServices.getResource(string3);
                URL uRL3 = wizardServices.getResource(string4);
                String string5 = FileUtils.createTempFile(uRL, JUDY_LIB_NAME);
                String string6 = FileUtils.createTempFile(uRL2, NATIVE_LIB_NAME);
                rmlfDest = FileUtils.createTempFile(uRL3, RMLF_EXE);
                FileUtils.clearTempFile(rmlfDest);
                String string7 = "/usr/bin/chmod ugo+r-w+x " + string5 + " " + string6 + " " + rmlfDest;
                HpuxUtils.say("  cmd:  " + string7);
                Process process = Runtime.getRuntime().exec(string7);
                int n = process.waitFor();
                if (n != 0) {
                    wizardServices.logEvent(wizardServices, "err", "Could not change permissions on " + string5 + " and " + string6 + ": " + n);
                }
                HpuxUtils.say("  status:  " + n);
                LibraryLoader.loadLibrary(string5);
                LibraryLoader.loadLibrary(string6);
                libLoaded = true;
            }
            catch (Exception exception) {
                wizardServices.logEvent(wizardServices, "err", exception);
            }
        }
    }

    private static void say(String string) {
        String string2 = System.getProperty("is.debug");
        if (string2 != null && string2.length() > 0) {
            System.out.println("HpuxUtils: " + string);
        }
    }
}

