/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.hpux.service.file;

import com.installshield.util.CommandUtils;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.platform.hpux.HpuxUtils;
import com.installshield.wizard.platform.hpux.service.file.FileSysTabEnt;
import com.installshield.wizard.platform.hpux.service.file.FileSysTable;
import com.installshield.wizard.platform.hpux.service.file.UnixFileAttrs;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileServiceImplementor;
import com.installshield.wizard.service.file.PureJavaFileServiceImpl;
import com.installshield.wizard.service.system.SystemUtilService;
import java.io.File;

public class HpuxFileServiceImpl
extends PureJavaFileServiceImpl
implements FileServiceImplementor {
    private FileSysTable mnttab = null;

    public int copyFile(String string, String string2, boolean bl) throws ServiceException {
        this.say("copyFile(" + string + ", " + string2 + ", " + bl + ")");
        String string3 = this.hpuxCopyFile(string, string2, bl);
        if (string3 != null) {
            this.say("adding " + string3 + " to deleteFileOnExit list");
            SystemUtilService systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService");
            if (systemUtilService != null) {
                systemUtilService.deleteFileOnExit(string3);
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public int deleteDirectory(String var1_1, boolean var2_2, boolean var3_3) throws ServiceException {
        var4_4 = 0;
        var5_5 = false;
        var6_6 = "";
        var7_7 = this.createFileName(this.getCurrentDirectory(), var1_1);
        if (this.fileExists(var7_7) && this.isDirectory(var7_7) && this.getParent(var7_7) == null) {
            throw new ServiceException(305, "deleteDirectory cannot be used to delete the root directory");
        }
        if (this.isDirectory(var7_7)) {
            if (!var2_2 && !var3_3) {
                try {
                    var8_8 = String.valueOf(FileUtils.appendSeparator(var7_7, this.getSeparator())) + "*";
                    var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -f " + var8_8});
                    if (var9_14.getExitCode() == 0) {
                        var9_14 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir " + var7_7});
                        if (var9_14.getExitCode() == 0) ** GOTO lbl42
                        var5_5 = true;
                        var6_6 = var9_14.getStderr();
                    }
                    var5_5 = true;
                    var6_6 = var9_14.getStderr();
                }
                catch (Exception var8_9) {
                    throw new ServiceException(var8_9);
                }
            } else if (var2_2 && !var3_3) {
                try {
                    var8_10 = CommandUtils.executeCommand("sh", new String[]{"-c", "rmdir " + var7_7});
                    if (var8_10.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_10.getStderr();
                }
                catch (Exception var8_11) {
                    throw new ServiceException(var8_11);
                }
            } else if (!var2_2 && var3_3) {
                try {
                    var8_12 = CommandUtils.executeCommand("sh", new String[]{"-c", "rm -rf " + var7_7});
                    if (var8_12.getExitCode() == 0) ** GOTO lbl42
                    var5_5 = true;
                    var6_6 = var8_12.getStderr();
                }
                catch (Exception var8_13) {
                    throw new ServiceException(var8_13);
                }
            } else {
                var4_4 = super.deleteDirectory(var1_1, var2_2, var3_3);
            }
        }
lbl42:
        // 10 sources

        if (var5_5) {
            throw new ServiceException(2, "Error deleting directory: " + var6_6);
        }
        return var4_4;
    }

    public int deleteFile(String string) throws ServiceException {
        this.say("deleteFile(" + string + ")");
        String string2 = this.hpuxDeleteFile(string);
        if (string2 != null) {
            this.say("adding " + string2 + " to deleteFileOnExit list");
            SystemUtilService systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService");
            if (systemUtilService != null) {
                systemUtilService.deleteFileOnExit(string2);
            }
            return 1;
        }
        return 0;
    }

    public FileAttributes getFileAttributes(String string) throws ServiceException {
        return UnixFileAttrs.getAttributeObject(string, this.getFileMode(string));
    }

    private native int getFileMode(String var1) throws ServiceException;

    public native String getFileOwner(String var1) throws ServiceException;

    public native String getFileOwnerGroup(String var1) throws ServiceException;

    protected String getLogFileDirectory() {
        return String.valueOf(File.separator) + "var" + File.separator + "adm";
    }

    private FileSysTable getMountTab() throws ServiceException {
        if (this.mnttab == null) {
            String string = String.valueOf(File.separator) + "etc" + File.separator + "mnttab";
            this.mnttab = new FileSysTable(string);
        }
        return this.mnttab;
    }

    public String getPartitionFormat(String string) throws ServiceException {
        return this.getMountTab().getEntry(string).getFSType();
    }

    public native long getPartitionFreeSpace(String var1) throws ServiceException;

    public long getPartitionFreeSpace(String string, long l) throws ServiceException {
        return this.getPartitionFreeSpace(string);
    }

    public String[] getPartitionNames() throws ServiceException {
        return this.getMountTab().getMountPts();
    }

    public int getPartitionType(String string) throws ServiceException {
        FileSysTabEnt fileSysTabEnt = this.getMountTab().getEntry(string);
        if (fileSysTabEnt.getFSType().equals("cdfs")) {
            return 2;
        }
        return 1;
    }

    protected String getStandardInstallDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "opt";
    }

    public int getSystemCompatibility() {
        return HpuxUtils.getCompatibilityScore();
    }

    public native int getSystemUMask() throws ServiceException;

    protected String getTempDirectory() throws ServiceException {
        return String.valueOf(File.separator) + "tmp";
    }

    private native String hpuxCopyFile(String var1, String var2, boolean var3) throws ServiceException;

    private native String hpuxDeleteFile(String var1) throws ServiceException;

    private native String hpuxMoveFile(String var1, String var2, boolean var3) throws ServiceException;

    public void initialized() {
        super.initialized();
        HpuxUtils.loadLibrary(this.getServices());
    }

    public int moveFile(String string, String string2, boolean bl) throws ServiceException {
        this.say("moveFile(" + string + ", " + string2 + ", " + bl + ")");
        String string3 = this.hpuxMoveFile(string, string2, bl);
        if (string3 != null) {
            this.say("adding " + string3 + " to deleteFileOnExit list");
            SystemUtilService systemUtilService = (SystemUtilService)this.getServices().getService("systemUtilService");
            if (systemUtilService != null) {
                systemUtilService.deleteFileOnExit(string3);
            }
        }
        return 0;
    }

    private void say(String string) {
        String string2 = System.getProperty("is.debug");
        if (string2 != null && string2.length() > 0) {
            System.out.println("HpuxFileService: " + string);
        }
    }

    public void setFileAttributes(String string, FileAttributes fileAttributes) throws ServiceException {
        this.setFileMode(string, UnixFileAttrs.getMode(fileAttributes));
    }

    public void setFileCreated(String string, long l) {
    }

    public void setFileExecutable(String string) throws ServiceException {
        int n = this.getFileMode(string);
        this.setFileMode(string, n |= 0x49);
    }

    private native void setFileMode(String var1, int var2) throws ServiceException;

    public native void setFileModified(String var1, long var2) throws ServiceException;

    public native void setFileOwner(String var1, String var2) throws ServiceException;

    public native void setFileOwnerGroup(String var1, String var2) throws ServiceException;

    public native void setFileTimes(String var1, long var2, long var4, long var6) throws ServiceException;

    public native void setSystemUMask(int var1) throws ServiceException;

    public native boolean supportsLongFileNames(String var1) throws ServiceException;

    public void validateFileName(String string) throws ServiceException {
        String string2 = ":*?\"<>|";
        int n = 0;
        while (n < string.length()) {
            if (string2.indexOf(string.charAt(n)) != -1) {
                throw new ServiceException(315, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "FileServiceImpl.invalidCharacters", new String[]{string2}));
            }
            ++n;
        }
    }
}

